/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.ConfigureDeprecationFixDialog;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class ConfigureDeprecationFixAction
extends SelectionDispatchAction {
    public static final String CONFIGURE_DEPRECATION_FIX = "org.eclipse.jdt.ui.actions.ConfigureDeprecationFix";
    public static final String CONFIGURE_DEPRECATION_FIXES = "org.eclipse.jdt.ui.edit.text.java.configure.deprecation.fix";
    private CompilationUnitEditor fEditor;

    public ConfigureDeprecationFixAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor));
    }

    public ConfigureDeprecationFixAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.ConfigureDeprecationFixAction_text);
        this.setDescription(ActionMessages.ConfigureDeprecationFixAction_description);
        this.setToolTipText(ActionMessages.ConfigureDeprecationFixAction_tool_tip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.configure_deprecation_fix_action_context");
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (selection.size() == 1) {
            Object element = selection.getFirstElement();
            if (element instanceof IMethod) {
                IMethod method = (IMethod)element;
                return !method.isReadOnly() && !method.isMainMethod() && Flags.isDeprecated((int)method.getFlags());
            }
            if (element instanceof IField) {
                IField field = (IField)element;
                return !field.isReadOnly() && Flags.isDeprecated((int)field.getFlags());
            }
        }
        return false;
    }

    private IMember getSelectedMember(IStructuredSelection selection) throws JavaModelException {
        Object[] elements = selection.toArray();
        if (elements.length == 1) {
            IField field;
            if (elements[0] instanceof IMethod) {
                IMethod method = (IMethod)elements[0];
                if (!method.isReadOnly() && !method.isMainMethod() && Flags.isDeprecated((int)method.getFlags())) {
                    return method;
                }
            } else if (elements[0] instanceof IField && !(field = (IField)elements[0]).isReadOnly() && Flags.isDeprecated((int)field.getFlags())) {
                return field;
            }
        }
        return null;
    }

    public void run(IStructuredSelection selection) {
        try {
            IMember member = this.getSelectedMember(selection);
            if (member == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.ConfigureDeprecationFixAction_dialog_title, (String)ActionMessages.ConfigureDeprecationFixAction_not_applicable);
                this.notifyResult(false);
                return;
            }
            if (!ElementValidator.check((IJavaElement)member, this.getShell(), ActionMessages.ConfigureDeprecationFixAction_dialog_title, false) || !ActionUtil.isProcessable(this.getShell(), member)) {
                this.notifyResult(false);
                return;
            }
            this.run(this.getShell(), member);
        }
        catch (CoreException exception) {
            ExceptionHandler.handle(exception, this.getShell(), ActionMessages.ConfigureDeprecationFixAction_dialog_title, ActionMessages.ConfigureDeprecationFixAction_general_error);
        }
    }

    public void run(ITextSelection selection) {
        try {
            IMember member = null;
            IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element instanceof IMethod) {
                member = (IMember)element;
            } else if (element instanceof IField) {
                member = (IMember)element;
            }
            if (member != null) {
                if (!ElementValidator.check((IJavaElement)member, this.getShell(), ActionMessages.ConfigureDeprecationFixAction_dialog_title, false) || !ActionUtil.isProcessable(this.getShell(), member)) {
                    this.notifyResult(false);
                    return;
                }
                if (member.isReadOnly()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.ConfigureDeprecationFixAction_dialog_title, (String)ActionMessages.ConfigureDeprecationFixAction_error_read_only);
                    this.notifyResult(false);
                    return;
                }
                if (!Flags.isDeprecated((int)member.getFlags())) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.ConfigureDeprecationFixAction_dialog_title, (String)ActionMessages.ConfigureDeprecationFixAction_error_not_deprecated);
                    this.notifyResult(false);
                    return;
                }
                if (member instanceof IMethod && ((IMethod)member).isMainMethod()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.ConfigureDeprecationFixAction_dialog_title, (String)ActionMessages.ConfigureDeprecationFixAction_error_main_method);
                    this.notifyResult(false);
                    return;
                }
                this.run(this.getShell(), member);
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.ConfigureDeprecationFixAction_dialog_title, (String)ActionMessages.ConfigureDeprecationFixAction_not_applicable);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), ActionMessages.ConfigureDeprecationFixAction_dialog_title, null);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.ConfigureDeprecationFixAction_dialog_title, ActionMessages.ConfigureDeprecationFixAction_general_error);
        }
    }

    private void run(Shell shell, IMember member) throws CoreException {
        CompilationUnit unit = RefactoringASTParser.parseWithASTProvider(member.getCompilationUnit(), true, null);
        if (unit != null) {
            MethodDeclaration extended;
            IMethodBinding binding = null;
            BodyDeclaration declaration = ASTNodeSearchUtil.getBodyDeclarationNode(member, unit);
            if (declaration instanceof MethodDeclaration) {
                extended = (MethodDeclaration)declaration;
                binding = extended.resolveBinding();
            } else if (declaration instanceof FieldDeclaration) {
                extended = (FieldDeclaration)declaration;
                Iterator iterator = extended.fragments().iterator();
                while (iterator.hasNext()) {
                    VariableDeclarationFragment fragment = (VariableDeclarationFragment)iterator.next();
                    if (!fragment.getName().getIdentifier().equals(member.getElementName())) continue;
                    binding = fragment.resolveBinding();
                    break;
                }
            }
            if (binding != null) {
                ConfigureDeprecationFixDialog dialog = new ConfigureDeprecationFixDialog(shell, member.getJavaProject(), (IBinding)binding);
                this.notifyResult(dialog.open() == 0);
            } else {
                this.notifyResult(false);
            }
        }
        this.notifyResult(true);
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException exception) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)exception))) {
                JavaPlugin.log(exception);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection selection) {
    }
}

