/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.jdt.internal.corext.refactoring.deprecation.CreateDeprecationFixChange;
import org.eclipse.jdt.internal.corext.refactoring.deprecation.DeprecationRefactorings;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.DeleteFileChange;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class ConfigureDeprecationFixDialog
extends TrayDialog {
    private static final int INLINE_FIX = 1;
    private static final int NO_FIX = 0;
    private final IBinding fBinding;
    private int fCurrentFix = -1;
    private int fFutureFix = -1;
    private Button fInlineFixButton;
    private Button fNoFixButton;
    private final IJavaProject fProject;

    public ConfigureDeprecationFixDialog(Shell shell, IJavaProject project, IBinding binding) {
        super(shell);
        Assert.isNotNull((Object)project);
        Assert.isNotNull((Object)binding);
        this.fProject = project;
        this.fBinding = binding;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ActionMessages.ConfigureDeprecationFixDialog_dialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.jdt.ui.configure_deprecation_fix_action_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout());
        Label label = new Label(composite, 16704);
        label.setText(ActionMessages.ConfigureDeprecationFixDialog_dialog_description);
        this.fNoFixButton = new Button(composite, 16);
        this.fNoFixButton.setText(ActionMessages.ConfigureDeprecationFixDialog_no_fix_label);
        this.fNoFixButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConfigureDeprecationFixDialog.this.fFutureFix = 0;
            }
        });
        GridData data = new GridData();
        data.verticalIndent = this.convertVerticalDLUsToPixels(8);
        this.fNoFixButton.setLayoutData((Object)data);
        this.fInlineFixButton = new Button(composite, 16);
        this.fInlineFixButton.setText(ActionMessages.ConfigureDeprecationFixDialog_inline_fix_label);
        this.fInlineFixButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConfigureDeprecationFixDialog.this.fFutureFix = 1;
            }
        });
        this.initializeFix();
        this.initializeControls();
        return composite;
    }

    private void initializeControls() {
        switch (this.fCurrentFix) {
            case 0: {
                this.fNoFixButton.setSelection(true);
                break;
            }
            case 1: {
                this.fInlineFixButton.setSelection(true);
            }
        }
    }

    private void initializeFix() {
        String name = DeprecationRefactorings.getRefactoringScriptName(this.fBinding);
        if (name != null) {
            RefactoringDescriptor descriptor;
            RefactoringDescriptorProxy[] proxies;
            RefactoringHistory history;
            IFile file = DeprecationRefactorings.getRefactoringScriptFile(this.fProject, name);
            if (file != null && file.exists() && (history = DeprecationRefactorings.getRefactoringHistory(file)) != null && (proxies = history.getDescriptors()).length == 1 && (descriptor = proxies[0].requestDescriptor(null)) != null && descriptor.getID().equals("org.eclipse.jdt.ui.inline.method")) {
                this.fCurrentFix = 1;
            }
        } else {
            this.fCurrentFix = 0;
        }
        this.fFutureFix = this.fCurrentFix;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int open() {
        int result = super.open();
        if (result != 0) return result;
        if (this.fCurrentFix == this.fFutureFix) return result;
        JDTChange change = null;
        IFile file = DeprecationRefactorings.getRefactoringScriptFile(this.fProject, DeprecationRefactorings.getRefactoringScriptName(this.fBinding));
        if (this.fFutureFix == 0) {
            change = new DeleteFileChange(file);
        } else if (this.fFutureFix == 1) {
            change = new CreateDeprecationFixChange(file.getFullPath(), DeprecationRefactorings.createInlineDeprecationScript(this.fBinding), CorrectionMessages.QuickAssistProcessor_create_fix_name);
        }
        if (change == null) return result;
        try {
            try {
                change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                WorkbenchRunnableAdapter adapter = new WorkbenchRunnableAdapter((IWorkspaceRunnable)RefactoringUI.createUIAwareChangeOperation((Change)change));
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)new BusyIndicatorRunnableContext(), (IRunnableWithProgress)adapter, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            }
            catch (InvocationTargetException exception) {
                JavaPlugin.log(exception);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            change.dispose();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        change.dispose();
        return result;
    }
}

