/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.SearchBrokenNLSKeysUtil;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public class FindBrokenNLSKeysAction
extends SelectionDispatchAction {
    public static final String FIND_BROKEN_NLS_KEYS_ACTION_ID = "org.eclipse.jdt.ui.edit.text.java.find.broken.nls.keys";
    public static final String ACTION_HANDLER_ID = "org.eclipse.jdt.ui.actions.FindNLSProblems";
    private JavaEditor fEditor;

    public FindBrokenNLSKeysAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.FindNLSProblemsAction_Name);
        this.setToolTipText(ActionMessages.FindNLSProblemsAction_ToolTip);
        this.setDescription(ActionMessages.FindNLSProblemsAction_Description);
    }

    public FindBrokenNLSKeysAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(FindBrokenNLSKeysAction.getCompilationUnit(editor) != null);
    }

    public void run(ITextSelection selection) {
        ISelectionProvider selectionProvider = this.fEditor.getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        this.run((IStructuredSelection)new StructuredSelection((Object)selectionProvider.getSelection()));
    }

    public void run(IStructuredSelection selection) {
        SearchPatternData[] data = this.getNLSFiles(selection);
        if (data == null || data.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.FindNLSProblemsAction_ErrorDialogTitle, (String)ActionMessages.FindNLSProblemsAction_NoPropertieFilesFoundErrorDescription);
            return;
        }
        String scope = "workspace";
        if (selection.size() == 1) {
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IJavaElement) {
                scope = ((IJavaElement)firstElement).getElementName();
            } else if (firstElement instanceof IFile) {
                scope = ((IFile)firstElement).getName();
            } else if (firstElement instanceof IFolder) {
                scope = ((IFolder)firstElement).getName();
            }
        }
        this.run(data, scope);
    }

    private void run(SearchPatternData[] data, String scope) {
        ArrayList<IType> wrappers = new ArrayList<IType>();
        ArrayList<IFile> properties = new ArrayList<IFile>();
        int i = 0;
        while (i < data.length) {
            SearchPatternData current = data[i];
            if (current.getWrapperClass() != null || current.getPropertyFile() != null) {
                wrappers.add(current.getWrapperClass());
                properties.add(current.getPropertyFile());
            }
            ++i;
        }
        IType[] accessorClasses = wrappers.toArray(new IType[wrappers.size()]);
        IFile[] propertieFiles = properties.toArray(new IFile[properties.size()]);
        SearchBrokenNLSKeysUtil.search(scope, accessorClasses, propertieFiles);
    }

    public void selectionChanged(ITextSelection selection) {
        ISelectionProvider selectionProvider = this.fEditor.getSelectionProvider();
        if (selectionProvider == null) {
            this.setEnabled(false);
        } else {
            this.selectionChanged((IStructuredSelection)new StructuredSelection((Object)selectionProvider.getSelection()));
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canEnable(selection));
    }

    private SearchPatternData[] getNLSFiles(IStructuredSelection selection) {
        Object[] selectedElements = selection.toArray();
        if (selectedElements.length == 1 && selectedElements[0] instanceof ICompilationUnit) {
            try {
                ICompilationUnit compilationUnit = (ICompilationUnit)selectedElements[0];
                return this.tryIfPropertyCuSelected(compilationUnit);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        Hashtable result = new Hashtable();
        try {
            this.collectNLSFiles(selectedElements, result);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        Collection values = result.values();
        return values.toArray(new SearchPatternData[values.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canEnable(IStructuredSelection selection) {
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            block14: {
                try {
                    IFile file;
                    if (selected[i] instanceof IJavaElement) {
                        IJavaElement elem = (IJavaElement)selected[i];
                        if (elem.exists()) {
                            switch (elem.getElementType()) {
                                case 7: {
                                    return elem.getParent().getElementType() == 5;
                                }
                                case 5: {
                                    return true;
                                }
                                case 12: {
                                    return true;
                                }
                                case 3: 
                                case 4: {
                                    IPackageFragmentRoot root = (IPackageFragmentRoot)elem.getAncestor(3);
                                    return root.getKind() == 1;
                                }
                                case 2: {
                                    return true;
                                }
                            }
                        }
                        break block14;
                    }
                    if (selected[i] instanceof LogicalPackage) {
                        return true;
                    }
                    if (selected[i] instanceof IFile && "properties".equalsIgnoreCase((file = (IFile)selected[i]).getFileExtension())) {
                        return true;
                    }
                }
                catch (JavaModelException e) {
                    if (e.isDoesNotExist()) break block14;
                    JavaPlugin.log(e);
                }
            }
            ++i;
        }
        return false;
    }

    private void collectNLSFiles(Object[] objects, Hashtable result) throws CoreException {
        int i = 0;
        while (i < objects.length) {
            IJavaElement element;
            IResource resource;
            IProject project;
            if (objects[i] instanceof IFile) {
                SearchPatternData data;
                if (!result.containsKey(objects[i]) && (data = this.tryIfPropertyFileSelected((IFile)objects[i])) != null) {
                    result.put(objects[i], data);
                }
            } else if (objects[i] instanceof IFolder) {
                IFolder folder = (IFolder)objects[i];
                this.collectNLSFiles(folder.members(), result);
            } else if (objects[i] instanceof IProject) {
                project = (IProject)objects[i];
                if (project.exists() && project.isOpen()) {
                    this.collectNLSFiles(project.members(), result);
                }
            } else if (objects[i] instanceof IJavaProject) {
                project = (IJavaProject)objects[i];
                if (project.exists()) {
                    this.collectNLSFiles(project.getAllPackageFragmentRoots(), result);
                }
            } else if (objects[i] instanceof IJavaElement && (resource = (element = (IJavaElement)objects[i]).getCorrespondingResource()) != null) {
                this.collectNLSFiles(new Object[]{resource}, result);
            }
            ++i;
        }
    }

    private SearchPatternData[] tryIfPropertyCuSelected(ICompilationUnit compilationUnit) throws JavaModelException {
        if (compilationUnit == null) {
            return null;
        }
        IType[] types = compilationUnit.getTypes();
        if (types.length > 1) {
            return null;
        }
        IStorage bundle = NLSHintHelper.getResourceBundle(compilationUnit);
        if (!(bundle instanceof IFile)) {
            return null;
        }
        return new SearchPatternData[]{new SearchPatternData(types[0], (IFile)bundle)};
    }

    private SearchPatternData tryIfPropertyFileSelected(IFile file) throws JavaModelException {
        if (!"properties".equalsIgnoreCase(file.getFileExtension())) {
            return null;
        }
        IPath propertyFullPath = file.getFullPath();
        String[] javaExtensions = JavaCore.getJavaLikeExtensions();
        int i = 0;
        while (i < javaExtensions.length) {
            String name;
            String resourceName;
            String resourceBundleName;
            ICompilationUnit compilationUnit;
            IType type;
            IJavaElement element;
            String filename;
            String extension = javaExtensions[i];
            IPath cuPath = propertyFullPath.removeFileExtension().addFileExtension(extension);
            IFile cuFile = (IFile)JavaPlugin.getWorkspace().getRoot().findMember(cuPath);
            if (cuFile == null && (filename = cuPath.removeFileExtension().lastSegment()) != null && filename.length() > 0) {
                filename = String.valueOf(Character.toUpperCase(filename.charAt(0))) + filename.substring(1);
                IPath dirPath = propertyFullPath.removeLastSegments(1).addTrailingSeparator();
                cuPath = dirPath.append(filename).addFileExtension(extension);
                cuFile = (IFile)JavaPlugin.getWorkspace().getRoot().findMember(cuPath);
            }
            if (cuFile != null && cuFile.exists() && (element = JavaCore.create((IFile)cuFile)) != null && element.exists() && element.getElementType() == 5 && (type = (compilationUnit = (ICompilationUnit)element).findPrimaryType()) != null && (resourceBundleName = NLSHintHelper.getResourceBundleName(compilationUnit)) != null && (resourceName = String.valueOf(resourceBundleName) + ".properties").endsWith(name = file.getName())) {
                return new SearchPatternData(type, file);
            }
            ++i;
        }
        return null;
    }

    private static ICompilationUnit getCompilationUnit(JavaEditor editor) {
        WorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
        ICompilationUnit cu = manager.getWorkingCopy(editor.getEditorInput());
        return cu;
    }

    private static class SearchPatternData {
        private final IType fAccessorType;
        private final IFile fPropertyFile;

        public SearchPatternData(IType accessorType, IFile propertyFile) {
            this.fAccessorType = accessorType;
            this.fPropertyFile = propertyFile;
        }

        public IFile getPropertyFile() {
            return this.fPropertyFile;
        }

        public IType getWrapperClass() {
            return this.fAccessorType;
        }
    }
}

