/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackager;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.jarpackager.IJarPackageWizardPage;
import org.eclipse.jdt.internal.ui.jarpackager.JarManifestWizardPage;
import org.eclipse.jdt.internal.ui.jarpackager.JarOptionsPage;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagePreviewPage;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackageRefactoringPage;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackageWizardPage;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class JarPackageWizard
extends Wizard
implements IExportWizard {
    private static String DIALOG_SETTINGS_KEY = "JarPackageWizard";
    private boolean fHasNewDialogSettings;
    private boolean fInitializeFromJarPackage;
    private JarOptionsPage fJarOptionsWizardPage;
    private JarPackageData fJarPackage;
    private JarPackageWizardPage fJarPackageWizardPage;
    private IStructuredSelection fSelection;

    public JarPackageWizard() {
        IDialogSettings workbenchSettings = JavaPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            this.fHasNewDialogSettings = true;
        } else {
            this.fHasNewDialogSettings = false;
            this.setDialogSettings(section);
        }
    }

    private void addJavaElement(List selectedElements, IJavaElement je) {
        if (je.getElementType() == 5) {
            selectedElements.add(je);
        } else if (je.getElementType() == 6) {
            selectedElements.add(je);
        } else if (je.getElementType() == 2) {
            selectedElements.add(je);
        } else if (je.getElementType() == 4) {
            if (!JavaModelUtil.getPackageFragmentRoot(je).isArchive()) {
                selectedElements.add(je);
            }
        } else if (je.getElementType() == 3) {
            if (!((IPackageFragmentRoot)je).isArchive()) {
                selectedElements.add(je);
            }
        } else {
            IOpenable openable = je.getOpenable();
            if (openable instanceof ICompilationUnit) {
                selectedElements.add(((ICompilationUnit)openable).getPrimary());
            } else if (openable instanceof IClassFile && !JavaModelUtil.getPackageFragmentRoot(je).isArchive()) {
                selectedElements.add(openable);
            }
        }
    }

    public void addPages() {
        super.addPages();
        this.fJarPackageWizardPage = new JarPackageWizardPage(this.fJarPackage, this.fSelection);
        this.addPage(this.fJarPackageWizardPage);
        this.addPage(new JarPackageRefactoringPage(this.fJarPackage));
        this.addPage(new JarPackagePreviewPage(this.fJarPackage, new RefactoringHistoryControlConfiguration(null, true, true){

            public String getProjectPattern() {
                return JarPackagerMessages.JarPackageWizard_project_pattern;
            }

            public String getWorkspaceCaption() {
                return JarPackagerMessages.JarPackageWizard_workspace_caption;
            }
        }));
        this.fJarOptionsWizardPage = new JarOptionsPage(this.fJarPackage);
        this.addPage(this.fJarOptionsWizardPage);
        this.addPage(new JarManifestWizardPage(this.fJarPackage));
    }

    private void addProject(List selectedElements, IProject project) {
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                selectedElements.add(JavaCore.create((IProject)project));
            }
        }
        catch (CoreException coreException) {}
    }

    private void addResource(List selectedElements, IResource resource) {
        IJavaElement je = JavaCore.create((IResource)resource);
        if (je != null && je.exists() && je.getElementType() == 5) {
            selectedElements.add(je);
        } else {
            selectedElements.add(resource);
        }
    }

    protected boolean executeExportOperation(IJarExportRunnable op) {
        block4: {
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() == null) break block4;
                ExceptionHandler.handle(ex, this.getShell(), JarPackagerMessages.JarPackageWizard_jarExportError_title, JarPackagerMessages.JarPackageWizard_jarExportError_message);
                return false;
            }
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)JarPackagerMessages.JarPackageWizard_jarExport_title, null, (IStatus)status);
            return !status.matches(4);
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fJarPackageWizardPage && !this.fJarPackage.isRefactoringAware()) {
            return this.fJarOptionsWizardPage;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.fJarOptionsWizardPage && !this.fJarPackage.isRefactoringAware()) {
            return this.fJarPackageWizardPage;
        }
        return super.getPreviousPage(page);
    }

    protected IStructuredSelection getValidSelection() {
        ISelection currentSelection = JavaPlugin.getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)currentSelection;
            ArrayList selectedElements = new ArrayList(structuredSelection.size());
            Iterator iter = structuredSelection.iterator();
            while (iter.hasNext()) {
                Object selectedElement = iter.next();
                if (selectedElement instanceof IProject) {
                    this.addProject(selectedElements, (IProject)selectedElement);
                    continue;
                }
                if (selectedElement instanceof IResource) {
                    this.addResource(selectedElements, (IResource)selectedElement);
                    continue;
                }
                if (!(selectedElement instanceof IJavaElement)) continue;
                this.addJavaElement(selectedElements, (IJavaElement)selectedElement);
            }
            return new StructuredSelection(selectedElements);
        }
        return StructuredSelection.EMPTY;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fSelection = this.getValidSelection();
        this.fJarPackage = new JarPackageData();
        this.setInitializeFromJarPackage(false);
        this.setWindowTitle(JarPackagerMessages.JarPackageWizard_windowTitle);
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_JAR_PACKAGER);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, JarPackageData jarPackage) {
        Assert.isNotNull((Object)workbench);
        Assert.isNotNull((Object)jarPackage);
        this.fJarPackage = jarPackage;
        this.setInitializeFromJarPackage(true);
        this.fSelection = new StructuredSelection(this.fJarPackage.getElements());
        this.setWindowTitle(JarPackagerMessages.JarPackageWizard_windowTitle);
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_JAR_PACKAGER);
        this.setNeedsProgressMonitor(true);
    }

    boolean isInitializingFromJarPackage() {
        return this.fInitializeFromJarPackage;
    }

    public boolean performFinish() {
        this.fJarPackage.setElements(this.fJarPackageWizardPage.getSelectedElementsWithoutContainedChildren());
        if (!this.executeExportOperation(this.fJarPackage.createJarExportRunnable(this.getShell()))) {
            return false;
        }
        if (this.fHasNewDialogSettings) {
            IDialogSettings workbenchSettings = JavaPlugin.getDefault().getDialogSettings();
            IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
            section = workbenchSettings.addNewSection(DIALOG_SETTINGS_KEY);
            this.setDialogSettings(section);
        }
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < this.getPageCount()) {
            IWizardPage page = pages[i];
            if (page instanceof IJarPackageWizardPage) {
                ((IJarPackageWizardPage)page).finish();
            }
            ++i;
        }
        return true;
    }

    void setInitializeFromJarPackage(boolean state) {
        this.fInitializeFromJarPackage = state;
    }

    public boolean canFinish() {
        return !this.fJarPackage.isRefactoringAware() || this.fJarPackage.getRefactoringDescriptors().length > 0;
    }
}

