/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.navigator;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class JavaNavigatorContentProvider
extends PackageExplorerContentProvider
implements IPipelinedTreeContentProvider {
    public static final String JDT_EXTENSION_ID = "org.eclipse.jdt.ui.javaContent";
    private IExtensionStateModel fStateModel;

    public JavaNavigatorContentProvider() {
        super(false);
    }

    public JavaNavigatorContentProvider(boolean provideMembers) {
        super(provideMembers);
    }

    public void init(ICommonContentExtensionSite commonContentExtensionSite) {
        IExtensionStateModel stateModel = commonContentExtensionSite.getExtensionStateModel();
        IMemento memento = commonContentExtensionSite.getMemento();
        this.fStateModel = stateModel;
        this.restoreState(memento);
        this.fStateModel.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("isLayoutFlat".equals(event.getProperty()) && event.getNewValue() != null) {
                    boolean newValue = (Boolean)event.getNewValue() != false;
                    JavaNavigatorContentProvider.this.setIsFlatLayout(newValue);
                }
            }
        });
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        boolean showCUChildren = store.getBoolean("org.eclipse.jdt.ui.packages.cuchildren");
        this.setProvideMembers(showCUChildren);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, this.findInputElement(newInput));
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IWorkspaceRoot) {
            return super.getElements(JavaCore.create((IWorkspaceRoot)((IWorkspaceRoot)inputElement)));
        }
        return super.getElements(inputElement);
    }

    private Object findInputElement(Object newInput) {
        if (newInput instanceof IWorkspaceRoot) {
            return JavaCore.create((IWorkspaceRoot)((IWorkspaceRoot)newInput));
        }
        return newInput;
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void getPipelinedChildren(Object parent, Set currentChildren) {
        Object[] children = this.getChildren(parent);
        Iterator iter = currentChildren.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof IResource)) continue;
            iter.remove();
        }
        currentChildren.addAll(Arrays.asList(children));
    }

    public void getPipelinedElements(Object input, Set currentElements) {
        Object[] children = this.getElements(input);
        Iterator iter = currentElements.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof IResource)) continue;
            iter.remove();
        }
        currentElements.addAll(Arrays.asList(children));
    }

    public Object getPipelinedParent(Object object, Object suggestedParent) {
        return this.getParent(object);
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification addModification) {
        return null;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification removeModification) {
        return null;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate refreshSynchronization) {
        HashSet<IJavaElement> interceptedElements = new HashSet<IJavaElement>();
        Iterator iter = refreshSynchronization.getRefreshTargets().iterator();
        while (iter.hasNext()) {
            IJavaElement javaElement;
            Object element = iter.next();
            if (!(element instanceof IResource) || (javaElement = JavaCore.create((IResource)((IResource)element))) == null || !javaElement.exists()) continue;
            iter.remove();
            interceptedElements.add(javaElement);
        }
        if (interceptedElements.size() > 0) {
            refreshSynchronization.getRefreshTargets().addAll(interceptedElements);
            return true;
        }
        return false;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate updateSynchronization) {
        return false;
    }

    protected void postAdd(Object parent, Object element) {
        if (parent instanceof IJavaModel) {
            super.postAdd(((IJavaModel)parent).getWorkspace(), element);
        } else {
            super.postAdd(parent, element);
        }
    }
}

