/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dnd.DelegatingDropAdapter;
import org.eclipse.jdt.internal.ui.dnd.JdtViewerDragAdapter;
import org.eclipse.jdt.internal.ui.dnd.ResourceTransferDragAdapter;
import org.eclipse.jdt.internal.ui.filters.OutputFolderFilter;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.packageview.CustomHashtable;
import org.eclipse.jdt.internal.ui.packageview.FileTransferDragAdapter;
import org.eclipse.jdt.internal.ui.packageview.FileTransferDropAdapter;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerActionGroup;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerLabelProvider;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jdt.internal.ui.packageview.SelectionTransferDragAdapter;
import org.eclipse.jdt.internal.ui.packageview.SelectionTransferDropAdapter;
import org.eclipse.jdt.internal.ui.packageview.WorkingSetAwareContentProvider;
import org.eclipse.jdt.internal.ui.packageview.WorkingSetAwareJavaElementSorter;
import org.eclipse.jdt.internal.ui.packageview.WorkingSetAwareLabelProvider;
import org.eclipse.jdt.internal.ui.packageview.WorkingSetDropAdapter;
import org.eclipse.jdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.jdt.internal.ui.util.JavaUIHelp;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.FilterUpdater;
import org.eclipse.jdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.jdt.internal.ui.viewsupport.StatusBarUpdater;
import org.eclipse.jdt.internal.ui.workingsets.ConfigureWorkingSetAction;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.actions.CustomFiltersActionGroup;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.framelist.FrameAction;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class PackageExplorerPart
extends ViewPart
implements ISetSelectionTarget,
IMenuListener,
IShowInTarget,
IPackagesViewPart,
IPropertyChangeListener,
IViewPartInputProvider {
    private static final String PERF_CREATE_PART_CONTROL = "org.eclipse.jdt.ui/perf/explorer/createPartControl";
    private static final String PERF_MAKE_ACTIONS = "org.eclipse.jdt.ui/perf/explorer/makeActions";
    private boolean fIsCurrentLayoutFlat;
    private static final int HIERARCHICAL_LAYOUT = 1;
    private static final int FLAT_LAYOUT = 2;
    public static final String VIEW_ID = "org.eclipse.jdt.ui.PackageExplorer";
    static final String TAG_SELECTION = "selection";
    static final String TAG_EXPANDED = "expanded";
    static final String TAG_ELEMENT = "element";
    static final String TAG_PATH = "path";
    static final String TAG_VERTICAL_POSITION = "verticalPosition";
    static final String TAG_HORIZONTAL_POSITION = "horizontalPosition";
    static final String TAG_FILTERS = "filters";
    static final String TAG_FILTER = "filter";
    static final String TAG_LAYOUT = "layout";
    static final String TAG_CURRENT_FRAME = "currentFramge";
    static final String TAG_ROOT_MODE = "rootMode";
    static final String SETTING_MEMENTO = "memento";
    private int fRootMode;
    private WorkingSetModel fWorkingSetModel;
    private PackageExplorerLabelProvider fLabelProvider;
    private PackageExplorerContentProvider fContentProvider;
    private FilterUpdater fFilterUpdater;
    private PackageExplorerActionGroup fActionSet;
    private ProblemTreeViewer fViewer;
    private Menu fContextMenu;
    private IMemento fMemento;
    private ISelection fLastOpenSelection;
    private ISelectionChangedListener fPostSelectionListener;
    private String fWorkingSetLabel;
    private IPartListener fPartListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                PackageExplorerPart.this.editorActivated((IEditorPart)part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private ITreeViewerListener fExpansionListener = new ITreeViewerListener(){

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            Object element = event.getElement();
            if (element instanceof ICompilationUnit || element instanceof IClassFile) {
                PackageExplorerPart.this.expandMainType(element);
            }
        }
    };
    private boolean fLinkingEnabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String settings;
        IDialogSettings section;
        super.init(site, memento);
        this.fMemento = memento;
        if (this.fMemento == null && (section = JavaPlugin.getDefault().getDialogSettings().getSection(this.getSectionName())) != null && (settings = section.get(SETTING_MEMENTO)) != null) {
            try {
                this.fMemento = XMLMemento.createReadRoot((Reader)new StringReader(settings));
            }
            catch (WorkbenchException workbenchException) {}
        }
        this.restoreRootMode(this.fMemento);
        if (this.showWorkingSets()) {
            this.createWorkingSetModel();
        }
        this.restoreLayoutState(memento);
    }

    private String getSectionName() {
        return "org.eclipse.jdt.ui.internal.packageExplorer";
    }

    private void restoreRootMode(IMemento memento) {
        if (memento != null) {
            Integer value = this.fMemento.getInteger(TAG_ROOT_MODE);
            int n = this.fRootMode = value == null ? 1 : value;
            if (this.fRootMode != 1 && this.fRootMode != 2) {
                this.fRootMode = 1;
            }
        } else {
            this.fRootMode = 1;
        }
    }

    private void restoreLayoutState(IMemento memento) {
        Integer state = null;
        if (memento != null) {
            state = memento.getInteger(TAG_LAYOUT);
        }
        if (state == null) {
            IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
            state = new Integer(store.getInt(TAG_LAYOUT));
        }
        this.fIsCurrentLayoutFlat = state == 2 ? true : state != 1;
    }

    public static PackageExplorerPart getFromActivePerspective() {
        IWorkbenchPage activePage = JavaPlugin.getActivePage();
        if (activePage == null) {
            return null;
        }
        IViewPart view = activePage.findView(VIEW_ID);
        if (view instanceof PackageExplorerPart) {
            return (PackageExplorerPart)view;
        }
        return null;
    }

    public static PackageExplorerPart openInActivePerspective() {
        try {
            return (PackageExplorerPart)JavaPlugin.getActivePage().showView(VIEW_ID);
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public void dispose() {
        if (this.fContextMenu != null && !this.fContextMenu.isDisposed()) {
            this.fContextMenu.dispose();
        }
        this.getSite().getPage().removePartListener(this.fPartListener);
        JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.fViewer != null) {
            this.fViewer.removeTreeListener(this.fExpansionListener);
            XMLMemento memento = XMLMemento.createWriteRoot((String)"packageexplorer");
            this.saveState((IMemento)memento);
            StringWriter writer = new StringWriter();
            try {
                memento.save((Writer)writer);
                String sectionName = this.getSectionName();
                IDialogSettings section = JavaPlugin.getDefault().getDialogSettings().getSection(sectionName);
                if (section == null) {
                    section = JavaPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
                }
                section.put(SETTING_MEMENTO, writer.getBuffer().toString());
            }
            catch (IOException iOException) {}
        }
        if (this.fActionSet != null) {
            this.fActionSet.dispose();
        }
        if (this.fFilterUpdater != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        }
        if (this.fWorkingSetModel != null) {
            this.fWorkingSetModel.dispose();
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        IEditorPart editor;
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_CREATE_PART_CONTROL, (Object)this);
        stats.startRun();
        this.fViewer = this.createViewer(parent);
        this.fViewer.setUseHashlookup(true);
        this.initDragAndDrop();
        this.setProviders();
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuMgr.createContextMenu((Control)this.fViewer.getTree());
        this.fViewer.getTree().setMenu(this.fContextMenu);
        IWorkbenchPartSite site = this.getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.fViewer);
        site.setSelectionProvider((ISelectionProvider)this.fViewer);
        site.getPage().addPartListener(this.fPartListener);
        if (this.fMemento != null) {
            this.restoreLinkingEnabled(this.fMemento);
        }
        this.makeActions();
        this.restoreFilterAndSorter();
        this.fViewer.setInput(this.findInputElement());
        this.initFrameActions();
        this.initKeyListener();
        this.fViewer.addPostSelectionChangedListener(this.fPostSelectionListener);
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PackageExplorerPart.this.fActionSet.handleDoubleClick(event);
            }
        });
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                PackageExplorerPart.this.fActionSet.handleOpen(event);
                PackageExplorerPart.this.fLastOpenSelection = event.getSelection();
            }
        });
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener(new StatusBarUpdater(slManager));
        this.fViewer.addTreeListener(this.fExpansionListener);
        if (this.fMemento != null) {
            this.restoreUIState(this.fMemento);
        }
        this.fMemento = null;
        JavaUIHelp.setHelp((StructuredViewer)this.fViewer, "org.eclipse.jdt.ui.package_view_context");
        this.fillActionBars();
        this.updateTitle();
        this.fFilterUpdater = new FilterUpdater((StructuredViewer)this.fViewer);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        if (this.isLinkingEnabled() && (editor = this.getViewSite().getPage().getActiveEditor()) != null) {
            this.editorActivated(editor);
        }
        stats.endRun();
    }

    private void initFrameActions() {
        this.fActionSet.getUpAction().update();
        this.fActionSet.getBackAction().update();
        this.fActionSet.getForwardAction().update();
    }

    private ProblemTreeViewer createViewer(Composite composite) {
        return new PackageExplorerProblemTreeViewer(composite, 770);
    }

    public boolean isFlatLayout() {
        return this.fIsCurrentLayoutFlat;
    }

    private void setProviders() {
        this.fContentProvider = this.createContentProvider();
        this.fContentProvider.setIsFlatLayout(this.fIsCurrentLayoutFlat);
        this.fViewer.setComparer(this.createElementComparer());
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fLabelProvider = this.createLabelProvider();
        this.fLabelProvider.setIsFlatLayout(this.fIsCurrentLayoutFlat);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(this.fLabelProvider, false));
    }

    void toggleLayout() {
        this.fIsCurrentLayoutFlat = !this.fIsCurrentLayoutFlat;
        this.saveLayoutState(null);
        this.fContentProvider.setIsFlatLayout(this.isFlatLayout());
        this.fLabelProvider.setIsFlatLayout(this.isFlatLayout());
        this.fViewer.getControl().setRedraw(false);
        this.fViewer.refresh();
        this.fViewer.getControl().setRedraw(true);
    }

    public PackageExplorerContentProvider createContentProvider() {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        boolean showCUChildren = store.getBoolean("org.eclipse.jdt.ui.packages.cuchildren");
        if (this.showProjects()) {
            return new PackageExplorerContentProvider(showCUChildren);
        }
        return new WorkingSetAwareContentProvider(showCUChildren, this.fWorkingSetModel);
    }

    private PackageExplorerLabelProvider createLabelProvider() {
        if (this.showProjects()) {
            return new PackageExplorerLabelProvider(0x212000200029L | JavaElementLabels.ALL_CATEGORY, 3, this.fContentProvider);
        }
        return new WorkingSetAwareLabelProvider(36421324767273L, 3, this.fContentProvider);
    }

    private IElementComparer createElementComparer() {
        if (this.showProjects()) {
            return null;
        }
        return WorkingSetModel.COMPARER;
    }

    private void fillActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fActionSet.fillActionBars(actionBars);
    }

    private Object findInputElement() {
        if (this.showWorkingSets()) {
            return this.fWorkingSetModel;
        }
        IAdaptable input = this.getSite().getPage().getInput();
        if (input instanceof IWorkspace) {
            return JavaCore.create((IWorkspaceRoot)((IWorkspace)input).getRoot());
        }
        if (input instanceof IContainer) {
            IJavaElement element = JavaCore.create((IResource)((IContainer)input));
            if (element != null && element.exists()) {
                return element;
            }
            return input;
        }
        return JavaCore.create((IWorkspaceRoot)JavaPlugin.getWorkspace().getRoot());
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.viewers.ISelectionProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return this.fViewer;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz2) {
            return this.getShowInSource();
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz3) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.help.IContextProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz4) {
            return JavaUIHelp.getHelpContextProvider((IWorkbenchPart)this, "org.eclipse.jdt.ui.package_view_context");
        }
        return super.getAdapter(key);
    }

    String getToolTipText(Object element) {
        IPath path;
        String result = !(element instanceof IResource) ? (element instanceof IJavaModel ? PackagesMessages.PackageExplorerPart_workspace : (element instanceof IJavaElement ? JavaElementLabels.getTextLabel(element, 36283885813801L) : (element instanceof IWorkingSet ? ((IWorkingSet)element).getLabel() : (element instanceof WorkingSetModel ? PackagesMessages.PackageExplorerPart_workingSetModel : this.fLabelProvider.getText(element))))) : ((path = ((IResource)element).getFullPath()).isRoot() ? PackagesMessages.PackageExplorer_title : path.makeRelative().toString());
        if (this.fWorkingSetLabel == null) {
            return result;
        }
        String wsstr = Messages.format(PackagesMessages.PackageExplorer_toolTip, new String[]{this.fWorkingSetLabel});
        if (result.length() == 0) {
            return wsstr;
        }
        return Messages.format(PackagesMessages.PackageExplorer_toolTip2, new String[]{result, this.fWorkingSetLabel});
    }

    public String getTitleToolTip() {
        if (this.fViewer == null) {
            return super.getTitleToolTip();
        }
        return this.getToolTipText(this.fViewer.getInput());
    }

    public void setFocus() {
        this.fViewer.getTree().setFocus();
    }

    private ISelection getSelection() {
        return this.fViewer.getSelection();
    }

    public void menuAboutToShow(IMenuManager menu) {
        JavaPlugin.createStandardGroups(menu);
        this.fActionSet.setContext(new ActionContext(this.getSelection()));
        this.fActionSet.fillContextMenu(menu);
        this.fActionSet.setContext(null);
    }

    private void makeActions() {
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_MAKE_ACTIONS, (Object)this);
        stats.startRun();
        this.fActionSet = new PackageExplorerActionGroup(this);
        if (this.fWorkingSetModel != null) {
            this.fActionSet.getWorkingSetActionGroup().setWorkingSetModel(this.fWorkingSetModel);
        }
        stats.endRun();
    }

    private void initDragAndDrop() {
        this.initDrag();
        this.initDrop();
    }

    private void initDrag() {
        int ops = 7;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance()};
        TransferDragSourceListener[] dragListeners = new TransferDragSourceListener[]{new SelectionTransferDragAdapter((ISelectionProvider)this.fViewer), new ResourceTransferDragAdapter((ISelectionProvider)this.fViewer), new FileTransferDragAdapter((ISelectionProvider)this.fViewer)};
        this.fViewer.addDragSupport(ops, transfers, new JdtViewerDragAdapter((StructuredViewer)this.fViewer, dragListeners));
    }

    private void initDrop() {
        int ops = 23;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), FileTransfer.getInstance()};
        TransferDropTargetListener[] dropListeners = new TransferDropTargetListener[]{new SelectionTransferDropAdapter((StructuredViewer)this.fViewer), new FileTransferDropAdapter((AbstractTreeViewer)this.fViewer), new WorkingSetDropAdapter(this)};
        this.fViewer.addDropSupport(ops, transfers, new DelegatingDropAdapter(dropListeners));
    }

    private void handlePostSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (this.isLinkingEnabled() && !selection.equals(this.fLastOpenSelection)) {
            this.linkToEditor((IStructuredSelection)selection);
        }
        this.fLastOpenSelection = null;
    }

    public void selectReveal(ISelection selection) {
        this.selectReveal(selection, 0);
    }

    private void selectReveal(final ISelection selection, final int count) {
        Control ctrl = this.getViewer().getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        ISelection javaSelection = this.convertSelection(selection);
        this.fViewer.setSelection(javaSelection, true);
        PackageExplorerContentProvider provider = (PackageExplorerContentProvider)this.getViewer().getContentProvider();
        ISelection cs = this.fViewer.getSelection();
        if (count == 0 && provider.hasPendingChanges() && !javaSelection.equals(cs)) {
            ctrl.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PackageExplorerPart.this.selectReveal(selection, count + 1);
                }
            });
        }
    }

    public ISelection convertSelection(ISelection s) {
        if (!(s instanceof IStructuredSelection)) {
            return s;
        }
        Object[] elements = ((IStructuredSelection)s).toArray();
        int i = 0;
        while (i < elements.length) {
            elements[i] = this.convertElement(elements[i]);
            ++i;
        }
        return new StructuredSelection(elements);
    }

    private Object convertElement(Object original) {
        if (original instanceof IJavaElement) {
            return original;
        }
        if (original instanceof IResource) {
            IJavaElement je = JavaCore.create((IResource)((IResource)original));
            if (je != null && je.exists()) {
                return je;
            }
        } else if (original instanceof IAdaptable) {
            IResource r;
            IJavaElement je;
            IAdaptable adaptable = (IAdaptable)original;
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((je = (IJavaElement)adaptable.getAdapter((Class)clazz)) != null && je.exists()) {
                return je;
            }
            Class<?> clazz2 = class$5;
            if (clazz2 == null) {
                try {
                    clazz2 = class$5 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((r = (IResource)adaptable.getAdapter((Class)clazz2)) != null) {
                je = JavaCore.create((IResource)r);
                if (je != null && je.exists()) {
                    return je;
                }
                return r;
            }
        }
        return original;
    }

    public void selectAndReveal(Object element) {
        this.selectReveal((ISelection)new StructuredSelection(element));
    }

    public boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    private void initLinkingEnabled() {
        this.fLinkingEnabled = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.packages.linktoeditor");
    }

    private void linkToEditor(IStructuredSelection selection) {
        IEditorPart part;
        if (!this.isActivePart()) {
            return;
        }
        Object obj = selection.getFirstElement();
        if (selection.size() == 1 && (part = EditorUtility.isOpenInEditor(obj)) != null) {
            IWorkbenchPage page = this.getSite().getPage();
            page.bringToTop((IWorkbenchPart)part);
            if (obj instanceof IJavaElement) {
                EditorUtility.revealInEditor(part, (IJavaElement)obj);
            }
        }
    }

    private boolean isActivePart() {
        return this == this.getSite().getPage().getActivePart();
    }

    public void saveState(IMemento memento) {
        if (this.fViewer == null) {
            if (this.fMemento != null) {
                memento.putMemento(this.fMemento);
            }
            return;
        }
        memento.putInteger(TAG_ROOT_MODE, this.fRootMode);
        if (this.fWorkingSetModel != null) {
            this.fWorkingSetModel.saveState(memento);
        }
        this.saveLayoutState(memento);
        this.saveLinkingEnabled(memento);
        this.fActionSet.saveFilterAndSorterState(memento);
    }

    private void saveLinkingEnabled(IMemento memento) {
        memento.putInteger("org.eclipse.jdt.ui.packages.linktoeditor", this.fLinkingEnabled ? 1 : 0);
    }

    private void saveLayoutState(IMemento memento) {
        if (memento != null) {
            memento.putInteger(TAG_LAYOUT, this.getLayoutAsInt());
        } else {
            IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
            store.setValue(TAG_LAYOUT, this.getLayoutAsInt());
        }
    }

    private int getLayoutAsInt() {
        if (this.fIsCurrentLayoutFlat) {
            return 2;
        }
        return 1;
    }

    protected void saveScrollState(IMemento memento, Tree tree) {
        ScrollBar bar = tree.getVerticalBar();
        int position = bar != null ? bar.getSelection() : 0;
        memento.putString(TAG_VERTICAL_POSITION, String.valueOf(position));
        bar = tree.getHorizontalBar();
        position = bar != null ? bar.getSelection() : 0;
        memento.putString(TAG_HORIZONTAL_POSITION, String.valueOf(position));
    }

    protected void saveSelectionState(IMemento memento) {
        Object[] elements = ((IStructuredSelection)this.fViewer.getSelection()).toArray();
        if (elements.length > 0) {
            IMemento selectionMem = memento.createChild(TAG_SELECTION);
            int i = 0;
            while (i < elements.length) {
                IMemento elementMem = selectionMem.createChild(TAG_ELEMENT);
                Object o = elements[i];
                if (o instanceof IJavaElement) {
                    elementMem.putString(TAG_PATH, ((IJavaElement)elements[i]).getHandleIdentifier());
                }
                ++i;
            }
        }
    }

    protected void saveExpansionState(IMemento memento) {
        Object[] expandedElements = this.fViewer.getVisibleExpandedElements();
        if (expandedElements.length > 0) {
            IMemento expandedMem = memento.createChild(TAG_EXPANDED);
            int i = 0;
            while (i < expandedElements.length) {
                IMemento elementMem = expandedMem.createChild(TAG_ELEMENT);
                Object o = expandedElements[i];
                if (o instanceof IJavaElement) {
                    elementMem.putString(TAG_PATH, ((IJavaElement)expandedElements[i]).getHandleIdentifier());
                }
                ++i;
            }
        }
    }

    private void restoreFilterAndSorter() {
        this.fViewer.addFilter(new OutputFolderFilter());
        this.setSorter();
        if (this.fMemento != null) {
            this.fActionSet.restoreFilterAndSorterState(this.fMemento);
        }
    }

    private void restoreUIState(IMemento memento) {
    }

    private void restoreLinkingEnabled(IMemento memento) {
        Integer val = memento.getInteger("org.eclipse.jdt.ui.packages.linktoeditor");
        if (val != null) {
            this.fLinkingEnabled = val != 0;
        }
    }

    protected void restoreScrollState(IMemento memento, Tree tree) {
        int position;
        String posStr;
        ScrollBar bar = tree.getVerticalBar();
        if (bar != null) {
            try {
                posStr = memento.getString(TAG_VERTICAL_POSITION);
                position = new Integer(posStr);
                bar.setSelection(position);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((bar = tree.getHorizontalBar()) != null) {
            try {
                posStr = memento.getString(TAG_HORIZONTAL_POSITION);
                position = new Integer(posStr);
                bar.setSelection(position);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    protected void restoreSelectionState(IMemento memento) {
        IMemento childMem = memento.getChild(TAG_SELECTION);
        if (childMem != null) {
            ArrayList<IJavaElement> list = new ArrayList<IJavaElement>();
            IMemento[] elementMem = childMem.getChildren(TAG_ELEMENT);
            int i = 0;
            while (i < elementMem.length) {
                IJavaElement element = JavaCore.create((String)elementMem[i].getString(TAG_PATH));
                if (element != null) {
                    list.add(element);
                }
                ++i;
            }
            this.fViewer.setSelection((ISelection)new StructuredSelection(list));
        }
    }

    protected void restoreExpansionState(IMemento memento) {
        IMemento childMem = memento.getChild(TAG_EXPANDED);
        if (childMem != null) {
            ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
            IMemento[] elementMem = childMem.getChildren(TAG_ELEMENT);
            int i = 0;
            while (i < elementMem.length) {
                IJavaElement element = JavaCore.create((String)elementMem[i].getString(TAG_PATH));
                if (element != null) {
                    elements.add(element);
                }
                ++i;
            }
            this.fViewer.setExpandedElements(elements.toArray());
        }
    }

    private void initKeyListener() {
        this.fViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                PackageExplorerPart.this.fActionSet.handleKeyEvent(event);
            }
        });
    }

    void editorActivated(IEditorPart editor) {
        if (!this.isLinkingEnabled()) {
            return;
        }
        Object input = this.getElementOfInput(editor.getEditorInput());
        if (input == null) {
            return;
        }
        if (!this.inputIsSelected(editor.getEditorInput())) {
            this.showInput(input);
        } else {
            this.getTreeViewer().getTree().showSelection();
        }
    }

    private boolean inputIsSelected(IEditorInput input) {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (selection.size() != 1) {
            return false;
        }
        IEditorInput selectionAsInput = null;
        try {
            selectionAsInput = EditorUtility.getEditorInput(selection.getFirstElement());
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        return input.equals(selectionAsInput);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean showInput(Object input) {
        Object element = null;
        if (input instanceof IFile && this.isOnClassPath((IFile)input)) {
            element = JavaCore.create((IFile)((IFile)input));
        }
        if (element == null) {
            element = input;
        }
        if (element == null) return false;
        StructuredSelection newSelection = new StructuredSelection(element);
        if (this.fViewer.getSelection().equals(newSelection)) {
            this.fViewer.reveal(element);
            return true;
        }
        try {
            this.fViewer.removePostSelectionChangedListener(this.fPostSelectionListener);
            this.fViewer.setSelection((ISelection)newSelection, true);
            while (element != null && this.fViewer.getSelection().isEmpty()) {
                if ((element = this.getParent(element)) == null) continue;
                newSelection = new StructuredSelection(element);
                this.fViewer.setSelection((ISelection)newSelection, true);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.fViewer.addPostSelectionChangedListener(this.fPostSelectionListener);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.fViewer.addPostSelectionChangedListener(this.fPostSelectionListener);
        return true;
    }

    private boolean isOnClassPath(IFile file) {
        IJavaProject jproject = JavaCore.create((IProject)file.getProject());
        return jproject.isOnClasspath((IResource)file);
    }

    private Object getParent(Object element) {
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).getParent();
        }
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    void expandMainType(Object element) {
        try {
            IType type = null;
            if (element instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)element;
                IType[] types = cu.getTypes();
                if (types.length > 0) {
                    type = types[0];
                }
            } else if (element instanceof IClassFile) {
                IClassFile cf = (IClassFile)element;
                type = cf.getType();
            }
            if (type != null) {
                final IType type2 = type;
                Control ctrl = this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ctrl.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            Control ctrl2 = PackageExplorerPart.this.fViewer.getControl();
                            if (ctrl2 != null && !ctrl2.isDisposed()) {
                                PackageExplorerPart.this.fViewer.expandToLevel(type2, 1);
                            }
                        }
                    });
                }
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    Object getElementOfInput(IEditorInput input) {
        if (input instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)input).getClassFile();
        }
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        if (input instanceof JarEntryEditorInput) {
            return ((JarEntryEditorInput)input).getStorage();
        }
        return null;
    }

    TreeViewer getViewer() {
        return this.fViewer;
    }

    public TreeViewer getTreeViewer() {
        return this.fViewer;
    }

    boolean isExpandable(Object element) {
        if (this.fViewer == null) {
            return false;
        }
        return this.fViewer.isExpandable(element);
    }

    void setWorkingSetLabel(String workingSetName) {
        this.fWorkingSetLabel = workingSetName;
    }

    void updateTitle() {
        Object input = this.fViewer.getInput();
        if (input == null || input instanceof IJavaModel) {
            this.setContentDescription("");
            this.setTitleToolTip("");
        } else {
            String inputText = JavaElementLabels.getTextLabel(input, 36283885813801L);
            this.setContentDescription(inputText);
            this.setTitleToolTip(this.getToolTipText(input));
        }
    }

    public void setLabelDecorator(ILabelDecorator decorator) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fViewer == null) {
            return;
        }
        boolean refreshViewer = false;
        if ("org.eclipse.jdt.ui.packages.cuchildren".equals(event.getProperty())) {
            this.fActionSet.updateActionBars(this.getViewSite().getActionBars());
            boolean showCUChildren = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.packages.cuchildren");
            ((StandardJavaElementContentProvider)this.fViewer.getContentProvider()).setProvideMembers(showCUChildren);
            refreshViewer = true;
        } else if (MembersOrderPreferenceCache.isMemberOrderProperty(event.getProperty())) {
            refreshViewer = true;
        }
        if (refreshViewer) {
            this.fViewer.refresh();
        }
    }

    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void collapseAll() {
        try {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.collapseToLevel(this.getViewPartInput(), -1);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fViewer.getControl().setRedraw(true);
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.fViewer.getControl().setRedraw(true);
    }

    public PackageExplorerPart() {
        this.initLinkingEnabled();
        this.fPostSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PackageExplorerPart.this.handlePostSelectionChanged(event);
            }
        };
    }

    public boolean show(ShowInContext context) {
        IStructuredSelection structuredSelection;
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && this.tryToReveal(structuredSelection.getFirstElement())) {
            return true;
        }
        Object input = context.getInput();
        if (input instanceof IEditorInput) {
            Object elementOfInput = this.getElementOfInput((IEditorInput)context.getInput());
            return elementOfInput != null && this.tryToReveal(elementOfInput);
        }
        return false;
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(PackageExplorerPart.this.getViewer().getInput(), PackageExplorerPart.this.getViewer().getSelection());
            }
        };
    }

    public void setLinkingEnabled(boolean enabled) {
        IEditorPart editor;
        this.fLinkingEnabled = enabled;
        PreferenceConstants.getPreferenceStore().setValue("org.eclipse.jdt.ui.packages.linktoeditor", enabled);
        if (enabled && (editor = this.getSite().getPage().getActiveEditor()) != null) {
            this.editorActivated(editor);
        }
    }

    String getFrameName(Object element) {
        if (element instanceof IJavaElement) {
            return ((IJavaElement)element).getElementName();
        }
        if (element instanceof WorkingSetModel) {
            return "";
        }
        return this.fLabelProvider.getText(element);
    }

    void projectStateChanged(Object root) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            this.fViewer.refresh(root, true);
            this.fViewer.setSelection(this.fViewer.getSelection());
        }
    }

    public boolean tryToReveal(Object element) {
        String[] newFilters;
        CustomFiltersActionGroup filterGroup;
        String[] currentFilters;
        if (this.revealElementOrParent(element)) {
            return true;
        }
        WorkingSetFilterActionGroup workingSetGroup = this.fActionSet.getWorkingSetActionGroup().getFilterGroup();
        if (workingSetGroup != null) {
            IWorkingSet workingSet = workingSetGroup.getWorkingSet();
            if (workingSetGroup.isFiltered(this.getVisibleParent(element), element)) {
                String message = Messages.format(PackagesMessages.PackageExplorer_notFound, workingSet.getLabel());
                if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)PackagesMessages.PackageExplorer_filteredDialog_title, (String)message)) {
                    workingSetGroup.setWorkingSet(null, true);
                    if (this.revealElementOrParent(element)) {
                        return true;
                    }
                }
            }
        }
        if ((currentFilters = (filterGroup = this.fActionSet.getCustomFilterActionGroup()).internalGetEnabledFilterIds()).length > (newFilters = filterGroup.removeFiltersFor(this.getVisibleParent(element), element, this.getTreeViewer().getContentProvider())).length) {
            String message = PackagesMessages.PackageExplorer_removeFilters;
            if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)PackagesMessages.PackageExplorer_filteredDialog_title, (String)message)) {
                filterGroup.setFilters(newFilters);
                if (this.revealElementOrParent(element)) {
                    return true;
                }
            }
        }
        FrameAction action = this.fActionSet.getUpAction();
        while (action.getFrameList().getCurrentIndex() > 0) {
            if (action.getFrameList().getSource().getFrame(3, 0) == null) break;
            action.run();
            if (!this.revealElementOrParent(element)) continue;
            return true;
        }
        return false;
    }

    private boolean revealElementOrParent(Object element) {
        if (this.revealAndVerify(element)) {
            return true;
        }
        if ((element = this.getVisibleParent(element)) != null) {
            IResource resource;
            if (this.revealAndVerify(element)) {
                return true;
            }
            if (element instanceof IJavaElement && (resource = ((IJavaElement)element).getResource()) != null && this.revealAndVerify(resource)) {
                return true;
            }
        }
        return false;
    }

    private Object getVisibleParent(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof IJavaElement)) {
            return object;
        }
        IJavaElement element2 = (IJavaElement)object;
        switch (element2.getElementType()) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                element2 = (IJavaElement)element2.getOpenable();
                break;
            }
            case 1: {
                element2 = null;
            }
        }
        return element2;
    }

    private boolean revealAndVerify(Object element) {
        if (element == null) {
            return false;
        }
        this.selectReveal((ISelection)new StructuredSelection(element));
        return !this.getSite().getSelectionProvider().getSelection().isEmpty();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rootModeChanged(int newMode) {
        this.fRootMode = newMode;
        if (this.showWorkingSets() && this.fWorkingSetModel == null) {
            this.createWorkingSetModel();
            if (this.fActionSet != null) {
                this.fActionSet.getWorkingSetActionGroup().setWorkingSetModel(this.fWorkingSetModel);
            }
        }
        ISelection selection = this.fViewer.getSelection();
        Object input = this.fViewer.getInput();
        boolean isRootInputChange = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).equals(input) || this.fWorkingSetModel != null && this.fWorkingSetModel.equals(input) || input instanceof IWorkingSet;
        try {
            this.fViewer.getControl().setRedraw(false);
            if (isRootInputChange) {
                this.fViewer.setInput(null);
            }
            this.setProviders();
            this.setSorter();
            this.fActionSet.getWorkingSetActionGroup().fillFilters((StructuredViewer)this.fViewer);
            if (isRootInputChange) {
                this.fViewer.setInput(this.findInputElement());
            }
            this.fViewer.setSelection(selection, true);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.fViewer.getControl().setRedraw(true);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.fViewer.getControl().setRedraw(true);
        if (isRootInputChange && this.showWorkingSets() && this.fWorkingSetModel.needsConfiguration()) {
            ConfigureWorkingSetAction action = new ConfigureWorkingSetAction(this.getSite());
            action.setWorkingSetModel(this.fWorkingSetModel);
            action.run();
            this.fWorkingSetModel.configured();
        }
    }

    private void createWorkingSetModel() {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                PackageExplorerPart.this.fWorkingSetModel = PackageExplorerPart.this.fMemento != null ? new WorkingSetModel(PackageExplorerPart.this.fMemento) : new WorkingSetModel();
            }

            public void handleException(Throwable exception) {
                PackageExplorerPart.this.fWorkingSetModel = new WorkingSetModel();
            }
        });
    }

    public WorkingSetModel getWorkingSetModel() {
        return this.fWorkingSetModel;
    }

    public int getRootMode() {
        return this.fRootMode;
    }

    boolean showProjects() {
        return this.fRootMode == 1;
    }

    boolean showWorkingSets() {
        return this.fRootMode == 2;
    }

    private void setSorter() {
        if (this.showWorkingSets()) {
            this.fViewer.setSorter(new WorkingSetAwareJavaElementSorter());
        } else {
            this.fViewer.setSorter(new JavaElementSorter());
        }
    }

    public void internalTestShowWorkingSets(IWorkingSet[] workingSets) {
        if (this.fWorkingSetModel == null) {
            this.createWorkingSetModel();
        }
        this.fWorkingSetModel.setActiveWorkingSets(workingSets);
        this.fWorkingSetModel.configured();
        this.rootModeChanged(2);
    }

    private class PackageExplorerProblemTreeViewer
    extends ProblemTreeViewer {
        private List fPendingRefreshes = Collections.synchronizedList(new ArrayList());
        private boolean fInPreserveSelection;

        public PackageExplorerProblemTreeViewer(Composite parent, int style) {
            super(parent, style);
        }

        public void add(Object parentElement, Object[] childElements) {
            if (this.fPendingRefreshes.contains(parentElement)) {
                return;
            }
            super.add(parentElement, childElements);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void internalRefresh(Object element, boolean updateLabels) {
            try {
                this.fPendingRefreshes.add(element);
                super.internalRefresh(element, updateLabels);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.fPendingRefreshes.remove(element);
                throw throwable;
            }
            {
                Object var3_5 = null;
                this.fPendingRefreshes.remove(element);
            }
        }

        protected Object[] getFilteredChildren(Object parent) {
            Object[] children = this.getRawChildren(parent);
            if (!this.hasFilters()) {
                return children;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            ViewerFilter[] filters = this.getFilters();
            int i = 0;
            while (i < children.length) {
                Object object = children[i];
                if (!this.isFiltered(object, parent, filters)) {
                    list.add(object);
                }
                ++i;
            }
            return list.toArray();
        }

        protected boolean evaluateExpandableWithFilters(Object parent) {
            if (parent instanceof IJavaProject || parent instanceof ICompilationUnit || parent instanceof IClassFile || parent instanceof ClassPathContainer) {
                return false;
            }
            return !(parent instanceof IPackageFragmentRoot) || !((IPackageFragmentRoot)parent).isArchive();
        }

        protected boolean isFiltered(Object object, Object parent, ViewerFilter[] filters) {
            boolean res = super.isFiltered(object, parent, filters);
            if (res && this.isEssential(object)) {
                return false;
            }
            return res;
        }

        protected Object[] filter(Object[] elements) {
            if (PackageExplorerPart.this.isFlatLayout()) {
                return super.filter(elements);
            }
            ViewerFilter[] filters = this.getFilters();
            if (filters == null || filters.length == 0) {
                return elements;
            }
            ArrayList<Object> filtered = new ArrayList<Object>(elements.length);
            Object root = this.getRoot();
            int i = 0;
            while (i < elements.length) {
                boolean add = true;
                if (!this.isEssential(elements[i])) {
                    int j = 0;
                    while (j < filters.length) {
                        add = filters[j].select((Viewer)this, root, elements[i]);
                        if (!add) break;
                        ++j;
                    }
                }
                if (add) {
                    filtered.add(elements[i]);
                }
                ++i;
            }
            return filtered.toArray();
        }

        private boolean isEssential(Object object) {
            try {
                if (!PackageExplorerPart.this.isFlatLayout() && object instanceof IPackageFragment) {
                    IPackageFragment fragment = (IPackageFragment)object;
                    return !fragment.isDefaultPackage() && fragment.hasSubpackages();
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            return false;
        }

        protected void handleInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
            IStructuredSelection is = (IStructuredSelection)invalidSelection;
            ArrayList<Object> ns = null;
            ns = newSelection instanceof IStructuredSelection ? new ArrayList(((IStructuredSelection)newSelection).toList()) : new ArrayList<Object>();
            boolean changed = false;
            Iterator iter = is.iterator();
            while (iter.hasNext()) {
                IProject project;
                Object element = iter.next();
                if (element instanceof IJavaProject) {
                    project = ((IJavaProject)element).getProject();
                    if (project.isOpen() || !project.exists()) continue;
                    ns.add(project);
                    changed = true;
                    continue;
                }
                if (!(element instanceof IProject) || !(project = (IProject)element).isOpen()) continue;
                IJavaProject jProject = JavaCore.create((IProject)project);
                if (jProject != null && jProject.exists()) {
                    ns.add(jProject);
                }
                changed = true;
            }
            if (changed) {
                newSelection = new StructuredSelection(ns);
                this.setSelection(newSelection);
            }
            super.handleInvalidSelection(invalidSelection, newSelection);
        }

        protected Object[] addAditionalProblemParents(Object[] elements) {
            if (PackageExplorerPart.this.showWorkingSets()) {
                return PackageExplorerPart.this.fWorkingSetModel.addWorkingSets(elements);
            }
            return elements;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void preservingSelection(Runnable updateCode) {
            try {
                this.fInPreserveSelection = true;
                super.preservingSelection(updateCode);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.fInPreserveSelection = false;
                throw throwable;
            }
            {
                Object var2_4 = null;
                this.fInPreserveSelection = false;
                return;
            }
        }

        protected void setSelectionToWidget(ISelection selection, boolean reveal) {
            super.setSelectionToWidget(selection, reveal);
        }

        private Widget internalFindChild(Widget parent, Object element) {
            Item[] items = this.getChildren(parent);
            int i = 0;
            while (i < items.length) {
                Item item = items[i];
                Object data = item.getData();
                if (data != null && this.equals(data, element)) {
                    return item;
                }
                ++i;
            }
            return null;
        }

        private CustomHashtable createRootAccessedMap(TreePath[] paths) {
            CustomHashtable result = new CustomHashtable(this.getComparer());
            int i = 0;
            while (i < paths.length) {
                TreePath path = paths[i];
                Object root = path.getFirstSegment();
                if (root != null) {
                    result.put(root, path);
                }
                ++i;
            }
            return result;
        }
    }
}

