/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.FileEntry;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.NLSSearchQuery;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class NLSSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private NLSSearchQuery fQuery;
    private final List fFileEntryGroups;

    public NLSSearchResult(NLSSearchQuery query) {
        this.fQuery = query;
        this.fFileEntryGroups = new ArrayList();
    }

    public void addFileEntryGroup(FileEntry group) {
        this.fFileEntryGroups.add(group);
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return this.computeContainedMatches(result, fileEditorInput.getFile());
        }
        if (editorInput instanceof IClassFileEditorInput) {
            IClassFileEditorInput classFileEditorInput = (IClassFileEditorInput)editorInput;
            HashSet matches = new HashSet();
            this.collectMatches(matches, (IJavaElement)classFileEditorInput.getClassFile());
            return matches.toArray(new Match[matches.size()]);
        }
        return null;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        ArrayList<Match> matches = new ArrayList<Match>();
        Iterator iter = this.fFileEntryGroups.iterator();
        while (iter.hasNext()) {
            FileEntry element = (FileEntry)iter.next();
            if (!element.getPropertiesFile().equals((Object)file)) continue;
            matches.addAll(Arrays.asList(this.getMatches(element)));
        }
        if (matches.size() > 0) {
            return matches.toArray(new Match[matches.size()]);
        }
        IJavaElement javaElement = JavaCore.create((IFile)file);
        HashSet matchesSet = new HashSet();
        this.collectMatches(matchesSet, javaElement);
        return matchesSet.toArray(new Match[matchesSet.size()]);
    }

    private void collectMatches(Set matches, IJavaElement element) {
        Match[] m = this.getMatches(element);
        if (m.length != 0) {
            int i = 0;
            while (i < m.length) {
                matches.add(m[i]);
                ++i;
            }
        }
        if (element instanceof IParent) {
            IParent parent = (IParent)element;
            try {
                IJavaElement[] children = parent.getChildren();
                int i = 0;
                while (i < children.length) {
                    this.collectMatches(matches, children[i]);
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    public IFile getFile(Object element) {
        if (element instanceof FileEntry) {
            return ((FileEntry)element).getPropertiesFile();
        }
        IJavaElement javaElement = (IJavaElement)element;
        IResource resource = null;
        try {
            resource = javaElement.getCorrespondingResource();
        }
        catch (JavaModelException javaModelException) {}
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (match.getElement() instanceof FileEntry) {
            IFile file = ((FileEntry)match.getElement()).getPropertiesFile();
            if (editorInput instanceof IFileEditorInput) {
                return ((IFileEditorInput)editorInput).getFile().equals((Object)file);
            }
        } else if (match.getElement() instanceof IJavaElement) {
            IJavaElement je = (IJavaElement)match.getElement();
            if (editorInput instanceof IFileEditorInput) {
                ICompilationUnit cu;
                block9: {
                    try {
                        cu = (ICompilationUnit)je.getAncestor(5);
                        if (cu != null) break block9;
                        return false;
                    }
                    catch (JavaModelException javaModelException) {
                        return false;
                    }
                }
                return ((IFileEditorInput)editorInput).getFile().equals((Object)cu.getCorrespondingResource());
            }
            if (editorInput instanceof IClassFileEditorInput) {
                return ((IClassFileEditorInput)editorInput).getClassFile().equals(je.getAncestor(6));
            }
        }
        return false;
    }

    public String getLabel() {
        return this.fQuery.getResultLabel(this.getMatchCount());
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return JavaPluginImages.DESC_OBJS_SEARCH_REF;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }
}

