/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.search.ExceptionOccurrencesGroupKey;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.ui.text.Match;

public class ExceptionOccurrencesFinder
extends ASTVisitor
implements IOccurrencesFinder {
    public static final String IS_EXCEPTION = "isException";
    private AST fAST;
    private Name fSelectedName;
    private ITypeBinding fException;
    private ASTNode fStart;
    private List fResult = new ArrayList();

    public String initialize(CompilationUnit root, int offset, int length) {
        return this.initialize(root, NodeFinder.perform((ASTNode)root, offset, length));
    }

    public String initialize(CompilationUnit root, ASTNode node) {
        IVariableBinding var;
        CatchClause catchClause;
        TryStatement tryStatement;
        this.fAST = root.getAST();
        if (!(node instanceof Name)) {
            return SearchMessages.ExceptionOccurrencesFinder_no_exception;
        }
        this.fSelectedName = ASTNodes.getTopMostName((Name)node);
        ASTNode parent = this.fSelectedName.getParent();
        MethodDeclaration decl = this.resolveMethodDeclaration(parent);
        if (decl != null && this.methodThrowsException(decl, this.fSelectedName)) {
            this.fException = this.fSelectedName.resolveTypeBinding();
            this.fStart = decl.getBody();
        } else if (parent instanceof Type && (parent = parent.getParent()) instanceof SingleVariableDeclaration && parent.getParent() instanceof CatchClause && (tryStatement = (TryStatement)(catchClause = (CatchClause)parent.getParent()).getParent()) != null && (var = catchClause.getException().resolveBinding()) != null && var.getType() != null) {
            this.fException = var.getType();
            this.fStart = tryStatement.getBody();
        }
        if (this.fException == null || this.fStart == null) {
            return SearchMessages.ExceptionOccurrencesFinder_no_exception;
        }
        return null;
    }

    private MethodDeclaration resolveMethodDeclaration(ASTNode node) {
        if (node instanceof MethodDeclaration) {
            return (MethodDeclaration)node;
        }
        Javadoc doc = (Javadoc)ASTNodes.getParent(node, 29);
        if (doc == null) {
            return null;
        }
        if (doc.getParent() instanceof MethodDeclaration) {
            return (MethodDeclaration)doc.getParent();
        }
        return null;
    }

    private boolean methodThrowsException(MethodDeclaration method, Name exception) {
        ASTMatcher matcher = new ASTMatcher();
        Iterator iter = method.thrownExceptions().iterator();
        while (iter.hasNext()) {
            Name thrown = (Name)iter.next();
            if (!exception.subtreeMatch(matcher, (Object)thrown)) continue;
            return true;
        }
        return false;
    }

    public List perform() {
        this.fStart.accept((ASTVisitor)this);
        if (this.fSelectedName != null) {
            this.fResult.add(this.fSelectedName);
        }
        return this.fResult;
    }

    public void collectOccurrenceMatches(IJavaElement element, IDocument document, Collection resultingMatches) {
        HashMap<Integer, ExceptionOccurrencesGroupKey> lineToLineElement = new HashMap<Integer, ExceptionOccurrencesGroupKey>();
        Iterator iter = this.fResult.iterator();
        while (iter.hasNext()) {
            ASTNode node = (ASTNode)iter.next();
            int startPosition = node.getStartPosition();
            int length = node.getLength();
            try {
                boolean isException = node == this.fSelectedName;
                int line = document.getLineOfOffset(startPosition);
                Integer lineInteger = new Integer(line);
                ExceptionOccurrencesGroupKey groupKey = (ExceptionOccurrencesGroupKey)lineToLineElement.get(lineInteger);
                if (groupKey == null) {
                    IRegion region = document.getLineInformation(line);
                    String lineContents = document.get(region.getOffset(), region.getLength()).trim();
                    groupKey = new ExceptionOccurrencesGroupKey(element, line, lineContents, isException);
                    lineToLineElement.put(lineInteger, groupKey);
                } else if (isException) {
                    groupKey.setException(true);
                }
                Match match = new Match((Object)groupKey, startPosition, length);
                resultingMatches.add(match);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public String getJobLabel() {
        return SearchMessages.ExceptionOccurrencesFinder_searchfor;
    }

    public String getPluralLabel(String elementName) {
        Object[] args = new String[]{ASTNodes.asString((ASTNode)this.fSelectedName), "{0}", elementName};
        return Messages.format(SearchMessages.ExceptionOccurrencesFinder_label_plural, args);
    }

    public String getSingularLabel(String elementName) {
        Object[] args = new String[]{ASTNodes.asString((ASTNode)this.fSelectedName), elementName};
        return Messages.format(SearchMessages.ExceptionOccurrencesFinder_label_singular, args);
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return false;
    }

    public boolean visit(CastExpression node) {
        if ("java.lang.ClassCastException".equals(this.fException.getQualifiedName())) {
            this.fResult.add(node.getType());
        }
        return super.visit(node);
    }

    public boolean visit(ClassInstanceCreation node) {
        if (this.matches(node.resolveConstructorBinding())) {
            this.fResult.add(node.getType());
        }
        return super.visit(node);
    }

    public boolean visit(ConstructorInvocation node) {
        if (this.matches(node.resolveConstructorBinding())) {
            SimpleName name = this.fAST.newSimpleName("xxxx");
            name.setSourceRange(node.getStartPosition(), 4);
            this.fResult.add(name);
        }
        return super.visit(node);
    }

    public boolean visit(MethodInvocation node) {
        if (this.matches(node.resolveMethodBinding())) {
            this.fResult.add(node.getName());
        }
        return super.visit(node);
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (this.matches(node.resolveConstructorBinding())) {
            SimpleName name = this.fAST.newSimpleName("xxxxx");
            name.setSourceRange(node.getStartPosition(), 5);
            this.fResult.add(name);
        }
        return super.visit(node);
    }

    public boolean visit(SuperMethodInvocation node) {
        if (this.matches(node.resolveMethodBinding())) {
            this.fResult.add(node.getName());
        }
        return super.visit(node);
    }

    public boolean visit(ThrowStatement node) {
        if (this.matches(node.getExpression().resolveTypeBinding())) {
            SimpleName name = this.fAST.newSimpleName("xxxxx");
            name.setSourceRange(node.getStartPosition(), 5);
            this.fResult.add(name);
        }
        return super.visit(node);
    }

    public boolean visit(TypeDeclarationStatement node) {
        return false;
    }

    private boolean matches(IMethodBinding binding) {
        if (binding == null) {
            return false;
        }
        ITypeBinding[] exceptions = binding.getExceptionTypes();
        int i = 0;
        while (i < exceptions.length) {
            ITypeBinding exception = exceptions[i];
            if (this.matches(exception)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean matches(ITypeBinding exception) {
        if (exception != null) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (Bindings.equals((IBinding)this.fException, (IBinding)exception)) {
                return true;
            }
            exception = exception.getSuperclass();
lbl6:
            // 2 sources

            ** while (exception != null)
        }
lbl7:
        // 1 sources

        return false;
    }
}

