/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.OccurrencesSearchResult;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;

public class OccurrencesSearchQuery
implements ISearchQuery {
    private final OccurrencesSearchResult fResult;
    private IOccurrencesFinder fFinder;
    private IDocument fDocument;
    private final IJavaElement fElement;
    private final String fJobLabel;
    private final String fSingularLabel;
    private final String fPluralLabel;

    public OccurrencesSearchQuery(IOccurrencesFinder finder, IDocument document, IJavaElement element) {
        this.fFinder = finder;
        this.fDocument = document;
        this.fElement = element;
        this.fJobLabel = this.fFinder.getJobLabel();
        this.fResult = new OccurrencesSearchResult(this);
        this.fSingularLabel = this.fFinder.getSingularLabel(element.getElementName());
        this.fPluralLabel = this.fFinder.getPluralLabel(element.getElementName());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus run(IProgressMonitor monitor) {
        if (this.fFinder == null) {
            new StatusInfo(4, "Query has already been running");
        }
        try {
            this.fFinder.perform();
            ArrayList resultingMatches = new ArrayList();
            this.fFinder.collectOccurrenceMatches(this.fElement, this.fDocument, resultingMatches);
            if (!resultingMatches.isEmpty()) {
                this.fResult.addMatches(resultingMatches.toArray(new Match[resultingMatches.size()]));
            }
            this.fFinder = null;
            this.fDocument = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    public String getLabel() {
        return this.fJobLabel;
    }

    public String getResultLabel(int nMatches) {
        if (nMatches == 0) {
            return this.fSingularLabel;
        }
        return Messages.format(this.fPluralLabel, new Object[]{new Integer(nMatches)});
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.fResult;
    }
}

