/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.CorrectionEngine;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.composite.MultiStateCompilationUnitChange;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaMarkerAnnotation;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.FixCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class CorrectionMarkerResolutionGenerator
implements IMarkerResolutionGenerator,
IMarkerResolutionGenerator2 {
    private static final IMarkerResolution[] NO_RESOLUTIONS = new IMarkerResolution[0];

    public boolean hasResolutions(IMarker marker) {
        return CorrectionMarkerResolutionGenerator.internalHasResolutions(marker);
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        return CorrectionMarkerResolutionGenerator.internalGetResolutions(marker);
    }

    private static boolean internalHasResolutions(IMarker marker) {
        int id = marker.getAttribute("id", -1);
        ICompilationUnit cu = CorrectionMarkerResolutionGenerator.getCompilationUnit(marker);
        return cu != null && JavaCorrectionProcessor.hasCorrections(cu, id, MarkerUtilities.getMarkerType((IMarker)marker));
    }

    private static IMarkerResolution[] internalGetResolutions(IMarker marker) {
        if (!CorrectionMarkerResolutionGenerator.internalHasResolutions(marker)) {
            return NO_RESOLUTIONS;
        }
        try {
            IProblemLocation location;
            IEditorInput input;
            ICompilationUnit cu = CorrectionMarkerResolutionGenerator.getCompilationUnit(marker);
            if (cu != null && (input = EditorUtility.getEditorInput(cu)) != null && (location = CorrectionMarkerResolutionGenerator.findProblemLocation(input, marker)) != null) {
                AssistContext context = new AssistContext(cu, location.getOffset(), location.getLength());
                if (!CorrectionMarkerResolutionGenerator.hasProblem(context.getASTRoot().getProblems(), location)) {
                    return NO_RESOLUTIONS;
                }
                ArrayList proposals = new ArrayList();
                JavaCorrectionProcessor.collectCorrections(context, new IProblemLocation[]{location}, proposals);
                Collections.sort(proposals, new CompletionProposalComparator());
                int nProposals = proposals.size();
                IMarkerResolution[] resolutions = new IMarkerResolution[nProposals];
                int i = 0;
                while (i < nProposals) {
                    resolutions[i] = new CorrectionMarkerResolution(context.getCompilationUnit(), location.getOffset(), location.getLength(), (IJavaCompletionProposal)proposals.get(i), marker);
                    ++i;
                }
                return resolutions;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return NO_RESOLUTIONS;
    }

    private static boolean hasProblem(IProblem[] problems, IProblemLocation location) {
        int i = 0;
        while (i < problems.length) {
            IProblem problem = problems[i];
            if (problem.getID() == location.getProblemId() && problem.getSourceStart() == location.getOffset()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static ICompilationUnit getCompilationUnit(IMarker marker) {
        IJavaElement element;
        IResource res = marker.getResource();
        if (res instanceof IFile && res.isAccessible() && (element = JavaCore.create((IFile)((IFile)res))) instanceof ICompilationUnit) {
            return (ICompilationUnit)element;
        }
        return null;
    }

    private static IProblemLocation findProblemLocation(IEditorInput input, IMarker marker) {
        IAnnotationModel model = JavaPlugin.getDefault().getCompilationUnitDocumentProvider().getAnnotationModel(input);
        if (model != null) {
            Iterator iter = model.getAnnotationIterator();
            while (iter.hasNext()) {
                Position pos;
                JavaMarkerAnnotation annot;
                Object curr = iter.next();
                if (!(curr instanceof JavaMarkerAnnotation) || !marker.equals((Object)(annot = (JavaMarkerAnnotation)curr).getMarker()) || (pos = model.getPosition((Annotation)annot)) == null) continue;
                return new ProblemLocation(pos.getOffset(), pos.getLength(), annot);
            }
        } else {
            ICompilationUnit cu = CorrectionMarkerResolutionGenerator.getCompilationUnit(marker);
            return CorrectionMarkerResolutionGenerator.createFromMarker(marker, cu);
        }
        return null;
    }

    private static IProblemLocation createFromMarker(IMarker marker, ICompilationUnit cu) {
        try {
            int id = marker.getAttribute("id", -1);
            int start = marker.getAttribute("charStart", -1);
            int end = marker.getAttribute("charEnd", -1);
            int severity = marker.getAttribute("severity", 0);
            String[] arguments = CorrectionEngine.getProblemArguments((IMarker)marker);
            String markerType = marker.getType();
            if (cu != null && id != -1 && start != -1 && end != -1 && arguments != null) {
                boolean isError = severity == 2;
                return new ProblemLocation(start, end - start, id, arguments, isError, markerType);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    public static class CorrectionMarkerResolution
    extends WorkbenchMarkerResolution {
        private static final IMarker[] NO_MARKERS = new IMarker[0];
        private ICompilationUnit fCompilationUnit;
        private int fOffset;
        private int fLength;
        private IJavaCompletionProposal fProposal;
        private final IMarker fMarker;

        public CorrectionMarkerResolution(ICompilationUnit cu, int offset, int length, IJavaCompletionProposal proposal, IMarker marker) {
            this.fCompilationUnit = cu;
            this.fOffset = offset;
            this.fLength = length;
            this.fProposal = proposal;
            this.fMarker = marker;
        }

        public String getLabel() {
            return this.fProposal.getDisplayString();
        }

        public void run(IMarker marker) {
            try {
                IEditorPart part = EditorUtility.isOpenInEditor(this.fCompilationUnit);
                if (part == null && (part = EditorUtility.openInEditor(this.fCompilationUnit)) instanceof ITextEditor) {
                    ((ITextEditor)part).selectAndReveal(this.fOffset, this.fLength);
                }
                if (part != null) {
                    IEditorInput input = part.getEditorInput();
                    IDocument doc = JavaPlugin.getDefault().getCompilationUnitDocumentProvider().getDocument(input);
                    this.fProposal.apply(doc);
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run(IMarker[] markers, IProgressMonitor monitor) {
            if (markers.length == 1) {
                this.run(markers[0]);
                return;
            }
            IProgressMonitor pm = monitor;
            if (pm == null) {
                pm = new NullProgressMonitor();
            }
            try {
                block26: {
                    Object var13_15;
                    CompositeChange allChanges;
                    block29: {
                        block28: {
                            block27: {
                                ICleanUp cleanUp;
                                if (!(this.fProposal instanceof FixCorrectionProposal) || (cleanUp = ((FixCorrectionProposal)this.fProposal).getCleanUp()) == null) break block26;
                                Hashtable problemLocations = new Hashtable();
                                int i = 0;
                                while (i < markers.length) {
                                    IProblemLocation location;
                                    IMarker marker = markers[i];
                                    ICompilationUnit cu = CorrectionMarkerResolutionGenerator.getCompilationUnit(marker);
                                    if (cu != null && (location = CorrectionMarkerResolutionGenerator.createFromMarker(marker, cu)) != null) {
                                        if (!problemLocations.containsKey(cu.getPrimary())) {
                                            problemLocations.put(cu.getPrimary(), new ArrayList());
                                        }
                                        List l = (List)problemLocations.get(cu.getPrimary());
                                        l.add(location);
                                    }
                                    ++i;
                                }
                                if (problemLocations.size() <= 0) break block26;
                                Set cus = problemLocations.keySet();
                                Hashtable projects = new Hashtable();
                                Iterator iter = cus.iterator();
                                while (iter.hasNext()) {
                                    ICompilationUnit cu = (ICompilationUnit)iter.next();
                                    IJavaProject project = cu.getJavaProject();
                                    if (!projects.containsKey(project)) {
                                        projects.put(project, new ArrayList());
                                    }
                                    ((List)projects.get(project)).add(cu);
                                }
                                pm.beginTask("", problemLocations.size() * 2 + 2 + projects.keySet().size());
                                String name = "";
                                String[] descriptions = cleanUp.getDescriptions();
                                if (descriptions != null && descriptions.length == 1) {
                                    name = descriptions[0];
                                }
                                allChanges = new CompositeChange(name);
                                Iterator projectIter = projects.keySet().iterator();
                                while (projectIter.hasNext()) {
                                    Object var16_19;
                                    IJavaProject project = (IJavaProject)projectIter.next();
                                    List compilationUnitsList = (List)projects.get(project);
                                    ICompilationUnit[] compilationUnits = compilationUnitsList.toArray(new ICompilationUnit[compilationUnitsList.size()]);
                                    try {
                                        try {
                                            this.cleanUpProject(project, compilationUnits, cleanUp, problemLocations, allChanges, pm);
                                        }
                                        catch (CoreException e) {
                                            JavaPlugin.log(e);
                                        }
                                        var16_19 = null;
                                    }
                                    catch (Throwable throwable) {
                                        var16_19 = null;
                                        pm.worked(1);
                                        throw throwable;
                                    }
                                    pm.worked(1);
                                }
                                if (!pm.isCanceled()) break block27;
                                break block28;
                            }
                            allChanges.initializeValidationData((IProgressMonitor)new SubProgressMonitor(pm, 1));
                            if (this.validChanges(allChanges)) break block29;
                        }
                        Object var18_21 = null;
                        pm.done();
                        return;
                    }
                    PerformChangeOperation op = new PerformChangeOperation((Change)allChanges);
                    op.setUndoManager(RefactoringCore.getUndoManager(), allChanges.getName());
                    try {
                        try {
                            op.run((IProgressMonitor)new SubProgressMonitor(pm, 1));
                        }
                        catch (CoreException e1) {
                            JavaPlugin.log(e1);
                        }
                        var13_15 = null;
                    }
                    catch (Throwable throwable) {
                        var13_15 = null;
                        pm.worked(1);
                        throw throwable;
                    }
                    pm.worked(1);
                    IEditorPart part = EditorUtility.isOpenInEditor(this.fCompilationUnit);
                    if (part instanceof ITextEditor) {
                        ((ITextEditor)part).selectAndReveal(this.fOffset, this.fLength);
                        part.setFocus();
                    }
                }
                Object var18_23 = null;
            }
            catch (Throwable throwable) {
                Object var18_22 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
        }

        private boolean validChanges(CompositeChange change) {
            RefactoringStatus result = new RefactoringStatus();
            ArrayList files = new ArrayList();
            try {
                this.findFilesToBeModified(change, files);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return false;
            }
            result.merge(Checks.validateModifiesFiles(files.toArray(new IFile[files.size()]), JavaPlugin.getActiveWorkbenchShell().getShell()));
            if (result.hasFatalError()) {
                MultiStatus status;
                RefactoringStatusEntry[] entries = result.getEntries();
                if (entries.length > 1) {
                    status = new MultiStatus("org.eclipse.jdt.ui", 0, result.getMessageMatchingSeverity(3), null);
                    int i = 0;
                    while (i < entries.length) {
                        status.add((IStatus)new Status(entries[i].getSeverity(), "org.eclipse.jdt.ui", 0, entries[i].getMessage(), null));
                        ++i;
                    }
                } else {
                    RefactoringStatusEntry entry = entries[0];
                    status = new Status(entry.getSeverity(), "org.eclipse.jdt.ui", 0, entry.getMessage(), null);
                }
                ErrorDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell().getShell(), (String)CorrectionMessages.CorrectionMarkerResolutionGenerator__multiFixErrorDialog_Titel, (String)CorrectionMessages.CorrectionMarkerResolutionGenerator_multiFixErrorDialog_description, (IStatus)status);
                return false;
            }
            return true;
        }

        private void findFilesToBeModified(CompositeChange change, List result) throws JavaModelException {
            Change[] children = change.getChildren();
            int i = 0;
            while (i < children.length) {
                Change child = children[i];
                if (child instanceof CompositeChange) {
                    this.findFilesToBeModified((CompositeChange)child, result);
                } else if (child instanceof MultiStateCompilationUnitChange) {
                    result.add(((MultiStateCompilationUnitChange)child).getCompilationUnit().getCorrespondingResource());
                } else if (child instanceof CompilationUnitChange) {
                    result.add(((CompilationUnitChange)child).getCompilationUnit().getCorrespondingResource());
                }
                ++i;
            }
        }

        private void cleanUpProject(IJavaProject project, ICompilationUnit[] compilationUnits, ICleanUp cleanUp, Hashtable problemLocations, CompositeChange result, IProgressMonitor monitor) throws CoreException {
            cleanUp.beginCleanUp(project, compilationUnits, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            int i = 0;
            while (i < compilationUnits.length) {
                ICompilationUnit cu = compilationUnits[i];
                CompilationUnit root = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)cu, ASTProvider.WAIT_YES, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                List locationList = (List)problemLocations.get(cu);
                IProblemLocation[] locations = locationList.toArray(new IProblemLocation[locationList.size()]);
                IFix fix = cleanUp.createFix(root, locations);
                if (monitor.isCanceled()) {
                    return;
                }
                if (fix != null) {
                    TextChange change = fix.createChange();
                    if (monitor.isCanceled()) {
                        return;
                    }
                    result.add((Change)change);
                    monitor.worked(1);
                }
                ++i;
            }
            cleanUp.endCleanUp();
        }

        public String getDescription() {
            return this.fProposal.getAdditionalProposalInfo();
        }

        public Image getImage() {
            return this.fProposal.getImage();
        }

        public IMarker[] findOtherMarkers(IMarker[] markers) {
            FixCorrectionProposal fix;
            ICleanUp cleanUp;
            if (this.fProposal instanceof FixCorrectionProposal && (cleanUp = (fix = (FixCorrectionProposal)this.fProposal).getCleanUp()) != null) {
                ArrayList<IMarker> result = new ArrayList<IMarker>();
                int i = 0;
                while (i < markers.length) {
                    ICompilationUnit cu;
                    IMarker marker = markers[i];
                    if (!marker.equals((Object)this.fMarker) && (cu = CorrectionMarkerResolutionGenerator.getCompilationUnit(marker)) != null) {
                        IProblemLocation location = CorrectionMarkerResolutionGenerator.createFromMarker(marker, cu);
                        try {
                            AssistContext context = new AssistContext(cu, location.getOffset(), location.getLength());
                            CompilationUnit root = context.getASTRoot();
                            if (cleanUp.canFix(root, location)) {
                                result.add(marker);
                            }
                        }
                        catch (CoreException e) {
                            JavaPlugin.log(e);
                        }
                    }
                    ++i;
                }
                return result.toArray(new IMarker[result.size()]);
            }
            return NO_MARKERS;
        }
    }
}

