/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.internal.corext.refactoring.deprecation.DeprecationRefactorings;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.deprecation.FixDeprecationRefactoringWizard;
import org.eclipse.jdt.internal.ui.text.HTMLPrinter;
import org.eclipse.jdt.internal.ui.text.correction.ChangeCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public final class FixDeprecationCorrectionProposal
extends ChangeCorrectionProposal {
    private static final int SIZING_WIZARD_HEIGHT = 470;
    private static final int SIZING_WIZARD_WIDTH = 490;
    private final IBinding fBinding;
    private final IInvocationContext fContext;
    private final RefactoringHistory fHistory;
    private final ASTNode fNode;

    public FixDeprecationCorrectionProposal(IInvocationContext context, RefactoringHistory history, IBinding binding, ASTNode node) {
        super(CorrectionMessages.QuickAssistProcessor_fix_deprecation_name, null, 100, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
        this.fContext = context;
        this.fHistory = history;
        this.fBinding = binding;
        this.fNode = node;
    }

    public void apply(IDocument document) {
        if (this.fHistory.isEmpty()) {
            return;
        }
        final FixDeprecationRefactoringWizard wizard = new FixDeprecationRefactoringWizard(this.fHistory.getDescriptors().length > 1, this.fContext.getCompilationUnit(), this.fNode.getStartPosition(), this.fNode.getLength());
        final WizardDialog dialog = new WizardDialog(JavaPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
        wizard.setRefactoringHistory(this.fHistory);
        IPackageFragmentRoot root = DeprecationRefactorings.getPackageFragmentRoot(this.fBinding);
        if (root != null) {
            wizard.setPackageFragmentRoot(root);
        }
        dialog.create();
        dialog.getShell().setSize(Math.max(490, dialog.getShell().getSize().x), 470);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jdt.ui.fix_deprecation_wizard_page_context");
        dialog.getShell().getDisplay().asyncExec(new Runnable(){

            public final void run() {
                dialog.showPage(wizard.getNextPage(wizard.getStartingPage()));
            }
        });
        dialog.open();
    }

    public String getAdditionalProposalInfo() {
        if (this.fHistory.isEmpty()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(512);
        HTMLPrinter.startBulletList(buffer);
        RefactoringDescriptorProxy[] proxies = this.fHistory.getDescriptors();
        int index = 0;
        while (index < proxies.length) {
            HTMLPrinter.addBullet(buffer, proxies[index].getDescription());
            ++index;
        }
        HTMLPrinter.endBulletList(buffer);
        return Messages.format(CorrectionMessages.QuickAssistProcessor_fix_deprecation_info, buffer.toString());
    }
}

