/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.SurroundWith;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.swt.graphics.Image;

public class SurroundWithRunnableProposal
extends LinkedCorrectionProposal {
    private final SurroundWithRunnable fSurround;

    public SurroundWithRunnableProposal(String name, IInvocationContext context, int relevance, Image image, Statement[] selectedStatements) {
        super(name, context.getCompilationUnit(), (ASTRewrite)null, relevance, image);
        this.fSurround = new SurroundWithRunnable(context, selectedStatements);
    }

    protected ASTRewrite getRewrite() throws CoreException {
        ASTRewrite rewrite = this.fSurround.getRewrite();
        this.addLinkedPosition(this.fSurround.getNamePosition(), true, "nameId");
        this.setEndPosition(this.fSurround.getEndPosition());
        return rewrite;
    }

    private static class SurroundWithRunnable
    extends SurroundWith {
        private static final String PROPOSED_RUNNABLE_VAR_NAME = "runnable";
        private static final String TYPE_NAME = "Runnable";
        private static final String METHOD_NAME = "run";
        private ITrackedNodePosition fNamePosition;
        private ITrackedNodePosition fEndPosition;

        public SurroundWithRunnable(IInvocationContext context, Statement[] selectedNodes) {
            super(context.getASTRoot(), selectedNodes);
        }

        protected Statement generateCodeSkeleton(Block newBody, ASTRewrite rewrite) {
            AST ast = this.getAst();
            MethodDeclaration runMethod = ast.newMethodDeclaration();
            runMethod.setName(ast.newSimpleName(METHOD_NAME));
            runMethod.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
            runMethod.setBody(newBody);
            AnonymousClassDeclaration runnableClassDeclaration = ast.newAnonymousClassDeclaration();
            runnableClassDeclaration.bodyDeclarations().add(runMethod);
            ClassInstanceCreation runnableInstanziator = ast.newClassInstanceCreation();
            runnableInstanziator.setType((Type)ast.newSimpleType(ast.newName(TYPE_NAME)));
            runnableInstanziator.setAnonymousClassDeclaration(runnableClassDeclaration);
            VariableDeclarationFragment variableDeclarationFragment = ast.newVariableDeclarationFragment();
            SimpleName variableName = ast.newSimpleName(PROPOSED_RUNNABLE_VAR_NAME);
            variableDeclarationFragment.setName(variableName);
            variableDeclarationFragment.setInitializer((Expression)runnableInstanziator);
            this.fNamePosition = rewrite.track((ASTNode)variableName);
            VariableDeclarationStatement variableDeclaration = ast.newVariableDeclarationStatement(variableDeclarationFragment);
            variableDeclaration.setType((Type)ast.newSimpleType(ast.newName(TYPE_NAME)));
            this.fEndPosition = rewrite.track((ASTNode)variableDeclaration);
            return variableDeclaration;
        }

        public ITrackedNodePosition getEndPosition() {
            return this.fEndPosition;
        }

        public ITrackedNodePosition getNamePosition() {
            return this.fNamePosition;
        }
    }
}

