/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.HTMLPrinter;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.SmartSemicolonAutoEditStrategy;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractReusableInformationControlCreator;
import org.eclipse.jdt.internal.ui.text.java.hover.BrowserInformationControl;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.osgi.framework.Bundle;

public abstract class AbstractJavaCompletionProposal
implements IJavaCompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3 {
    private String fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private Image fImage;
    private IContextInformation fContextInformation;
    private ProposalInfo fProposalInfo;
    private char[] fTriggerCharacters;
    private String fSortString;
    private int fRelevance;
    private boolean fIsInJavadoc;
    private StyleRange fRememberedStyleRange;
    private boolean fToggleEating;
    private ITextViewer fTextViewer;
    private IInformationControlCreator fCreator;
    private URL fStyleSheetURL;

    protected AbstractJavaCompletionProposal() {
    }

    public char[] getTriggerCharacters() {
        return this.fTriggerCharacters;
    }

    public void setTriggerCharacters(char[] triggerCharacters) {
        this.fTriggerCharacters = triggerCharacters;
    }

    public void setProposalInfo(ProposalInfo proposalInfo) {
        this.fProposalInfo = proposalInfo;
    }

    protected ProposalInfo getProposalInfo() {
        return this.fProposalInfo;
    }

    public void setCursorPosition(int cursorPosition) {
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.fCursorPosition = cursorPosition;
    }

    protected int getCursorPosition() {
        return this.fCursorPosition;
    }

    public final void apply(IDocument document) {
        this.apply(document, '\u0000', this.getReplacementOffset() + this.getReplacementLength());
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            String replacement;
            boolean isSmartTrigger;
            int delta = offset - (this.getReplacementOffset() + this.getReplacementLength());
            if (delta > 0) {
                this.setReplacementLength(this.getReplacementLength() + delta);
            }
            if ((isSmartTrigger = this.isSmartTrigger(trigger)) || trigger == '\u0000') {
                replacement = this.getReplacementString();
            } else {
                StringBuffer buffer = new StringBuffer(this.getReplacementString());
                if (this.getCursorPosition() > 0 && this.getCursorPosition() <= buffer.length() && buffer.charAt(this.getCursorPosition() - 1) != trigger) {
                    buffer.insert(this.getCursorPosition(), trigger);
                    this.setCursorPosition(this.getCursorPosition() + 1);
                }
                replacement = buffer.toString();
                this.setReplacementString(replacement);
            }
            int referenceOffset = this.getReplacementOffset() + this.getReplacementLength();
            ReferenceTracker referenceTracker = new ReferenceTracker();
            referenceTracker.preReplace(document, referenceOffset);
            this.replace(document, this.getReplacementOffset(), this.getReplacementLength(), replacement);
            referenceOffset = referenceTracker.postReplace(document);
            this.setReplacementOffset(referenceOffset - (replacement == null ? 0 : replacement.length()));
            if (isSmartTrigger) {
                this.handleSmartTrigger(document, trigger, referenceOffset);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean isSmartTrigger(char trigger) {
        return trigger == ';' && JavaPlugin.getDefault().getCombinedPreferenceStore().getBoolean("smart_semicolon") || trigger == '{' && JavaPlugin.getDefault().getCombinedPreferenceStore().getBoolean("smart_opening_brace");
    }

    private void handleSmartTrigger(IDocument document, char trigger, int referenceOffset) throws BadLocationException {
        DocumentCommand cmd = new DocumentCommand(){};
        cmd.offset = referenceOffset;
        cmd.length = 0;
        cmd.text = Character.toString(trigger);
        cmd.doit = true;
        cmd.shiftsCaret = true;
        cmd.caretOffset = this.getReplacementOffset() + this.getCursorPosition();
        SmartSemicolonAutoEditStrategy strategy = new SmartSemicolonAutoEditStrategy("___java_partitioning");
        strategy.customizeDocumentCommand(document, cmd);
        this.replace(document, cmd.offset, cmd.length, cmd.text);
        this.setCursorPosition(cmd.caretOffset - this.getReplacementOffset() + cmd.text.length());
    }

    protected final void replace(IDocument document, int offset, int length, String string) throws BadLocationException {
        if (!document.get(offset, length).equals(string)) {
            document.replace(offset, length, string);
        }
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        if (this.fTextViewer == null) {
            this.fTextViewer = viewer;
        }
        if (!this.isInJavadoc() && !this.validate(document, offset, null)) {
            this.setCursorPosition(offset - this.getReplacementOffset());
            if (trigger != '\u0000') {
                try {
                    document.replace(offset, 0, String.valueOf(trigger));
                    this.setCursorPosition(this.getCursorPosition() + 1);
                    if (trigger == '(' && this.autocloseBrackets()) {
                        document.replace(this.getReplacementOffset() + this.getCursorPosition(), 0, ")");
                        this.setUpLinkedMode(document, ')');
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            return;
        }
        Point selection = viewer.getSelectedRange();
        this.fToggleEating = (stateMask & SWT.MOD1) != 0;
        int newLength = selection.x + selection.y - this.getReplacementOffset();
        if (AbstractJavaCompletionProposal.insertCompletion() ^ this.fToggleEating && newLength >= 0) {
            this.setReplacementLength(newLength);
        }
        this.apply(document, trigger, offset);
        this.fToggleEating = false;
    }

    protected boolean isInJavadoc() {
        return this.fIsInJavadoc;
    }

    protected void setInJavadoc(boolean isInJavadoc) {
        this.fIsInJavadoc = isInJavadoc;
    }

    public Point getSelection(IDocument document) {
        return new Point(this.getReplacementOffset() + this.getCursorPosition(), 0);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public void setContextInformation(IContextInformation contextInformation) {
        this.fContextInformation = contextInformation;
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    public String getAdditionalProposalInfo() {
        if (this.getProposalInfo() != null) {
            String info = this.getProposalInfo().getInfo();
            if (info != null && info.length() > 0) {
                StringBuffer buffer = new StringBuffer();
                HTMLPrinter.insertPageProlog(buffer, 0, this.getStyleSheetURL());
                buffer.append(info);
                HTMLPrinter.addPageEpilog(buffer);
                info = buffer.toString();
            }
            return info;
        }
        return null;
    }

    protected URL getStyleSheetURL() {
        if (this.fStyleSheetURL == null) {
            Bundle bundle = Platform.getBundle((String)JavaPlugin.getPluginId());
            this.fStyleSheetURL = bundle.getEntry("/JavadocHoverStyleSheet.css");
            if (this.fStyleSheetURL != null) {
                try {
                    this.fStyleSheetURL = FileLocator.toFileURL((URL)this.fStyleSheetURL);
                }
                catch (IOException ex) {
                    JavaPlugin.log(ex);
                }
            }
        }
        return this.fStyleSheetURL;
    }

    public int getContextInformationPosition() {
        if (this.getContextInformation() == null) {
            return this.getReplacementOffset() - 1;
        }
        return this.getReplacementOffset() + this.getCursorPosition();
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public void setReplacementOffset(int replacementOffset) {
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        this.fReplacementOffset = replacementOffset;
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.getReplacementOffset();
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    public void setReplacementLength(int replacementLength) {
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.fReplacementLength = replacementLength;
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public void setReplacementString(String replacementString) {
        Assert.isNotNull((Object)replacementString);
        this.fReplacementString = replacementString;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.getReplacementString();
    }

    public Image getImage() {
        return this.fImage;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public boolean isValidFor(IDocument document, int offset) {
        return this.validate(document, offset, null);
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (offset < this.getReplacementOffset()) {
            return false;
        }
        boolean validated = this.isValidPrefix(this.getPrefix(document, offset));
        if (validated && event != null) {
            int delta = (event.fText == null ? 0 : event.fText.length()) - event.fLength;
            int newLength = Math.max(this.getReplacementLength() + delta, 0);
            this.setReplacementLength(newLength);
        }
        return validated;
    }

    protected boolean isValidPrefix(String prefix) {
        return this.isPrefix(prefix, this.getDisplayString());
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }

    protected String getPrefix(IDocument document, int offset) {
        try {
            int length = offset - this.getReplacementOffset();
            if (length > 0) {
                return document.get(this.getReplacementOffset(), length);
            }
        }
        catch (BadLocationException badLocationException) {}
        return "";
    }

    protected boolean isPrefix(String prefix, String string) {
        if (prefix == null || string == null || prefix.length() > string.length()) {
            return false;
        }
        String start = string.substring(0, prefix.length());
        return start.equalsIgnoreCase(prefix) || this.isCamelCaseMatching() && CharOperation.camelCaseMatch((char[])prefix.toCharArray(), (char[])string.toCharArray());
    }

    protected boolean isCamelCaseMatching() {
        IJavaProject project = this.getProject();
        String value = project == null ? JavaCore.getOption((String)"org.eclipse.jdt.core.codeComplete.camelCaseMatch") : project.getOption("org.eclipse.jdt.core.codeComplete.camelCaseMatch", true);
        return "enabled".equals(value);
    }

    private IJavaProject getProject() {
        return null;
    }

    private static boolean insertCompletion() {
        IPreferenceStore preference = JavaPlugin.getDefault().getPreferenceStore();
        return preference.getBoolean("content_assist_insert_completion");
    }

    private static Color getForegroundColor(StyledText text) {
        IPreferenceStore preference = JavaPlugin.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)preference, (String)"content_assist_completion_replacement_foreground");
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        return textTools.getColorManager().getColor(rgb);
    }

    private static Color getBackgroundColor(StyledText text) {
        IPreferenceStore preference = JavaPlugin.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)preference, (String)"content_assist_completion_replacement_background");
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        return textTools.getColorManager().getColor(rgb);
    }

    private void repairPresentation(ITextViewer viewer) {
        if (this.fRememberedStyleRange != null) {
            if (viewer instanceof ITextViewerExtension2) {
                ITextViewerExtension2 viewer2 = (ITextViewerExtension2)viewer;
                if (viewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                    IRegion modelRange = extension.widgetRange2ModelRange((IRegion)new Region(this.fRememberedStyleRange.start, this.fRememberedStyleRange.length));
                    if (modelRange != null) {
                        viewer2.invalidateTextPresentation(modelRange.getOffset(), modelRange.getLength());
                    }
                } else {
                    viewer2.invalidateTextPresentation(this.fRememberedStyleRange.start + viewer.getVisibleRegion().getOffset(), this.fRememberedStyleRange.length);
                }
            } else {
                viewer.invalidateTextPresentation();
            }
        }
    }

    private void updateStyle(ITextViewer viewer) {
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        int widgetCaret = text.getCaretOffset();
        int modelCaret = 0;
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            modelCaret = extension.widgetOffset2ModelOffset(widgetCaret);
        } else {
            IRegion visibleRegion = viewer.getVisibleRegion();
            modelCaret = widgetCaret + visibleRegion.getOffset();
        }
        if (modelCaret >= this.getReplacementOffset() + this.getReplacementLength()) {
            this.repairPresentation(viewer);
            return;
        }
        int offset = widgetCaret;
        int length = this.getReplacementOffset() + this.getReplacementLength() - modelCaret;
        Color foreground = AbstractJavaCompletionProposal.getForegroundColor(text);
        Color background = AbstractJavaCompletionProposal.getBackgroundColor(text);
        StyleRange range = text.getStyleRangeAtOffset(offset);
        int fontStyle = range != null ? range.fontStyle : 0;
        this.repairPresentation(viewer);
        this.fRememberedStyleRange = new StyleRange(offset, length, foreground, background, fontStyle);
        if (range != null) {
            this.fRememberedStyleRange.strikeout = range.strikeout;
            this.fRememberedStyleRange.underline = range.underline;
        }
        try {
            text.setStyleRange(this.fRememberedStyleRange);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.fRememberedStyleRange = null;
        }
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
        if (!AbstractJavaCompletionProposal.insertCompletion() ^ smartToggle) {
            this.updateStyle(viewer);
        } else {
            this.repairPresentation(viewer);
            this.fRememberedStyleRange = null;
        }
    }

    public void unselected(ITextViewer viewer) {
        this.repairPresentation(viewer);
        this.fRememberedStyleRange = null;
    }

    public IInformationControlCreator getInformationControlCreator() {
        if (!BrowserInformationControl.isAvailable(null)) {
            return null;
        }
        if (this.fCreator == null) {
            this.fCreator = new AbstractReusableInformationControlCreator(){

                public IInformationControl doCreateInformationControl(Shell parent) {
                    return new BrowserInformationControl(parent, 8, 0, null, false);
                }
            };
        }
        return this.fCreator;
    }

    public String getSortString() {
        return this.fSortString;
    }

    protected void setSortString(String string) {
        this.fSortString = string;
    }

    protected ITextViewer getTextViewer() {
        return this.fTextViewer;
    }

    protected boolean isToggleEating() {
        return this.fToggleEating;
    }

    protected void setUpLinkedMode(IDocument document, char closingCharacter) {
        if (this.getTextViewer() != null && this.autocloseBrackets()) {
            int offset = this.getReplacementOffset() + this.getCursorPosition();
            int exit = this.getReplacementOffset() + this.getReplacementString().length();
            try {
                LinkedPositionGroup group = new LinkedPositionGroup();
                group.addPosition(new LinkedPosition(document, offset, 0, -1));
                LinkedModeModel model = new LinkedModeModel();
                model.addGroup(group);
                model.forceInstall();
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
                ui.setSimpleMode(true);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(closingCharacter, document));
                ui.setExitPosition(this.getTextViewer(), exit, 0, Integer.MAX_VALUE);
                ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                ui.enter();
            }
            catch (BadLocationException x) {
                JavaPlugin.log(x);
            }
        }
    }

    protected boolean autocloseBrackets() {
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        return preferenceStore.getBoolean("closeBrackets");
    }

    protected void setDisplayString(String string) {
        this.fDisplayString = string;
    }

    public String toString() {
        return this.getDisplayString();
    }

    public IJavaElement getJavaElement() {
        if (this.getProposalInfo() != null) {
            try {
                return this.getProposalInfo().getJavaElement();
            }
            catch (JavaModelException x) {
                JavaPlugin.log(x);
            }
        }
        return null;
    }

    static final class ReferenceTracker {
        private static final String CATEGORY = "reference_position";
        private final IPositionUpdater fPositionUpdater = new DefaultPositionUpdater("reference_position");
        private final Position fPosition = new Position(0);

        ReferenceTracker() {
        }

        public void preReplace(IDocument document, int offset) throws BadLocationException {
            this.fPosition.setOffset(offset);
            try {
                document.addPositionCategory(CATEGORY);
                document.addPositionUpdater(this.fPositionUpdater);
                document.addPosition(CATEGORY, this.fPosition);
            }
            catch (BadPositionCategoryException e) {
                JavaPlugin.log(e);
            }
        }

        public int postReplace(IDocument document) {
            try {
                document.removePosition(CATEGORY, this.fPosition);
                document.removePositionUpdater(this.fPositionUpdater);
                document.removePositionCategory(CATEGORY);
            }
            catch (BadPositionCategoryException e) {
                JavaPlugin.log(e);
            }
            return this.fPosition.getOffset();
        }
    }

    protected static final class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;
        private final IDocument fDocument;

        public ExitPolicy(char exitCharacter, IDocument document) {
            this.fExitCharacter = exitCharacter;
            this.fDocument = document;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public LinkedModeUI.ExitFlags doExit(LinkedModeModel environment, VerifyEvent event, int offset, int length) {
            if (event.character == this.fExitCharacter) {
                if (!environment.anyPositionContains(offset)) return new LinkedModeUI.ExitFlags(2, true);
                return new LinkedModeUI.ExitFlags(2, false);
            }
            switch (event.character) {
                case ';': {
                    return new LinkedModeUI.ExitFlags(0, true);
                }
                case '\r': {
                    if (offset <= 0) return null;
                    try {
                        if (this.fDocument.getChar(offset - 1) != '{') return null;
                        return new LinkedModeUI.ExitFlags(1, true);
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            return null;
        }
    }
}

