/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.OverrideMethodDialog;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.java.JavaTypeCompletionProposal;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MalformedTreeException;

public class AnonymousTypeCompletionProposal
extends JavaTypeCompletionProposal
implements ICompletionProposalExtension4 {
    private String fDeclarationSignature;
    private IType fSuperType;
    static /* synthetic */ Class class$0;

    public AnonymousTypeCompletionProposal(IJavaProject jproject, ICompilationUnit cu, int start, int length, String constructorCompletion, String displayName, String declarationSignature, int relevance) {
        super(constructorCompletion, cu, start, length, null, displayName, relevance);
        Assert.isNotNull((Object)declarationSignature);
        Assert.isNotNull((Object)jproject);
        Assert.isNotNull((Object)cu);
        this.fDeclarationSignature = declarationSignature;
        this.fSuperType = this.getDeclaringType(jproject, SignatureUtil.stripSignatureToFQN(String.valueOf(declarationSignature)));
        this.setImage(this.getImageForType(this.fSuperType));
        this.setCursorPosition(constructorCompletion.indexOf(40) + 1);
    }

    private int createDummy(String name, StringBuffer buffer) throws JavaModelException {
        String lineDelim = "\n";
        buffer.append("class ");
        buffer.append(name);
        if (this.fSuperType.isInterface()) {
            buffer.append(" implements ");
        } else {
            buffer.append(" extends ");
        }
        if (this.fDeclarationSignature != null) {
            buffer.append(Signature.toString((String)this.fDeclarationSignature));
        } else {
            buffer.append(this.fSuperType.getFullyQualifiedParameterizedName());
        }
        int start = buffer.length();
        buffer.append("{");
        buffer.append(lineDelim);
        buffer.append(lineDelim);
        buffer.append("}");
        return start;
    }

    private boolean createStubs(StringBuffer buffer, ImportRewrite importRewrite) throws CoreException {
        ICompilationUnit copy;
        block26: {
            String[] keys;
            CodeGenerationSettings settings;
            IMethodBinding[] bindings;
            AbstractTypeDeclaration declaration;
            ITypeBinding binding;
            CompilationUnit unit;
            int end;
            int start;
            block28: {
                block29: {
                    if (importRewrite == null) {
                        return false;
                    }
                    if (this.fSuperType == null) {
                        return true;
                    }
                    copy = null;
                    String name = "Type" + System.currentTimeMillis();
                    copy = this.fCompilationUnit.getPrimary().getWorkingCopy(null);
                    StringBuffer contents = new StringBuffer();
                    start = 0;
                    end = 0;
                    ISourceRange range = this.fSuperType.getSourceRange();
                    boolean sameUnit = range != null && this.fCompilationUnit.equals(this.fSuperType.getCompilationUnit());
                    StringBuffer dummy = new StringBuffer();
                    int length = this.createDummy(name, dummy);
                    contents.append(this.fCompilationUnit.getBuffer().getContents());
                    if (sameUnit) {
                        int size = range.getOffset() + range.getLength();
                        start = size + length;
                        end = contents.length() - size;
                        contents.insert(size, dummy.toString());
                    } else {
                        range = this.fCompilationUnit.getTypes()[0].getSourceRange();
                        start = range.getOffset() + length;
                        end = contents.length() - range.getOffset();
                        contents.insert(range.getOffset(), dummy.toString());
                    }
                    copy.getBuffer().setContents(contents.toString());
                    JavaModelUtil.reconcile(copy);
                    ASTParser parser = ASTParser.newParser((int)3);
                    parser.setResolveBindings(true);
                    parser.setSource(copy);
                    unit = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
                    IType type = null;
                    IType[] types = copy.getAllTypes();
                    int index = 0;
                    while (index < types.length) {
                        IType result = types[index];
                        if (result.getElementName().equals(name)) {
                            type = result;
                            break;
                        }
                        ++index;
                    }
                    if (type == null || !type.exists()) break block26;
                    binding = null;
                    ASTNode aSTNode = NodeFinder.perform((ASTNode)unit, type.getNameRange());
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.AbstractTypeDeclaration");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((declaration = (AbstractTypeDeclaration)ASTNodes.getParent(aSTNode, clazz)) == null || (binding = declaration.resolveBinding()) == null) break block26;
                    bindings = StubUtility2.getOverridableMethods(unit.getAST(), binding, true);
                    settings = JavaPreferencesSettings.getCodeGenerationSettings(this.fSuperType.getJavaProject());
                    keys = null;
                    if (!this.fSuperType.isInterface() && !this.fSuperType.isAnnotation()) {
                        Object[] selection;
                        OverrideMethodDialog dialog = new OverrideMethodDialog(JavaPlugin.getActiveWorkbenchShell(), null, type, true);
                        dialog.setGenerateComment(false);
                        dialog.setElementPositionEnabled(false);
                        if (dialog.open() == 0 && (selection = dialog.getResult()) != null) {
                            ArrayList<String> result = new ArrayList<String>(selection.length);
                            int index2 = 0;
                            while (index2 < selection.length) {
                                if (selection[index2] instanceof IMethodBinding) {
                                    result.add(((IBinding)selection[index2]).getKey());
                                }
                                ++index2;
                            }
                            keys = result.toArray(new String[result.size()]);
                            settings.createComments = dialog.getGenerateComment();
                        }
                    } else {
                        settings.createComments = false;
                        ArrayList<String> list = new ArrayList<String>();
                        int index3 = 0;
                        while (index3 < bindings.length) {
                            if (Modifier.isAbstract((int)bindings[index3].getModifiers())) {
                                list.add(bindings[index3].getKey());
                            }
                            ++index3;
                        }
                        keys = list.toArray(new String[list.size()]);
                    }
                    if (keys != null) break block28;
                    this.setReplacementString("");
                    this.setReplacementLength(0);
                    Object var27_29 = null;
                    if (copy == null) break block29;
                    copy.discardWorkingCopy();
                }
                return false;
            }
            try {
                ASTRewrite rewrite = ASTRewrite.create((AST)unit.getAST());
                ListRewrite rewriter = rewrite.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty());
                String key = null;
                MethodDeclaration stub = null;
                int index = 0;
                while (index < keys.length) {
                    key = keys[index];
                    int offset = 0;
                    while (offset < bindings.length) {
                        if (key.equals(bindings[offset].getKey())) {
                            stub = StubUtility2.createImplementationStub(copy, rewrite, importRewrite, bindings[offset], binding.getName(), binding.isInterface(), settings);
                            if (stub == null) break;
                            rewriter.insertFirst((ASTNode)stub, null);
                            break;
                        }
                        ++offset;
                    }
                    ++index;
                }
                Document document = new Document(copy.getBuffer().getContents());
                try {
                    rewrite.rewriteAST((IDocument)document, this.fCompilationUnit.getJavaProject().getOptions(true)).apply((IDocument)document, 2);
                    buffer.append(document.get(start, document.getLength() - start - end));
                }
                catch (MalformedTreeException exception) {
                    JavaPlugin.log(exception);
                }
                catch (BadLocationException exception) {
                    JavaPlugin.log(exception);
                }
            }
            catch (Throwable throwable) {
                block30: {
                    Object var27_31 = null;
                    if (copy == null) break block30;
                    copy.discardWorkingCopy();
                }
                throw throwable;
            }
        }
        Object var27_30 = null;
        if (copy != null) {
            copy.discardWorkingCopy();
        }
        return true;
    }

    private IType getDeclaringType(IJavaProject project, String typeName) {
        try {
            return JavaModelUtil.findType(project, typeName);
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    private Image getImageForType(IType type) {
        String imageName = "org.eclipse.jdt.ui.class_obj.gif";
        if (type != null) {
            try {
                if (type.isAnnotation()) {
                    imageName = "org.eclipse.jdt.ui.annotation_obj.gif";
                } else if (type.isInterface()) {
                    imageName = "org.eclipse.jdt.ui.int_obj.gif";
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return JavaPluginImages.get(imageName);
    }

    public boolean isAutoInsertable() {
        return false;
    }

    protected boolean updateReplacementString(IDocument document, char trigger, int offset, ImportRewrite impRewrite) throws CoreException, BadLocationException {
        String replacementString = this.getReplacementString();
        StringBuffer buf = new StringBuffer("new A(");
        buf.append(replacementString);
        if (!replacementString.endsWith(")")) {
            buf.append(')');
        }
        if (!this.createStubs(buf, impRewrite)) {
            return false;
        }
        if (document.getChar(offset) != ')') {
            buf.append(';');
        }
        String lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        IJavaProject project = this.fCompilationUnit.getJavaProject();
        IRegion region = document.getLineInformationOfOffset(this.getReplacementOffset());
        int indent = Strings.computeIndentUnits(document.get(region.getOffset(), region.getLength()), project);
        String replacement = CodeFormatterUtil.format(1, buf.toString(), 0, null, lineDelim, this.fSuperType.getJavaProject());
        replacement = Strings.changeIndent(replacement, 0, project, CodeFormatterUtil.createIndentString(indent, project), lineDelim);
        this.setReplacementString(replacement.substring(replacement.indexOf(40) + 1));
        int pos = offset;
        while (pos < document.getLength() && Character.isWhitespace(document.getChar(pos))) {
            ++pos;
        }
        if (pos < document.getLength() && document.getChar(pos) == ')') {
            this.setReplacementLength(pos - offset + 1);
        }
        return true;
    }
}

