/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.JavadocContentAccess;

public class ProposalInfo {
    private boolean fJavadocResolved = false;
    private String fJavadoc = null;
    protected IJavaElement fElement;

    public ProposalInfo(IMember member) {
        this.fElement = member;
    }

    protected ProposalInfo() {
        this.fElement = null;
    }

    public IJavaElement getJavaElement() throws JavaModelException {
        return this.fElement;
    }

    public final String getInfo() {
        if (!this.fJavadocResolved) {
            this.fJavadocResolved = true;
            this.fJavadoc = this.computeInfo();
        }
        return this.fJavadoc;
    }

    private String computeInfo() {
        try {
            IJavaElement javaElement = this.getJavaElement();
            if (javaElement instanceof IMember) {
                IMember member = (IMember)javaElement;
                return this.extractJavadoc(member);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        catch (IOException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    private String extractJavadoc(IMember member) throws JavaModelException, IOException {
        Reader reader;
        if (member != null && (reader = JavadocContentAccess.getHTMLContentReader(member, true, true)) != null) {
            return ProposalInfo.getString(reader);
        }
        return null;
    }

    private static String getString(Reader reader) {
        StringBuffer buf = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            int count;
            while ((count = reader.read(buffer)) != -1) {
                buf.append(buffer, 0, count);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return buf.toString();
    }
}

