/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.ide.dialogs.PathVariableSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class AddSourceFolderWizardPage
extends NewElementWizardPage {
    private static final String PAGE_NAME = "NewSourceFolderWizardPage";
    private final StringButtonDialogField fRootDialogField;
    private final SelectionButtonDialogField fAddExclusionPatterns;
    private final SelectionButtonDialogField fRemoveProjectFolder;
    private final SelectionButtonDialogField fIgnoreConflicts;
    private final LinkFields fLinkFields;
    private final CPListElement fNewElement;
    private final List fExistingEntries;
    private final Hashtable fOrginalExlusionFilters;
    private final Hashtable fOrginalInclusionFilters;
    private final Hashtable fOrginalExlusionFiltersCopy;
    private final Hashtable fOrginalInclusionFiltersCopy;
    private final IPath fOrginalPath;
    private final boolean fLinkedMode;
    private IPath fOutputLocation;
    private IPath fNewOutputLocation;
    private CPListElement fOldProjectSourceFolder;
    private List fModifiedElements;
    private List fRemovedElements;
    private final boolean fAllowConflict;
    private final boolean fAllowRemoveProjectFolder;
    private final boolean fAllowAddExclusionPatterns;
    private final boolean fCanCommitConflictingBuildpath;
    static /* synthetic */ Class class$0;

    public AddSourceFolderWizardPage(CPListElement newElement, List existingEntries, IPath outputLocation, boolean linkedMode, boolean canCommitConflictingBuildpath, boolean allowIgnoreConflicts, boolean allowRemoveProjectFolder, boolean allowAddExclusionPatterns) {
        super(PAGE_NAME);
        this.fLinkedMode = linkedMode;
        this.fCanCommitConflictingBuildpath = canCommitConflictingBuildpath;
        this.fAllowConflict = allowIgnoreConflicts;
        this.fAllowRemoveProjectFolder = allowRemoveProjectFolder;
        this.fAllowAddExclusionPatterns = allowAddExclusionPatterns;
        this.fOrginalExlusionFilters = new Hashtable();
        this.fOrginalInclusionFilters = new Hashtable();
        this.fOrginalExlusionFiltersCopy = new Hashtable();
        this.fOrginalInclusionFiltersCopy = new Hashtable();
        Iterator iter = existingEntries.iterator();
        while (iter.hasNext()) {
            IPath[] inclusions;
            CPListElement element = (CPListElement)iter.next();
            IPath[] exlusions = (IPath[])element.getAttribute("exclusion");
            if (exlusions != null) {
                IPath[] save = new IPath[exlusions.length];
                int i = 0;
                while (i < save.length) {
                    save[i] = exlusions[i];
                    ++i;
                }
                this.fOrginalExlusionFiltersCopy.put(element, save);
                this.fOrginalExlusionFilters.put(element, exlusions);
            }
            if ((inclusions = (IPath[])element.getAttribute("inclusion")) == null) continue;
            IPath[] save = new IPath[inclusions.length];
            int i = 0;
            while (i < save.length) {
                save[i] = inclusions[i];
                ++i;
            }
            this.fOrginalInclusionFiltersCopy.put(element, save);
            this.fOrginalInclusionFilters.put(element, inclusions);
        }
        this.setTitle(NewWizardMessages.NewSourceFolderWizardPage_title);
        this.fOrginalPath = newElement.getPath();
        if (this.fOrginalPath == null) {
            if (linkedMode) {
                this.setDescription(Messages.format(NewWizardMessages.NewFolderDialog_createIn, newElement.getJavaProject().getElementName()));
            } else {
                this.setDescription(NewWizardMessages.NewSourceFolderWizardPage_description);
            }
        } else {
            this.setDescription(NewWizardMessages.NewSourceFolderWizardPage_edit_description);
        }
        this.fNewElement = newElement;
        this.fExistingEntries = existingEntries;
        this.fModifiedElements = new ArrayList();
        this.fRemovedElements = new ArrayList();
        this.fOutputLocation = outputLocation;
        RootFieldAdapter adapter = new RootFieldAdapter();
        this.fRootDialogField = new StringButtonDialogField(adapter);
        this.fRootDialogField.setLabelText(NewWizardMessages.NewSourceFolderWizardPage_root_label);
        this.fRootDialogField.setButtonLabel(NewWizardMessages.NewSourceFolderWizardPage_root_button);
        if (this.fNewElement.getPath() == null) {
            this.fRootDialogField.setText("");
        } else {
            this.setFolderDialogText(this.fNewElement.getPath());
        }
        this.fRootDialogField.setEnabled(this.fNewElement.getJavaProject() != null);
        int buttonStyle = 32;
        if (this.fAllowConflict && this.fAllowAddExclusionPatterns || this.fAllowConflict && this.fAllowRemoveProjectFolder || this.fAllowAddExclusionPatterns && this.fAllowRemoveProjectFolder) {
            buttonStyle = 16;
        }
        this.fAddExclusionPatterns = new SelectionButtonDialogField(buttonStyle);
        this.fAddExclusionPatterns.setLabelText(NewWizardMessages.NewSourceFolderWizardPage_exclude_label);
        this.fAddExclusionPatterns.setSelection(!this.fCanCommitConflictingBuildpath && !this.fAllowRemoveProjectFolder);
        this.fRemoveProjectFolder = new SelectionButtonDialogField(buttonStyle);
        this.fRemoveProjectFolder.setLabelText(NewWizardMessages.NewSourceFolderWizardPage_ReplaceExistingSourceFolder_label);
        this.fRemoveProjectFolder.setSelection(!this.fCanCommitConflictingBuildpath && this.fAllowRemoveProjectFolder);
        this.fIgnoreConflicts = new SelectionButtonDialogField(buttonStyle);
        this.fIgnoreConflicts.setLabelText(NewWizardMessages.AddSourceFolderWizardPage_ignoreNestingConflicts);
        this.fIgnoreConflicts.setSelection(this.fCanCommitConflictingBuildpath);
        this.fLinkFields = new LinkFields();
        if (this.fNewElement.getLinkTarget() != null) {
            this.fLinkFields.setLinkTarget(this.fNewElement.getLinkTarget());
        }
        this.fRemoveProjectFolder.setDialogFieldListener(adapter);
        this.fAddExclusionPatterns.setDialogFieldListener(adapter);
        this.fIgnoreConflicts.setDialogFieldListener(adapter);
        this.fRootDialogField.setDialogFieldListener(adapter);
        this.fLinkFields.setDialogFieldListener(adapter);
        this.packRootDialogFieldChanged();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        composite.setLayout((Layout)layout);
        if (this.fLinkedMode) {
            this.fLinkFields.doFillIntoGrid(composite, layout.numColumns);
        }
        this.fRootDialogField.doFillIntoGrid(composite, layout.numColumns);
        if (this.fAllowRemoveProjectFolder) {
            this.fRemoveProjectFolder.doFillIntoGrid(composite, layout.numColumns);
        }
        if (this.fAllowAddExclusionPatterns) {
            this.fAddExclusionPatterns.doFillIntoGrid(composite, layout.numColumns);
        }
        if (this.fAllowConflict) {
            this.fIgnoreConflicts.doFillIntoGrid(composite, layout.numColumns);
        }
        LayoutUtil.setHorizontalSpan((Control)this.fRootDialogField.getLabelControl(null), layout.numColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.fRootDialogField.getTextControl(null));
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_packageroot_wizard_page_context");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fRootDialogField.setFocus();
        }
    }

    protected void packRootChangeControlPressed(DialogField field) {
        Path initialPath;
        String message;
        String title;
        IFolder folder;
        if (field == this.fRootDialogField && (folder = this.chooseFolder(title = NewWizardMessages.NewSourceFolderWizardPage_ChooseExistingRootDialog_title, message = NewWizardMessages.NewSourceFolderWizardPage_ChooseExistingRootDialog_description, (IPath)(initialPath = new Path(this.fRootDialogField.getText())))) != null) {
            this.setFolderDialogText(folder.getFullPath());
        }
    }

    private void setFolderDialogText(IPath path) {
        IPath shortPath = path.removeFirstSegments(1);
        this.fRootDialogField.setText(shortPath.toString());
    }

    protected void packRootDialogFieldChanged() {
        StatusInfo status = this.updateRootStatus();
        this.updateStatus(new IStatus[]{status});
    }

    private StatusInfo updateRootStatus() {
        IStatus linkNameStatus;
        IJavaProject javaProject = this.fNewElement.getJavaProject();
        IProject project = javaProject.getProject();
        StatusInfo pathNameStatus = AddSourceFolderWizardPage.validatePathName(this.fRootDialogField.getText(), project);
        if (!pathNameStatus.isOK()) {
            return pathNameStatus;
        }
        if (this.fLinkedMode && (linkNameStatus = this.validateLinkLocation(this.fRootDialogField.getText())).matches(4)) {
            StatusInfo result = new StatusInfo();
            result.setError(linkNameStatus.getMessage());
            return result;
        }
        StatusInfo result = new StatusInfo();
        result.setOK();
        IPath projPath = project.getFullPath();
        IPath path = projPath.append(this.fRootDialogField.getText());
        this.restoreCPElements();
        int projectEntryIndex = -1;
        int i = 0;
        while (i < this.fExistingEntries.size()) {
            IClasspathEntry curr = ((CPListElement)this.fExistingEntries.get(i)).getClasspathEntry();
            if (curr.getEntryKind() == 3) {
                if (path.equals((Object)curr.getPath()) && this.fExistingEntries.get(i) != this.fNewElement) {
                    result.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExisting);
                    return result;
                }
                if (projPath.equals((Object)curr.getPath())) {
                    projectEntryIndex = i;
                }
            }
            ++i;
        }
        boolean isProjectASourceFolder = projectEntryIndex != -1;
        this.fModifiedElements.clear();
        this.updateFilters(this.fNewElement.getPath(), path);
        this.fNewElement.setPath(path);
        if (this.fLinkedMode) {
            this.fNewElement.setLinkTarget(this.fLinkFields.getLinkTarget());
        }
        this.fRemovedElements.clear();
        HashSet modified = new HashSet();
        boolean isProjectSourceFolderReplaced = false;
        if (this.fAddExclusionPatterns.isSelected()) {
            if (this.fOrginalPath == null) {
                this.addExclusionPatterns(this.fNewElement, this.fExistingEntries, modified);
                this.fModifiedElements.addAll(modified);
                CPListElement.insert(this.fNewElement, this.fExistingEntries);
            }
        } else if (isProjectASourceFolder) {
            if (this.fRemoveProjectFolder.isSelected()) {
                this.fOldProjectSourceFolder = (CPListElement)this.fExistingEntries.get(projectEntryIndex);
                this.fRemovedElements.add(this.fOldProjectSourceFolder);
                this.fExistingEntries.set(projectEntryIndex, this.fNewElement);
                isProjectSourceFolderReplaced = true;
            } else {
                CPListElement.insert(this.fNewElement, this.fExistingEntries);
            }
        } else {
            CPListElement.insert(this.fNewElement, this.fExistingEntries);
        }
        if (!this.fAllowConflict && this.fCanCommitConflictingBuildpath) {
            return new StatusInfo();
        }
        this.fNewOutputLocation = null;
        IJavaModelStatus status = JavaConventions.validateClasspath((IJavaProject)javaProject, (IClasspathEntry[])CPListElement.convertToClasspathEntries(this.fExistingEntries), (IPath)this.fOutputLocation);
        if (!status.isOK()) {
            if (this.fOutputLocation.equals((Object)projPath)) {
                this.fNewOutputLocation = projPath.append(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
                IJavaModelStatus status2 = JavaConventions.validateClasspath((IJavaProject)javaProject, (IClasspathEntry[])CPListElement.convertToClasspathEntries(this.fExistingEntries), (IPath)this.fNewOutputLocation);
                if (status2.isOK()) {
                    if (isProjectSourceFolderReplaced) {
                        result.setInfo(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceSFandOL, this.fNewOutputLocation.makeRelative().toString()));
                    } else {
                        result.setInfo(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceOL, this.fNewOutputLocation.makeRelative().toString()));
                    }
                    return result;
                }
            }
            this.fNewOutputLocation = null;
            if (this.fCanCommitConflictingBuildpath) {
                result.setInfo(String.valueOf(NewWizardMessages.AddSourceFolderWizardPage_conflictWarning) + status.getMessage());
            } else {
                result.setError(status.getMessage());
            }
            return result;
        }
        if (!modified.isEmpty()) {
            if (modified.size() == 1) {
                CPListElement elem = (CPListElement)modified.toArray()[0];
                IPath changed = elem.getPath().makeRelative();
                IPath excl = this.fNewElement.getPath().makeRelative();
                result.setInfo(Messages.format(NewWizardMessages.AddSourceFolderWizardPage_addSinglePattern, new Object[]{excl, changed}));
            } else {
                result.setInfo(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_warning_AddedExclusions, String.valueOf(modified.size())));
            }
            return result;
        }
        if (isProjectSourceFolderReplaced) {
            result.setInfo(NewWizardMessages.AddSourceFolderWizardPage_replaceSourceFolderInfo);
            return result;
        }
        return result;
    }

    public void restore() {
        Iterator iter = this.fExistingEntries.iterator();
        while (iter.hasNext()) {
            CPListElement element = (CPListElement)iter.next();
            if (this.fOrginalExlusionFilters.containsKey(element)) {
                element.setAttribute("exclusion", this.fOrginalExlusionFiltersCopy.get(element));
            }
            if (!this.fOrginalInclusionFilters.containsKey(element)) continue;
            element.setAttribute("inclusion", this.fOrginalInclusionFiltersCopy.get(element));
        }
        this.fNewElement.setPath(this.fOrginalPath);
    }

    private void restoreCPElements() {
        if (this.fNewElement.getPath() != null) {
            Iterator iter = this.fExistingEntries.iterator();
            while (iter.hasNext()) {
                CPListElement element = (CPListElement)iter.next();
                if (this.fOrginalExlusionFilters.containsKey(element)) {
                    element.setAttribute("exclusion", this.fOrginalExlusionFilters.get(element));
                }
                if (!this.fOrginalInclusionFilters.containsKey(element)) continue;
                element.setAttribute("inclusion", this.fOrginalInclusionFilters.get(element));
            }
            if (this.fOldProjectSourceFolder != null) {
                this.fExistingEntries.set(this.fExistingEntries.indexOf(this.fNewElement), this.fOldProjectSourceFolder);
                this.fOldProjectSourceFolder = null;
            } else if (this.fExistingEntries.contains(this.fNewElement)) {
                this.fExistingEntries.remove(this.fNewElement);
            }
        }
    }

    private void updateFilters(IPath oldPath, IPath newPath) {
        if (oldPath == null) {
            return;
        }
        IPath projPath = this.fNewElement.getJavaProject().getProject().getFullPath();
        if (projPath.isPrefixOf(oldPath)) {
            oldPath = oldPath.removeFirstSegments(projPath.segmentCount()).addTrailingSeparator();
        }
        if (projPath.isPrefixOf(newPath)) {
            newPath = newPath.removeFirstSegments(projPath.segmentCount()).addTrailingSeparator();
        }
        Iterator iter = this.fExistingEntries.iterator();
        while (iter.hasNext()) {
            IPath[] inclusion;
            IPath[] exlusions;
            CPListElement element = (CPListElement)iter.next();
            IPath elementPath = element.getPath();
            if (projPath.isPrefixOf(elementPath) && (elementPath = elementPath.removeFirstSegments(projPath.segmentCount())).segmentCount() > 0) {
                elementPath = elementPath.addTrailingSeparator();
            }
            if ((exlusions = (IPath[])element.getAttribute("exclusion")) != null) {
                int i = 0;
                while (i < exlusions.length) {
                    if (elementPath.append(exlusions[i]).equals((Object)oldPath)) {
                        this.fModifiedElements.add(element);
                        exlusions[i] = newPath.removeFirstSegments(elementPath.segmentCount());
                    }
                    ++i;
                }
                element.setAttribute("exclusion", exlusions);
            }
            if ((inclusion = (IPath[])element.getAttribute("inclusion")) == null) continue;
            int i = 0;
            while (i < inclusion.length) {
                if (elementPath.append(inclusion[i]).equals((Object)oldPath)) {
                    this.fModifiedElements.add(element);
                    inclusion[i] = newPath.removeFirstSegments(elementPath.segmentCount());
                }
                ++i;
            }
            element.setAttribute("inclusion", inclusion);
        }
    }

    private IStatus validateLinkLocation(String folderName) {
        IWorkspace workspace = JavaPlugin.getWorkspace();
        IPath path = Path.fromOSString((String)this.fLinkFields.fLinkLocation.getText());
        IStatus locationStatus = workspace.validateLinkLocation((IResource)this.fNewElement.getJavaProject().getProject().getFolder((IPath)new Path(folderName)), path);
        if (locationStatus.matches(4)) {
            return locationStatus;
        }
        IPathVariableManager pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        IPath path1 = Path.fromOSString((String)this.fLinkFields.fLinkLocation.getText());
        IPath resolvedPath = pathVariableManager.resolvePath(path1);
        String resolvedLinkTarget = resolvedPath.toOSString();
        path = new Path(resolvedLinkTarget);
        File linkTargetFile = new Path(resolvedLinkTarget).toFile();
        if (linkTargetFile.exists()) {
            if (!linkTargetFile.isDirectory()) {
                return new StatusInfo(4, NewWizardMessages.NewFolderDialog_linkTargetNotFolder);
            }
        } else {
            return new StatusInfo(4, NewWizardMessages.NewFolderDialog_linkTargetNonExistent);
        }
        if (locationStatus.isOK()) {
            return new StatusInfo();
        }
        return new StatusInfo(locationStatus.getSeverity(), locationStatus.getMessage());
    }

    private static StatusInfo validatePathName(String str, IProject project) {
        StatusInfo result = new StatusInfo();
        result.setOK();
        IPath projPath = project.getFullPath();
        if (str.length() == 0) {
            result.setError(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_error_EnterRootName, projPath.toString()));
            return result;
        }
        IPath path = projPath.append(str);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IStatus validate = workspaceRoot.getWorkspace().validatePath(path.toString(), 2);
        if (validate.matches(4)) {
            result.setError(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_error_InvalidRootName, validate.getMessage()));
            return result;
        }
        IResource res = workspaceRoot.findMember(path);
        if (res != null) {
            if (res.getType() != 2) {
                result.setError(NewWizardMessages.NewSourceFolderWizardPage_error_NotAFolder);
                return result;
            }
        } else {
            URI projLocation = project.getLocationURI();
            if (projLocation != null) {
                try {
                    IFileStore store = EFS.getStore((URI)projLocation).getChild(str);
                    if (store.fetchInfo().exists()) {
                        result.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExistingDifferentCase);
                        return result;
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        return result;
    }

    private void addExclusionPatterns(CPListElement newEntry, List existing, Set modifiedEntries) {
        IPath entryPath = newEntry.getPath();
        int i = 0;
        while (i < existing.size()) {
            boolean added;
            CPListElement curr = (CPListElement)existing.get(i);
            IPath currPath = curr.getPath();
            if (curr != newEntry && curr.getEntryKind() == 3 && currPath.isPrefixOf(entryPath) && (added = curr.addToExclusions(entryPath))) {
                modifiedEntries.add(curr);
            }
            ++i;
        }
    }

    public IResource getCorrespondingResource() {
        return this.fNewElement.getJavaProject().getProject().getFolder(this.fRootDialogField.getText());
    }

    public IPath getOutputLocation() {
        if (this.fNewOutputLocation != null) {
            return this.fNewOutputLocation;
        }
        return this.fOutputLocation;
    }

    private IFolder chooseFolder(String title, String message, IPath initialPath) {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] acceptedClasses = classArray;
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, null);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        IProject currProject = this.fNewElement.getJavaProject().getProject();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)currProject);
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        IResource res = currProject.findMember(initialPath);
        if (res != null) {
            dialog.setInitialSelection((Object)res);
        }
        if (dialog.open() == 0) {
            return (IFolder)dialog.getFirstResult();
        }
        return null;
    }

    public List getModifiedElements() {
        if (this.fOrginalPath != null && !this.fModifiedElements.contains(this.fNewElement)) {
            this.fModifiedElements.add(this.fNewElement);
        }
        return this.fModifiedElements;
    }

    public List getRemovedElements() {
        return this.fRemovedElements;
    }

    private final class LinkFields
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private StringButtonDialogField fLinkLocation = new StringButtonDialogField(this);
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.jdt.ui.last.external.project";
        private RootFieldAdapter fAdapter;
        private SelectionButtonDialogField fVariables;

        public LinkFields() {
            this.fLinkLocation.setLabelText(NewWizardMessages.LinkFolderDialog_dependenciesGroup_locationLabel_desc);
            this.fLinkLocation.setButtonLabel(NewWizardMessages.LinkFolderDialog_dependenciesGroup_browseButton_desc);
            this.fLinkLocation.setDialogFieldListener(this);
            this.fVariables = new SelectionButtonDialogField(8);
            this.fVariables.setLabelText(NewWizardMessages.LinkFolderDialog_dependenciesGroup_variables_desc);
            this.fVariables.setDialogFieldListener(new IDialogFieldListener(this){
                final /* synthetic */ LinkFields this$1;
                {
                    this.this$1 = linkFields;
                }

                public void dialogFieldChanged(DialogField field) {
                    LinkFields.access$0(this.this$1);
                }
            });
        }

        public void setDialogFieldListener(RootFieldAdapter adapter) {
            this.fAdapter = adapter;
        }

        private void doFillIntoGrid(Composite parent, int numColumns) {
            this.fLinkLocation.doFillIntoGrid(parent, numColumns);
            LayoutUtil.setHorizontalSpan((Control)this.fLinkLocation.getLabelControl(null), numColumns);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLinkLocation.getTextControl(null));
            this.fVariables.doFillIntoGrid(parent, 1);
        }

        public IPath getLinkTarget() {
            return Path.fromOSString((String)this.fLinkLocation.getText());
        }

        public void setLinkTarget(IPath path) {
            this.fLinkLocation.setText(path.toOSString());
        }

        public void changeControlPressed(DialogField field) {
            String selectedDirectory;
            File path;
            String prevLocation;
            DirectoryDialog dialog = new DirectoryDialog(AddSourceFolderWizardPage.this.getShell());
            dialog.setMessage(NewWizardMessages.JavaProjectWizardFirstPage_directory_message);
            String directoryName = this.fLinkLocation.getText().trim();
            if (directoryName.length() == 0 && (prevLocation = JavaPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                directoryName = prevLocation;
            }
            if (directoryName.length() > 0 && (path = new File(directoryName)).exists()) {
                dialog.setFilterPath(directoryName);
            }
            if ((selectedDirectory = dialog.open()) != null) {
                this.fLinkLocation.setText(selectedDirectory);
                AddSourceFolderWizardPage.this.fRootDialogField.setText(selectedDirectory.substring(selectedDirectory.lastIndexOf(File.separatorChar) + 1));
                JavaPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
                if (this.fAdapter != null) {
                    this.fAdapter.dialogFieldChanged(AddSourceFolderWizardPage.this.fRootDialogField);
                }
            }
        }

        private void handleVariablesButtonPressed() {
            String[] variableNames;
            int variableTypes = 2;
            PathVariableSelectionDialog dialog = new PathVariableSelectionDialog(AddSourceFolderWizardPage.this.getShell(), variableTypes);
            if (dialog.open() == 0 && (variableNames = (String[])dialog.getResult()) != null && variableNames.length == 1) {
                this.fLinkLocation.setText(variableNames[0]);
                AddSourceFolderWizardPage.this.fRootDialogField.setText(variableNames[0]);
                if (this.fAdapter != null) {
                    this.fAdapter.dialogFieldChanged(AddSourceFolderWizardPage.this.fRootDialogField);
                }
            }
        }

        public void dialogFieldChanged(DialogField field) {
            if (this.fAdapter != null) {
                this.fAdapter.dialogFieldChanged(this.fLinkLocation);
            }
        }

        static /* synthetic */ void access$0(LinkFields linkFields) {
            linkFields.handleVariablesButtonPressed();
        }
    }

    private class RootFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private RootFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            AddSourceFolderWizardPage.this.packRootChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            AddSourceFolderWizardPage.this.packRootDialogFieldChanged();
        }
    }
}

