/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class JARFileSelectionDialog
extends ElementTreeSelectionDialog {
    public JARFileSelectionDialog(Shell parent, boolean multiSelect, boolean acceptFolders) {
        super(parent, (ILabelProvider)new FileLabelProvider(), (ITreeContentProvider)new FileContentProvider());
        this.setSorter(new FileViewerSorter());
        this.addFilter(new FileArchiveFileFilter());
        this.setValidator(new FileSelectionValidator(multiSelect, acceptFolders));
    }

    private static boolean isArchive(File file) {
        String name = file.getName();
        int detIndex = name.lastIndexOf(46);
        return detIndex != -1 && ArchiveFileFilter.isArchiveFileExtension(name.substring(detIndex + 1));
    }

    private static class FileLabelProvider
    extends LabelProvider {
        private final Image IMG_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        private final Image IMG_JAR = JavaPlugin.getDefault().getImageRegistry().get("org.eclipse.jdt.ui.jar_l_obj.gif");

        private FileLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof File) {
                File curr = (File)element;
                if (curr.isDirectory()) {
                    return this.IMG_FOLDER;
                }
                return this.IMG_JAR;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof File) {
                return ((File)element).getName();
            }
            return super.getText(element);
        }
    }

    private static class FileContentProvider
    implements ITreeContentProvider {
        private final Object[] EMPTY = new Object[0];

        private FileContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children;
            if (parentElement instanceof File && (children = ((File)parentElement).listFiles()) != null) {
                return children;
            }
            return this.EMPTY;
        }

        public Object getParent(Object element) {
            if (element instanceof File) {
                return ((File)element).getParentFile();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class FileArchiveFileFilter
    extends ViewerFilter {
        private FileArchiveFileFilter() {
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            if (element instanceof File) {
                File file = (File)element;
                if (file.isFile()) {
                    return JARFileSelectionDialog.isArchive(file);
                }
                return true;
            }
            return false;
        }
    }

    private static class FileViewerSorter
    extends ViewerSorter {
        private FileViewerSorter() {
        }

        public int category(Object element) {
            if (element instanceof File && ((File)element).isFile()) {
                return 1;
            }
            return 0;
        }
    }

    private static class FileSelectionValidator
    implements ISelectionStatusValidator {
        private boolean fMultiSelect;
        private boolean fAcceptFolders;

        public FileSelectionValidator(boolean multiSelect, boolean acceptFolders) {
            this.fMultiSelect = multiSelect;
            this.fAcceptFolders = acceptFolders;
        }

        public IStatus validate(Object[] selection) {
            int nSelected = selection.length;
            if (nSelected == 0 || nSelected > 1 && !this.fMultiSelect) {
                return new StatusInfo(4, "");
            }
            int i = 0;
            while (i < selection.length) {
                Object curr = selection[i];
                if (curr instanceof File) {
                    File file = (File)curr;
                    if (!this.fAcceptFolders && !file.isFile()) {
                        return new StatusInfo(4, "");
                    }
                }
                ++i;
            }
            return new StatusInfo();
        }
    }
}

