/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class AddSelectedLibraryToBuildpathAction
extends Action
implements ISelectionChangedListener {
    private final IWorkbenchSite fSite;
    private final List fSelectedElements;
    static /* synthetic */ Class class$0;

    public AddSelectedLibraryToBuildpathAction(IWorkbenchSite site) {
        super(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelLibToCP_label, JavaPluginImages.DESC_OBJS_EXTJAR);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelLibToCP_tooltip);
        this.fSite = site;
        this.fSelectedElements = new ArrayList();
    }

    public void run() {
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IJavaProject project = JavaCore.create((IProject)((IFile)AddSelectedLibraryToBuildpathAction.this.fSelectedElements.get(0)).getProject());
                        List result = AddSelectedLibraryToBuildpathAction.this.addLibraryEntries(AddSelectedLibraryToBuildpathAction.this.fSelectedElements, project, monitor);
                        AddSelectedLibraryToBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause());
            } else {
                JavaPlugin.log(e);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private List addLibraryEntries(List resources, IJavaProject project, IProgressMonitor monitor) throws CoreException {
        ArrayList<IPackageFragmentRoot> arrayList;
        ArrayList<CPListElement> addedEntries = new ArrayList<CPListElement>();
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 4);
            int i = 0;
            while (i < resources.size()) {
                IResource res = (IResource)resources.get(i);
                addedEntries.add(new CPListElement(project, 1, res.getFullPath(), res));
                ++i;
            }
            monitor.worked(1);
            List existingEntries = ClasspathModifier.getExistingEntries(project);
            ClasspathModifier.setNewEntry(existingEntries, addedEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ClasspathModifier.commitClassPath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>(addedEntries.size());
            int i2 = 0;
            while (i2 < resources.size()) {
                IResource res = (IResource)resources.get(i2);
                IPackageFragmentRoot elem = project.getPackageFragmentRoot(res);
                if (elem != null) {
                    result.add(elem);
                }
                ++i2;
            }
            monitor.worked(1);
            arrayList = result;
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return arrayList;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.canHandle((IStructuredSelection)selection));
        } else {
            this.setEnabled(this.canHandle((IStructuredSelection)StructuredSelection.EMPTY));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canHandle(IStructuredSelection elements) {
        if (elements.size() == 0) {
            return false;
        }
        try {
            IJavaProject project;
            IFile file;
            this.fSelectedElements.clear();
            Iterator iter = elements.iterator();
            do {
                if (!iter.hasNext()) {
                    return true;
                }
                Object element = iter.next();
                this.fSelectedElements.add(element);
                if (!(element instanceof IFile)) {
                    return false;
                }
                file = (IFile)element;
                project = JavaCore.create((IProject)file.getProject());
                if (project != null) continue;
                return false;
            } while (ClasspathModifier.isArchive(file, project));
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private void showExceptionDialog(CoreException exception) {
        ExceptionHandler.handle(exception, this.fSite.getShell(), NewWizardMessages.AddSelectedLibraryToBuildpathAction_ErrorTitle, exception.getMessage());
    }

    private void selectAndReveal(final ISelection selection) {
        IWorkbenchPart part;
        IWorkbenchPage page = this.fSite.getPage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        Iterator itr = parts.iterator();
        while (itr.hasNext()) {
            part = (IWorkbenchPart)itr.next();
            ISetSelectionTarget target = null;
            if (part instanceof ISetSelectionTarget) {
                target = (ISetSelectionTarget)part;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ui.part.ISetSelectionTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                target = (ISetSelectionTarget)part.getAdapter((Class)clazz);
            }
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            page.getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    finalTarget.selectReveal(selection);
                }
            });
        }
    }
}

