/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.filters.LibraryFilter;
import org.eclipse.jdt.internal.ui.filters.OutputFolderFilter;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.ClasspathModifierAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorerActionGroup;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

public class DialogPackageExplorer
implements IMenuListener,
ISelectionChangedListener {
    private TreeViewer fPackageViewer;
    private Menu fContextMenu;
    private DialogPackageExplorerActionGroup fActionGroup = null;
    private boolean fShowOutputFolders = false;
    private IStructuredSelection fCurrentSelection = new StructuredSelection();
    private IJavaProject fCurrJProject = null;

    public Control createControl(Composite parent) {
        this.fPackageViewer = new TreeViewer(parent, 2);
        this.fPackageViewer.setComparer(WorkingSetModel.COMPARER);
        this.fPackageViewer.addFilter((ViewerFilter)new PackageFilter());
        this.fPackageViewer.setSorter((ViewerSorter)new ExtendedJavaElementSorter());
        this.fPackageViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CPListElementAttribute attribute;
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (DialogPackageExplorer.this.fPackageViewer.isExpandable(element)) {
                    DialogPackageExplorer.this.fPackageViewer.setExpandedState(element, !DialogPackageExplorer.this.fPackageViewer.getExpandedState(element));
                } else if (element instanceof CPListElementAttribute && (attribute = (CPListElementAttribute)element).getKey().equals("output")) {
                    ClasspathModifierAction[] actions = DialogPackageExplorer.this.fActionGroup.getActions();
                    int i = 0;
                    while (i < actions.length) {
                        if (actions[i].getOperation().getTypeId() == 7) {
                            actions[i].run();
                            return;
                        }
                        ++i;
                    }
                }
            }
        });
        this.fPackageViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuMgr.createContextMenu((Control)this.fPackageViewer.getTree());
        this.fPackageViewer.getTree().setMenu(this.fContextMenu);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DialogPackageExplorer.this.fContextMenu.dispose();
            }
        });
        return this.fPackageViewer.getControl();
    }

    public void setActionGroup(final DialogPackageExplorerActionGroup actionGroup) {
        this.fActionGroup = actionGroup;
        this.fPackageViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (actionGroup != null) {
                    actionGroup.dispose();
                }
            }
        });
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.fActionGroup == null) {
            return;
        }
        JavaPlugin.createStandardGroups(manager);
        this.fActionGroup.fillContextMenu(manager);
    }

    public void setContentProvider() {
        PackageContentProvider contentProvider = new PackageContentProvider();
        PackageLabelProvider labelProvider = new PackageLabelProvider(36421324767273L, 3);
        this.fPackageViewer.setContentProvider((IContentProvider)contentProvider);
        this.fPackageViewer.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(labelProvider, false));
    }

    public void setInput(IJavaProject project) {
        this.fCurrJProject = project;
        this.fPackageViewer.setInput(new Object());
        StructuredSelection selection = new StructuredSelection((Object)project);
        this.fPackageViewer.setSelection((ISelection)selection);
        this.fPackageViewer.expandToLevel(2);
        this.fCurrentSelection = selection;
        try {
            if (this.fActionGroup != null) {
                this.fActionGroup.refresh(new DialogPackageExplorerActionGroup.DialogExplorerActionContext((ISelection)this.fCurrentSelection, this.fCurrJProject));
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    public void refresh() {
        this.fPackageViewer.refresh(true);
    }

    public void setSelection(List elements) {
        if (elements == null || elements.size() == 0) {
            return;
        }
        this.fPackageViewer.refresh();
        StructuredSelection selection = new StructuredSelection(elements);
        this.fPackageViewer.setSelection((ISelection)selection, true);
        this.fPackageViewer.getTree().setFocus();
        if (elements.size() == 1 && elements.get(0) instanceof IJavaProject) {
            this.fPackageViewer.expandToLevel(elements.get(0), 1);
        }
    }

    public IStructuredSelection getSelection() {
        return this.fCurrentSelection;
    }

    public Control getViewerControl() {
        return this.fPackageViewer.getControl();
    }

    private boolean isSelected() {
        return this.fShowOutputFolders;
    }

    public void showOutputFolders(boolean showOutputFolders) {
        this.fShowOutputFolders = showOutputFolders;
        this.fActionGroup.showOutputFolders(showOutputFolders);
        this.fPackageViewer.refresh();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fCurrentSelection = (IStructuredSelection)event.getSelection();
        try {
            if (this.fActionGroup != null) {
                this.fActionGroup.setContext(new DialogPackageExplorerActionGroup.DialogExplorerActionContext((ISelection)this.fCurrentSelection, this.fCurrJProject));
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    private final class PackageContentProvider
    extends StandardJavaElementContentProvider {
        public Object[] getElements(Object element) {
            if (DialogPackageExplorer.this.fCurrJProject == null) {
                return new Object[0];
            }
            return new Object[]{DialogPackageExplorer.this.fCurrJProject};
        }

        public Object[] getChildren(Object element) {
            Object[] children = super.getChildren(element);
            if ((element instanceof IPackageFragmentRoot && !((IPackageFragmentRoot)element).isArchive() || element instanceof IJavaProject && DialogPackageExplorer.this.fCurrJProject.isOnClasspath((IJavaElement)DialogPackageExplorer.this.fCurrJProject)) && DialogPackageExplorer.this.isSelected()) {
                try {
                    IClasspathEntry entry = element instanceof IPackageFragmentRoot ? ((IPackageFragmentRoot)element).getRawClasspathEntry() : ClasspathModifier.getClasspathEntryFor(DialogPackageExplorer.this.fCurrJProject.getPath(), DialogPackageExplorer.this.fCurrJProject, 3);
                    CPListElement parent = CPListElement.createFromExisting(entry, DialogPackageExplorer.this.fCurrJProject);
                    CPListElementAttribute outputFolder = new CPListElementAttribute(parent, "output", parent.getAttribute("output"), true);
                    Object[] extendedChildren = new Object[children.length + 1];
                    System.arraycopy(children, 0, extendedChildren, 1, children.length);
                    extendedChildren[0] = outputFolder;
                    return extendedChildren;
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                    return null;
                }
            }
            return children;
        }
    }

    private final class PackageLabelProvider
    extends AppearanceAwareLabelProvider {
        private CPListLabelProvider outputFolderLabel = new CPListLabelProvider();

        public PackageLabelProvider(long textFlags, int imageFlags) {
            super(textFlags, imageFlags);
        }

        public String getText(Object element) {
            if (element instanceof CPListElementAttribute) {
                return this.outputFolderLabel.getText(element);
            }
            String text = super.getText(element);
            try {
                IResource resource;
                IPackageFragmentRoot root;
                IJavaProject project;
                IPackageFragmentRoot root2;
                if (element instanceof IPackageFragmentRoot && (root2 = (IPackageFragmentRoot)element).exists() && ClasspathModifier.filtersSet(root2)) {
                    IClasspathEntry entry = root2.getRawClasspathEntry();
                    int excluded = entry.getExclusionPatterns().length;
                    if (excluded == 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_SingleExcluded, text);
                    }
                    if (excluded > 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_MultiExcluded, new Object[]{text, new Integer(excluded)});
                    }
                }
                if (element instanceof IJavaProject && (project = (IJavaProject)element).exists() && project.isOnClasspath((IJavaElement)project) && ClasspathModifier.filtersSet(root = project.findPackageFragmentRoot(project.getPath()))) {
                    IClasspathEntry entry = root.getRawClasspathEntry();
                    int excluded = entry.getExclusionPatterns().length;
                    if (excluded == 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_SingleExcluded, text);
                    }
                    if (excluded > 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_MultiExcluded, new Object[]{text, new Integer(excluded)});
                    }
                }
                if ((element instanceof IFile || element instanceof IFolder) && (resource = (IResource)element).exists() && ClasspathModifier.isExcluded(resource, DialogPackageExplorer.this.fCurrJProject)) {
                    return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_Excluded, text);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            return text;
        }

        public Color getForeground(Object element) {
            try {
                IResource resource;
                IPackageFragmentRoot root;
                IJavaProject project;
                IPackageFragmentRoot root2;
                if (element instanceof IPackageFragmentRoot && (root2 = (IPackageFragmentRoot)element).exists() && ClasspathModifier.filtersSet(root2)) {
                    return this.getBlueColor();
                }
                if (element instanceof IJavaProject && (project = (IJavaProject)element).exists() && project.isOnClasspath((IJavaElement)project) && (root = project.findPackageFragmentRoot(project.getPath())) != null && ClasspathModifier.filtersSet(root)) {
                    return this.getBlueColor();
                }
                if ((element instanceof IFile || element instanceof IFolder) && (resource = (IResource)element).exists() && ClasspathModifier.isExcluded(resource, DialogPackageExplorer.this.fCurrJProject)) {
                    return this.getBlueColor();
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            return null;
        }

        private Color getBlueColor() {
            return Display.getCurrent().getSystemColor(9);
        }

        public Image getImage(Object element) {
            if (element instanceof CPListElementAttribute) {
                return this.outputFolderLabel.getImage(element);
            }
            return super.getImage(element);
        }

        public void dispose() {
            this.outputFolderLabel.dispose();
            super.dispose();
        }
    }

    private final class ExtendedJavaElementSorter
    extends JavaElementSorter {
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof CPListElementAttribute) {
                return -1;
            }
            if (e2 instanceof CPListElementAttribute) {
                return 1;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private final class PackageFilter
    extends LibraryFilter {
        private OutputFolderFilter fOutputFolderFilter = new OutputFolderFilter();

        private PackageFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            block5: {
                IFile file;
                if (!(element instanceof IFile) || !(file = (IFile)element).getName().equals(".classpath") && !file.getName().equals(".project")) break block5;
                return false;
            }
            try {
                IClasspathEntry cpe;
                if (element instanceof IPackageFragmentRoot && ((cpe = ((IPackageFragmentRoot)element).getRawClasspathEntry()) == null || cpe.getEntryKind() == 5)) {
                    return false;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            return this.fOutputFolderFilter.select(viewer, parentElement, element);
        }
    }
}

