/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.AddTaskAction;
import org.eclipse.jdt.internal.ui.actions.CleanUpAction;
import org.eclipse.jdt.internal.ui.actions.ConfigureDeprecationFixAction;
import org.eclipse.jdt.internal.ui.actions.FindBrokenNLSKeysAction;
import org.eclipse.jdt.internal.ui.actions.JDTQuickMenuAction;
import org.eclipse.jdt.internal.ui.javaeditor.AddImportOnSelectionAction;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.ui.actions.AddDelegateMethodsAction;
import org.eclipse.jdt.ui.actions.AddGetterSetterAction;
import org.eclipse.jdt.ui.actions.AddJavaDocStubAction;
import org.eclipse.jdt.ui.actions.AddUnimplementedConstructorsAction;
import org.eclipse.jdt.ui.actions.ExternalizeStringsAction;
import org.eclipse.jdt.ui.actions.FindStringsToExternalizeAction;
import org.eclipse.jdt.ui.actions.FormatAllAction;
import org.eclipse.jdt.ui.actions.GenerateHashCodeEqualsAction;
import org.eclipse.jdt.ui.actions.GenerateNewConstructorUsingFieldsAction;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.jdt.ui.actions.OverrideMethodsAction;
import org.eclipse.jdt.ui.actions.SortMembersAction;
import org.eclipse.jdt.ui.actions.SurroundWithTryCatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.AddBookmarkAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.IUpdate;

public class GenerateActionGroup
extends ActionGroup {
    public static final String MENU_ID = "org.eclipse.jdt.ui.source.menu";
    public static final String GROUP_IMPORT = "importGroup";
    public static final String GROUP_GENERATE = "generateGroup";
    public static final String GROUP_CODE = "codeGroup";
    private CompilationUnitEditor fEditor;
    private IWorkbenchSite fSite;
    private String fGroupName = "group.reorganize";
    private List fRegisteredSelectionListeners;
    private AddImportOnSelectionAction fAddImport;
    private OverrideMethodsAction fOverrideMethods;
    private ConfigureDeprecationFixAction fDeprecationAction;
    private GenerateHashCodeEqualsAction fHashCodeEquals;
    private AddGetterSetterAction fAddGetterSetter;
    private AddDelegateMethodsAction fAddDelegateMethods;
    private AddUnimplementedConstructorsAction fAddUnimplementedConstructors;
    private GenerateNewConstructorUsingFieldsAction fGenerateConstructorUsingFields;
    private AddJavaDocStubAction fAddJavaDocStub;
    private AddBookmarkAction fAddBookmark;
    private AddTaskAction fAddTaskAction;
    private ExternalizeStringsAction fExternalizeStrings;
    private FindStringsToExternalizeAction fFindStringsToExternalize;
    private SurroundWithTryCatchAction fSurroundWithTryCatch;
    private CleanUpAction fCleanUp;
    private FindBrokenNLSKeysAction fFindNLSProblems;
    private OrganizeImportsAction fOrganizeImports;
    private SortMembersAction fSortMembers;
    private FormatAllAction fFormatAll;
    private static final String QUICK_MENU_ID = "org.eclipse.jdt.ui.edit.text.java.source.quickMenu";
    private RefactorQuickAccessAction fQuickAccessAction;
    private IKeyBindingService fKeyBindingService;

    public GenerateActionGroup(CompilationUnitEditor editor, String groupName) {
        this.fSite = editor.getSite();
        this.fEditor = editor;
        this.fGroupName = groupName;
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fAddImport = new AddImportOnSelectionAction(editor);
        this.fAddImport.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.add.import");
        this.fAddImport.update();
        editor.setAction("AddImport", (IAction)this.fAddImport);
        this.fOrganizeImports = new OrganizeImportsAction(editor);
        this.fOrganizeImports.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.organize.imports");
        editor.setAction("OrganizeImports", (IAction)this.fOrganizeImports);
        this.fSortMembers = new SortMembersAction(editor);
        this.fSortMembers.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.sort.members");
        editor.setAction("SortMembers", (IAction)this.fSortMembers);
        this.fOverrideMethods = new OverrideMethodsAction(editor);
        this.fOverrideMethods.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.override.methods");
        editor.setAction("OverrideMethods", (IAction)this.fOverrideMethods);
        this.fAddGetterSetter = new AddGetterSetterAction(editor);
        this.fAddGetterSetter.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.create.getter.setter");
        editor.setAction("AddGetterSetter", (IAction)this.fAddGetterSetter);
        this.fAddDelegateMethods = new AddDelegateMethodsAction(editor);
        this.fAddDelegateMethods.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.create.delegate.methods");
        editor.setAction("AddDelegateMethods", (IAction)this.fAddDelegateMethods);
        this.fAddUnimplementedConstructors = new AddUnimplementedConstructorsAction(editor);
        this.fAddUnimplementedConstructors.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.add.unimplemented.constructors");
        editor.setAction("AddUnimplementedConstructors", (IAction)this.fAddUnimplementedConstructors);
        this.fGenerateConstructorUsingFields = new GenerateNewConstructorUsingFieldsAction(editor);
        this.fGenerateConstructorUsingFields.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.generate.constructor.using.fields");
        editor.setAction("GenerateConstructorUsingFields", (IAction)this.fGenerateConstructorUsingFields);
        this.fHashCodeEquals = new GenerateHashCodeEqualsAction(editor);
        this.fHashCodeEquals.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.generate.hashcode.equals");
        editor.setAction("GenerateHashCodeEquals", (IAction)this.fHashCodeEquals);
        this.fDeprecationAction = new ConfigureDeprecationFixAction(editor);
        this.fDeprecationAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.configure.deprecation.fix");
        editor.setAction("ConfigureDeprecationFix", (IAction)this.fDeprecationAction);
        this.fAddJavaDocStub = new AddJavaDocStubAction(editor);
        this.fAddJavaDocStub.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.add.javadoc.comment");
        editor.setAction("AddJavadocComment", (IAction)this.fAddJavaDocStub);
        this.fSurroundWithTryCatch = new SurroundWithTryCatchAction(editor);
        this.fSurroundWithTryCatch.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.surround.with.try.catch");
        this.fSurroundWithTryCatch.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)this.fSurroundWithTryCatch);
        editor.setAction("SurroundWithTryCatch", (IAction)this.fSurroundWithTryCatch);
        this.fCleanUp = new CleanUpAction(editor);
        this.fCleanUp.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.clean.up");
        editor.setAction("CleanUp", (IAction)this.fCleanUp);
        this.fExternalizeStrings = new ExternalizeStringsAction(editor);
        this.fExternalizeStrings.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.externalize.strings");
        editor.setAction("ExternalizeStrings", (IAction)this.fExternalizeStrings);
        this.fQuickAccessAction = new RefactorQuickAccessAction(editor);
        this.fKeyBindingService = editor.getEditorSite().getKeyBindingService();
        this.fKeyBindingService.registerAction((IAction)this.fQuickAccessAction);
    }

    public GenerateActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite(), null);
    }

    public GenerateActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite(), part.getSite().getKeyBindingService());
    }

    private GenerateActionGroup(IWorkbenchSite site, IKeyBindingService keyBindingService) {
        this.fSite = site;
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fOverrideMethods = new OverrideMethodsAction(site);
        this.fOverrideMethods.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.override.methods");
        this.fAddGetterSetter = new AddGetterSetterAction(site);
        this.fAddGetterSetter.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.create.getter.setter");
        this.fAddDelegateMethods = new AddDelegateMethodsAction(site);
        this.fAddDelegateMethods.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.create.delegate.methods");
        this.fAddUnimplementedConstructors = new AddUnimplementedConstructorsAction(site);
        this.fAddUnimplementedConstructors.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.add.unimplemented.constructors");
        this.fGenerateConstructorUsingFields = new GenerateNewConstructorUsingFieldsAction(site);
        this.fGenerateConstructorUsingFields.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.generate.constructor.using.fields");
        this.fHashCodeEquals = new GenerateHashCodeEqualsAction(site);
        this.fHashCodeEquals.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.generate.hashcode.equals");
        this.fDeprecationAction = new ConfigureDeprecationFixAction(site);
        this.fDeprecationAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.configure.deprecation.fix");
        this.fAddJavaDocStub = new AddJavaDocStubAction(site);
        this.fAddJavaDocStub.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.add.javadoc.comment");
        this.fAddBookmark = new AddBookmarkAction(site.getShell());
        this.fAddBookmark.setActionDefinitionId("org.eclipse.ui.edit.addBookmark");
        this.fAddTaskAction = new AddTaskAction(site);
        this.fAddTaskAction.setActionDefinitionId("org.eclipse.ui.edit.addTask");
        this.fExternalizeStrings = new ExternalizeStringsAction(site);
        this.fExternalizeStrings.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.externalize.strings");
        this.fFindStringsToExternalize = new FindStringsToExternalizeAction(site);
        this.fFindStringsToExternalize.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.find.strings.to.externalize");
        this.fFindNLSProblems = new FindBrokenNLSKeysAction(site);
        this.fFindNLSProblems.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.find.broken.nls.keys");
        this.fOrganizeImports = new OrganizeImportsAction(site);
        this.fOrganizeImports.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.organize.imports");
        this.fSortMembers = new SortMembersAction(site);
        this.fSortMembers.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.sort.members");
        this.fFormatAll = new FormatAllAction(site);
        this.fFormatAll.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.format");
        this.fCleanUp = new CleanUpAction(site);
        this.fCleanUp.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.clean.up");
        this.fOverrideMethods.update(selection);
        this.fAddGetterSetter.update(selection);
        this.fAddDelegateMethods.update(selection);
        this.fAddUnimplementedConstructors.update(selection);
        this.fGenerateConstructorUsingFields.update(selection);
        this.fHashCodeEquals.update(selection);
        this.fDeprecationAction.update(selection);
        this.fAddJavaDocStub.update(selection);
        this.fExternalizeStrings.update(selection);
        this.fFindStringsToExternalize.update(selection);
        this.fFindNLSProblems.update(selection);
        this.fCleanUp.update(selection);
        this.fAddTaskAction.update(selection);
        this.fOrganizeImports.update(selection);
        this.fSortMembers.update(selection);
        this.fFormatAll.update(selection);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            this.fAddBookmark.selectionChanged(ss);
        } else {
            this.fAddBookmark.setEnabled(false);
        }
        this.registerSelectionListener(provider, this.fOverrideMethods);
        this.registerSelectionListener(provider, this.fAddGetterSetter);
        this.registerSelectionListener(provider, this.fAddDelegateMethods);
        this.registerSelectionListener(provider, this.fAddUnimplementedConstructors);
        this.registerSelectionListener(provider, this.fGenerateConstructorUsingFields);
        this.registerSelectionListener(provider, this.fHashCodeEquals);
        this.registerSelectionListener(provider, this.fDeprecationAction);
        this.registerSelectionListener(provider, this.fAddJavaDocStub);
        this.registerSelectionListener(provider, (ISelectionChangedListener)this.fAddBookmark);
        this.registerSelectionListener(provider, this.fExternalizeStrings);
        this.registerSelectionListener(provider, this.fFindStringsToExternalize);
        this.registerSelectionListener(provider, this.fFindNLSProblems);
        this.registerSelectionListener(provider, this.fOrganizeImports);
        this.registerSelectionListener(provider, this.fFormatAll);
        this.registerSelectionListener(provider, this.fSortMembers);
        this.registerSelectionListener(provider, this.fAddTaskAction);
        this.registerSelectionListener(provider, this.fCleanUp);
        this.fKeyBindingService = keyBindingService;
        if (this.fKeyBindingService != null) {
            this.fQuickAccessAction = new RefactorQuickAccessAction(null);
            this.fKeyBindingService.registerAction((IAction)this.fQuickAccessAction);
        }
    }

    private void registerSelectionListener(ISelectionProvider provider, ISelectionChangedListener listener) {
        if (this.fRegisteredSelectionListeners == null) {
            this.fRegisteredSelectionListeners = new ArrayList(20);
        }
        provider.addSelectionChangedListener(listener);
        this.fRegisteredSelectionListeners.add(listener);
    }

    public void editorStateChanged() {
        Assert.isTrue((boolean)this.isEditorOwner());
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        String menuText = ActionMessages.SourceMenu_label;
        if (this.fQuickAccessAction != null) {
            menuText = this.fQuickAccessAction.addShortcut(menuText);
        }
        MenuManager subMenu = new MenuManager(menuText, MENU_ID);
        int added = 0;
        added = this.isEditorOwner() ? this.fillEditorSubMenu((IMenuManager)subMenu) : this.fillViewSubMenu((IMenuManager)subMenu);
        if (added > 0) {
            menu.appendToGroup(this.fGroupName, (IContributionItem)subMenu);
        }
    }

    private void fillQuickMenu(IMenuManager menu) {
        if (this.isEditorOwner()) {
            this.fillEditorSubMenu(menu);
        } else {
            this.fillViewSubMenu(menu);
        }
    }

    private int fillEditorSubMenu(IMenuManager source) {
        int added = 0;
        added += this.addEditorAction(source, "ToggleComment");
        added += this.addEditorAction(source, "AddBlockComment");
        added += this.addEditorAction(source, "RemoveBlockComment");
        added += this.addEditorAction(source, "Format");
        added += this.addEditorAction(source, "Indent");
        added += this.addAction(source, (IAction)this.fSortMembers);
        source.add((IContributionItem)new Separator(GROUP_IMPORT));
        added += this.addAction(source, (IAction)this.fOrganizeImports);
        added += this.addAction(source, (IAction)this.fAddImport);
        source.add((IContributionItem)new Separator(GROUP_GENERATE));
        added += this.addAction(source, (IAction)this.fOverrideMethods);
        added += this.addAction(source, (IAction)this.fAddGetterSetter);
        added += this.addAction(source, (IAction)this.fAddDelegateMethods);
        added += this.addAction(source, (IAction)this.fAddUnimplementedConstructors);
        added += this.addAction(source, (IAction)this.fGenerateConstructorUsingFields);
        added += this.addAction(source, (IAction)this.fHashCodeEquals);
        added += this.addAction(source, (IAction)this.fAddJavaDocStub);
        source.add((IContributionItem)new Separator(GROUP_CODE));
        added += this.addAction(source, (IAction)this.fSurroundWithTryCatch);
        added += this.addAction(source, (IAction)this.fExternalizeStrings);
        return added += this.addAction(source, (IAction)this.fCleanUp);
    }

    private int fillViewSubMenu(IMenuManager source) {
        int added = 0;
        added += this.addAction(source, (IAction)this.fFormatAll);
        added += this.addAction(source, (IAction)this.fSortMembers);
        source.add((IContributionItem)new Separator(GROUP_IMPORT));
        added += this.addAction(source, (IAction)this.fOrganizeImports);
        added += this.addAction(source, (IAction)this.fAddImport);
        source.add((IContributionItem)new Separator(GROUP_GENERATE));
        added += this.addAction(source, (IAction)this.fOverrideMethods);
        added += this.addAction(source, (IAction)this.fAddGetterSetter);
        added += this.addAction(source, (IAction)this.fAddDelegateMethods);
        added += this.addAction(source, (IAction)this.fAddUnimplementedConstructors);
        added += this.addAction(source, (IAction)this.fGenerateConstructorUsingFields);
        added += this.addAction(source, (IAction)this.fHashCodeEquals);
        added += this.addAction(source, (IAction)this.fAddJavaDocStub);
        source.add((IContributionItem)new Separator(GROUP_CODE));
        added += this.addAction(source, (IAction)this.fSurroundWithTryCatch);
        added += this.addAction(source, (IAction)this.fExternalizeStrings);
        added += this.addAction(source, (IAction)this.fFindStringsToExternalize);
        added += this.addAction(source, (IAction)this.fFindNLSProblems);
        added += this.addAction(source, (IAction)this.fDeprecationAction);
        return added += this.addAction(source, (IAction)this.fCleanUp);
    }

    public void dispose() {
        if (this.fRegisteredSelectionListeners != null) {
            ISelectionProvider provider = this.fSite.getSelectionProvider();
            Iterator iter = this.fRegisteredSelectionListeners.iterator();
            while (iter.hasNext()) {
                ISelectionChangedListener listener = (ISelectionChangedListener)iter.next();
                provider.removeSelectionChangedListener(listener);
            }
        }
        if (this.fQuickAccessAction != null && this.fKeyBindingService != null) {
            this.fKeyBindingService.unregisterAction((IAction)this.fQuickAccessAction);
        }
        this.fEditor = null;
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars actionBar) {
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.AddImport", (IAction)this.fAddImport);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.SurroundWithTryCatch", (IAction)this.fSurroundWithTryCatch);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.OverrideMethods", (IAction)this.fOverrideMethods);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.GenerateGetterSetter", (IAction)this.fAddGetterSetter);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.GenerateDelegateMethods", (IAction)this.fAddDelegateMethods);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.AddConstructorFromSuperclass", (IAction)this.fAddUnimplementedConstructors);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.GenerateConstructorUsingFields", (IAction)this.fGenerateConstructorUsingFields);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.GenerateHashCodeEquals", (IAction)this.fHashCodeEquals);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ConfigureDeprecationFix", (IAction)this.fDeprecationAction);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.AddJavaDocComment", (IAction)this.fAddJavaDocStub);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ExternalizeStrings", (IAction)this.fExternalizeStrings);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.CleanUp", (IAction)this.fCleanUp);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.FindStringsToExternalize", (IAction)this.fFindStringsToExternalize);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.FindNLSProblems", (IAction)this.fFindNLSProblems);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.OrganizeImports", (IAction)this.fOrganizeImports);
        actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.SortMembers", (IAction)this.fSortMembers);
        if (!this.isEditorOwner()) {
            actionBar.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), (IAction)this.fAddBookmark);
            actionBar.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), (IAction)this.fAddTaskAction);
            actionBar.setGlobalActionHandler("org.eclipse.jdt.ui.actions.Format", (IAction)this.fFormatAll);
        }
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private int addEditorAction(IMenuManager menu, String actionID) {
        if (this.fEditor == null) {
            return 0;
        }
        IAction action = this.fEditor.getAction(actionID);
        if (action == null) {
            return 0;
        }
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
        if (action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private boolean isEditorOwner() {
        return this.fEditor != null;
    }

    private class RefactorQuickAccessAction
    extends JDTQuickMenuAction {
        public RefactorQuickAccessAction(CompilationUnitEditor editor) {
            super(editor, GenerateActionGroup.QUICK_MENU_ID);
        }

        protected void fillMenu(IMenuManager menu) {
            GenerateActionGroup.this.fillQuickMenu(menu);
        }
    }
}

