/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.adaptor.EclipseLog;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.core.runtime.internal.adaptor.ContextFinder;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.EclipseAppLauncher;
import org.eclipse.core.runtime.internal.adaptor.EclipseEnvironmentInfo;
import org.eclipse.core.runtime.internal.adaptor.Semaphore;
import org.eclipse.core.runtime.internal.stats.StatsManager;
import org.eclipse.osgi.framework.adaptor.FilePath;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.OSGi;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class EclipseStarter {
    private static FrameworkAdaptor adaptor;
    private static BundleContext context;
    private static boolean initialize;
    public static boolean debug;
    private static boolean running;
    private static OSGi osgi;
    private static final String CLEAN = "-clean";
    private static final String CONSOLE = "-console";
    private static final String CONSOLE_LOG = "-consoleLog";
    private static final String DEBUG = "-debug";
    private static final String INITIALIZE = "-initialize";
    private static final String DEV = "-dev";
    private static final String WS = "-ws";
    private static final String OS = "-os";
    private static final String ARCH = "-arch";
    private static final String NL = "-nl";
    private static final String CONFIGURATION = "-configuration";
    private static final String USER = "-user";
    private static final String NOEXIT = "-noExit";
    private static final String DATA = "-data";
    public static final String PROP_BUNDLES = "osgi.bundles";
    public static final String PROP_BUNDLES_STARTLEVEL = "osgi.bundles.defaultStartLevel";
    public static final String PROP_EXTENSIONS = "osgi.framework.extensions";
    public static final String PROP_INITIAL_STARTLEVEL = "osgi.startLevel";
    public static final String PROP_DEBUG = "osgi.debug";
    public static final String PROP_DEV = "osgi.dev";
    public static final String PROP_CLEAN = "osgi.clean";
    public static final String PROP_CONSOLE = "osgi.console";
    public static final String PROP_CONSOLE_CLASS = "osgi.consoleClass";
    public static final String PROP_CHECK_CONFIG = "osgi.checkConfiguration";
    public static final String PROP_OS = "osgi.os";
    public static final String PROP_WS = "osgi.ws";
    public static final String PROP_NL = "osgi.nl";
    public static final String PROP_ARCH = "osgi.arch";
    public static final String PROP_ADAPTOR = "osgi.adaptor";
    public static final String PROP_SYSPATH = "osgi.syspath";
    public static final String PROP_LOGFILE = "osgi.logfile";
    public static final String PROP_FRAMEWORK = "osgi.framework";
    public static final String PROP_INSTALL_AREA = "osgi.install.area";
    public static final String PROP_FRAMEWORK_SHAPE = "osgi.framework.shape";
    public static final String PROP_NOSHUTDOWN = "osgi.noShutdown";
    private static final String PROP_FORCED_RESTART = "osgi.forcedRestart";
    public static final String PROP_EXITCODE = "eclipse.exitcode";
    public static final String PROP_EXITDATA = "eclipse.exitdata";
    public static final String PROP_CONSOLE_LOG = "eclipse.consoleLog";
    private static final String PROP_VM = "eclipse.vm";
    private static final String PROP_VMARGS = "eclipse.vmargs";
    private static final String PROP_COMMANDS = "eclipse.commands";
    public static final String PROP_IGNOREAPP = "eclipse.ignoreApp";
    public static final String PROP_REFRESH_BUNDLES = "eclipse.refreshBundles";
    private static final String PROP_ALLOW_APPRELAUNCH = "eclipse.allowAppRelaunch";
    private static final String PROP_APPLICATION_NODEFAULT = "eclipse.application.noDefault";
    private static final String FILE_SCHEME = "file:";
    private static final String FILE_PROTOCOL = "file";
    private static final String REFERENCE_SCHEME = "reference:";
    private static final String REFERENCE_PROTOCOL = "reference";
    private static final String INITIAL_LOCATION = "initial@";
    protected static final String DEFAULT_ADAPTOR_CLASS = "org.eclipse.osgi.baseadaptor.BaseAdaptor";
    private static final int DEFAULT_INITIAL_STARTLEVEL = 6;
    private static final String DEFAULT_BUNDLES_STARTLEVEL = "4";
    protected static final String DEFAULT_CONSOLE_CLASS = "org.eclipse.osgi.framework.internal.core.FrameworkConsole";
    private static final String CONSOLE_NAME = "OSGi Console";
    private static FrameworkLog log;
    private static HashMap searchCandidates;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;

    static {
        initialize = false;
        debug = false;
        running = false;
        osgi = null;
        searchCandidates = new HashMap(4);
    }

    public static void main(String[] args) throws Exception {
        if (FrameworkProperties.getProperty("eclipse.startTime") == null) {
            FrameworkProperties.setProperty("eclipse.startTime", Long.toString(System.currentTimeMillis()));
        }
        if (FrameworkProperties.getProperty(PROP_NOSHUTDOWN) == null) {
            FrameworkProperties.setProperty(PROP_NOSHUTDOWN, "true");
        }
        EclipseStarter.run(args, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object run(String[] args, Runnable endSplashHandler) throws Exception {
        block38: {
            block37: {
                block34: {
                    block36: {
                        block33: {
                            if (Profile.STARTUP) {
                                Profile.logEnter("EclipseStarter.run()", null);
                            }
                            if (EclipseStarter.running) {
                                throw new IllegalStateException(EclipseAdaptorMsg.ECLIPSE_STARTUP_ALREADY_RUNNING);
                            }
                            startupFailed = true;
                            try {
                                try {
                                    EclipseStarter.startup(args, endSplashHandler);
                                    startupFailed = false;
                                    if (Boolean.valueOf(FrameworkProperties.getProperty("eclipse.ignoreApp")).booleanValue()) {
                                        var5_3 = null;
                                        break block33;
                                    }
                                    var7_15 = EclipseStarter.run(null);
                                    break block34;
                                }
                                catch (Throwable e) {
                                    if (endSplashHandler != null) {
                                        endSplashHandler.run();
                                    }
                                    logEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, startupFailed != false ? EclipseAdaptorMsg.ECLIPSE_STARTUP_STARTUP_ERROR : EclipseAdaptorMsg.ECLIPSE_STARTUP_APP_ERROR, 1, e, null);
                                    if (EclipseStarter.log != null) {
                                        EclipseStarter.log.log(logEntry);
                                        EclipseStarter.logUnresolvedBundles(EclipseStarter.context.getBundles());
                                    } else {
                                        e.printStackTrace();
                                    }
                                    ** GOTO lbl-1000
                                }
lbl28:
                                // 1 sources

                                return var7_15;
                            }
                            catch (Throwable var6_18) {
                                block35: {
                                    var5_5 = null;
                                    try {
                                        if (!Boolean.valueOf(FrameworkProperties.getProperty("osgi.noShutdown")).booleanValue()) {
                                            EclipseStarter.shutdown();
                                        }
                                    }
                                    catch (Throwable e) {
                                        logEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, EclipseAdaptorMsg.ECLIPSE_STARTUP_SHUTDOWN_ERROR, 1, e, null);
                                        if (EclipseStarter.log != null) {
                                            EclipseStarter.log.log(logEntry);
                                            break block35;
                                        }
                                        e.printStackTrace();
                                    }
                                }
                                if (Profile.STARTUP) {
                                    Profile.logExit("EclipseStarter.run()");
                                }
                                if ((report = Profile.getProfileLog()) == null || report.length() <= 0) throw var6_18;
                                System.out.println(report);
                                throw var6_18;
                            }
                        }
                        ** try [egrp 2[TRYBLOCK] [6 : 159->179)] { 
lbl51:
                        // 1 sources

                        if (!Boolean.valueOf(FrameworkProperties.getProperty("osgi.noShutdown")).booleanValue()) {
                            EclipseStarter.shutdown();
                        }
                        break block36;
lbl54:
                        // 1 sources

                        catch (Throwable e) {
                            logEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, EclipseAdaptorMsg.ECLIPSE_STARTUP_SHUTDOWN_ERROR, 1, e, null);
                            if (EclipseStarter.log != null) {
                                EclipseStarter.log.log(logEntry);
                                break block36;
                            }
                            e.printStackTrace();
                        }
                    }
                    if (Profile.STARTUP) {
                        Profile.logExit("EclipseStarter.run()");
                    }
                    if ((report = Profile.getProfileLog()) == null || report.length() <= 0) return null;
                    System.out.println(report);
                    return null;
                }
                var5_4 = null;
                ** try [egrp 2[TRYBLOCK] [6 : 159->179)] { 
lbl69:
                // 1 sources

                if (!Boolean.valueOf(FrameworkProperties.getProperty("osgi.noShutdown")).booleanValue()) {
                    EclipseStarter.shutdown();
                }
                break block37;
lbl72:
                // 1 sources

                catch (Throwable e) {
                    logEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, EclipseAdaptorMsg.ECLIPSE_STARTUP_SHUTDOWN_ERROR, 1, e, null);
                    if (EclipseStarter.log != null) {
                        EclipseStarter.log.log(logEntry);
                        break block37;
                    }
                    e.printStackTrace();
                }
            }
            if (Profile.STARTUP) {
                Profile.logExit("EclipseStarter.run()");
            }
            if ((report = Profile.getProfileLog()) == null || report.length() <= 0) ** GOTO lbl28
            System.out.println(report);
            return var7_15;
lbl-1000:
            // 2 sources

            {
                var5_6 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 159->179)] { 
lbl86:
            // 1 sources

            if (!Boolean.valueOf(FrameworkProperties.getProperty("osgi.noShutdown")).booleanValue()) {
                EclipseStarter.shutdown();
            }
            break block38;
lbl89:
            // 1 sources

            catch (Throwable e) {
                logEntry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, EclipseAdaptorMsg.ECLIPSE_STARTUP_SHUTDOWN_ERROR, 1, e, null);
                if (EclipseStarter.log != null) {
                    EclipseStarter.log.log(logEntry);
                }
                e.printStackTrace();
            }
        }
        if (Profile.STARTUP) {
            Profile.logExit("EclipseStarter.run()");
        }
        if ((report = Profile.getProfileLog()) != null && report.length() > 0) {
            System.out.println(report);
        }
        if (Boolean.valueOf(FrameworkProperties.getProperty("osgi.forcedRestart")).booleanValue()) {
            FrameworkProperties.setProperty("eclipse.exitcode", "23");
            return null;
        }
        FrameworkProperties.setProperty("eclipse.exitcode", "13");
        FrameworkProperties.setProperty("eclipse.exitdata", NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_ERROR_CHECK_LOG, EclipseStarter.log == null ? null : EclipseStarter.log.getFile().getPath()));
        return null;
    }

    public static boolean isRunning() {
        return running;
    }

    protected static FrameworkLog createFrameworkLog() {
        EclipseLog frameworkLog;
        String logFileProp = FrameworkProperties.getProperty(PROP_LOGFILE);
        if (logFileProp != null) {
            frameworkLog = new EclipseLog(new File(logFileProp));
        } else {
            Location location = LocationManager.getConfigurationLocation();
            File configAreaDirectory = null;
            if (location != null) {
                configAreaDirectory = new File(location.getURL().getFile());
            }
            if (configAreaDirectory != null) {
                String logFileName = String.valueOf(Long.toString(System.currentTimeMillis())) + ".log";
                File logFile = new File(configAreaDirectory, logFileName);
                FrameworkProperties.setProperty(PROP_LOGFILE, logFile.getAbsolutePath());
                frameworkLog = new EclipseLog(logFile);
            } else {
                frameworkLog = new EclipseLog();
            }
        }
        if ("true".equals(FrameworkProperties.getProperty(PROP_CONSOLE_LOG))) {
            frameworkLog.setConsoleLog(true);
        }
        return frameworkLog;
    }

    public static BundleContext startup(String[] args, Runnable endSplashHandler) throws Exception {
        String console;
        if (Profile.STARTUP) {
            Profile.logEnter("EclipseStarter.startup()", null);
        }
        if (running) {
            throw new IllegalStateException(EclipseAdaptorMsg.ECLIPSE_STARTUP_ALREADY_RUNNING);
        }
        EclipseStarter.initializeProperties();
        EclipseStarter.processCommandLine(args);
        LocationManager.initializeLocations();
        EclipseStarter.loadConfigurationInfo();
        EclipseStarter.finalizeProperties();
        Profile.initProps();
        if (Profile.STARTUP) {
            Profile.logTime("EclipseStarter.startup()", "props inited");
        }
        adaptor = EclipseStarter.createAdaptor();
        log = adaptor.getFrameworkLog();
        EclipseStarter.initializeContextFinder();
        if (Profile.STARTUP) {
            Profile.logTime("EclipseStarter.startup()", "adapter created");
        }
        osgi = new OSGi(adaptor);
        if (Profile.STARTUP) {
            Profile.logTime("EclipseStarter.startup()", "OSGi created");
        }
        osgi.launch();
        if (Profile.STARTUP) {
            Profile.logTime("EclipseStarter.startup()", "osgi launched");
        }
        if ((console = FrameworkProperties.getProperty(PROP_CONSOLE)) != null) {
            EclipseStarter.startConsole(osgi, new String[0], console);
            if (Profile.STARTUP) {
                Profile.logTime("EclipseStarter.startup()", "console started");
            }
        }
        context = osgi.getBundleContext();
        if ("true".equals(FrameworkProperties.getProperty(PROP_REFRESH_BUNDLES))) {
            EclipseStarter.refreshPackages(EclipseStarter.getCurrentBundles(false));
        }
        EclipseStarter.publishSplashScreen(endSplashHandler);
        if (Profile.STARTUP) {
            Profile.logTime("EclipseStarter.startup()", "loading basic bundles");
        }
        long stateStamp = adaptor.getState().getTimeStamp();
        Bundle[] startBundles = EclipseStarter.loadBasicBundles();
        EclipseStarter.setStartLevel(EclipseStarter.getStartLevel());
        if (Profile.STARTUP) {
            Profile.logTime("EclipseStarter.startup()", "StartLevel set");
        }
        EclipseStarter.ensureBundlesActive(startBundles);
        if ((debug || FrameworkProperties.getProperty(PROP_DEV) != null) && stateStamp != adaptor.getState().getTimeStamp()) {
            EclipseStarter.logUnresolvedBundles(context.getBundles());
        }
        running = true;
        if (Profile.STARTUP) {
            Profile.logExit("EclipseStarter.startup()");
        }
        return context;
    }

    private static void initializeContextFinder() {
        Thread current = Thread.currentThread();
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Thread");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method getContextClassLoader = clazz.getMethod("getContextClassLoader", null);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.Thread");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class[] classArray = new Class[1];
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.ClassLoader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz3;
            Method setContextClassLoader = clazz2.getMethod("setContextClassLoader", classArray);
            Object[] params = new Object[]{new ContextFinder((ClassLoader)getContextClassLoader.invoke((Object)current, null))};
            setContextClassLoader.invoke((Object)current, params);
            return;
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_CANNOT_SET_CONTEXTFINDER, null), 0, null, null);
        log.log(entry);
    }

    private static int getStartLevel() {
        block3: {
            String level = FrameworkProperties.getProperty(PROP_INITIAL_STARTLEVEL);
            if (level != null) {
                try {
                    return Integer.parseInt(level);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!debug) break block3;
                    System.out.println("Start level = " + level + "  parsed. Using hardcoded default: 6");
                }
            }
        }
        return 6;
    }

    public static Object run(Object argument) throws Exception {
        if (Profile.STARTUP) {
            Profile.logEnter("EclipseStarter.run(Object)()", null);
        }
        if (!running) {
            throw new IllegalStateException(EclipseAdaptorMsg.ECLIPSE_STARTUP_NOT_RUNNING);
        }
        if (initialize) {
            return new Integer(0);
        }
        EclipseAppLauncher launcher = new EclipseAppLauncher(context, Boolean.valueOf(FrameworkProperties.getProperty(PROP_ALLOW_APPRELAUNCH)), Boolean.valueOf(FrameworkProperties.getProperty(PROP_APPLICATION_NODEFAULT)) == false);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.osgi.service.runnable.ApplicationLauncher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.registerService(clazz.getName(), (Object)launcher, null);
        return launcher.start(argument);
    }

    public static void shutdown() throws Exception {
        if (!running || osgi == null) {
            return;
        }
        osgi.close();
        osgi = null;
        context = null;
        running = false;
    }

    /*
     * Exception decompiling
     */
    private static void ensureBundlesActive(Bundle[] bundles) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 222->226)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void logUnresolvedBundles(Bundle[] bundles) {
        State state = adaptor.getState();
        FrameworkLog logService = adaptor.getFrameworkLog();
        StateHelper stateHelper = adaptor.getPlatformAdmin().getStateHelper();
        VersionConstraint[] leafConstraints = stateHelper.getUnsatisfiedLeaves(state.getBundles());
        HashMap<BundleDescription, ArrayList<VersionConstraint>> missing = new HashMap<BundleDescription, ArrayList<VersionConstraint>>();
        int i = 0;
        while (i < leafConstraints.length) {
            if (!(leafConstraints[i] instanceof BundleSpecification && ((BundleSpecification)leafConstraints[i]).isOptional() || leafConstraints[i] instanceof ImportPackageSpecification && ("optional".equals(((ImportPackageSpecification)leafConstraints[i]).getDirective("resolution")) || "dynamic".equals(((ImportPackageSpecification)leafConstraints[i]).getDirective("resolution"))))) {
                BundleDescription bundle = leafConstraints[i].getBundle();
                ArrayList<VersionConstraint> constraints = (ArrayList<VersionConstraint>)missing.get(bundle);
                if (constraints == null) {
                    constraints = new ArrayList<VersionConstraint>();
                    missing.put(bundle, constraints);
                }
                constraints.add(leafConstraints[i]);
            }
            ++i;
        }
        if (missing.size() > 0) {
            FrameworkLogEntry[] rootChildren = new FrameworkLogEntry[missing.size()];
            int rootIndex = 0;
            Iterator iter = missing.keySet().iterator();
            while (iter.hasNext()) {
                BundleDescription description = (BundleDescription)iter.next();
                String symbolicName = description.getSymbolicName() == null ? "org.eclipse.osgi" : description.getSymbolicName();
                String generalMessage = NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_ERROR_BUNDLE_NOT_RESOLVED, description.getLocation());
                ArrayList constraints = (ArrayList)missing.get(description);
                FrameworkLogEntry[] logChildren = new FrameworkLogEntry[constraints.size()];
                int i2 = 0;
                while (i2 < logChildren.length) {
                    logChildren[i2] = new FrameworkLogEntry(symbolicName, 2, 0, EclipseAdaptorMsg.getResolutionFailureMessage((VersionConstraint)constraints.get(i2)), 0, null, null);
                    ++i2;
                }
                rootChildren[rootIndex] = new FrameworkLogEntry("org.eclipse.osgi", 2, 0, generalMessage, 0, null, logChildren);
                ++rootIndex;
            }
            logService.log(new FrameworkLogEntry("org.eclipse.osgi", 2, 0, EclipseAdaptorMsg.ECLIPSE_STARTUP_ROOTS_NOT_RESOLVED, 0, null, rootChildren));
        }
        ArrayList<FrameworkLogEntry> allChildren = new ArrayList<FrameworkLogEntry>();
        int i3 = 0;
        while (i3 < bundles.length) {
            if (bundles[i3].getState() == 2) {
                String symbolicName = bundles[i3].getSymbolicName() == null ? "org.eclipse.osgi" : bundles[i3].getSymbolicName();
                String generalMessage = NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_ERROR_BUNDLE_NOT_RESOLVED, bundles[i3]);
                BundleDescription description = state.getBundle(bundles[i3].getBundleId());
                if (description != null) {
                    FrameworkLogEntry[] logChildren = null;
                    VersionConstraint[] unsatisfied = stateHelper.getUnsatisfiedConstraints(description);
                    if (unsatisfied.length > 0) {
                        logChildren = new FrameworkLogEntry[unsatisfied.length];
                        int j = 0;
                        while (j < unsatisfied.length) {
                            logChildren[j] = new FrameworkLogEntry(symbolicName, 2, 0, EclipseAdaptorMsg.getResolutionFailureMessage(unsatisfied[j]), 0, null, null);
                            ++j;
                        }
                    } else {
                        ResolverError[] resolverErrors = state.getResolverErrors(description);
                        if (resolverErrors.length > 0) {
                            logChildren = new FrameworkLogEntry[resolverErrors.length];
                            int j = 0;
                            while (j < resolverErrors.length) {
                                logChildren[j] = new FrameworkLogEntry(symbolicName, 2, 0, resolverErrors[j].toString(), 0, null, null);
                                ++j;
                            }
                        }
                    }
                    allChildren.add(new FrameworkLogEntry("org.eclipse.osgi", 2, 0, generalMessage, 0, null, logChildren));
                }
            }
            ++i3;
        }
        if (allChildren.size() > 0) {
            logService.log(new FrameworkLogEntry("org.eclipse.osgi", 2, 0, EclipseAdaptorMsg.ECLIPSE_STARTUP_ALL_NOT_RESOLVED, 0, null, allChildren.toArray(new FrameworkLogEntry[allChildren.size()])));
        }
    }

    private static void publishSplashScreen(final Runnable endSplashHandler) {
        block9: {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("name", "splashscreen");
            Runnable handler = new Runnable(){

                public void run() {
                    if (debug) {
                        String timeString = FrameworkProperties.getProperty("eclipse.startTime");
                        long time = timeString == null ? 0L : Long.parseLong(timeString);
                        System.out.println("Application Started: " + (System.currentTimeMillis() - time));
                    }
                    StatsManager.doneBooting();
                    endSplashHandler.run();
                }
            };
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("java.lang.Runnable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            context.registerService(clazz.getName(), (Object)handler, properties);
            try {
                Method method = endSplashHandler.getClass().getMethod("getOutputStream", new Class[0]);
                Object outputStream = method.invoke((Object)endSplashHandler, new Object[0]);
                if (!(outputStream instanceof OutputStream)) break block9;
                Hashtable<String, String> osProperties = new Hashtable<String, String>();
                ((Dictionary)osProperties).put("name", "splashstream");
                Class<?> clazz2 = class$5;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$5 = Class.forName("java.io.OutputStream");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                context.registerService(clazz2.getName(), outputStream, osProperties);
            }
            catch (Exception exception) {}
        }
    }

    private static URL searchForBundle(String name, String parent) throws MalformedURLException {
        Object result;
        URL url = null;
        File fileLocation = null;
        boolean reference = false;
        try {
            new URL(name);
            url = new URL(new File(parent).toURL(), name);
        }
        catch (MalformedURLException malformedURLException) {
            File child = new File(name);
            fileLocation = child.isAbsolute() ? child : new File(parent, name);
            url = new URL(REFERENCE_PROTOCOL, null, fileLocation.toURL().toExternalForm());
            reference = true;
        }
        if (!reference) {
            URL baseURL = url;
            if (url.getProtocol().equals(REFERENCE_PROTOCOL)) {
                File child;
                reference = true;
                String baseSpec = url.getFile();
                baseURL = baseSpec.startsWith(FILE_SCHEME) ? ((child = new File(baseSpec.substring(5))).isAbsolute() ? child.toURL() : new File(parent, child.getPath()).toURL()) : new URL(baseSpec);
            }
            if (!(fileLocation = new File(baseURL.getFile())).isAbsolute()) {
                fileLocation = new File(parent, fileLocation.toString());
            }
        }
        if (reference) {
            result = EclipseStarter.searchFor(fileLocation.getName(), new File(fileLocation.getParent()).getAbsolutePath());
            if (result != null) {
                url = new URL(REFERENCE_PROTOCOL, null, FILE_SCHEME + (String)result);
            } else {
                return null;
            }
        }
        try {
            result = url.openConnection();
            ((URLConnection)result).connect();
            return url;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static Bundle[] loadBasicBundles() throws IOException {
        long startTime = System.currentTimeMillis();
        String osgiBundles = FrameworkProperties.getProperty(PROP_BUNDLES);
        String osgiExtensions = FrameworkProperties.getProperty(PROP_EXTENSIONS);
        if (osgiExtensions != null && osgiExtensions.length() > 0) {
            osgiBundles = String.valueOf(osgiExtensions) + ',' + osgiBundles;
            FrameworkProperties.setProperty(PROP_BUNDLES, osgiBundles);
        }
        String[] installEntries = EclipseStarter.getArrayFromList(osgiBundles, ",");
        InitialBundle[] initialBundles = EclipseStarter.getInitialBundles(installEntries);
        Bundle[] curInitBundles = EclipseStarter.getCurrentBundles(true);
        ArrayList toRefresh = new ArrayList(curInitBundles.length);
        EclipseStarter.uninstallBundles(curInitBundles, initialBundles, toRefresh);
        ArrayList startBundles = new ArrayList(installEntries.length);
        EclipseStarter.installBundles(initialBundles, curInitBundles, startBundles, toRefresh);
        if (!toRefresh.isEmpty()) {
            EclipseStarter.refreshPackages(toRefresh.toArray(new Bundle[toRefresh.size()]));
        }
        Bundle[] startInitBundles = startBundles.toArray(new Bundle[startBundles.size()]);
        EclipseStarter.startBundles(startInitBundles);
        if (debug) {
            System.out.println("Time to load bundles: " + (System.currentTimeMillis() - startTime));
        }
        return startInitBundles;
    }

    private static InitialBundle[] getInitialBundles(String[] installEntries) throws MalformedURLException {
        searchCandidates.clear();
        ArrayList<InitialBundle> result = new ArrayList<InitialBundle>(installEntries.length);
        int defaultStartLevel = Integer.parseInt(FrameworkProperties.getProperty(PROP_BUNDLES_STARTLEVEL, DEFAULT_BUNDLES_STARTLEVEL));
        String syspath = EclipseStarter.getSysPath();
        int i = 0;
        while (i < installEntries.length) {
            URL location;
            String name = installEntries[i];
            int level = defaultStartLevel;
            boolean start = false;
            int index = name.indexOf(64);
            if (index >= 0) {
                String[] attributes = EclipseStarter.getArrayFromList(name.substring(index + 1, name.length()), ":");
                name = name.substring(0, index);
                int j = 0;
                while (j < attributes.length) {
                    String attribute = attributes[j];
                    if (attribute.equals("start")) {
                        start = true;
                    } else {
                        level = Integer.parseInt(attribute);
                    }
                    ++j;
                }
            }
            if ((location = EclipseStarter.searchForBundle(name, syspath)) == null) {
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_BUNDLE_NOT_FOUND, installEntries[i]), 0, null, null);
                log.log(entry);
            } else {
                location = EclipseStarter.makeRelative(LocationManager.getInstallLocation().getURL(), location);
                String locationString = INITIAL_LOCATION + location.toExternalForm();
                result.add(new InitialBundle(locationString, location, level, start));
            }
            ++i;
        }
        return result.toArray(new InitialBundle[result.size()]);
    }

    private static void refreshPackages(Bundle[] bundles) {
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference packageAdminRef = context.getServiceReference(clazz.getName());
        PackageAdmin packageAdmin = null;
        if (packageAdminRef != null && (packageAdmin = (PackageAdmin)context.getService(packageAdminRef)) == null) {
            return;
        }
        final Semaphore semaphore = new Semaphore(0);
        FrameworkListener listener = new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 4) {
                    semaphore.release();
                }
            }
        };
        context.addFrameworkListener(listener);
        packageAdmin.refreshPackages(bundles);
        semaphore.acquire();
        context.removeFrameworkListener(listener);
        context.ungetService(packageAdminRef);
        if (Boolean.valueOf(FrameworkProperties.getProperty(PROP_FORCED_RESTART)).booleanValue()) {
            Bundle systemBundle = context.getBundle(0L);
            for (int i = 0; i < 5000 && (systemBundle.getState() & 0x30) != 0; i += 200) {
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }

    private static void startConsole(OSGi osgi, String[] consoleArgs, String consolePort) {
        try {
            Object[] parameters;
            Class[] parameterTypes;
            String consoleClassName = FrameworkProperties.getProperty(PROP_CONSOLE_CLASS, DEFAULT_CONSOLE_CLASS);
            Class<?> consoleClass = Class.forName(consoleClassName);
            if (consolePort.length() == 0) {
                Class[] classArray = new Class[2];
                Class<?> clazz = class$7;
                if (clazz == null) {
                    try {
                        clazz = class$7 = Class.forName("org.eclipse.osgi.framework.internal.core.OSGi");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class<?> clazz2 = class$8;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$8 = Class.forName("[Ljava.lang.String;");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz2;
                parameterTypes = classArray;
                parameters = new Object[]{osgi, consoleArgs};
            } else {
                Class[] classArray = new Class[3];
                Class<?> clazz = class$7;
                if (clazz == null) {
                    try {
                        clazz = class$7 = Class.forName("org.eclipse.osgi.framework.internal.core.OSGi");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                classArray[1] = Integer.TYPE;
                Class<?> clazz3 = class$8;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$8 = Class.forName("[Ljava.lang.String;");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[2] = clazz3;
                parameterTypes = classArray;
                parameters = new Object[]{osgi, new Integer(consolePort), consoleArgs};
            }
            Constructor<?> constructor = consoleClass.getConstructor(parameterTypes);
            Object console = constructor.newInstance(parameters);
            Thread t = new Thread((Runnable)console, CONSOLE_NAME);
            t.start();
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_INVALID_PORT, consolePort));
        }
        catch (Exception exception) {
            System.out.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FAILED_FIND, CONSOLE_NAME));
        }
    }

    private static FrameworkAdaptor createAdaptor() throws Exception {
        String adaptorClassName = FrameworkProperties.getProperty(PROP_ADAPTOR, DEFAULT_ADAPTOR_CLASS);
        Class<?> adaptorClass = Class.forName(adaptorClassName);
        Class[] classArray = new Class[1];
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] constructorArgs = classArray;
        Constructor<?> constructor = adaptorClass.getConstructor(constructorArgs);
        return (FrameworkAdaptor)constructor.newInstance(new Object[]{new String[0]});
    }

    private static String[] processCommandLine(String[] args) throws Exception {
        EclipseEnvironmentInfo.setAllArgs(args);
        if (args.length == 0) {
            EclipseEnvironmentInfo.setFrameworkArgs(args);
            EclipseEnvironmentInfo.setAllArgs(args);
            return args;
        }
        int[] configArgs = new int[args.length];
        configArgs[0] = -1;
        int configArgIndex = 0;
        int i = 0;
        while (i < args.length) {
            boolean found = false;
            if (args[i].equalsIgnoreCase(DEBUG) && (i + 1 == args.length || i + 1 < args.length && args[i + 1].startsWith("-"))) {
                FrameworkProperties.setProperty(PROP_DEBUG, "");
                debug = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(DEV) && (i + 1 == args.length || i + 1 < args.length && args[i + 1].startsWith("-"))) {
                FrameworkProperties.setProperty(PROP_DEV, "");
                found = true;
            }
            if (args[i].equalsIgnoreCase(INITIALIZE)) {
                initialize = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(CLEAN)) {
                FrameworkProperties.setProperty(PROP_CLEAN, "true");
                found = true;
            }
            if (args[i].equalsIgnoreCase(CONSOLE_LOG)) {
                FrameworkProperties.setProperty(PROP_CONSOLE_LOG, "true");
                found = true;
            }
            if (args[i].equalsIgnoreCase(CONSOLE) && (i + 1 == args.length || i + 1 < args.length && args[i + 1].startsWith("-"))) {
                FrameworkProperties.setProperty(PROP_CONSOLE, "");
                found = true;
            }
            if (args[i].equalsIgnoreCase(NOEXIT)) {
                FrameworkProperties.setProperty(PROP_NOSHUTDOWN, "true");
                found = true;
            }
            if (found) {
                configArgs[configArgIndex++] = i;
            } else if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase(CONSOLE)) {
                    FrameworkProperties.setProperty(PROP_CONSOLE, arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(CONFIGURATION)) {
                    FrameworkProperties.setProperty("osgi.configuration.area", arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(DATA)) {
                    FrameworkProperties.setProperty("osgi.instance.area", arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(USER)) {
                    FrameworkProperties.setProperty("osgi.user.area", arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(DEV)) {
                    FrameworkProperties.setProperty(PROP_DEV, arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(DEBUG)) {
                    FrameworkProperties.setProperty(PROP_DEBUG, arg);
                    debug = true;
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(WS)) {
                    FrameworkProperties.setProperty(PROP_WS, arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(OS)) {
                    FrameworkProperties.setProperty(PROP_OS, arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(ARCH)) {
                    FrameworkProperties.setProperty(PROP_ARCH, arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(NL)) {
                    FrameworkProperties.setProperty(PROP_NL, arg);
                    found = true;
                }
                if (found) {
                    configArgs[configArgIndex++] = i - 1;
                    configArgs[configArgIndex++] = i;
                }
            }
            ++i;
        }
        if (configArgIndex == 0) {
            EclipseEnvironmentInfo.setFrameworkArgs(new String[0]);
            EclipseEnvironmentInfo.setAppArgs(args);
            return args;
        }
        String[] appArgs = new String[args.length - configArgIndex];
        String[] frameworkArgs = new String[configArgIndex];
        configArgIndex = 0;
        int j = 0;
        int k = 0;
        int i2 = 0;
        while (i2 < args.length) {
            if (i2 == configArgs[configArgIndex]) {
                frameworkArgs[k++] = args[i2];
                ++configArgIndex;
            } else {
                appArgs[j++] = args[i2];
            }
            ++i2;
        }
        EclipseEnvironmentInfo.setFrameworkArgs(frameworkArgs);
        EclipseEnvironmentInfo.setAppArgs(appArgs);
        return appArgs;
    }

    private static String[] getArrayFromList(String prop, String separator) {
        return ManifestElement.getArrayFromList(prop, separator);
    }

    protected static String getSysPath() {
        String result = FrameworkProperties.getProperty(PROP_SYSPATH);
        if (result != null) {
            return result;
        }
        result = EclipseStarter.getSysPathFromURL(FrameworkProperties.getProperty(PROP_FRAMEWORK));
        if (result == null) {
            result = EclipseStarter.getSysPathFromCodeSource();
        }
        if (result == null) {
            throw new IllegalStateException("Can not find the system path.");
        }
        if (Character.isUpperCase(result.charAt(0))) {
            char[] chars = result.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            result = new String(chars);
        }
        FrameworkProperties.setProperty(PROP_SYSPATH, result);
        return result;
    }

    private static String getSysPathFromURL(String urlSpec) {
        if (urlSpec == null) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(urlSpec);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        File fwkFile = new File(url.getFile());
        fwkFile = new File(fwkFile.getAbsolutePath());
        fwkFile = new File(fwkFile.getParent());
        return fwkFile.getAbsolutePath();
    }

    private static String getSysPathFromCodeSource() {
        ProtectionDomain pd;
        Class<?> clazz = class$10;
        if (clazz == null) {
            try {
                clazz = class$10 = Class.forName("org.eclipse.core.runtime.adaptor.EclipseStarter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((pd = clazz.getProtectionDomain()) == null) {
            return null;
        }
        CodeSource cs = pd.getCodeSource();
        if (cs == null) {
            return null;
        }
        URL url = cs.getLocation();
        if (url == null) {
            return null;
        }
        String result = url.getFile();
        if (result.endsWith(".jar")) {
            result = result.substring(0, result.lastIndexOf(47));
            if ("folder".equals(FrameworkProperties.getProperty(PROP_FRAMEWORK_SHAPE))) {
                result = result.substring(0, result.lastIndexOf(47));
            }
        } else {
            if (result.endsWith("/")) {
                result = result.substring(0, result.length() - 1);
            }
            result = result.substring(0, result.lastIndexOf(47));
            result = result.substring(0, result.lastIndexOf(47));
        }
        return result;
    }

    private static Bundle[] getCurrentBundles(boolean includeInitial) {
        Bundle[] installed = context.getBundles();
        ArrayList<Bundle> initial = new ArrayList<Bundle>();
        int i = 0;
        while (i < installed.length) {
            Bundle bundle = installed[i];
            if (bundle.getLocation().startsWith(INITIAL_LOCATION)) {
                if (includeInitial) {
                    initial.add(bundle);
                }
            } else if (!includeInitial && bundle.getBundleId() != 0L) {
                initial.add(bundle);
            }
            ++i;
        }
        return initial.toArray(new Bundle[initial.size()]);
    }

    private static Bundle getBundleByLocation(String location, Bundle[] bundles) {
        int i = 0;
        while (i < bundles.length) {
            Bundle bundle = bundles[i];
            if (location.equalsIgnoreCase(bundle.getLocation())) {
                return bundle;
            }
            ++i;
        }
        return null;
    }

    private static void uninstallBundles(Bundle[] curInitBundles, InitialBundle[] newInitBundles, List toRefresh) {
        int i = 0;
        while (i < curInitBundles.length) {
            boolean found = false;
            int j = 0;
            while (j < newInitBundles.length) {
                if (curInitBundles[i].getLocation().equalsIgnoreCase(newInitBundles[j].locationString)) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                try {
                    curInitBundles[i].uninstall();
                    toRefresh.add(curInitBundles[i]);
                }
                catch (BundleException e) {
                    FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FAILED_UNINSTALL, curInitBundles[i].getLocation()), 0, e, null);
                    log.log(entry);
                }
            }
            ++i;
        }
    }

    private static void installBundles(InitialBundle[] initialBundles, Bundle[] curInitBundles, ArrayList startBundles, List toRefresh) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.osgi.service.startlevel.StartLevel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceReference reference = context.getServiceReference(clazz.getName());
        StartLevel startService = null;
        if (reference != null) {
            startService = (StartLevel)context.getService(reference);
        }
        int i = 0;
        while (i < initialBundles.length) {
            FrameworkLogEntry entry;
            Bundle osgiBundle = EclipseStarter.getBundleByLocation(initialBundles[i].locationString, curInitBundles);
            try {
                if (osgiBundle == null) {
                    InputStream in = initialBundles[i].location.openStream();
                    osgiBundle = context.installBundle(initialBundles[i].locationString, in);
                }
                if ((osgiBundle.getState() & 1) == 0 && initialBundles[i].level >= 0 && startService != null) {
                    startService.setBundleStartLevel(osgiBundle, initialBundles[i].level);
                }
                if (initialBundles[i].start) {
                    startBundles.add(osgiBundle);
                }
                if ((osgiBundle.getState() & 2) != 0) {
                    toRefresh.add(osgiBundle);
                }
            }
            catch (BundleException e) {
                entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FAILED_INSTALL, initialBundles[i].location), 0, e, null);
                log.log(entry);
            }
            catch (IOException e) {
                entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FAILED_INSTALL, initialBundles[i].location), 0, e, null);
                log.log(entry);
            }
            ++i;
        }
        context.ungetService(reference);
    }

    private static void startBundles(Bundle[] bundles) {
        int i = 0;
        while (i < bundles.length) {
            block3: {
                Bundle bundle = bundles[i];
                try {
                    bundle.start();
                }
                catch (BundleException e) {
                    if ((bundle.getState() & 4) == 0) break block3;
                    FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_FAILED_START, bundle.getLocation()), 0, e, null);
                    log.log(entry);
                }
            }
            ++i;
        }
    }

    private static void loadConfigurationInfo() {
        Location configArea = LocationManager.getConfigurationLocation();
        if (configArea == null) {
            return;
        }
        URL location = null;
        try {
            location = new URL(String.valueOf(configArea.getURL().toExternalForm()) + "config.ini");
        }
        catch (MalformedURLException malformedURLException) {}
        EclipseStarter.mergeProperties(FrameworkProperties.getProperties(), EclipseStarter.loadProperties(location));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadProperties(URL location) {
        Properties result = new Properties();
        if (location == null) {
            return result;
        }
        try {
            InputStream in = location.openStream();
            try {
                result.load(in);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                in.close();
                throw throwable;
            }
            {
                Object var3_5 = null;
                in.close();
                return result;
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    private static URL makeRelative(URL base, URL location) throws MalformedURLException {
        if (base == null) {
            return location;
        }
        if (!FILE_PROTOCOL.equals(base.getProtocol())) {
            return location;
        }
        boolean reference = location.getProtocol().equals(REFERENCE_PROTOCOL);
        URL nonReferenceLocation = location;
        if (reference) {
            nonReferenceLocation = new URL(location.getPath());
        }
        if (!base.getProtocol().equals(nonReferenceLocation.getProtocol())) {
            return location;
        }
        File locationPath = new File(nonReferenceLocation.getPath());
        if (!locationPath.isAbsolute()) {
            return location;
        }
        File relativePath = EclipseStarter.makeRelative(new File(base.getPath()), locationPath);
        String urlPath = relativePath.getPath();
        if (File.separatorChar != '/') {
            urlPath = urlPath.replace(File.separatorChar, '/');
        }
        if (nonReferenceLocation.getPath().endsWith("/")) {
            urlPath = String.valueOf(urlPath) + '/';
        }
        URL relativeURL = new URL(base.getProtocol(), base.getHost(), base.getPort(), urlPath);
        if (reference) {
            relativeURL = new URL(REFERENCE_SCHEME + relativeURL.toExternalForm());
        }
        return relativeURL;
    }

    private static File makeRelative(File base, File location) {
        if (!location.isAbsolute()) {
            return location;
        }
        File relative = new File(new FilePath(base).makeRelative(new FilePath(location)));
        return relative;
    }

    private static void mergeProperties(Properties destination, Properties source) {
        Enumeration<Object> e = source.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = source.getProperty(key);
            if (destination.getProperty(key) != null) continue;
            destination.put(key, value);
        }
    }

    private static void setStartLevel(final int value) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.osgi.service.startlevel.StartLevel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceTracker tracker = new ServiceTracker(context, clazz.getName(), null);
        tracker.open();
        final StartLevel startLevel = (StartLevel)tracker.getService();
        final Semaphore semaphore = new Semaphore(0);
        FrameworkListener listener = new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 8 && startLevel.getStartLevel() == value) {
                    semaphore.release();
                }
            }
        };
        context.addFrameworkListener(listener);
        startLevel.setStartLevel(value);
        semaphore.acquire();
        context.removeFrameworkListener(listener);
        tracker.close();
    }

    private static String searchFor(String target, String start) {
        String[] candidates = (String[])searchCandidates.get(start);
        if (candidates == null && (candidates = new File(start).list()) != null) {
            searchCandidates.put(start, candidates);
        }
        if (candidates == null) {
            return null;
        }
        String result = null;
        Object[] maxVersion = null;
        int i = 0;
        while (i < candidates.length) {
            String name = candidates[i];
            if (name.equals(target) || name.startsWith(String.valueOf(target) + "_")) {
                String version = "";
                int index = name.indexOf(95);
                if (index != -1) {
                    version = name.substring(index + 1);
                }
                Object[] currentVersion = EclipseStarter.getVersionElements(version);
                File candidate = new File(start, candidates[i]);
                if (maxVersion == null) {
                    result = candidate.getAbsolutePath();
                    maxVersion = currentVersion;
                } else if (EclipseStarter.compareVersion(maxVersion, currentVersion) < 0) {
                    result = candidate.getAbsolutePath();
                    maxVersion = currentVersion;
                }
            }
            ++i;
        }
        if (result == null) {
            return null;
        }
        return String.valueOf(result.replace(File.separatorChar, '/')) + "/";
    }

    private static Object[] getVersionElements(String version) {
        Object[] result = new Object[]{new Integer(0), new Integer(0), new Integer(0), ""};
        StringTokenizer t = new StringTokenizer(version, ".");
        int i = 0;
        while (t.hasMoreTokens() && i < 4) {
            String token = t.nextToken();
            if (i < 3) {
                try {
                    result[i++] = new Integer(token);
                    continue;
                }
                catch (Exception exception) {
                    break;
                }
            }
            result[i++] = token;
        }
        return result;
    }

    private static int compareVersion(Object[] left, Object[] right) {
        int result = ((Integer)left[0]).compareTo((Integer)right[0]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[1]).compareTo((Integer)right[1]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[2]).compareTo((Integer)right[2]);
        if (result != 0) {
            return result;
        }
        return ((String)left[3]).compareTo((String)right[3]);
    }

    private static String buildCommandLine(String arg, String value) {
        String commandLine;
        int i;
        StringBuffer result = new StringBuffer(300);
        String entry = FrameworkProperties.getProperty(PROP_VM);
        if (entry == null) {
            return null;
        }
        result.append(entry);
        result.append('\n');
        entry = FrameworkProperties.getProperty(PROP_VMARGS);
        if (entry != null) {
            result.append(entry);
        }
        if ((entry = FrameworkProperties.getProperty(PROP_COMMANDS)) != null) {
            result.append(entry);
        }
        if ((i = (commandLine = result.toString()).indexOf(String.valueOf(arg) + "\n")) == 0) {
            commandLine = String.valueOf(commandLine) + arg + "\n" + value + "\n";
        } else {
            String left = commandLine.substring(0, i += arg.length() + 1);
            int j = commandLine.indexOf(10, i);
            String right = commandLine.substring(j);
            commandLine = String.valueOf(left) + value + right;
        }
        return commandLine;
    }

    private static void initializeProperties() {
        if (FrameworkProperties.getProperty(PROP_FRAMEWORK) == null || FrameworkProperties.getProperty(PROP_INSTALL_AREA) == null) {
            CodeSource cs;
            Class<?> clazz = class$10;
            if (clazz == null) {
                try {
                    clazz = class$10 = Class.forName("org.eclipse.core.runtime.adaptor.EclipseStarter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((cs = clazz.getProtectionDomain().getCodeSource()) == null) {
                throw new IllegalArgumentException(NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_PROPS_NOT_SET, "osgi.framework, osgi.install.area"));
            }
            URL url = cs.getLocation();
            if (FrameworkProperties.getProperty(PROP_FRAMEWORK) == null) {
                FrameworkProperties.setProperty(PROP_FRAMEWORK, url.toExternalForm());
            }
            if (FrameworkProperties.getProperty(PROP_INSTALL_AREA) == null) {
                String filePart = url.getFile();
                FrameworkProperties.setProperty(PROP_INSTALL_AREA, filePart.substring(0, filePart.lastIndexOf(47)));
            }
        }
        FrameworkProperties.setProperty(PROP_FRAMEWORK, EclipseStarter.decode(FrameworkProperties.getProperty(PROP_FRAMEWORK)));
        FrameworkProperties.setProperty(PROP_INSTALL_AREA, EclipseStarter.decode(FrameworkProperties.getProperty(PROP_INSTALL_AREA)));
    }

    private static void finalizeProperties() {
        if (FrameworkProperties.getProperty(PROP_DEV) != null && FrameworkProperties.getProperty(PROP_CHECK_CONFIG) == null) {
            FrameworkProperties.setProperty(PROP_CHECK_CONFIG, "true");
        }
    }

    private static String decode(String urlString) {
        try {
            Object result;
            Class<?> clazz = class$11;
            if (clazz == null) {
                try {
                    clazz = class$11 = Class.forName("java.net.URLDecoder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            Class[] classArray = new Class[2];
            Class<?> clazz3 = class$12;
            if (clazz3 == null) {
                try {
                    clazz3 = class$12 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz3;
            Class<?> clazz4 = class$12;
            if (clazz4 == null) {
                try {
                    clazz4 = class$12 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz4;
            Method method = clazz2.getDeclaredMethod("decode", classArray);
            if (urlString.indexOf(43) >= 0) {
                int len = urlString.length();
                StringBuffer buf = new StringBuffer(len);
                int i = 0;
                while (i < len) {
                    char c = urlString.charAt(i);
                    if (c == '+') {
                        buf.append("%2B");
                    } else {
                        buf.append(c);
                    }
                    ++i;
                }
                urlString = buf.toString();
            }
            if ((result = method.invoke(null, urlString, "UTF-8")) != null) {
                return (String)result;
            }
        }
        catch (Exception exception) {}
        boolean replaced = false;
        byte[] encodedBytes = urlString.getBytes();
        int encodedLength = encodedBytes.length;
        byte[] decodedBytes = new byte[encodedLength];
        int decodedLength = 0;
        int i = 0;
        while (i < encodedLength) {
            byte b = encodedBytes[i];
            if (b == 37) {
                byte enc1 = encodedBytes[++i];
                byte enc2 = encodedBytes[++i];
                b = (byte)((EclipseStarter.hexToByte(enc1) << 4) + EclipseStarter.hexToByte(enc2));
                replaced = true;
            }
            decodedBytes[decodedLength++] = b;
            ++i;
        }
        if (!replaced) {
            return urlString;
        }
        try {
            return new String(decodedBytes, 0, decodedLength, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(decodedBytes, 0, decodedLength);
        }
    }

    private static int hexToByte(byte b) {
        switch (b) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
        }
        throw new IllegalArgumentException("Switch error decoding URL");
    }

    public static void setInitialProperties(Map initialProperties) {
        if (initialProperties == null || initialProperties.isEmpty()) {
            return;
        }
        Iterator it = initialProperties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getValue() != null) {
                FrameworkProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            FrameworkProperties.clearProperty((String)entry.getKey());
        }
    }

    private static class InitialBundle {
        public final String locationString;
        public final URL location;
        public final int level;
        public final boolean start;

        InitialBundle(String locationString, URL location, int level, boolean start) {
            this.locationString = locationString;
            this.location = location;
            this.level = level;
            this.start = start;
        }
    }
}

