/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.GenericCapability;
import org.eclipse.osgi.internal.module.GenericConstraint;
import org.eclipse.osgi.internal.module.ResolverConstraint;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImpl;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.service.resolver.VersionRange;

public class ResolverBundle
extends VersionSupplier {
    public static final int UNRESOLVED = 0;
    public static final int RESOLVING = 1;
    public static final int RESOLVED = 2;
    private Long bundleID;
    private BundleConstraint host;
    private ResolverImport[] imports;
    private ResolverExport[] exports;
    private BundleConstraint[] requires;
    private GenericCapability[] capabilities;
    private GenericConstraint[] genericReqiures;
    private ArrayList fragments;
    private HashMap fragmentExports;
    private HashMap fragmentImports;
    private HashMap fragmentRequires;
    private HashMap fragmentGenericRequires;
    private boolean resolvable = true;
    private int state = 0;
    private ResolverImpl resolver;
    private boolean newFragmentExports;
    private ArrayList refs;

    ResolverBundle(BundleDescription bundle, ResolverImpl resolver) {
        super(bundle);
        this.bundleID = new Long(bundle.getBundleId());
        this.resolver = resolver;
        this.initialize(bundle.isResolved());
    }

    void initialize(boolean useSelectedExports) {
        if (this.getBundle().isSingleton()) {
            this.refs = new ArrayList();
        }
        GenericDescription[] actualCapabilities = this.getBundle().getGenericCapabilities();
        this.capabilities = new GenericCapability[actualCapabilities.length];
        int i = 0;
        while (i < this.capabilities.length) {
            this.capabilities[i] = new GenericCapability(this, actualCapabilities[i]);
            ++i;
        }
        if (this.getBundle().getHost() != null) {
            this.host = new BundleConstraint(this, this.getBundle().getHost());
            this.exports = new ResolverExport[0];
            this.imports = new ResolverImport[0];
            this.requires = new BundleConstraint[0];
            this.genericReqiures = new GenericConstraint[0];
            return;
        }
        ImportPackageSpecification[] actualImports = this.getBundle().getImportPackages();
        ArrayList<ResolverImport> importList = new ArrayList<ResolverImport>(actualImports.length);
        int i2 = actualImports.length - 1;
        while (i2 >= 0) {
            if ("optional".equals(actualImports[i2].getDirective("resolution"))) {
                importList.add(new ResolverImport(this, actualImports[i2]));
            } else {
                importList.add(0, new ResolverImport(this, actualImports[i2]));
            }
            --i2;
        }
        this.imports = importList.toArray(new ResolverImport[importList.size()]);
        ExportPackageDescription[] actualExports = useSelectedExports ? this.getBundle().getSelectedExports() : this.getBundle().getExportPackages();
        this.exports = new ResolverExport[actualExports.length];
        int i3 = 0;
        while (i3 < actualExports.length) {
            this.exports[i3] = new ResolverExport(this, actualExports[i3]);
            ++i3;
        }
        BundleSpecification[] actualRequires = this.getBundle().getRequiredBundles();
        this.requires = new BundleConstraint[actualRequires.length];
        int i4 = 0;
        while (i4 < this.requires.length) {
            this.requires[i4] = new BundleConstraint(this, actualRequires[i4]);
            ++i4;
        }
        GenericSpecification[] actualGenericRequires = this.getBundle().getGenericRequires();
        this.genericReqiures = new GenericConstraint[actualGenericRequires.length];
        int i5 = 0;
        while (i5 < this.genericReqiures.length) {
            this.genericReqiures[i5] = new GenericConstraint(this, actualGenericRequires[i5]);
            ++i5;
        }
        this.fragments = null;
        this.fragmentExports = null;
        this.fragmentImports = null;
        this.fragmentRequires = null;
        this.fragmentGenericRequires = null;
    }

    ResolverExport getExport(String name) {
        ResolverExport[] allExports = this.getExportPackages();
        int i = 0;
        while (i < allExports.length) {
            if (name.equals(allExports[i].getName())) {
                return allExports[i];
            }
            ++i;
        }
        return null;
    }

    ResolverExport[] getExports(String name) {
        ArrayList<ResolverExport> results = new ArrayList<ResolverExport>(1);
        int i = 0;
        while (i < this.exports.length) {
            if (name.equals(this.exports[i].getName())) {
                results.add(this.exports[i]);
            }
            ++i;
        }
        return results.toArray(new ResolverExport[results.size()]);
    }

    void clearWires(boolean clearUnresolvable) {
        ResolverImport[] allImports = this.getImportPackages();
        int i = 0;
        while (i < allImports.length) {
            allImports[i].setMatchingExport(null);
            if (clearUnresolvable) {
                allImports[i].clearUnresolvableWirings();
            }
            ++i;
        }
        if (this.host != null) {
            this.host.removeAllMatchingBundles();
        }
        BundleConstraint[] allRequires = this.getRequires();
        int i2 = 0;
        while (i2 < allRequires.length) {
            allRequires[i2].setMatchingBundle(null);
            ++i2;
        }
        GenericConstraint[] allGenericRequires = this.getGenericRequires();
        int i3 = 0;
        while (i3 < allGenericRequires.length) {
            allGenericRequires[i3].setMatchingCapability(null);
            ++i3;
        }
    }

    boolean isResolved() {
        return this.getState() == 2;
    }

    boolean isFragment() {
        return this.host != null;
    }

    int getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = state;
    }

    ResolverImport[] getImportPackages() {
        if (this.isFragment()) {
            return new ResolverImport[0];
        }
        if (this.fragments == null || this.fragments.size() == 0) {
            return this.imports;
        }
        ArrayList<ResolverImport> resultList = new ArrayList<ResolverImport>(this.imports.length);
        int i = 0;
        while (i < this.imports.length) {
            resultList.add(this.imports[i]);
            ++i;
        }
        Iterator iter = this.fragments.iterator();
        while (iter.hasNext()) {
            ResolverBundle fragment = (ResolverBundle)iter.next();
            ArrayList fragImports = (ArrayList)this.fragmentImports.get(fragment.bundleID);
            if (fragImports == null) continue;
            resultList.addAll(fragImports);
        }
        return resultList.toArray(new ResolverImport[resultList.size()]);
    }

    ResolverExport[] getExportPackages() {
        if (this.isFragment()) {
            return new ResolverExport[0];
        }
        if (this.fragments == null || this.fragments.size() == 0) {
            return this.exports;
        }
        ArrayList<ResolverExport> resultList = new ArrayList<ResolverExport>(this.exports.length);
        int i = 0;
        while (i < this.exports.length) {
            resultList.add(this.exports[i]);
            ++i;
        }
        Iterator iter = this.fragments.iterator();
        while (iter.hasNext()) {
            ResolverBundle fragment = (ResolverBundle)iter.next();
            ArrayList fragExports = (ArrayList)this.fragmentExports.get(fragment.bundleID);
            if (fragExports == null) continue;
            resultList.addAll(fragExports);
        }
        return resultList.toArray(new ResolverExport[resultList.size()]);
    }

    ResolverExport[] getSelectedExports() {
        ResolverExport[] allExports = this.getExportPackages();
        int removedExports = 0;
        int i = 0;
        while (i < allExports.length) {
            if (allExports[i].isDropped()) {
                ++removedExports;
            }
            ++i;
        }
        if (removedExports == 0) {
            return allExports;
        }
        ResolverExport[] selectedExports = new ResolverExport[allExports.length - removedExports];
        int index = 0;
        int i2 = 0;
        while (i2 < allExports.length) {
            if (!allExports[i2].isDropped()) {
                selectedExports[index] = allExports[i2];
                ++index;
            }
            ++i2;
        }
        return selectedExports;
    }

    BundleConstraint getHost() {
        return this.host;
    }

    GenericCapability[] getGenericCapabilities() {
        return this.capabilities;
    }

    BundleConstraint[] getRequires() {
        if (this.isFragment()) {
            return new BundleConstraint[0];
        }
        if (this.fragments == null || this.fragments.size() == 0) {
            return this.requires;
        }
        ArrayList<BundleConstraint> resultList = new ArrayList<BundleConstraint>(this.requires.length);
        int i = 0;
        while (i < this.requires.length) {
            resultList.add(this.requires[i]);
            ++i;
        }
        Iterator iter = this.fragments.iterator();
        while (iter.hasNext()) {
            ResolverBundle fragment = (ResolverBundle)iter.next();
            ArrayList fragRequires = (ArrayList)this.fragmentRequires.get(fragment.bundleID);
            if (fragRequires == null) continue;
            resultList.addAll(fragRequires);
        }
        return resultList.toArray(new BundleConstraint[resultList.size()]);
    }

    GenericConstraint[] getGenericRequires() {
        if (this.isFragment() || this.fragments == null || this.fragments.size() == 0) {
            return this.genericReqiures;
        }
        ArrayList<GenericConstraint> resultList = new ArrayList<GenericConstraint>(this.genericReqiures.length);
        int i = 0;
        while (i < this.genericReqiures.length) {
            resultList.add(this.genericReqiures[i]);
            ++i;
        }
        Iterator iter = this.fragments.iterator();
        while (iter.hasNext()) {
            ResolverBundle fragment = (ResolverBundle)iter.next();
            ArrayList fragGenericRegs = (ArrayList)this.fragmentGenericRequires.get(fragment.bundleID);
            if (fragGenericRegs == null) continue;
            resultList.addAll(fragGenericRegs);
        }
        return resultList.toArray(new GenericConstraint[resultList.size()]);
    }

    BundleConstraint getRequire(String name) {
        BundleConstraint[] allRequires = this.getRequires();
        int i = 0;
        while (i < allRequires.length) {
            if (allRequires[i].getVersionConstraint().getName().equals(name)) {
                return allRequires[i];
            }
            ++i;
        }
        return null;
    }

    public BundleDescription getBundle() {
        return (BundleDescription)this.getBaseDescription();
    }

    ResolverImport getImport(String name) {
        ResolverImport[] allImports = this.getImportPackages();
        int i = 0;
        while (i < allImports.length) {
            if (allImports[i].getName().equals(name)) {
                return allImports[i];
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return "[" + this.getBundle() + "]";
    }

    private void initFragments() {
        if (this.fragments == null) {
            this.fragments = new ArrayList(1);
        }
        if (this.fragmentExports == null) {
            this.fragmentExports = new HashMap(1);
        }
        if (this.fragmentImports == null) {
            this.fragmentImports = new HashMap(1);
        }
        if (this.fragmentRequires == null) {
            this.fragmentRequires = new HashMap(1);
        }
        if (this.fragmentGenericRequires == null) {
            this.fragmentGenericRequires = new HashMap(1);
        }
    }

    private boolean isImported(String packageName) {
        ResolverImport[] allImports = this.getImportPackages();
        int i = 0;
        while (i < allImports.length) {
            if (packageName.equals(allImports[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isExported(String packageName) {
        return this.getExport(packageName) != null;
    }

    private boolean isRequired(String bundleName) {
        return this.getRequire(bundleName) != null;
    }

    ResolverExport[] attachFragment(ResolverBundle fragment, boolean dynamicAttach) {
        int i;
        if (this.isFragment()) {
            return new ResolverExport[0];
        }
        if (!this.getBundle().attachFragments() || this.isResolved() && !this.getBundle().dynamicFragments()) {
            return new ResolverExport[0];
        }
        if (fragment.getHost().getMatchingBundles() != null && !((HostSpecification)fragment.getHost().getVersionConstraint()).isMultiHost()) {
            return new ResolverExport[0];
        }
        ImportPackageSpecification[] newImports = fragment.getBundle().getImportPackages();
        BundleSpecification[] newRequires = fragment.getBundle().getRequiredBundles();
        ExportPackageDescription[] newExports = fragment.getBundle().getExportPackages();
        GenericSpecification[] newGenericRequires = fragment.getBundle().getGenericRequires();
        if (dynamicAttach && this.constraintsConflict(fragment.getBundle(), newImports, newRequires, newGenericRequires)) {
            return new ResolverExport[0];
        }
        if (this.isResolved() && newExports.length > 0) {
            fragment.setNewFragmentExports(true);
        }
        this.initFragments();
        if (this.fragments.contains(fragment)) {
            return new ResolverExport[0];
        }
        this.fragments.add(fragment);
        fragment.getHost().addMatchingBundle(this);
        if (newImports.length > 0) {
            ArrayList<ResolverImport> hostImports = new ArrayList<ResolverImport>(newImports.length);
            i = 0;
            while (i < newImports.length) {
                if (!this.isImported(newImports[i].getName())) {
                    hostImports.add(new ResolverImport(this, newImports[i]));
                }
                ++i;
            }
            this.fragmentImports.put(fragment.bundleID, hostImports);
        }
        if (newRequires.length > 0) {
            ArrayList<BundleConstraint> hostRequires = new ArrayList<BundleConstraint>(newRequires.length);
            i = 0;
            while (i < newRequires.length) {
                if (!this.isRequired(newRequires[i].getName())) {
                    hostRequires.add(new BundleConstraint(this, newRequires[i]));
                }
                ++i;
            }
            this.fragmentRequires.put(fragment.bundleID, hostRequires);
        }
        if (newGenericRequires.length > 0) {
            ArrayList<GenericConstraint> hostGenericRequires = new ArrayList<GenericConstraint>(newGenericRequires.length);
            i = 0;
            while (i < newGenericRequires.length) {
                hostGenericRequires.add(new GenericConstraint(this, newGenericRequires[i]));
                ++i;
            }
            this.fragmentGenericRequires.put(fragment.bundleID, hostGenericRequires);
        }
        ArrayList<ResolverExport> hostExports = new ArrayList<ResolverExport>(newExports.length);
        if (newExports.length > 0 && dynamicAttach) {
            StateObjectFactory factory = this.resolver.getState().getFactory();
            int i2 = 0;
            while (i2 < newExports.length) {
                if (!this.isExported(newExports[i2].getName())) {
                    ExportPackageDescription hostExport = factory.createExportPackageDescription(newExports[i2].getName(), newExports[i2].getVersion(), newExports[i2].getDirectives(), newExports[i2].getAttributes(), newExports[i2].isRoot(), this.getBundle());
                    hostExports.add(new ResolverExport(this, hostExport));
                }
                ++i2;
            }
            this.fragmentExports.put(fragment.bundleID, hostExports);
        }
        return hostExports.toArray(new ResolverExport[hostExports.size()]);
    }

    private boolean constraintsConflict(BundleDescription fragment, ImportPackageSpecification[] newImports, BundleSpecification[] newRequires, GenericSpecification[] newGenericRequires) {
        int i = 0;
        while (i < newImports.length) {
            ResolverImport importPkg = this.getImport(newImports[i].getName());
            if (importPkg == null && this.isResolved() || importPkg != null && !ResolverBundle.isIncluded(newImports[i].getVersionRange(), importPkg.getVersionConstraint().getVersionRange())) {
                this.resolver.getState().addResolverError(fragment, 16, newImports[i].toString(), newImports[i]);
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < newRequires.length) {
            BundleConstraint constraint = this.getRequire(newRequires[i].getName());
            if (constraint == null && this.isResolved() || constraint != null && !ResolverBundle.isIncluded(newRequires[i].getVersionRange(), constraint.getVersionConstraint().getVersionRange())) {
                this.resolver.getState().addResolverError(fragment, 16, newRequires[i].toString(), newRequires[i]);
                return true;
            }
            ++i;
        }
        return !this.isResolved() ? false : newGenericRequires != null && newGenericRequires.length > 0;
    }

    private static boolean isIncluded(VersionRange outer, VersionRange inner) {
        if (!(outer.isIncluded(inner.getMinimum()) || inner.getMinimum().equals(outer.getMinimum()) && inner.getIncludeMinimum() == outer.getIncludeMinimum())) {
            return false;
        }
        return outer.isIncluded(inner.getMaximum()) || inner.getMaximum().equals(outer.getMaximum()) && inner.getIncludeMaximum() == outer.getIncludeMaximum();
    }

    private void setNewFragmentExports(boolean newFragmentExports) {
        this.newFragmentExports = newFragmentExports;
    }

    boolean isNewFragmentExports() {
        return this.newFragmentExports;
    }

    ResolverExport[] detachFragment(ResolverBundle fragment, ResolverConstraint reason) {
        if (this.isFragment()) {
            return new ResolverExport[0];
        }
        this.initFragments();
        if (!this.fragments.remove(fragment)) {
            return new ResolverExport[0];
        }
        fragment.getHost().removeMatchingBundle(this);
        ArrayList fragImports = (ArrayList)this.fragmentImports.remove(fragment.bundleID);
        ArrayList fragRequires = (ArrayList)this.fragmentRequires.remove(fragment.bundleID);
        ArrayList removedExports = (ArrayList)this.fragmentExports.remove(fragment.bundleID);
        this.fragmentGenericRequires.remove(fragment.bundleID);
        if (reason != null) {
            ResolverBundle[] remainingFrags = this.fragments.toArray(new ResolverBundle[this.fragments.size()]);
            int i = 0;
            while (i < remainingFrags.length) {
                ArrayList newRequires;
                this.resolver.getResolverExports().remove(this.detachFragment(remainingFrags[i], null));
                VersionConstraint[] constraints = reason instanceof ResolverImport ? remainingFrags[i].getBundle().getImportPackages() : remainingFrags[i].getBundle().getRequiredBundles();
                int j = 0;
                while (j < constraints.length) {
                    if (reason.getName().equals(constraints[j].getName())) {
                        // empty if block
                    }
                    ++j;
                }
                this.resolver.getResolverExports().put(this.attachFragment(remainingFrags[i], true));
                ArrayList newImports = (ArrayList)this.fragmentImports.get(remainingFrags[i].bundleID);
                if (newImports != null && fragImports != null) {
                    Iterator iNewImports = newImports.iterator();
                    while (iNewImports.hasNext()) {
                        ResolverImport newImport = (ResolverImport)iNewImports.next();
                        Iterator iOldImports = fragImports.iterator();
                        while (iOldImports.hasNext()) {
                            ResolverImport oldImport = (ResolverImport)iOldImports.next();
                            if (!newImport.getName().equals(oldImport.getName())) continue;
                            newImport.setMatchingExport(oldImport.getMatchingExport());
                        }
                    }
                }
                if ((newRequires = (ArrayList)this.fragmentRequires.get(remainingFrags[i].bundleID)) != null && fragRequires != null) {
                    Iterator iNewRequires = newRequires.iterator();
                    while (iNewRequires.hasNext()) {
                        BundleConstraint newRequire = (BundleConstraint)iNewRequires.next();
                        Iterator iOldRequires = fragRequires.iterator();
                        while (iOldRequires.hasNext()) {
                            BundleConstraint oldRequire = (BundleConstraint)iOldRequires.next();
                            if (!newRequire.getName().equals(oldRequire.getName())) continue;
                            newRequire.setMatchingBundle(oldRequire.getMatchingBundle());
                        }
                    }
                }
                ++i;
            }
        }
        return removedExports == null ? new ResolverExport[]{} : removedExports.toArray(new ResolverExport[removedExports.size()]);
    }

    void detachAllFragments() {
        if (this.fragments == null) {
            return;
        }
        ResolverBundle[] allFragments = this.fragments.toArray(new ResolverBundle[this.fragments.size()]);
        int i = 0;
        while (i < allFragments.length) {
            this.detachFragment(allFragments[i], null);
            ++i;
        }
    }

    boolean isResolvable() {
        return this.resolvable;
    }

    void setResolvable(boolean resolvable) {
        this.resolvable = resolvable;
    }

    void addExport(ResolverExport re) {
        ResolverExport[] newExports = new ResolverExport[this.exports.length + 1];
        int i = 0;
        while (i < this.exports.length) {
            newExports[i] = this.exports[i];
            ++i;
        }
        newExports[this.exports.length] = re;
        this.exports = newExports;
    }

    ResolverImpl getResolver() {
        return this.resolver;
    }

    void clearRefs() {
        if (this.refs != null) {
            this.refs.clear();
        }
    }

    void addRef(ResolverBundle ref) {
        if (this.refs != null && !this.refs.contains(ref)) {
            this.refs.add(ref);
        }
    }

    int getRefs() {
        return this.refs == null ? 0 : this.refs.size();
    }
}

