/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.core.model.CategoryModel;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.core.model.SiteModelFactory;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultSiteParser
extends DefaultHandler {
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private SAXParser parser;
    private SiteModelFactory factory;
    private MultiStatus status;
    private boolean DESCRIPTION_SITE_ALREADY_SEEN = false;
    private static final int STATE_IGNORED_ELEMENT = -1;
    private static final int STATE_INITIAL = 0;
    private static final int STATE_SITE = 1;
    private static final int STATE_FEATURE = 2;
    private static final int STATE_ARCHIVE = 3;
    private static final int STATE_CATEGORY = 4;
    private static final int STATE_CATEGORY_DEF = 5;
    private static final int STATE_DESCRIPTION_SITE = 6;
    private static final int STATE_DESCRIPTION_CATEGORY_DEF = 7;
    private static final String PLUGIN_ID = UpdateCore.getPlugin().getBundle().getSymbolicName();
    private static final String SITE = "site";
    private static final String FEATURE = "feature";
    private static final String ARCHIVE = "archive";
    private static final String CATEGORY_DEF = "category-def";
    private static final String CATEGORY = "category";
    private static final String DESCRIPTION = "description";
    private static final String MIRROR = "mirror";
    private static final String DEFAULT_INFO_URL = "index.html";
    private static final String FEATURES = "features/";
    Stack stateStack = new Stack();
    Stack objectStack = new Stack();
    private int currentState;

    public DefaultSiteParser() {
        try {
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            UpdateCore.log(e);
        }
        catch (SAXException e) {
            UpdateCore.log(e);
        }
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            DefaultSiteParser.debug("Created");
        }
    }

    public void init(SiteModelFactory factory) {
        this.factory = factory;
        this.stateStack = new Stack();
        this.objectStack = new Stack();
        this.status = null;
        this.DESCRIPTION_SITE_ALREADY_SEEN = false;
    }

    public SiteModel parse(InputStream in) throws SAXException, IOException {
        this.stateStack.push(new Integer(0));
        this.currentState = (Integer)this.stateStack.peek();
        this.parser.parse(new InputSource(in), (DefaultHandler)this);
        if (this.objectStack.isEmpty()) {
            throw new SAXException(Messages.DefaultSiteParser_NoSiteTag);
        }
        if (this.objectStack.peek() instanceof SiteModel) {
            return (SiteModel)((Object)this.objectStack.pop());
        }
        String stack = "";
        Iterator iter = this.objectStack.iterator();
        while (iter.hasNext()) {
            stack = String.valueOf(stack) + iter.next().toString() + "\r\n";
        }
        throw new SAXException(NLS.bind((String)Messages.DefaultSiteParser_WrongParsingStack, (Object[])new String[]{stack}));
    }

    public MultiStatus getStatus() {
        return this.status;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            DefaultSiteParser.debug("State: " + this.currentState);
            DefaultSiteParser.debug("Start Element: uri:" + uri + " local Name:" + localName + " qName:" + qName);
        }
        switch (this.currentState) {
            case -1: {
                this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{localName, this.getState(this.currentState)}));
                break;
            }
            case 0: {
                this.handleInitialState(localName, attributes);
                break;
            }
            case 1: {
                this.handleSiteState(localName, attributes);
                break;
            }
            case 2: {
                this.handleFeatureState(localName, attributes);
                break;
            }
            case 3: {
                this.handleSiteState(localName, attributes);
                break;
            }
            case 4: {
                this.handleCategoryState(localName, attributes);
                break;
            }
            case 5: {
                this.handleCategoryDefState(localName, attributes);
                break;
            }
            case 6: {
                this.handleSiteState(localName, attributes);
                break;
            }
            case 7: {
                this.handleSiteState(localName, attributes);
                break;
            }
            default: {
                this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownStartState, (Object[])new String[]{this.getState(this.currentState)}));
            }
        }
        int newState = (Integer)this.stateStack.peek();
        if (newState != -1) {
            this.currentState = newState;
        }
    }

    public void endElement(String uri, String localName, String qName) {
        String text = null;
        URLEntryModel info = null;
        int state = (Integer)this.stateStack.peek();
        switch (state) {
            case -1: 
            case 3: 
            case 4: {
                this.stateStack.pop();
                break;
            }
            case 0: {
                this.internalError(Messages.DefaultSiteParser_ParsingStackBackToInitialState);
                break;
            }
            case 1: {
                this.stateStack.pop();
                if (!(this.objectStack.peek() instanceof String)) break;
                text = (String)this.objectStack.pop();
                SiteModel site = (SiteModel)((Object)this.objectStack.peek());
                site.getDescriptionModel().setAnnotation(text);
                break;
            }
            case 2: {
                this.stateStack.pop();
                this.objectStack.pop();
                break;
            }
            case 5: {
                this.stateStack.pop();
                if (this.objectStack.peek() instanceof String) {
                    text = (String)this.objectStack.pop();
                    CategoryModel category = (CategoryModel)((Object)this.objectStack.peek());
                    category.getDescriptionModel().setAnnotation(text);
                }
                this.objectStack.pop();
                break;
            }
            case 6: {
                this.stateStack.pop();
                text = "";
                while (this.objectStack.peek() instanceof String) {
                    String newText = (String)this.objectStack.pop();
                    if (this.trailingSpace(newText) && !this.leadingSpace(text)) {
                        text = " " + text;
                    }
                    text = String.valueOf(newText.trim()) + text;
                    if (!this.leadingSpace(newText) || this.leadingSpace(text)) continue;
                    text = " " + text;
                }
                text = text.trim();
                info = (URLEntryModel)((Object)this.objectStack.pop());
                if (text != null) {
                    info.setAnnotation(text);
                }
                SiteModel siteModel = (SiteModel)((Object)this.objectStack.peek());
                if (this.DESCRIPTION_SITE_ALREADY_SEEN) {
                    DefaultSiteParser.debug(NLS.bind((String)Messages.DefaultSiteParser_ElementAlreadySet, (Object[])new String[]{this.getState(state)}));
                }
                siteModel.setDescriptionModel(info);
                this.DESCRIPTION_SITE_ALREADY_SEEN = true;
                break;
            }
            case 7: {
                CategoryModel category;
                this.stateStack.pop();
                text = "";
                while (this.objectStack.peek() instanceof String) {
                    String newText = (String)this.objectStack.pop();
                    if (this.trailingSpace(newText) && !this.leadingSpace(text)) {
                        text = " " + text;
                    }
                    text = String.valueOf(newText.trim()) + text;
                    if (!this.leadingSpace(newText) || this.leadingSpace(text)) continue;
                    text = " " + text;
                }
                text = text.trim();
                info = (URLEntryModel)((Object)this.objectStack.pop());
                if (text != null) {
                    info.setAnnotation(text);
                }
                if ((category = (CategoryModel)((Object)this.objectStack.peek())).getDescriptionModel() != null) {
                    this.internalError(NLS.bind((String)Messages.DefaultSiteParser_ElementAlreadySet, (Object[])new String[]{this.getState(state), category.getLabel()}));
                    break;
                }
                category.setDescriptionModel(info);
                break;
            }
            default: {
                this.internalError(NLS.bind((String)Messages.DefaultSiteParser_UnknownEndState, (Object[])new String[]{this.getState(state)}));
            }
        }
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            DefaultSiteParser.debug("End Element:" + uri + ":" + localName + ":" + qName);
        }
    }

    public void characters(char[] ch, int start, int length) {
        String text = new String(ch, start, length);
        int state = (Integer)this.stateStack.peek();
        if (state == 6 || state == 7) {
            this.objectStack.push(text);
        }
    }

    public void error(SAXParseException ex) {
        this.logStatus(ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.logStatus(ex);
        throw ex;
    }

    private void handleInitialState(String elementName, Attributes attributes) throws SAXException {
        if (!elementName.equals(SITE)) {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState)}));
            throw new SAXException(Messages.DefaultSiteParser_InvalidXMLStream);
        }
        this.stateStack.push(new Integer(1));
        this.processSite(attributes);
    }

    private void handleSiteState(String elementName, Attributes attributes) {
        if (elementName.equals(DESCRIPTION)) {
            this.stateStack.push(new Integer(6));
            this.processInfo(attributes);
        } else if (elementName.equals(FEATURE)) {
            this.stateStack.push(new Integer(2));
            this.processFeature(attributes);
        } else if (elementName.equals(ARCHIVE)) {
            this.stateStack.push(new Integer(3));
            this.processArchive(attributes);
        } else if (elementName.equals(CATEGORY_DEF)) {
            this.stateStack.push(new Integer(5));
            this.processCategoryDef(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState)}));
        }
    }

    private void handleFeatureState(String elementName, Attributes attributes) {
        if (elementName.equals(DESCRIPTION)) {
            this.stateStack.push(new Integer(6));
            this.processInfo(attributes);
        } else if (elementName.equals(FEATURE)) {
            this.stateStack.push(new Integer(2));
            this.processFeature(attributes);
        } else if (elementName.equals(ARCHIVE)) {
            this.stateStack.push(new Integer(3));
            this.processArchive(attributes);
        } else if (elementName.equals(CATEGORY_DEF)) {
            this.stateStack.push(new Integer(5));
            this.processCategoryDef(attributes);
        } else if (elementName.equals(CATEGORY)) {
            this.stateStack.push(new Integer(4));
            this.processCategory(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState)}));
        }
    }

    private void handleCategoryDefState(String elementName, Attributes attributes) {
        if (elementName.equals(FEATURE)) {
            this.stateStack.push(new Integer(2));
            this.processFeature(attributes);
        } else if (elementName.equals(ARCHIVE)) {
            this.stateStack.push(new Integer(3));
            this.processArchive(attributes);
        } else if (elementName.equals(CATEGORY_DEF)) {
            this.stateStack.push(new Integer(5));
            this.processCategoryDef(attributes);
        } else if (elementName.equals(DESCRIPTION)) {
            this.stateStack.push(new Integer(7));
            this.processInfo(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState)}));
        }
    }

    private void handleCategoryState(String elementName, Attributes attributes) {
        if (elementName.equals(DESCRIPTION)) {
            this.stateStack.push(new Integer(6));
            this.processInfo(attributes);
        } else if (elementName.equals(FEATURE)) {
            this.stateStack.push(new Integer(2));
            this.processFeature(attributes);
        } else if (elementName.equals(ARCHIVE)) {
            this.stateStack.push(new Integer(3));
            this.processArchive(attributes);
        } else if (elementName.equals(CATEGORY_DEF)) {
            this.stateStack.push(new Integer(5));
            this.processCategoryDef(attributes);
        } else if (elementName.equals(CATEGORY)) {
            this.stateStack.push(new Integer(4));
            this.processCategory(attributes);
        } else {
            this.internalErrorUnknownTag(NLS.bind((String)Messages.DefaultSiteParser_UnknownElement, (Object[])new String[]{elementName, this.getState(this.currentState)}));
        }
    }

    private void processSite(Attributes attributes) throws SAXException {
        SiteModel site = this.factory.createSiteMapModel();
        String siteURL = attributes.getValue("url");
        if (siteURL != null && !"".equals(siteURL.trim())) {
            if (!siteURL.endsWith("/") && !siteURL.endsWith(File.separator)) {
                siteURL = String.valueOf(siteURL) + "/";
            }
            site.setLocationURLString(siteURL);
        }
        URLEntryModel description = this.factory.createURLEntryModel();
        description.setURLString(DEFAULT_INFO_URL);
        site.setDescriptionModel(description);
        String type = attributes.getValue("type");
        if (!this.factory.canParseSiteType(type)) {
            throw new SAXException(new InvalidSiteTypeException(type));
        }
        site.setType(type);
        String mirrorsURL = attributes.getValue("mirrorsURL");
        if (mirrorsURL != null && mirrorsURL.trim().length() > 0) {
            URLEntryModel[] mirrors = DefaultSiteParser.getMirrors(mirrorsURL, this.factory);
            if (mirrors != null) {
                site.setMirrorSiteEntryModels(mirrors);
            } else {
                site.setMirrorsURLString(mirrorsURL);
            }
        }
        this.objectStack.push(site);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            DefaultSiteParser.debug("End process Site tag: siteURL:" + siteURL + " type:" + type);
        }
    }

    private void processFeature(Attributes attributes) {
        boolean noVersion;
        SiteFeatureReferenceModel feature = this.factory.createFeatureReferenceModel();
        String urlInfo = attributes.getValue("url");
        String id = attributes.getValue("id");
        String ver = attributes.getValue("version");
        boolean noURL = urlInfo == null || urlInfo.trim().equals("");
        boolean noId = id == null || id.trim().equals("");
        boolean bl = noVersion = ver == null || ver.trim().equals("");
        if (noURL) {
            if (noId || noVersion) {
                this.internalError(NLS.bind((String)Messages.DefaultSiteParser_Missing, (Object[])new String[]{"url", this.getState(this.currentState)}));
            } else {
                urlInfo = FEATURES + id + '_' + ver;
            }
        }
        feature.setURLString(urlInfo);
        String type = attributes.getValue("type");
        feature.setType(type);
        if (noId ^ noVersion) {
            Object[] values = new String[]{id, ver, this.getState(this.currentState)};
            UpdateCore.warn(NLS.bind((String)Messages.DefaultFeatureParser_IdOrVersionInvalid, (Object[])values));
        } else {
            feature.setFeatureIdentifier(id);
            feature.setFeatureVersion(ver);
        }
        String label = attributes.getValue("label");
        if (label != null && "".equals(label.trim())) {
            label = null;
        }
        feature.setLabel(label);
        String os = attributes.getValue("os");
        feature.setOS(os);
        String ws = attributes.getValue("ws");
        feature.setWS(ws);
        String nl = attributes.getValue("nl");
        feature.setNL(nl);
        String arch = attributes.getValue("arch");
        feature.setArch(arch);
        String patch = attributes.getValue("patch");
        feature.setPatch(patch);
        SiteModel site = (SiteModel)((Object)this.objectStack.peek());
        site.addFeatureReferenceModel(feature);
        feature.setSiteModel(site);
        this.objectStack.push(feature);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            DefaultSiteParser.debug("End Processing DefaultFeature Tag: url:" + urlInfo + " type:" + type);
        }
    }

    private void processArchive(Attributes attributes) {
        ArchiveReferenceModel archive = this.factory.createArchiveReferenceModel();
        String id = attributes.getValue("path");
        if (id == null || id.trim().equals("")) {
            this.internalError(NLS.bind((String)Messages.DefaultSiteParser_Missing, (Object[])new String[]{"path", this.getState(this.currentState)}));
        }
        archive.setPath(id);
        String url = attributes.getValue("url");
        if (url == null || url.trim().equals("")) {
            this.internalError(NLS.bind((String)Messages.DefaultSiteParser_Missing, (Object[])new String[]{ARCHIVE, this.getState(this.currentState)}));
        } else {
            archive.setURLString(url);
            SiteModel site = (SiteModel)((Object)this.objectStack.peek());
            site.addArchiveReferenceModel(archive);
        }
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            DefaultSiteParser.debug("End processing Archive: path:" + id + " url:" + url);
        }
    }

    private void processCategory(Attributes attributes) {
        String category = attributes.getValue("name");
        SiteFeatureReferenceModel feature = (SiteFeatureReferenceModel)this.objectStack.peek();
        feature.addCategoryName(category);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            DefaultSiteParser.debug("End processing Category: name:" + category);
        }
    }

    private void processCategoryDef(Attributes attributes) {
        CategoryModel category = this.factory.createSiteCategoryModel();
        String name = attributes.getValue("name");
        String label = attributes.getValue("label");
        category.setName(name);
        category.setLabel(label);
        SiteModel site = (SiteModel)((Object)this.objectStack.peek());
        site.addCategoryModel(category);
        this.objectStack.push(category);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            DefaultSiteParser.debug("End processing CategoryDef: name:" + name + " label:" + label);
        }
    }

    private void processInfo(Attributes attributes) {
        URLEntryModel inf = this.factory.createURLEntryModel();
        String infoURL = attributes.getValue("url");
        inf.setURLString(infoURL);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            DefaultSiteParser.debug("Processed Info: url:" + infoURL);
        }
        this.objectStack.push(inf);
    }

    private static void debug(String s) {
        UpdateCore.debug("DefaultSiteParser" + s);
    }

    private void logStatus(SAXParseException ex) {
        String msg;
        String name = ex.getSystemId();
        name = name == null ? "" : name.substring(1 + name.lastIndexOf("/"));
        if (name.equals("")) {
            msg = NLS.bind((String)Messages.DefaultSiteParser_ErrorParsing, (Object[])new String[]{ex.getMessage()});
        } else {
            Object[] values = new String[]{name, Integer.toString(ex.getLineNumber()), Integer.toString(ex.getColumnNumber()), ex.getMessage()};
            msg = NLS.bind((String)Messages.DefaultSiteParser_ErrorlineColumnMessage, (Object[])values);
        }
        this.error((IStatus)new Status(4, PLUGIN_ID, 1, msg, (Throwable)ex));
    }

    private void error(IStatus error) {
        if (this.status == null) {
            this.status = new MultiStatus(PLUGIN_ID, 1, Messages.DefaultSiteParser_ErrorParsingSite, null);
        }
        this.status.add(error);
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
            UpdateCore.log(error);
        }
    }

    private void internalErrorUnknownTag(String msg) {
        this.stateStack.push(new Integer(-1));
        this.internalError(msg);
    }

    private void internalError(String message) {
        this.error((IStatus)new Status(4, PLUGIN_ID, 0, message, null));
    }

    private String getState(int state) {
        switch (state) {
            case -1: {
                return "Ignored";
            }
            case 0: {
                return "Initial";
            }
            case 1: {
                return "Site";
            }
            case 2: {
                return "Feature";
            }
            case 3: {
                return "Archive";
            }
            case 4: {
                return "Category";
            }
            case 5: {
                return "Category Def";
            }
            case 7: {
                return "Description / Category Def";
            }
            case 6: {
                return "Description / Site";
            }
        }
        return Messages.DefaultSiteParser_UnknownState;
    }

    private boolean leadingSpace(String str) {
        if (str.length() <= 0) {
            return false;
        }
        return Character.isWhitespace(str.charAt(0));
    }

    private boolean trailingSpace(String str) {
        if (str.length() <= 0) {
            return false;
        }
        return Character.isWhitespace(str.charAt(str.length() - 1));
    }

    static URLEntryModel[] getMirrors(String mirrorsURL, SiteModelFactory factory) {
        Document document;
        block6: {
            String countryCode = Locale.getDefault().getCountry().toLowerCase();
            int timeZone = new GregorianCalendar().get(15) / 3600000;
            mirrorsURL = mirrorsURL.indexOf("?") != -1 ? String.valueOf(mirrorsURL) + "&" : String.valueOf(mirrorsURL) + "?";
            mirrorsURL = String.valueOf(mirrorsURL) + "countryCode=" + countryCode + "&timeZone=" + timeZone + "&responseType=xml";
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            document = builder.parse(mirrorsURL);
            if (document != null) break block6;
            return null;
        }
        try {
            NodeList mirrorNodes = document.getElementsByTagName(MIRROR);
            URLEntryModel[] mirrors = new URLEntryModel[mirrorNodes.getLength()];
            int i = 0;
            while (i < mirrorNodes.getLength()) {
                Element mirrorNode = (Element)mirrorNodes.item(i);
                mirrors[i] = factory.createURLEntryModel();
                String infoURL = mirrorNode.getAttribute("url");
                String label = mirrorNode.getAttribute("label");
                mirrors[i].setURLString(infoURL);
                mirrors[i].setAnnotation(label);
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_PARSING) {
                    DefaultSiteParser.debug("Processed mirror: url:" + infoURL + " label:" + label);
                }
                ++i;
            }
            return mirrors;
        }
        catch (Exception e) {
            if (mirrorsURL != null && (mirrorsURL.startsWith("http://") || mirrorsURL.startsWith("https://") || mirrorsURL.startsWith("file://") || mirrorsURL.startsWith("ftp://") || mirrorsURL.startsWith("jar://"))) {
                UpdateCore.log(Messages.DefaultSiteParser_mirrors, e);
            }
            return null;
        }
    }
}

