/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.mirror.MirrorCommand;
import org.eclipse.update.standalone.AddSiteCommand;
import org.eclipse.update.standalone.DisableCommand;
import org.eclipse.update.standalone.EnableCommand;
import org.eclipse.update.standalone.InstallCommand;
import org.eclipse.update.standalone.ListFeaturesCommand;
import org.eclipse.update.standalone.RemoveSiteCommand;
import org.eclipse.update.standalone.ScriptedCommand;
import org.eclipse.update.standalone.SearchCommand;
import org.eclipse.update.standalone.StandaloneUpdateApplication;
import org.eclipse.update.standalone.UninstallCommand;
import org.eclipse.update.standalone.UpdateCommand;

public class CmdLineArgs {
    private HashMap options = new HashMap();

    public CmdLineArgs(String[] args) {
        int i = 0;
        while (i < args.length - 1) {
            String to;
            if ("-command".equals(args[i])) {
                if (this.isValidCommand(args[i + 1])) {
                    this.options.put("-command", args[i + 1]);
                    ++i;
                } else {
                    StandaloneUpdateApplication.exceptionLogged();
                    UpdateCore.log(Utilities.newCoreException(String.valueOf(Messages.Standalone_invalidCmd) + args[i + 1], null));
                    return;
                }
            }
            if (this.isValidParam(args[i])) {
                this.options.put(args[i], args[i + 1]);
                ++i;
            }
            if ((to = (String)this.options.get("-to")) != null && to.startsWith("file:")) {
                try {
                    URL url = new URL(to);
                    this.options.put("-to", url.getFile());
                }
                catch (MalformedURLException malformedURLException) {}
            }
            ++i;
        }
    }

    private boolean isValidParam(String param) {
        return param.equals("-command") || param.equals("-version") || param.equals("-to") || param.equals("-from") || param.equals("-featureId") || param.equals("-verifyOnly") || param.equals("-mirrorURL");
    }

    private boolean isValidCommand(String cmd) {
        if (cmd == null) {
            return false;
        }
        return cmd.equals("install") || cmd.equals("enable") || cmd.equals("disable") || cmd.equals("search") || cmd.equals("update") || cmd.equals("mirror") || cmd.equals("uninstall") || cmd.equals("listFeatures") || cmd.equals("addSite") || cmd.equals("removeSite");
    }

    public ScriptedCommand getCommand() {
        String cmd;
        block13: {
            try {
                cmd = (String)this.options.get("-command");
                if (cmd != null) break block13;
                return null;
            }
            catch (Exception e) {
                StandaloneUpdateApplication.exceptionLogged();
                UpdateCore.log(e);
                return null;
            }
        }
        if (cmd.equals("install")) {
            return new InstallCommand((String)this.options.get("-featureId"), (String)this.options.get("-version"), (String)this.options.get("-from"), (String)this.options.get("-to"), (String)this.options.get("-verifyOnly"));
        }
        if (cmd.equals("enable")) {
            return new EnableCommand((String)this.options.get("-featureId"), (String)this.options.get("-version"), (String)this.options.get("-to"), (String)this.options.get("-verifyOnly"));
        }
        if (cmd.equals("disable")) {
            return new DisableCommand((String)this.options.get("-featureId"), (String)this.options.get("-version"), (String)this.options.get("-to"), (String)this.options.get("-verifyOnly"));
        }
        if (cmd.equals("search")) {
            return new SearchCommand((String)this.options.get("-from"));
        }
        if (cmd.equals("update")) {
            return new UpdateCommand((String)this.options.get("-featureId"), (String)this.options.get("-version"), (String)this.options.get("-verifyOnly"));
        }
        if (cmd.equals("mirror")) {
            return new MirrorCommand((String)this.options.get("-featureId"), (String)this.options.get("-version"), (String)this.options.get("-from"), (String)this.options.get("-to"), (String)this.options.get("-mirrorURL"));
        }
        if (cmd.equals("uninstall")) {
            return new UninstallCommand((String)this.options.get("-featureId"), (String)this.options.get("-version"), (String)this.options.get("-to"), (String)this.options.get("-verifyOnly"));
        }
        if (cmd.equals("listFeatures")) {
            return new ListFeaturesCommand((String)this.options.get("-from"));
        }
        if (cmd.equals("addSite")) {
            return new AddSiteCommand((String)this.options.get("-from"));
        }
        if (cmd.equals("removeSite")) {
            return new RemoveSiteCommand((String)this.options.get("-to"));
        }
        return null;
    }
}

