/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.configurator.UpdateURLDecoder;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.search.SiteSearchCategory;
import org.eclipse.update.search.IUpdateSearchResultCollector;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;
import org.eclipse.update.standalone.ScriptedCommand;
import org.eclipse.update.standalone.StandaloneUpdateApplication;

public class SearchCommand
extends ScriptedCommand {
    private URL remoteSiteURL;
    private UpdateSearchRequest searchRequest;
    private IUpdateSearchResultCollector collector;

    public SearchCommand(String fromSite) {
        try {
            this.remoteSiteURL = new URL(UpdateURLDecoder.decode((String)fromSite, (String)"UTF-8"));
            UpdateSearchScope searchScope = new UpdateSearchScope();
            searchScope.addSearchSite("remoteSite", this.remoteSiteURL, new String[0]);
            this.searchRequest = new UpdateSearchRequest(new SiteSearchCategory(), searchScope);
            this.collector = new UpdateSearchResultCollector();
        }
        catch (MalformedURLException e) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(e);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public boolean run(IProgressMonitor monitor) {
        try {
            monitor.beginTask(String.valueOf(Messages.Standalone_searching) + this.remoteSiteURL.toExternalForm(), 4);
            this.searchRequest.performSearch(this.collector, monitor);
            Object var4_2 = null;
        }
        catch (CoreException ce) {
            try {
                IStatus status = ce.getStatus();
                if (status != null && status.getCode() == 42) {
                    System.out.println(Messages.Standalone_connection);
                } else {
                    StandaloneUpdateApplication.exceptionLogged();
                    UpdateCore.log(ce);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return false;
        }
        monitor.done();
        return true;
    }

    class UpdateSearchResultCollector
    implements IUpdateSearchResultCollector {
        UpdateSearchResultCollector() {
        }

        public void accept(IFeature feature) {
            System.out.println("\"" + feature.getLabel() + "\" " + feature.getVersionedIdentifier().getIdentifier() + " " + feature.getVersionedIdentifier().getVersion());
        }
    }
}

