/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.refactoring.RenameTypeArguments;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.internal.debug.core.refactoring.BreakpointRenameParticipant;
import org.eclipse.jdt.internal.debug.core.refactoring.WatchpointTypeRenameChange;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;

public class BreakpointRenameTypeParticipant
extends BreakpointRenameParticipant {
    protected boolean accepts(IJavaElement element) {
        return element instanceof IType;
    }

    protected Change createTypeChange(IJavaBreakpoint breakpoint, IType destType, IType originalType) throws CoreException {
        if (breakpoint instanceof IJavaWatchpoint) {
            return new WatchpointTypeRenameChange((IJavaWatchpoint)breakpoint, destType, originalType, this.getProcessor(), (RenameTypeArguments)this.getArguments());
        }
        return super.createTypeChange(breakpoint, destType, originalType);
    }

    protected void gatherChanges(IMarker[] markers, List changes, String simpleDestName) throws CoreException, OperationCanceledException {
        IType originalType = (IType)this.getOriginalElement();
        ICompilationUnit originalCU = originalType.getCompilationUnit();
        ICompilationUnit destCU = null;
        IType primaryType = originalCU.findPrimaryType();
        if (originalType.isMember() || primaryType == null || !primaryType.equals(originalType)) {
            destCU = originalCU;
        } else if (primaryType.equals(originalType)) {
            String ext = ".java";
            IResource res = originalCU.getResource();
            if (res != null) {
                ext = String.valueOf('.') + res.getFileExtension();
            }
            destCU = originalType.getPackageFragment().getCompilationUnit(String.valueOf(simpleDestName) + ext);
        }
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            IBreakpoint breakpoint = this.getBreakpoint(marker);
            if (breakpoint instanceof IJavaBreakpoint) {
                IJavaBreakpoint javaBreakpoint = (IJavaBreakpoint)breakpoint;
                IType breakpointType = BreakpointUtils.getType(javaBreakpoint);
                IType destType = null;
                if (breakpointType != null && this.isContained((IJavaElement)originalCU, breakpointType)) {
                    String typeQualifiedName = breakpointType.getTypeQualifiedName();
                    String[] names = typeQualifiedName.split("\\$");
                    if (this.isContained((IJavaElement)originalType, breakpointType)) {
                        String[] oldNames = originalType.getTypeQualifiedName().split("\\$");
                        names[oldNames.length - 1] = simpleDestName;
                    }
                    destType = destCU.getType(names[0]);
                    int j = 1;
                    while (j < names.length) {
                        destType = destType.getType(names[j]);
                        ++j;
                    }
                    changes.add(this.createTypeChange(javaBreakpoint, destType, breakpointType));
                }
            }
            ++i;
        }
    }
}

