/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.jres.IAddVMDialogRequestor;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.VMLibraryBlock;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AddVMDialog
extends StatusDialog {
    private IAddVMDialogRequestor fRequestor;
    private IVMInstall fEditedVM;
    private IVMInstallType[] fVMTypes;
    private IVMInstallType fSelectedVMType;
    private ComboDialogField fVMTypeCombo;
    private VMLibraryBlock fLibraryBlock;
    private StringButtonDialogField fJRERoot;
    private StringDialogField fVMName;
    private StringDialogField fVMArgs;
    private URL fJavadocLocation = null;
    private boolean fAutoDetectJavadocLocation = false;
    private IStatus[] fStati;
    private int fPrevIndex = -1;

    public AddVMDialog(IAddVMDialogRequestor requestor, Shell shell, IVMInstallType[] vmInstallTypes, IVMInstall editedVM) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fRequestor = requestor;
        this.fStati = new IStatus[5];
        int i = 0;
        while (i < this.fStati.length) {
            this.fStati[i] = new StatusInfo();
            ++i;
        }
        this.fVMTypes = vmInstallTypes;
        this.fSelectedVMType = editedVM != null ? editedVM.getVMInstallType() : vmInstallTypes[0];
        this.fEditedVM = editedVM;
        this.fAutoDetectJavadocLocation = this.fEditedVM == null || this.fEditedVM.getJavadocLocation() == null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, IJavaDebugHelpContextIds.EDIT_JRE_DIALOG);
    }

    protected void createDialogFields() {
        this.fVMTypeCombo = new ComboDialogField(8);
        this.fVMTypeCombo.setLabelText(JREMessages.addVMDialog_jreType);
        this.fVMTypeCombo.setItems(this.getVMTypeNames());
        this.fVMName = new StringDialogField();
        this.fVMName.setLabelText(JREMessages.addVMDialog_jreName);
        this.fJRERoot = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                AddVMDialog.this.browseForInstallDir();
            }
        });
        this.fJRERoot.setLabelText(JREMessages.addVMDialog_jreHome);
        this.fJRERoot.setButtonLabel(JREMessages.addVMDialog_browse1);
        this.fVMArgs = new StringDialogField();
        this.fVMArgs.setLabelText(JREMessages.AddVMDialog_23);
    }

    protected void createFieldListeners() {
        this.fVMTypeCombo.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddVMDialog.this.updateVMType();
            }
        });
        this.fVMName.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddVMDialog.this.setVMNameStatus(AddVMDialog.this.validateVMName());
                AddVMDialog.this.updateStatusLine();
            }
        });
        this.fJRERoot.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddVMDialog.this.setJRELocationStatus(AddVMDialog.this.validateJRELocation());
                AddVMDialog.this.updateStatusLine();
            }
        });
    }

    protected String getVMName() {
        return this.fVMName.getText();
    }

    protected File getInstallLocation() {
        return new File(this.fJRERoot.getText());
    }

    protected Control createDialogArea(Composite ancestor) {
        this.createDialogFields();
        Composite parent = (Composite)super.createDialogArea(ancestor);
        ((GridLayout)parent.getLayout()).numColumns = 3;
        this.fVMTypeCombo.doFillIntoGrid(parent, 3);
        ((GridData)this.fVMTypeCombo.getComboControl(null).getLayoutData()).widthHint = this.convertWidthInCharsToPixels(50);
        this.fVMName.doFillIntoGrid(parent, 3);
        this.fJRERoot.doFillIntoGrid(parent, 3);
        this.fVMArgs.doFillIntoGrid(parent, 3);
        Label l = new Label(parent, 0);
        l.setText(JREMessages.AddVMDialog_JRE_system_libraries__1);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        l.setLayoutData((Object)gd);
        this.fLibraryBlock = new VMLibraryBlock(this);
        Control block = this.fLibraryBlock.createControl(parent);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        block.setLayoutData((Object)gd);
        Text t = this.fJRERoot.getTextControl(parent);
        gd = (GridData)t.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.initializeFields();
        this.createFieldListeners();
        AddVMDialog.applyDialogFont((Control)parent);
        return parent;
    }

    private void updateVMType() {
        int selIndex = this.fVMTypeCombo.getSelectionIndex();
        if (selIndex == this.fPrevIndex) {
            return;
        }
        this.fPrevIndex = selIndex;
        if (selIndex >= 0 && selIndex < this.fVMTypes.length) {
            this.fSelectedVMType = this.fVMTypes[selIndex];
        }
        this.setJRELocationStatus(this.validateJRELocation());
        this.fLibraryBlock.initializeFrom(this.fEditedVM, this.fSelectedVMType);
        this.updateStatusLine();
    }

    public void create() {
        super.create();
        this.fVMName.setFocus();
        this.selectVMType();
    }

    private String[] getVMTypeNames() {
        String[] names = new String[this.fVMTypes.length];
        int i = 0;
        while (i < this.fVMTypes.length) {
            names[i] = this.fVMTypes[i].getName();
            ++i;
        }
        return names;
    }

    private void selectVMType() {
        int i = 0;
        while (i < this.fVMTypes.length) {
            if (this.fSelectedVMType == this.fVMTypes[i]) {
                this.fVMTypeCombo.selectItem(i);
                return;
            }
            ++i;
        }
    }

    private void initializeFields() {
        this.fVMTypeCombo.setItems(this.getVMTypeNames());
        if (this.fEditedVM == null) {
            this.fVMName.setText("");
            this.fJRERoot.setText("");
            this.fLibraryBlock.initializeFrom(null, this.fSelectedVMType);
            this.fVMArgs.setText("");
        } else {
            this.fVMTypeCombo.setEnabled(false);
            this.fVMName.setText(this.fEditedVM.getName());
            this.fJRERoot.setText(this.fEditedVM.getInstallLocation().getAbsolutePath());
            this.fLibraryBlock.initializeFrom(this.fEditedVM, this.fSelectedVMType);
            if (this.fEditedVM instanceof IVMInstall2) {
                IVMInstall2 vm2 = (IVMInstall2)this.fEditedVM;
                String vmArgs = vm2.getVMArgs();
                if (vmArgs != null) {
                    this.fVMArgs.setText(vmArgs);
                }
            } else {
                String[] vmArgs = this.fEditedVM.getVMArguments();
                if (vmArgs != null) {
                    StringBuffer buffer = new StringBuffer();
                    int length = vmArgs.length;
                    if (length > 0) {
                        buffer.append(vmArgs[0]);
                        int i = 1;
                        while (i < length) {
                            buffer.append(' ').append(vmArgs[i]);
                            ++i;
                        }
                    }
                    this.fVMArgs.setText(buffer.toString());
                }
            }
        }
        this.setVMNameStatus(this.validateVMName());
        this.updateStatusLine();
    }

    private IVMInstallType getVMType() {
        return this.fSelectedVMType;
    }

    private IStatus validateJRELocation() {
        String locationName = this.fJRERoot.getText();
        StatusInfo s = null;
        File file = null;
        if (locationName.length() == 0) {
            s = new StatusInfo(1, JREMessages.addVMDialog_enterLocation);
        } else {
            file = new File(locationName);
            if (!file.exists()) {
                s = new StatusInfo(4, JREMessages.addVMDialog_locationNotExists);
            } else {
                final IStatus[] temp = new IStatus[1];
                final File tempFile = file;
                Runnable r = new Runnable(){

                    public void run() {
                        temp[0] = AddVMDialog.this.getVMType().validateInstallLocation(tempFile);
                    }
                };
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
                s = temp[0];
            }
        }
        if (s.isOK()) {
            this.fLibraryBlock.setHomeDirectory(file);
        } else {
            this.fLibraryBlock.setHomeDirectory(null);
        }
        this.fLibraryBlock.restoreDefaultLibraries();
        this.detectJavadocLocation();
        return s;
    }

    private void detectJavadocLocation() {
        if (this.fAutoDetectJavadocLocation) {
            if (this.getVMType() instanceof AbstractVMInstallType) {
                AbstractVMInstallType type = (AbstractVMInstallType)this.getVMType();
                this.fJavadocLocation = type.getDefaultJavadocLocation(this.getInstallLocation());
            }
        } else {
            this.fJavadocLocation = this.fEditedVM.getJavadocLocation();
        }
    }

    private IStatus validateVMName() {
        StatusInfo status = new StatusInfo();
        String name = this.fVMName.getText();
        if (name == null || name.trim().length() == 0) {
            status.setInfo(JREMessages.addVMDialog_enterName);
        } else if (this.fRequestor.isDuplicateName(name) && (this.fEditedVM == null || !name.equals(this.fEditedVM.getName()))) {
            status.setError(JREMessages.addVMDialog_duplicateName);
        } else {
            IStatus s = ResourcesPlugin.getWorkspace().validateName(name, 1);
            if (!s.isOK()) {
                status.setError(MessageFormat.format((String)JREMessages.AddVMDialog_JRE_name_must_be_a_valid_file_name___0__1, (Object[])new String[]{s.getMessage()}));
            }
        }
        return status;
    }

    protected void updateStatusLine() {
        IStatus max = null;
        int i = 0;
        while (i < this.fStati.length) {
            IStatus curr = this.fStati[i];
            if (curr.matches(4)) {
                this.updateStatus(curr);
                return;
            }
            if (max == null || curr.getSeverity() > max.getSeverity()) {
                max = curr;
            }
            ++i;
        }
        this.updateStatus(max);
    }

    private void browseForInstallDir() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(this.fJRERoot.getText());
        dialog.setMessage(JREMessages.addVMDialog_pickJRERootDialog_message);
        String newPath = dialog.open();
        if (newPath != null) {
            this.fJRERoot.setText(newPath);
        }
    }

    protected URL getURL() {
        return this.fJavadocLocation;
    }

    protected void okPressed() {
        this.doOkPressed();
        super.okPressed();
    }

    private void doOkPressed() {
        if (this.fEditedVM == null) {
            VMStandin vm = new VMStandin(this.fSelectedVMType, this.createUniqueId(this.fSelectedVMType));
            this.setFieldValuesToVM((IVMInstall)vm);
            this.fRequestor.vmAdded((IVMInstall)vm);
        } else {
            this.setFieldValuesToVM(this.fEditedVM);
        }
    }

    private String createUniqueId(IVMInstallType vmType) {
        String id = null;
        while (vmType.findVMInstall(id = String.valueOf(System.currentTimeMillis())) != null) {
        }
        return id;
    }

    protected void setFieldValuesToVM(IVMInstall vm) {
        vm.setInstallLocation(new File(this.fJRERoot.getText()).getAbsoluteFile());
        vm.setName(this.fVMName.getText());
        vm.setJavadocLocation(this.getURL());
        String argString = this.fVMArgs.getText().trim();
        if (vm instanceof IVMInstall2) {
            IVMInstall2 vm2 = (IVMInstall2)vm;
            if (argString != null && argString.length() > 0) {
                vm2.setVMArgs(argString);
            } else {
                vm2.setVMArgs(null);
            }
        } else if (argString != null && argString.length() > 0) {
            vm.setVMArguments(DebugPlugin.parseArguments((String)argString));
        } else {
            vm.setVMArguments(null);
        }
        this.fLibraryBlock.performApply(vm);
    }

    protected File getAbsoluteFileOrEmpty(String path) {
        if (path == null || path.length() == 0) {
            return new File("");
        }
        return new File(path).getAbsoluteFile();
    }

    private void setVMNameStatus(IStatus status) {
        this.fStati[0] = status;
    }

    private void setJRELocationStatus(IStatus status) {
        this.fStati[1] = status;
    }

    protected IStatus getSystemLibraryStatus() {
        return this.fStati[3];
    }

    protected void setSystemLibraryStatus(IStatus status) {
        this.fStati[3] = status;
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button ok = this.getButton(0);
        if (ok != null && !ok.isDisposed()) {
            ok.setEnabled(status.getSeverity() == 0);
        }
    }

    protected void setButtonLayoutData(Button button) {
        super.setButtonLayoutData(button);
    }

    protected String getDialogSettingsSectionName() {
        return "ADD_VM_DIALOG_SECTION";
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = JDIDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }
}

