/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.variables;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.elements.adapters.VariableLabelAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDIModelPresentation;
import org.eclipse.ui.IWorkbenchPart;

public class JavaVariableLabelAdapter
extends VariableLabelAdapter {
    public static JDIModelPresentation fLabelProvider = new JDIModelPresentation();

    protected String getValueText(IVariable variable, IValue value, IPresentationContext context) throws CoreException {
        if (value instanceof IJavaValue) {
            return fLabelProvider.getFormattedValueText((IJavaValue)value);
        }
        return super.getValueText(variable, value, context);
    }

    protected String getValueTypeName(IVariable variable, IValue value, IPresentationContext context) throws CoreException {
        if (!this.isShowQualfiiedNames(context)) {
            return fLabelProvider.removeQualifierFromGenericName(value.getReferenceTypeName());
        }
        return super.getValueTypeName(variable, value, context);
    }

    protected String getVariableTypeName(IVariable variable, IPresentationContext context) throws CoreException {
        if (!this.isShowQualfiiedNames(context)) {
            return fLabelProvider.removeQualifierFromGenericName(variable.getReferenceTypeName());
        }
        return super.getVariableTypeName(variable, context);
    }

    private boolean isShowQualfiiedNames(IPresentationContext context) {
        IWorkbenchPart part = context.getPart();
        if (part != null) {
            return JDIDebugUIPlugin.getDefault().getPluginPreferences().getBoolean(String.valueOf(part.getSite().getId()) + "." + IJDIPreferencesConstants.PREF_SHOW_QUALIFIED_NAMES);
        }
        return false;
    }
}

