/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileRevision;
import org.eclipse.team.internal.ccvs.ui.AbstractCVSHistoryCategory;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryPage;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.core.LocalFileRevision;
import org.eclipse.team.internal.ui.history.CompareFileRevisionEditorInput;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class CompareRevisionAction
extends BaseSelectionListenerAction {
    CVSHistoryPage page;
    IStructuredSelection selection;

    public CompareRevisionAction(String text) {
        super(text);
    }

    public void run() {
        try {
            IStructuredSelection structSel = this.selection;
            Object[] objArray = structSel.toArray();
            IFileRevision file1 = null;
            IFileRevision file2 = null;
            switch (structSel.size()) {
                case 1: {
                    file1 = this.page.getCurrentFileRevision();
                    Object tempRevision = objArray[0];
                    if (tempRevision instanceof IFileRevision) {
                        file2 = (IFileRevision)tempRevision;
                        break;
                    }
                    return;
                }
                case 2: {
                    Object tempRevision2 = objArray[0];
                    Object tempRevision3 = objArray[1];
                    if (tempRevision2 instanceof IFileRevision && tempRevision3 instanceof IFileRevision) {
                        file1 = (IFileRevision)objArray[0];
                        file2 = (IFileRevision)objArray[1];
                        break;
                    }
                    return;
                }
            }
            if (file1 == null || file2 == null || !file1.exists() || !file2.exists()) {
                MessageDialog.openError((Shell)this.page.getSite().getShell(), (String)CVSUIMessages.OpenRevisionAction_DeletedRevTitle, (String)CVSUIMessages.CompareRevisionAction_DeleteCompareMessage);
                return;
            }
            FileRevisionTypedElement left = new FileRevisionTypedElement(file1);
            FileRevisionTypedElement right = new FileRevisionTypedElement(file2);
            CompareFileRevisionEditorInput input = new CompareFileRevisionEditorInput(left, right);
            IWorkbenchPage workBenchPage = this.page.getSite().getPage();
            IEditorPart editor = CompareRevisionAction.findReusableCompareEditor(workBenchPage);
            if (editor != null) {
                IEditorInput otherInput = editor.getEditorInput();
                if (otherInput.equals(input)) {
                    workBenchPage.activate((IWorkbenchPart)editor);
                } else {
                    CompareUI.reuseCompareEditor((CompareEditorInput)input, (IReusableEditor)((IReusableEditor)editor));
                    workBenchPage.activate((IWorkbenchPart)editor);
                }
            } else {
                CompareUI.openCompareEditor((CompareEditorInput)input);
            }
        }
        catch (Exception exception) {}
    }

    public static IEditorPart findReusableCompareEditor(IWorkbenchPage page) {
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part != null && part.getEditorInput() instanceof CompareFileRevisionEditorInput && part instanceof IReusableEditor && !part.isDirty()) {
                return part;
            }
            ++i;
        }
        return null;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.selection = selection;
        if (selection.size() == 1) {
            Object el = selection.getFirstElement();
            if (el instanceof CVSFileRevision) {
                CVSFileRevision tempFileRevision = (CVSFileRevision)el;
                this.setText(NLS.bind((String)CVSUIMessages.CompareRevisionAction_Revision, (Object[])new String[]{tempFileRevision.getContentIdentifier()}));
            } else if (el instanceof LocalFileRevision) {
                this.setText(CVSUIMessages.CompareRevisionAction_Local);
            } else {
                this.setText(CVSUIMessages.CompareRevisionAction_CompareWithCurrent);
            }
            return this.shouldShow();
        }
        if (selection.size() == 2) {
            this.setText(CVSUIMessages.CompareRevisionAction_CompareWithOther);
            return this.shouldShow();
        }
        return false;
    }

    public void setPage(CVSHistoryPage page) {
        this.page = page;
    }

    private boolean shouldShow() {
        IStructuredSelection structSel = this.selection;
        Object[] objArray = structSel.toArray();
        if (objArray.length == 0) {
            return false;
        }
        int i = 0;
        while (i < objArray.length) {
            if (objArray[i] instanceof AbstractCVSHistoryCategory) {
                return false;
            }
            IFileRevision revision = (IFileRevision)objArray[i];
            if (revision != null && !revision.exists()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

