/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ccvs.core.CVSCompareSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.SyncAction;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceTraversalAction;
import org.eclipse.team.internal.ccvs.ui.mappings.ModelCompareOperation;
import org.eclipse.team.internal.ccvs.ui.subscriber.CompareParticipant;
import org.eclipse.team.internal.ccvs.ui.tags.TagSelectionDialog;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;

public class CompareWithTagAction
extends WorkspaceTraversalAction {
    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        IResource[] resources = this.getSelectedResources();
        CVSTag tag = this.promptForTag(resources);
        if (tag == null) {
            return;
        }
        IFile file = this.getSelectedFile();
        if (file != null) {
            CVSCompareSubscriber compareSubscriber = new CVSCompareSubscriber(resources, tag);
            SyncAction.showSingleFileComparison(this.getShell(), (Subscriber)compareSubscriber, (IResource)file, this.getTargetPage());
            compareSubscriber.dispose();
            return;
        }
        CVSCompareSubscriber compareSubscriber = new CVSCompareSubscriber(CompareWithTagAction.getProjects(resources), tag);
        if (this.isShowModelSync()) {
            try {
                ResourceMapping[] mappings = this.getCVSResourceMappings();
                try {
                    compareSubscriber.primeRemoteTree();
                }
                catch (CVSException cVSException) {}
                new ModelCompareOperation(this.getTargetPart(), mappings, compareSubscriber).run();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            ResourceMapping[] resourceMappings = this.getCVSResourceMappings();
            if (CompareWithTagAction.isLogicalModel(resourceMappings)) {
                compareSubscriber = new CVSCompareSubscriber(CompareWithTagAction.getProjects(resources), tag);
                resources = this.getResourcesToCompare((Subscriber)compareSubscriber);
                compareSubscriber.dispose();
            }
            compareSubscriber = new CVSCompareSubscriber(resources, tag);
            try {
                compareSubscriber.primeRemoteTree();
            }
            catch (CVSException cVSException) {}
            CompareParticipant participant = CompareParticipant.getMatchingParticipant(resources, tag);
            if (participant == null) {
                CVSCompareSubscriber s = compareSubscriber;
                participant = new CompareParticipant(s);
                TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
            }
            participant.refresh(resources, null, null, null);
        }
    }

    private boolean isShowModelSync() {
        return CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("enableModelSync");
    }

    protected CVSTag promptForTag(IResource[] resources) {
        CVSTag tag = TagSelectionDialog.getTagToCompareWith(this.getShell(), TagSource.create(resources), 31);
        return tag;
    }

    protected boolean isEnabledForNonExistantResources() {
        return true;
    }
}

