/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberResourceMappingContext;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.team.internal.core.mapping.CompoundResourceTraversal;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.ui.PlatformUI;

public abstract class WorkspaceTraversalAction
extends WorkspaceAction {
    protected ResourceMapping[] getCVSResourceMappings() {
        return this.getSelectedResourceMappings(CVSProviderPlugin.getTypeId());
    }

    protected static ResourceTraversal[] getTraversals(ResourceMapping[] mappings, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        CompoundResourceTraversal traversal = new CompoundResourceTraversal();
        int i = 0;
        while (i < mappings.length) {
            ResourceMapping mapping = mappings[i];
            ResourceTraversal[] traversals = mapping.getTraversals(context, monitor);
            traversal.addTraversals(traversals);
            ++i;
        }
        return traversal.asTraversals();
    }

    private static IResource[] getRootTraversalResources(ResourceMapping[] mappings, ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        HashSet<IResource> result = new HashSet<IResource>();
        ResourceTraversal[] traversals = WorkspaceTraversalAction.getTraversals(mappings, context, monitor);
        int i = 0;
        while (i < traversals.length) {
            ResourceTraversal traversal = traversals[i];
            IResource[] resources = traversal.getResources();
            int k = 0;
            while (k < resources.length) {
                IResource resource = resources[k];
                if (RepositoryProvider.getProvider((IProject)resource.getProject(), (String)CVSProviderPlugin.getTypeId()) != null) {
                    result.add(resource);
                }
                ++k;
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    protected Subscriber getWorkspaceSubscriber() {
        return CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber();
    }

    protected IResource[] getResourcesToCompare(Subscriber subscriber) throws InvocationTargetException {
        return WorkspaceTraversalAction.getResourcesToCompare(this.getCVSResourceMappings(), subscriber);
    }

    protected ResourceMappingContext getResourceMappingContext() {
        return SubscriberResourceMappingContext.createContext((Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber());
    }

    public static IResource[] getResourcesToCompare(final ResourceMapping[] mappings, final Subscriber subscriber) throws InvocationTargetException {
        final IResource[][] resources = new IResource[1][];
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        resources[0] = WorkspaceTraversalAction.getRootTraversalResources(mappings, (ResourceMappingContext)SubscriberResourceMappingContext.createContext((Subscriber)subscriber), monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return resources[0];
    }

    public static IResource[] getProjects(IResource[] resources) {
        HashSet<IProject> projects = new HashSet<IProject>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            projects.add(resource.getProject());
            ++i;
        }
        return projects.toArray(new IResource[projects.size()]);
    }

    public static boolean isLogicalModel(ResourceMapping[] mappings) {
        int i = 0;
        while (i < mappings.length) {
            ResourceMapping mapping = mappings[i];
            if (!(mapping.getModelObject() instanceof IResource)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected IFile getSelectedFile() {
        IResource resource;
        ResourceMapping[] mappings = this.getCVSResourceMappings();
        if (mappings.length == 1 && (resource = Utils.getResource((Object)mappings[0].getModelObject())) != null && resource.getType() == 1) {
            return (IFile)resource;
        }
        return null;
    }

    protected boolean hasOutgoingChanges(final RepositoryProviderOperation operation) throws InvocationTargetException, InterruptedException {
        final boolean[] hasChange = new boolean[1];
        PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(CVSUIMessages.WorkspaceTraversalAction_0, 100);
                        operation.buildScope(Policy.subMonitorFor(monitor, 50));
                        hasChange[0] = CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().hasLocalChanges(operation.getScope().getTraversals(), Policy.subMonitorFor(monitor, 50));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        });
        return hasChange[0];
    }
}

