/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ccvs.core.CVSMergeSubscriber;
import org.eclipse.team.internal.ccvs.ui.mappings.CVSSubscriberMergeContext;

public class MergeSubscriberContext
extends CVSSubscriberMergeContext {
    private boolean cancel = true;

    public static MergeSubscriberContext createContext(ISynchronizationScopeManager manager, Subscriber subscriber) {
        MergeSubscriberContext mergeContext = new MergeSubscriberContext(subscriber, manager);
        mergeContext.initialize();
        return mergeContext;
    }

    public MergeSubscriberContext(Subscriber subscriber, ISynchronizationScopeManager manager) {
        super(subscriber, manager);
    }

    public void markAsMerged(final IDiff diff, boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
        this.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ((CVSMergeSubscriber)MergeSubscriberContext.this.getSubscriber()).merged(new IResource[]{MergeSubscriberContext.this.getDiffTree().getResource(diff)});
            }
        }, this.getMergeRule(diff), 0, monitor);
    }

    public void markAsMerged(final IDiff[] diffs, boolean inSyncHint, IProgressMonitor monitor) throws CoreException {
        this.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ArrayList<IResource> result = new ArrayList<IResource>();
                int i = 0;
                while (i < diffs.length) {
                    IDiff diff = diffs[i];
                    result.add(MergeSubscriberContext.this.getDiffTree().getResource(diff));
                    ++i;
                }
                ((CVSMergeSubscriber)MergeSubscriberContext.this.getSubscriber()).merged(result.toArray(new IResource[result.size()]));
            }
        }, this.getMergeRule(diffs), 0, monitor);
    }

    public void dispose() {
        if (this.cancel) {
            ((CVSMergeSubscriber)this.getSubscriber()).cancel();
        }
        super.dispose();
    }

    public void setCancelSubscriber(boolean b) {
        this.cancel = b;
    }
}

