/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.team.internal.ccvs.core.CVSMergeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.mappings.ModelMergeOperation;
import org.eclipse.team.internal.ccvs.ui.mappings.ModelMergeParticipant;
import org.eclipse.team.internal.ccvs.ui.operations.UpdateOperation;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.team.internal.ccvs.ui.wizards.MergeWizardPage;
import org.eclipse.ui.IWorkbenchPart;

public class MergeWizard
extends Wizard {
    MergeWizardPage page;
    IResource[] resources;
    private final IWorkbenchPart part;
    private final ResourceMapping[] mappings;

    public MergeWizard(IWorkbenchPart part, IResource[] resources, ResourceMapping[] mappings) {
        this.part = part;
        this.resources = resources;
        this.mappings = mappings;
    }

    public void addPages() {
        this.setNeedsProgressMonitor(true);
        TagSource tagSource = TagSource.create(this.resources);
        this.setWindowTitle(CVSUIMessages.MergeWizard_title);
        ImageDescriptor mergeImage = CVSUIPlugin.getPlugin().getImageDescriptor("wizban/mergestream_wizban.png");
        this.page = new MergeWizardPage("mergePage", CVSUIMessages.MergeWizard_0, mergeImage, CVSUIMessages.MergeWizard_1, tagSource);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        CVSTag startTag = this.page.getStartTag();
        CVSTag endTag = this.page.getEndTag();
        if (startTag == null || !this.page.isPreview()) {
            UpdateOperation op = new UpdateOperation(this.getPart(), this.mappings, this.getLocalOptions(startTag, endTag), null);
            try {
                op.run();
            }
            catch (InvocationTargetException e) {
                CVSUIPlugin.openError(this.getShell(), null, null, e);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            ModelMergeParticipant participant = ModelMergeParticipant.getMatchingParticipant(this.mappings, startTag, endTag);
            if (participant == null) {
                CVSMergeSubscriber s = new CVSMergeSubscriber(this.getProjects(this.resources), startTag, endTag);
                try {
                    new ModelMergeOperation(this.getPart(), this.mappings, s, this.page.isOnlyPreviewConflicts()).run();
                }
                catch (InvocationTargetException e) {
                    CVSUIPlugin.log(4, "Internal error", e.getTargetException());
                }
                catch (InterruptedException interruptedException) {}
            } else {
                participant.refresh(null, this.mappings);
            }
        }
        return true;
    }

    private IResource[] getProjects(IResource[] resources) {
        HashSet<IProject> projects = new HashSet<IProject>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            projects.add(resource.getProject());
            ++i;
        }
        return projects.toArray(new IResource[projects.size()]);
    }

    private Command.LocalOption[] getLocalOptions(CVSTag startTag, CVSTag endTag) {
        ArrayList<Command.LocalOption> options = new ArrayList<Command.LocalOption>();
        if (startTag != null) {
            options.add(Command.makeArgumentOption((Command.LocalOption)Update.JOIN, (String)startTag.getName()));
        }
        options.add(Command.makeArgumentOption((Command.LocalOption)Update.JOIN, (String)endTag.getName()));
        return options.toArray(new Command.LocalOption[options.size()]);
    }

    private IWorkbenchPart getPart() {
        return this.part;
    }
}

