/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.launchConfigurations.TargetOrderDialog;
import org.eclipse.ant.internal.ui.launchConfigurations.TargetTableLabelProvider;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModelContentProvider;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntTargetNode;
import org.eclipse.ant.internal.ui.model.InternalTargetFilter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AntTargetsTab
extends AbstractLaunchConfigurationTab {
    private AntTargetNode fDefaultTarget = null;
    private AntTargetNode[] fAllTargets = null;
    private List fOrderedTargets = null;
    private CheckboxTableViewer fTableViewer = null;
    private Label fSelectionCountLabel = null;
    private Text fTargetOrderText = null;
    private Button fOrderButton = null;
    private Button fFilterInternalTargets;
    private InternalTargetFilter fInternalTargetFilter = null;
    private Button fSortButton;
    private ILaunchConfiguration fLaunchConfiguration;
    private int fSortDirection = 0;
    private boolean fInitializing = false;
    public static final int SORT_NONE = 0;
    public static final int SORT_NAME = 1;
    public static final int SORT_NAME_REVERSE = -1;
    public static final int SORT_DESCRIPTION = 2;
    public static final int SORT_DESCRIPTION_REVERSE = -2;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ant.ui.ant_targets_tab_context");
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        comp.setFont(font);
        this.createTargetsTable(comp);
        this.createSelectionCount(comp);
        Composite buttonComposite = new Composite(comp, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setFont(font);
        this.createSortTargets(buttonComposite);
        this.createFilterInternalTargets(buttonComposite);
        this.createVerticalSpacer(comp, 1);
        this.createTargetOrder(comp);
        Dialog.applyDialogFont((Control)parent);
    }

    private void createSelectionCount(Composite parent) {
        this.fSelectionCountLabel = new Label(parent, 0);
        this.fSelectionCountLabel.setFont(parent.getFont());
        this.fSelectionCountLabel.setText(AntLaunchConfigurationMessages.AntTargetsTab_0_out_of_0_selected_2);
        GridData gd = new GridData(768);
        this.fSelectionCountLabel.setLayoutData((Object)gd);
    }

    private void createTargetOrder(Composite parent) {
        Font font = parent.getFont();
        Label label = new Label(parent, 0);
        label.setText(AntLaunchConfigurationMessages.AntTargetsTab_Target_execution_order__3);
        label.setFont(font);
        Composite orderComposite = new Composite(parent, 0);
        GridData gd = new GridData(768);
        orderComposite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        orderComposite.setLayout((Layout)layout);
        orderComposite.setFont(font);
        this.fTargetOrderText = new Text(orderComposite, 2634);
        this.fTargetOrderText.setFont(font);
        gd = new GridData(768);
        gd.heightHint = 40;
        gd.widthHint = 200;
        this.fTargetOrderText.setLayoutData((Object)gd);
        this.fOrderButton = this.createPushButton(orderComposite, AntLaunchConfigurationMessages.AntTargetsTab__Order____4, null);
        gd = (GridData)this.fOrderButton.getLayoutData();
        gd.verticalAlignment = 1;
        this.fOrderButton.setFont(font);
        this.fOrderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntTargetsTab.this.handleOrderPressed();
            }
        });
    }

    private void createFilterInternalTargets(Composite parent) {
        this.fFilterInternalTargets = this.createCheckButton(parent, AntLaunchConfigurationMessages.AntTargetsTab_12);
        this.fFilterInternalTargets.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntTargetsTab.this.handleFilterTargetsSelected();
            }
        });
    }

    private void createSortTargets(Composite parent) {
        this.fSortButton = this.createCheckButton(parent, AntLaunchConfigurationMessages.AntTargetsTab_14);
        this.fSortButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntTargetsTab.this.handleSortTargetsSelected();
            }
        });
    }

    private void handleFilterTargetsSelected() {
        boolean filter = this.fFilterInternalTargets.getSelection();
        if (filter) {
            this.fTableViewer.addFilter(this.getInternalTargetsFilter());
        } else {
            this.fTableViewer.removeFilter(this.getInternalTargetsFilter());
        }
        this.updateSelectionCount();
        if (!this.fInitializing) {
            this.updateLaunchConfigurationDialog();
        }
    }

    private ViewerFilter getInternalTargetsFilter() {
        if (this.fInternalTargetFilter == null) {
            this.fInternalTargetFilter = new InternalTargetFilter();
        }
        return this.fInternalTargetFilter;
    }

    private void handleSortTargetsSelected() {
        this.setSort(this.fSortButton.getSelection() ? 1 : 0);
    }

    private void setSort(int column) {
        this.fSortDirection = column;
        this.fTableViewer.refresh();
        if (!this.fInitializing) {
            this.updateLaunchConfigurationDialog();
        }
    }

    private void handleOrderPressed() {
        TargetOrderDialog dialog = new TargetOrderDialog(this.getShell(), this.fOrderedTargets.toArray());
        int ok = dialog.open();
        if (ok == 0) {
            this.fOrderedTargets.clear();
            Object[] targets = dialog.getTargets();
            int i = 0;
            while (i < targets.length) {
                this.fOrderedTargets.add(targets[i]);
                this.updateSelectionCount();
                this.updateLaunchConfigurationDialog();
                ++i;
            }
        }
    }

    private void createTargetsTable(Composite parent) {
        Font font = parent.getFont();
        Label label = new Label(parent, 0);
        label.setFont(font);
        label.setText(AntLaunchConfigurationMessages.AntTargetsTab_Check_targets_to_e_xecute__1);
        Table table = new Table(parent, 67632);
        GridData data = new GridData(1808);
        int availableRows = this.availableRows(parent);
        data.heightHint = table.getItemHeight() * (availableRows / 20);
        data.widthHint = 250;
        table.setLayoutData((Object)data);
        table.setFont(font);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        ColumnWeightData weightData = new ColumnWeightData(30, true);
        tableLayout.addColumnData((ColumnLayoutData)weightData);
        weightData = new ColumnWeightData(70, true);
        tableLayout.addColumnData((ColumnLayoutData)weightData);
        table.setLayout((Layout)tableLayout);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(AntLaunchConfigurationMessages.AntTargetsTab_Name_5);
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(AntLaunchConfigurationMessages.AntTargetsTab_Description_6);
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TargetTableLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new AntModelContentProvider());
        this.fTableViewer.setSorter((ViewerSorter)new AntTargetsSorter());
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    Object element = ss.getFirstElement();
                    boolean checked = !AntTargetsTab.this.fTableViewer.getChecked(element);
                    AntTargetsTab.this.fTableViewer.setChecked(element, checked);
                    AntTargetsTab.this.updateOrderedTargets(element, checked);
                }
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AntTargetsTab.this.updateOrderedTargets(event.getElement(), event.getChecked());
            }
        });
        TableColumn[] columns = this.fTableViewer.getTable().getColumns();
        int i = 0;
        while (i < columns.length) {
            final int index = i++;
            columns[index].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (AntTargetsTab.this.fSortButton.getSelection()) {
                        int column = index + 1;
                        if (column == AntTargetsTab.this.fSortDirection) {
                            column = -column;
                        }
                        AntTargetsTab.this.setSort(column);
                    }
                }
            });
        }
    }

    private int availableRows(Composite parent) {
        int fontHeight = parent.getFont().getFontData()[0].getHeight();
        int displayHeight = parent.getDisplay().getClientArea().height;
        return displayHeight / fontHeight;
    }

    private void updateOrderedTargets(Object element, boolean checked) {
        if (checked) {
            this.fOrderedTargets.add(element);
        } else {
            this.fOrderedTargets.remove(element);
        }
        this.updateSelectionCount();
        this.updateLaunchConfigurationDialog();
    }

    private void updateSelectionCount() {
        Object[] checked = this.fTableViewer.getCheckedElements();
        String numSelected = Integer.toString(checked.length);
        int all = this.fAllTargets == null ? 0 : this.fAllTargets.length;
        int visible = this.fTableViewer.getTable().getItemCount();
        String total = Integer.toString(visible);
        int numHidden = all - visible;
        if (numHidden > 0) {
            this.fSelectionCountLabel.setText(MessageFormat.format(AntLaunchConfigurationMessages.AntTargetsTab_13, numSelected, String.valueOf(all), String.valueOf(numHidden)));
        } else {
            this.fSelectionCountLabel.setText(MessageFormat.format(AntLaunchConfigurationMessages.AntTargetsTab__0__out_of__1__selected_7, numSelected, total));
        }
        this.fOrderButton.setEnabled(checked.length > 1);
        StringBuffer buffer = new StringBuffer();
        Iterator iter = this.fOrderedTargets.iterator();
        while (iter.hasNext()) {
            buffer.append(((AntTargetNode)iter.next()).getTargetName());
            buffer.append(", ");
        }
        if (buffer.length() > 2) {
            buffer.setLength(buffer.length() - 2);
        }
        this.fTargetOrderText.setText(buffer.toString());
    }

    private AntTargetNode[] getTargets() {
        if (this.fAllTargets == null || this.isDirty()) {
            this.fAllTargets = null;
            this.fDefaultTarget = null;
            this.setDirty(false);
            this.setErrorMessage(null);
            this.setMessage(null);
            final String expandedLocation = this.validateLocation();
            if (expandedLocation == null) {
                return this.fAllTargets;
            }
            final CoreException[] exceptions = new CoreException[1];
            try {
                IRunnableWithProgress operation = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            AntTargetsTab.this.fAllTargets = AntUtil.getTargets(expandedLocation, AntTargetsTab.this.fLaunchConfiguration);
                        }
                        catch (CoreException ce) {
                            exceptions[0] = ce;
                        }
                    }
                };
                IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (context == null) {
                    context = this.getLaunchConfigurationDialog();
                }
                IFile rule = null;
                if (!ResourcesPlugin.getWorkspace().isTreeLocked()) {
                    rule = AntUtil.getFileForLocation(expandedLocation, null);
                }
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, operation, (ISchedulingRule)rule);
            }
            catch (InvocationTargetException e) {
                AntUIPlugin.log("Internal error occurred retrieving targets", e.getTargetException());
                this.setErrorMessage(AntLaunchConfigurationMessages.AntTargetsTab_1);
                this.fAllTargets = null;
                return null;
            }
            catch (InterruptedException e) {
                AntUIPlugin.log("Internal error occurred retrieving targets", e);
                this.setErrorMessage(AntLaunchConfigurationMessages.AntTargetsTab_1);
                this.fAllTargets = null;
                return null;
            }
            if (exceptions[0] != null) {
                IStatus exceptionStatus = exceptions[0].getStatus();
                IStatus[] children = exceptionStatus.getChildren();
                StringBuffer message = new StringBuffer(exceptions[0].getMessage());
                int i = 0;
                while (i < children.length) {
                    message.append(' ');
                    IStatus childStatus = children[i];
                    message.append(childStatus.getMessage());
                    ++i;
                }
                this.setErrorMessage(message.toString());
                this.fAllTargets = null;
                return this.fAllTargets;
            }
            if (this.fAllTargets == null) {
                return this.fAllTargets;
            }
            AntTargetNode target = this.fAllTargets[0];
            AntProjectNode projectNode = target.getProjectNode();
            this.setErrorMessageFromNode(projectNode);
            int i = 0;
            while (i < this.fAllTargets.length) {
                target = this.fAllTargets[i];
                if (target.isDefaultTarget()) {
                    this.fDefaultTarget = target;
                }
                this.setErrorMessageFromNode(target);
                ++i;
            }
        }
        return this.fAllTargets;
    }

    private void setErrorMessageFromNode(AntElementNode node) {
        if (this.getErrorMessage() != null) {
            return;
        }
        if (node.isErrorNode() || node.isWarningNode()) {
            String message = node.getProblemMessage();
            if (message != null) {
                this.setErrorMessage(message);
            } else {
                this.setErrorMessage(AntLaunchConfigurationMessages.AntTargetsTab_0);
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fInitializing = true;
        this.fLaunchConfiguration = configuration;
        this.fOrderedTargets = new ArrayList();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setDirty(true);
        boolean hideInternal = false;
        try {
            hideInternal = this.fLaunchConfiguration.getAttribute("org.eclipse.ui.externaltools.ATTR_HIDE_INTERNAL_TARGETS", false);
        }
        catch (CoreException e) {
            AntUIPlugin.log(e);
        }
        this.fFilterInternalTargets.setSelection(hideInternal);
        this.handleFilterTargetsSelected();
        int sort = 0;
        try {
            sort = this.fLaunchConfiguration.getAttribute("org.eclipse.ui.externaltoolsATTR_SORT_TARGETS", sort);
        }
        catch (CoreException e) {
            AntUIPlugin.log(e);
        }
        this.fSortButton.setSelection(sort != 0);
        this.setSort(sort);
        String configTargets = null;
        String newLocation = null;
        try {
            configTargets = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", null);
            newLocation = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
        }
        catch (CoreException ce) {
            AntUIPlugin.log(AntLaunchConfigurationMessages.AntTargetsTab_Error_reading_configuration_12, ce);
        }
        if (newLocation == null) {
            this.fAllTargets = null;
            this.initializeForNoTargets();
            return;
        }
        AntTargetNode[] allTargetNodes = this.getTargets();
        if (allTargetNodes == null) {
            this.initializeForNoTargets();
            return;
        }
        String[] targetNames = AntUtil.parseRunTargets(configTargets);
        if (targetNames.length == 0) {
            this.fTableViewer.setAllChecked(false);
            this.setExecuteInput(allTargetNodes);
            if (this.fDefaultTarget != null) {
                this.fOrderedTargets.add(this.fDefaultTarget);
                this.fTableViewer.setChecked((Object)this.fDefaultTarget, true);
                this.updateSelectionCount();
                this.updateLaunchConfigurationDialog();
            }
            this.fInitializing = false;
            return;
        }
        this.setExecuteInput(allTargetNodes);
        this.fTableViewer.setAllChecked(false);
        int i = 0;
        while (i < targetNames.length) {
            int j = 0;
            while (j < this.fAllTargets.length) {
                if (targetNames[i].equals(this.fAllTargets[j].getTargetName())) {
                    this.fOrderedTargets.add(this.fAllTargets[j]);
                    this.fTableViewer.setChecked((Object)this.fAllTargets[j], true);
                }
                ++j;
            }
            ++i;
        }
        this.updateSelectionCount();
        this.fInitializing = false;
    }

    private void initializeForNoTargets() {
        this.setExecuteInput(new AntTargetNode[0]);
        this.fTableViewer.setInput((Object)new AntTargetNode[0]);
        this.fInitializing = false;
    }

    private void setExecuteInput(Object input) {
        this.fTableViewer.setInput(input);
        this.updateSelectionCount();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fFilterInternalTargets.getSelection()) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_HIDE_INTERNAL_TARGETS", true);
        } else {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_HIDE_INTERNAL_TARGETS", null);
        }
        if (this.fSortDirection != 0) {
            configuration.setAttribute("org.eclipse.ui.externaltoolsATTR_SORT_TARGETS", this.fSortDirection);
        } else {
            configuration.setAttribute("org.eclipse.ui.externaltoolsATTR_SORT_TARGETS", null);
        }
        if (this.fOrderedTargets.size() == 1) {
            AntTargetNode item = (AntTargetNode)this.fOrderedTargets.get(0);
            if (item.isDefaultTarget()) {
                configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", null);
                return;
            }
        } else if (this.fOrderedTargets.size() == 0) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", null);
            return;
        }
        StringBuffer buff = new StringBuffer();
        Iterator iter = this.fOrderedTargets.iterator();
        String targets = null;
        while (iter.hasNext()) {
            AntTargetNode item = (AntTargetNode)iter.next();
            buff.append(item.getTargetName());
            buff.append(',');
        }
        if (buff.length() > 0) {
            targets = buff.toString();
        }
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", targets);
    }

    public String getName() {
        return AntLaunchConfigurationMessages.AntTargetsTab_Tar_gets_14;
    }

    public Image getImage() {
        return AntUIImages.getImage("org.eclipse.ant.ui.IMG_TAB_ANT_TARGETS");
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (this.fAllTargets == null || this.isDirty()) {
            if (this.getErrorMessage() != null && !this.isDirty()) {
                return false;
            }
            this.initializeFrom(launchConfig);
            if (this.getErrorMessage() != null) {
                return false;
            }
        }
        this.setErrorMessage(null);
        return super.isValid(launchConfig);
    }

    protected void setDirty(boolean dirty) {
        super.setDirty(dirty);
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        if (this.isDirty()) {
            super.activated(workingCopy);
        }
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
        if (this.fOrderedTargets.size() == 0) {
            this.setDirty(true);
        }
    }

    private String validateLocation() {
        String expandedLocation;
        block12: {
            File file;
            block11: {
                block10: {
                    IStringVariableManager manager;
                    String location;
                    block9: {
                        expandedLocation = null;
                        location = null;
                        manager = VariablesPlugin.getDefault().getStringVariableManager();
                        try {
                            location = this.fLaunchConfiguration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
                            if (location != null) break block9;
                            return null;
                        }
                        catch (CoreException e1) {
                            if (location != null) {
                                try {
                                    manager.validateStringVariables(location);
                                    this.setMessage(AntLaunchConfigurationMessages.AntTargetsTab_17);
                                    return null;
                                }
                                catch (CoreException e2) {
                                    this.setErrorMessage(e2.getStatus().getMessage());
                                    return null;
                                }
                            }
                            this.setErrorMessage(e1.getStatus().getMessage());
                            return null;
                        }
                    }
                    expandedLocation = manager.performStringSubstitution(location);
                    if (expandedLocation != null) break block10;
                    return null;
                }
                file = new File(expandedLocation);
                if (file.exists()) break block11;
                this.setErrorMessage(AntLaunchConfigurationMessages.AntTargetsTab_15);
                return null;
            }
            if (file.isFile()) break block12;
            this.setErrorMessage(AntLaunchConfigurationMessages.AntTargetsTab_16);
            return null;
        }
        return expandedLocation;
    }

    protected boolean isTargetSelected() {
        return !this.fOrderedTargets.isEmpty();
    }

    private class AntTargetsSorter
    extends ViewerSorter {
        private AntTargetsSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String string2;
            String string1;
            if (!(e1 instanceof AntTargetNode) || !(e2 instanceof AntTargetNode)) {
                return super.compare(viewer, e1, e2);
            }
            if (AntTargetsTab.this.fSortDirection == 0) {
                return 0;
            }
            int result = 0;
            if (AntTargetsTab.this.fSortDirection == 1 || AntTargetsTab.this.fSortDirection == -1) {
                string1 = ((AntTargetNode)e1).getLabel();
                string2 = ((AntTargetNode)e2).getLabel();
            } else {
                string1 = ((AntTargetNode)e1).getTarget().getDescription();
                string2 = ((AntTargetNode)e2).getTarget().getDescription();
            }
            if (string1 != null && string2 != null) {
                result = this.getCollator().compare(string1, string2);
            } else if (string1 == null) {
                result = 1;
            } else if (string2 == null) {
                result = -1;
            }
            if (AntTargetsTab.this.fSortDirection < 0) {
                result = result == 0 ? -1 : -result;
            }
            return result;
        }
    }
}

