/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.core.filebuffers.manipulation.ContainerCreator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.DocumentReader;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.editors.text.TextEditorMessages;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.internal.editors.text.WorkspaceOperationRunner;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class FileDocumentProvider
extends StorageDocumentProvider {
    private static final QualifiedName ENCODING_KEY = new QualifiedName("org.eclipse.ui.editors", "encoding");
    private static final String CHARSET_UTF_8 = "UTF-8";
    private WorkspaceOperationRunner fOperationRunner;
    private IResourceRuleFactory fResourceRuleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput) throws CoreException {
        if (!(editorInput instanceof IFileEditorInput)) return super.setDocumentContent(document, editorInput);
        IFile file = ((IFileEditorInput)editorInput).getFile();
        InputStream stream = file.getContents(false);
        try {
            this.setDocumentContent(document, stream);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (IOException iOException) {}
        stream.close();
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        if (!(editorInput instanceof IFileEditorInput)) return super.setDocumentContent(document, editorInput, encoding);
        IFile file = ((IFileEditorInput)editorInput).getFile();
        InputStream contentStream = file.getContents(false);
        try {
            try {
                FileInfo info = (FileInfo)this.getElementInfo(editorInput);
                boolean removeBOM = false;
                if (CHARSET_UTF_8.equals(encoding)) {
                    removeBOM = info != null ? info.fHasBOM : this.hasBOM(editorInput);
                }
                if (removeBOM) {
                    int bytes;
                    int n = 0;
                    do {
                        if ((bytes = contentStream.read(new byte[IContentDescription.BOM_UTF_8.length])) != -1) continue;
                        throw new IOException();
                    } while ((n += bytes) < IContentDescription.BOM_UTF_8.length);
                }
                this.setDocumentContent(document, contentStream, encoding);
            }
            catch (IOException ex) {
                String message = ex.getMessage() != null ? ex.getMessage() : "";
                Status s = new Status(4, "org.eclipse.ui", 0, message, (Throwable)ex);
                throw new CoreException((IStatus)s);
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            try {
                contentStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var10_15 = null;
        }
        try {}
        catch (IOException iOException) {}
        contentStream.close();
        return true;
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return new ResourceMarkerAnnotationModel((IResource)input.getFile());
        }
        return super.createAnnotationModel(element);
    }

    protected void checkSynchronizationState(long cachedModificationStamp, IResource resource) throws CoreException {
        if (cachedModificationStamp != this.computeModificationStamp(resource)) {
            Status status = new Status(4, "org.eclipse.ui", 274, TextEditorMessages.FileDocumentProvider_error_out_of_sync, null);
            throw new CoreException((IStatus)status);
        }
    }

    protected long computeModificationStamp(IResource resource) {
        long modificationStamp = resource.getModificationStamp();
        IPath path = resource.getLocation();
        if (path == null) {
            return modificationStamp;
        }
        modificationStamp = path.toFile().lastModified();
        return modificationStamp;
    }

    public long getModificationStamp(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return this.computeModificationStamp((IResource)input.getFile());
        }
        return super.getModificationStamp(element);
    }

    public long getSynchronizationStamp(Object element) {
        FileInfo info;
        if (element instanceof IFileEditorInput && (info = (FileInfo)this.getElementInfo(element)) != null) {
            return info.fModificationStamp;
        }
        return super.getSynchronizationStamp(element);
    }

    protected void doSynchronize(Object element, IProgressMonitor monitor) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            FileInfo info = (FileInfo)this.getElementInfo(element);
            if (info != null) {
                if (info.fFileSynchronizer != null) {
                    info.fFileSynchronizer.uninstall();
                    this.refreshFile(input.getFile(), monitor);
                    info.fFileSynchronizer.install();
                } else {
                    this.refreshFile(input.getFile(), monitor);
                }
                this.handleElementContentChanged((IFileEditorInput)element);
            }
            return;
        }
        super.doSynchronize(element, monitor);
    }

    public boolean isDeleted(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            IPath path = input.getFile().getLocation();
            if (path == null) {
                return true;
            }
            return !path.toFile().exists();
        }
        return super.isDeleted(element);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        Object var13_22;
        InputStream stream;
        Charset charset;
        if (!(element instanceof IFileEditorInput)) {
            super.doSaveDocument(monitor, element, document, overwrite);
            return;
        }
        IFileEditorInput input = (IFileEditorInput)element;
        String encoding = null;
        FileInfo info = (FileInfo)this.getElementInfo(element);
        IFile file = input.getFile();
        encoding = this.getCharsetForNewFile(file, document, info);
        try {
            charset = Charset.forName(encoding);
        }
        catch (UnsupportedCharsetException ex) {
            String message = NLSUtility.format(TextEditorMessages.DocumentProvider_error_unsupported_encoding_message_arg, encoding);
            Status s = new Status(4, "org.eclipse.ui.editors", 0, message, (Throwable)ex);
            throw new CoreException((IStatus)s);
        }
        catch (IllegalCharsetNameException ex) {
            String message = NLSUtility.format(TextEditorMessages.DocumentProvider_error_illegal_encoding_message_arg, encoding);
            Status s = new Status(4, "org.eclipse.ui.editors", 0, message, (Throwable)ex);
            throw new CoreException((IStatus)s);
        }
        CharsetEncoder encoder = charset.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.REPLACE);
        encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            byte[] bytes;
            ByteBuffer byteBuffer = encoder.encode(CharBuffer.wrap(document.get()));
            if (byteBuffer.hasArray()) {
                bytes = byteBuffer.array();
            } else {
                bytes = new byte[byteBuffer.limit()];
                byteBuffer.get(bytes);
            }
            stream = new ByteArrayInputStream(bytes, 0, byteBuffer.limit());
        }
        catch (CharacterCodingException ex) {
            Assert.isTrue((boolean)(ex instanceof UnmappableCharacterException));
            String message = NLSUtility.format(TextEditorMessages.DocumentProvider_error_charset_mapping_failed_message_arg, encoding);
            Status s = new Status(4, "org.eclipse.ui.editors", 1, message, null);
            throw new CoreException((IStatus)s);
        }
        if (info != null && info.fHasBOM && CHARSET_UTF_8.equals(encoding)) {
            stream = new SequenceInputStream(new ByteArrayInputStream(IContentDescription.BOM_UTF_8), stream);
        }
        if (file.exists()) {
            if (info != null && !overwrite) {
                this.checkSynchronizationState(info.fModificationStamp, (IResource)file);
            }
            this.fireElementStateChanging(element);
            try {
                file.setContents(stream, overwrite, true, monitor);
            }
            catch (CoreException x) {
                this.fireElementStateChangeFailed(element);
                throw x;
            }
            catch (RuntimeException x) {
                this.fireElementStateChangeFailed(element);
                throw x;
            }
            if (info == null) return;
            ResourceMarkerAnnotationModel model = (ResourceMarkerAnnotationModel)info.fModel;
            if (model != null) {
                model.updateMarkers(info.fDocument);
            }
            info.fModificationStamp = this.computeModificationStamp((IResource)file);
            return;
        }
        try {
            monitor.beginTask(TextEditorMessages.FileDocumentProvider_task_saving, 2000);
            ContainerCreator creator = new ContainerCreator(file.getWorkspace(), file.getParent().getFullPath());
            creator.createContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            file.create(stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        catch (Throwable throwable) {
            var13_22 = null;
            monitor.done();
            throw throwable;
        }
        {
            var13_22 = null;
            monitor.done();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCharsetForNewFile(IFile targetFile, IDocument document, FileInfo info) {
        DocumentReader reader;
        block15: {
            String string;
            String encoding;
            try {
                encoding = targetFile.getCharset(false);
            }
            catch (CoreException coreException) {
                encoding = null;
            }
            if (encoding != null) {
                return encoding;
            }
            reader = new DocumentReader(document);
            try {
                try {
                    QualifiedName[] options = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
                    IContentDescription description = Platform.getContentTypeManager().getDescriptionFor((Reader)reader, targetFile.getName(), options);
                    if (description == null || (encoding = description.getCharset()) == null) break block15;
                    string = encoding;
                    Object var8_9 = null;
                }
                catch (IOException iOException) {
                    break block15;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    ((Reader)reader).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            ((Reader)reader).close();
            return string;
        }
        Object var8_11 = null;
        try {}
        catch (IOException iOException) {}
        ((Reader)reader).close();
        if (info != null && info.fHasBOM) {
            return info.fEncoding;
        }
        try {
            return targetFile.getParent().getDefaultCharset();
        }
        catch (CoreException coreException) {
            return ResourcesPlugin.getEncoding();
        }
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        if (element instanceof IFileEditorInput) {
            String initalLineDelimiter;
            IFileEditorInput input = (IFileEditorInput)element;
            try {
                this.refreshFile(input.getFile());
            }
            catch (CoreException x) {
                this.handleCoreException(x, TextEditorMessages.FileDocumentProvider_createElementInfo);
            }
            IDocument d = null;
            IStatus s = null;
            try {
                d = this.createDocument(element);
            }
            catch (CoreException x) {
                this.handleCoreException(x, TextEditorMessages.FileDocumentProvider_createElementInfo);
                s = x.getStatus();
                d = this.createEmptyDocument();
            }
            if (d instanceof IDocumentExtension4 && (initalLineDelimiter = this.getLineDelimiterPreference(input.getFile())) != null) {
                ((IDocumentExtension4)d).setInitialLineDelimiter(initalLineDelimiter);
            }
            IAnnotationModel m = this.createAnnotationModel(element);
            FileSynchronizer f = new FileSynchronizer(input);
            f.install();
            FileInfo info = new FileInfo(d, m, f);
            info.fModificationStamp = this.computeModificationStamp((IResource)input.getFile());
            info.fStatus = s;
            info.fEncoding = this.getPersistedEncoding(element);
            info.fHasBOM = this.hasBOM(element);
            this.cacheEncodingState(element);
            return info;
        }
        return super.createElementInfo(element);
    }

    private String getLineDelimiterPreference(IFile file) {
        IScopeContext[] scopeContext;
        if (file != null && file.getProject() != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(file.getProject())};
            String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineDelimiter != null) {
                return lineDelimiter;
            }
        }
        scopeContext = new IScopeContext[]{new InstanceScope()};
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        if (info instanceof FileInfo) {
            FileInfo fileInfo = (FileInfo)info;
            if (fileInfo.fFileSynchronizer != null) {
                fileInfo.fFileSynchronizer.uninstall();
            }
        }
        super.disposeElementInfo(element, info);
    }

    protected void handleElementContentChanged(IFileEditorInput fileEditorInput) {
        FileInfo info = (FileInfo)this.getElementInfo(fileEditorInput);
        if (info == null) {
            return;
        }
        IDocument document = this.createEmptyDocument();
        IStatus status = null;
        try {
            try {
                this.refreshFile(fileEditorInput.getFile());
            }
            catch (CoreException x) {
                this.handleCoreException(x, "FileDocumentProvider.handleElementContentChanged");
            }
            this.cacheEncodingState(fileEditorInput);
            this.setDocumentContent(document, (IEditorInput)fileEditorInput, info.fEncoding);
        }
        catch (CoreException x) {
            status = x.getStatus();
        }
        String newContent = document.get();
        if (!newContent.equals(info.fDocument.get())) {
            this.fireElementContentAboutToBeReplaced(fileEditorInput);
            this.removeUnchangedElementListeners(fileEditorInput, info);
            info.fDocument.removeDocumentListener((IDocumentListener)info);
            info.fDocument.set(newContent);
            info.fCanBeSaved = false;
            info.fModificationStamp = this.computeModificationStamp((IResource)fileEditorInput.getFile());
            info.fStatus = status;
            this.addUnchangedElementListeners(fileEditorInput, info);
            this.fireElementContentReplaced(fileEditorInput);
        } else {
            this.removeUnchangedElementListeners(fileEditorInput, info);
            info.fCanBeSaved = false;
            info.fModificationStamp = this.computeModificationStamp((IResource)fileEditorInput.getFile());
            info.fStatus = status;
            this.addUnchangedElementListeners(fileEditorInput, info);
            this.fireElementDirtyStateChanged(fileEditorInput, false);
        }
    }

    protected void handleElementMoved(IFileEditorInput fileEditorInput, IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile newFile = workspace.getRoot().getFile(path);
        this.fireElementMoved(fileEditorInput, newFile == null ? null : new FileEditorInput(newFile));
    }

    protected void handleElementDeleted(IFileEditorInput fileEditorInput) {
        this.fireElementDeleted(fileEditorInput);
    }

    protected AbstractDocumentProvider.ElementInfo getElementInfo(Object element) {
        return super.getElementInfo(element);
    }

    protected void doValidateState(Object element, Object computationContext) throws CoreException {
        IFile file;
        IFileEditorInput input;
        FileInfo info;
        if (element instanceof IFileEditorInput && (info = (FileInfo)this.getElementInfo(input = (IFileEditorInput)element)) != null && (file = input.getFile()).isReadOnly()) {
            IWorkspace workspace = file.getWorkspace();
            workspace.validateEdit(new IFile[]{file}, computationContext);
        }
        super.doValidateState(element, computationContext);
    }

    public boolean isModifiable(Object element) {
        if (!this.isStateValidated(element) && element instanceof IFileEditorInput) {
            return true;
        }
        return super.isModifiable(element);
    }

    protected void doResetDocument(Object element, IProgressMonitor monitor) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            try {
                this.refreshFile(input.getFile(), monitor);
                this.cacheEncodingState(element);
            }
            catch (CoreException x) {
                this.handleCoreException(x, TextEditorMessages.FileDocumentProvider_resetDocument);
            }
        }
        super.doResetDocument(element, monitor);
        IAnnotationModel model = this.getAnnotationModel(element);
        if (model instanceof AbstractMarkerAnnotationModel) {
            AbstractMarkerAnnotationModel markerModel = (AbstractMarkerAnnotationModel)model;
            markerModel.resetMarkers();
        }
    }

    protected void refreshFile(IFile file) throws CoreException {
        this.refreshFile(file, this.getProgressMonitor());
    }

    protected void refreshFile(IFile file, IProgressMonitor monitor) throws CoreException {
        try {
            file.refreshLocal(2, monitor);
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    public boolean isSynchronized(Object element) {
        if (element instanceof IFileEditorInput) {
            if (this.getElementInfo(element) != null) {
                IFileEditorInput input = (IFileEditorInput)element;
                IFile resource = input.getFile();
                return resource.isSynchronized(0);
            }
            return false;
        }
        return super.isSynchronized(element);
    }

    public IContentType getContentType(Object element) throws CoreException {
        IContentType contentType = null;
        if (!this.canSaveDocument(element) && element instanceof IFileEditorInput) {
            contentType = this.getContentType((IFileEditorInput)element);
        }
        if (contentType == null) {
            contentType = super.getContentType(element);
        }
        if (contentType == null && element instanceof IFileEditorInput) {
            contentType = this.getContentType((IFileEditorInput)element);
        }
        return contentType;
    }

    private IContentType getContentType(IFileEditorInput input) throws CoreException {
        IContentDescription desc = input.getFile().getContentDescription();
        if (desc != null) {
            return desc.getContentType();
        }
        return null;
    }

    protected String getPersistedEncoding(Object element) {
        IFileEditorInput editorInput;
        IFile file;
        if (element instanceof IFileEditorInput && (file = (editorInput = (IFileEditorInput)element).getFile()) != null) {
            String encoding = null;
            try {
                encoding = file.getPersistentProperty(ENCODING_KEY);
            }
            catch (CoreException coreException) {}
            if (encoding != null) {
                try {
                    file.setCharset(encoding, this.getProgressMonitor());
                    file.setPersistentProperty(ENCODING_KEY, null);
                }
                catch (CoreException ex) {
                    this.handleCoreException(ex, TextEditorMessages.FileDocumentProvider_getPersistedEncoding);
                }
            } else {
                try {
                    encoding = file.getCharset();
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            return encoding;
        }
        return super.getPersistedEncoding(element);
    }

    protected void persistEncoding(Object element, String encoding) throws CoreException {
        IFileEditorInput editorInput;
        IFile file;
        if (element instanceof IFileEditorInput && (file = (editorInput = (IFileEditorInput)element).getFile()) != null) {
            file.setCharset(encoding, this.getProgressMonitor());
            StorageDocumentProvider.StorageInfo info = (StorageDocumentProvider.StorageInfo)this.getElementInfo(element);
            if (info != null) {
                if (encoding == null) {
                    info.fEncoding = file.getCharset();
                }
                if (info instanceof FileInfo) {
                    ((FileInfo)info).fHasBOM = this.hasBOM(element);
                }
            }
        }
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        if (this.fOperationRunner == null) {
            this.fOperationRunner = new WorkspaceOperationRunner();
        }
        this.fOperationRunner.setProgressMonitor(monitor);
        return this.fOperationRunner;
    }

    protected ISchedulingRule getResetRule(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return this.fResourceRuleFactory.refreshRule((IResource)input.getFile());
        }
        return null;
    }

    protected ISchedulingRule getSaveRule(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return this.computeSchedulingRule((IResource)input.getFile());
        }
        return null;
    }

    protected ISchedulingRule getSynchronizeRule(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return this.fResourceRuleFactory.refreshRule((IResource)input.getFile());
        }
        return null;
    }

    protected ISchedulingRule getValidateStateRule(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return this.fResourceRuleFactory.validateEditRule(new IResource[]{input.getFile()});
        }
        return null;
    }

    private boolean hasBOM(Object element) {
        IFile file;
        if (element instanceof IFileEditorInput && (file = ((IFileEditorInput)element).getFile()) != null) {
            try {
                IContentDescription description = file.getContentDescription();
                return description != null && description.getProperty(IContentDescription.BYTE_ORDER_MARK) != null;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return false;
    }

    protected void readUTF8BOM(IFile file, String encoding, Object element) throws CoreException {
    }

    protected void cacheEncodingState(Object element) throws CoreException {
        IFileEditorInput editorInput;
        IFile file;
        if (element instanceof IFileEditorInput && (file = (editorInput = (IFileEditorInput)element).getFile()) != null) {
            AbstractDocumentProvider.ElementInfo info = this.getElementInfo(element);
            if (info instanceof StorageDocumentProvider.StorageInfo) {
                ((StorageDocumentProvider.StorageInfo)info).fEncoding = this.getPersistedEncoding(element);
            }
            if (info instanceof FileInfo) {
                ((FileInfo)info).fHasBOM = this.hasBOM(element);
            }
        }
    }

    private ISchedulingRule computeSchedulingRule(IResource toCreateOrModify) {
        if (toCreateOrModify.exists()) {
            return this.fResourceRuleFactory.modifyRule(toCreateOrModify);
        }
        IResource parent = toCreateOrModify;
        while ((parent = (toCreateOrModify = parent).getParent()) != null && !parent.exists()) {
        }
        return this.fResourceRuleFactory.createRule(toCreateOrModify);
    }

    protected class SafeChange
    implements Runnable {
        private IFileEditorInput fInput;

        public SafeChange(IFileEditorInput input) {
            this.fInput = input;
        }

        protected void execute(IFileEditorInput input) throws Exception {
        }

        public void run() {
            if (FileDocumentProvider.this.getElementInfo(this.fInput) == null) {
                FileDocumentProvider.this.fireElementStateChangeFailed(this.fInput);
                return;
            }
            try {
                this.execute(this.fInput);
            }
            catch (Exception exception) {
                FileDocumentProvider.this.fireElementStateChangeFailed(this.fInput);
            }
        }
    }

    protected class FileSynchronizer
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        protected IFileEditorInput fFileEditorInput;
        protected boolean fIsInstalled = false;

        public FileSynchronizer(IFileEditorInput fileEditorInput) {
            this.fFileEditorInput = fileEditorInput;
        }

        public FileSynchronizer(FileEditorInput fileEditorInput) {
            this.fFileEditorInput = fileEditorInput;
        }

        protected IFile getFile() {
            return this.fFileEditorInput.getFile();
        }

        public void install() {
            this.getFile().getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            this.fIsInstalled = true;
        }

        public void uninstall() {
            this.getFile().getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            this.fIsInstalled = false;
        }

        public void resourceChanged(IResourceChangeEvent e) {
            IResourceDelta delta = e.getDelta();
            try {
                if (delta != null && this.fIsInstalled) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException x) {
                FileDocumentProvider.this.handleCoreException(x, "FileDocumentProvider.resourceChanged");
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta == null) {
                return false;
            }
            if ((delta = delta.findMember(this.getFile().getFullPath())) == null) {
                return false;
            }
            SafeChange runnable = null;
            switch (delta.getKind()) {
                case 4: {
                    boolean isSynchronized;
                    FileInfo info = (FileInfo)FileDocumentProvider.this.getElementInfo(this.fFileEditorInput);
                    if (info == null || info.fCanBeSaved) break;
                    boolean bl = isSynchronized = FileDocumentProvider.this.computeModificationStamp((IResource)this.getFile()) == info.fModificationStamp;
                    if ((0x100000 & delta.getFlags()) != 0 && isSynchronized) {
                        runnable = new SafeChange(this, FileDocumentProvider.this, this.fFileEditorInput){
                            final /* synthetic */ FileSynchronizer this$1;
                            {
                                this.this$1 = fileSynchronizer;
                            }

                            protected void execute(IFileEditorInput input) throws Exception {
                                FileSynchronizer.access$0(this.this$1).handleElementContentChanged(input);
                            }
                        };
                    }
                    if (runnable != null || (0x100 & delta.getFlags()) == 0 || isSynchronized) break;
                    runnable = new SafeChange(this, FileDocumentProvider.this, this.fFileEditorInput){
                        final /* synthetic */ FileSynchronizer this$1;
                        {
                            this.this$1 = fileSynchronizer;
                        }

                        protected void execute(IFileEditorInput input) throws Exception {
                            FileSynchronizer.access$0(this.this$1).handleElementContentChanged(input);
                        }
                    };
                    break;
                }
                case 2: {
                    if ((0x2000 & delta.getFlags()) != 0) {
                        IPath path = delta.getMovedToPath();
                        runnable = new SafeChange(this, FileDocumentProvider.this, this.fFileEditorInput, path){
                            final /* synthetic */ FileSynchronizer this$1;
                            private final /* synthetic */ IPath val$path;
                            {
                                this.this$1 = fileSynchronizer;
                                this.val$path = iPath;
                            }

                            protected void execute(IFileEditorInput input) throws Exception {
                                FileSynchronizer.access$0(this.this$1).handleElementMoved(input, this.val$path);
                            }
                        };
                        break;
                    }
                    FileInfo info = (FileInfo)FileDocumentProvider.this.getElementInfo(this.fFileEditorInput);
                    if (info == null || info.fCanBeSaved) break;
                    runnable = new SafeChange(this, FileDocumentProvider.this, this.fFileEditorInput){
                        final /* synthetic */ FileSynchronizer this$1;
                        {
                            this.this$1 = fileSynchronizer;
                        }

                        protected void execute(IFileEditorInput input) throws Exception {
                            FileSynchronizer.access$0(this.this$1).handleElementDeleted(input);
                        }
                    };
                }
            }
            if (runnable != null) {
                this.update(runnable);
            }
            return false;
        }

        protected void update(Runnable runnable) {
            IWorkbench workbench;
            IWorkbenchWindow[] windows;
            if (runnable instanceof SafeChange) {
                FileDocumentProvider.this.fireElementStateChanging(this.fFileEditorInput);
            }
            if ((windows = (workbench = PlatformUI.getWorkbench()).getWorkbenchWindows()) != null && windows.length > 0) {
                Display display = windows[0].getShell().getDisplay();
                display.asyncExec(runnable);
            } else {
                runnable.run();
            }
        }

        static /* synthetic */ FileDocumentProvider access$0(FileSynchronizer fileSynchronizer) {
            return fileSynchronizer.FileDocumentProvider.this;
        }
    }

    protected class FileInfo
    extends StorageDocumentProvider.StorageInfo {
        public FileSynchronizer fFileSynchronizer;
        public long fModificationStamp = -1L;
        private boolean fHasBOM;

        public FileInfo(IDocument document, IAnnotationModel model, FileSynchronizer fileSynchronizer) {
            super(FileDocumentProvider.this, document, model);
            this.fFileSynchronizer = fileSynchronizer;
        }
    }
}

