/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.patch.Diff;
import org.eclipse.compare.internal.patch.DiffProject;
import org.eclipse.compare.internal.patch.LineReader;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.internal.patch.Patcher;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class WorkspacePatcher
extends Patcher
implements IAdaptable,
IWorkbenchAdapter {
    private DiffProject[] fDiffProjects;
    private boolean fIsWorkspacePatch = false;
    public static final String MULTIPROJECTPATCH_HEADER = "### Eclipse Workspace Patch";
    public static final String MULTIPROJECTPATCH_VERSION = "1.0";
    public static final String MULTIPROJECTPATCH_PROJECT = "#P";
    static /* synthetic */ Class class$0;

    public static void writeMultiProjectPatchHeader(PrintStream stream) {
        stream.println("### Eclipse Workspace Patch 1.0");
    }

    public static void addMultiProjectPatchProject(PrintStream stream, IProject project) {
        stream.println("#P " + project.getName());
    }

    public DiffProject[] getDiffProjects() {
        return this.fDiffProjects;
    }

    boolean isWorkspacePatch() {
        return this.fIsWorkspacePatch;
    }

    public void parse(BufferedReader reader) throws IOException {
        ArrayList diffs = new ArrayList();
        HashMap<String, DiffProject> diffProjects = new HashMap<String, DiffProject>(4);
        String line = null;
        boolean reread = false;
        String diffArgs = null;
        String fileName = null;
        String project = "";
        this.fIsWorkspacePatch = false;
        LineReader lr = new LineReader(reader);
        if (!"carbon".equals(SWT.getPlatform())) {
            lr.ignoreSingleCR();
        }
        if (!(line = lr.readLine()).startsWith(MULTIPROJECTPATCH_HEADER)) {
            this.parse(lr, line);
            return;
        }
        this.fIsWorkspacePatch = true;
        while (true) {
            DiffProject diffProject;
            if (!reread) {
                line = lr.readLine();
            }
            reread = false;
            if (line == null) break;
            if (line.length() < 4) continue;
            if (line.startsWith(MULTIPROJECTPATCH_PROJECT)) {
                project = line.substring(2).trim();
                continue;
            }
            if (line.startsWith("Index: ")) {
                fileName = line.substring(7).trim();
                continue;
            }
            if (line.startsWith("diff")) {
                diffArgs = line.substring(4).trim();
                continue;
            }
            if (!line.startsWith("--- ")) continue;
            if (!diffProjects.containsKey(project)) {
                IProject iproject = ResourcesPlugin.getWorkspace().getRoot().getProject(project);
                diffProject = new DiffProject(iproject);
                diffProjects.put(project, diffProject);
            } else {
                diffProject = (DiffProject)diffProjects.get(project);
            }
            line = this.readUnifiedDiff(diffs, lr, line, diffArgs, fileName, diffProject);
            fileName = null;
            diffArgs = null;
            reread = true;
        }
        lr.close();
        this.fDiffs = diffs.toArray(new Diff[diffs.size()]);
        this.fDiffProjects = diffProjects.values().toArray(new DiffProject[diffProjects.size()]);
    }

    private String readUnifiedDiff(List diffs, LineReader lr, String line, String diffArgs, String fileName, DiffProject diffProject) throws IOException {
        ArrayList newDiffs = new ArrayList();
        String nextLine = this.readUnifiedDiff(newDiffs, lr, line, diffArgs, fileName);
        Iterator iter = newDiffs.iterator();
        while (iter.hasNext()) {
            Diff diff = (Diff)iter.next();
            diff.setProject(diffProject);
            diffs.add(diff);
        }
        return nextLine;
    }

    public void applyAll(IProgressMonitor pm, Shell shell, String title) throws CoreException {
        if (!this.fIsWorkspacePatch) {
            super.applyAll(pm, shell, title);
        } else {
            ArrayList<IFile> list = new ArrayList<IFile>();
            int j = 0;
            while (j < this.fDiffProjects.length) {
                DiffProject diffProject = this.fDiffProjects[j];
                list.addAll(Arrays.asList(diffProject.getTargetFiles()));
                ++j;
            }
            if (!Utilities.validateResources(list, shell, title)) {
                return;
            }
            if (pm != null) {
                String message = PatchMessages.Patcher_Task_message;
                pm.beginTask(message, this.fDiffs.length * 10);
            }
            int i = 0;
            while (i < this.fDiffs.length) {
                int workTicks = 10;
                Diff diff = this.fDiffs[i];
                if (diff.isEnabled()) {
                    IFile file = diff.getTargetFile();
                    IPath path = file.getProjectRelativePath();
                    if (pm != null) {
                        pm.subTask(path.toString());
                    }
                    this.createPath((IContainer)file.getProject(), path);
                    ArrayList failed = new ArrayList();
                    List result = null;
                    int type = diff.getType();
                    switch (type) {
                        case 1: {
                            result = this.apply(diff, file, true, failed);
                            this.store(this.createString(result), file, (IProgressMonitor)new SubProgressMonitor(pm, workTicks));
                            workTicks -= 10;
                            break;
                        }
                        case 2: {
                            file.delete(true, true, (IProgressMonitor)new SubProgressMonitor(pm, workTicks));
                            workTicks -= 10;
                            break;
                        }
                        case 3: {
                            result = this.apply(diff, file, false, failed);
                            this.store(this.createString(result), file, (IProgressMonitor)new SubProgressMonitor(pm, workTicks));
                            workTicks -= 10;
                        }
                    }
                    if (failed.size() > 0) {
                        IPath pp = null;
                        if (path.segmentCount() > 1) {
                            pp = path.removeLastSegments(1);
                            pp = pp.append(String.valueOf(path.lastSegment()) + ".rej");
                        } else {
                            pp = new Path(String.valueOf(path.lastSegment()) + ".rej");
                        }
                        file = this.createPath((IContainer)file.getProject(), pp);
                        if (file != null) {
                            this.store(this.getRejected(failed), file, pm);
                            try {
                                IMarker marker = file.createMarker("org.eclipse.compare.rejectedPatchMarker");
                                marker.setAttribute("message", (Object)PatchMessages.Patcher_Marker_message);
                                marker.setAttribute("priority", 2);
                            }
                            catch (CoreException coreException) {}
                        }
                    }
                }
                if (pm != null) {
                    if (pm.isCanceled()) break;
                    if (workTicks > 0) {
                        pm.worked(workTicks);
                    }
                }
                ++i;
            }
        }
    }

    public ISchedulingRule[] getTargetProjects() {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        int i = 0;
        while (i < this.fDiffProjects.length) {
            DiffProject diffProject = this.fDiffProjects[i];
            projects.add(diffProject.getProject());
            ++i;
        }
        return projects.toArray(new ISchedulingRule[projects.size()]);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return null;
    }

    public Object[] getChildren(Object o) {
        if (this.fIsWorkspacePatch) {
            return this.fDiffProjects;
        }
        if (this.fDiffs != null) {
            return this.fDiffs;
        }
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return null;
    }

    public Object getParent(Object o) {
        return null;
    }
}

