/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.expressions;

import org.eclipse.core.expressions.IPropertyTester;
import org.eclipse.core.internal.expressions.ExpressionMessages;
import org.eclipse.core.internal.expressions.ExpressionPlugin;
import org.eclipse.core.internal.expressions.Messages;
import org.eclipse.core.internal.expressions.PropertyTesterDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public abstract class PropertyTester
implements IPropertyTester {
    private IConfigurationElement fConfigElement;
    private String fNamespace;
    private String fProperties;

    public final void internalInitialize(PropertyTesterDescriptor descriptor) {
        this.fProperties = descriptor.getProperties();
        this.fNamespace = descriptor.getNamespace();
        this.fConfigElement = descriptor.getConfigurationElement();
    }

    public final PropertyTesterDescriptor internalCreateDescriptor() {
        return new PropertyTesterDescriptor(this.fConfigElement, this.fNamespace, this.fProperties);
    }

    public final void internalActivateDeclaringPlugin() throws CoreException {
        String pluginName = this.fConfigElement.getContributor().getName();
        Bundle bundle = Platform.getBundle((String)pluginName);
        try {
            bundle.start();
        }
        catch (BundleException e) {
            throw new CoreException((IStatus)new Status(4, ExpressionPlugin.getPluginId(), 4, Messages.format(ExpressionMessages.PropertyTester_error_activating_plugin, pluginName), (Throwable)e));
        }
    }

    public final boolean handles(String namespace, String property) {
        return this.fNamespace.equals(namespace) && this.fProperties.indexOf("," + property + ",") != -1;
    }

    public final boolean isInstantiated() {
        return true;
    }

    public boolean isDeclaringPluginActive() {
        Bundle bundle = Platform.getBundle((String)this.fConfigElement.getContributor().getName());
        return bundle.getState() == 32;
    }

    public final IPropertyTester instantiate() {
        return this;
    }
}

