/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEStateHelper;
import org.eclipse.pde.internal.core.XMLPrintHandler;
import org.eclipse.pde.internal.core.plugin.PluginExtension;
import org.eclipse.pde.internal.core.plugin.PluginExtensionPoint;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PDEExtensionRegistry {
    protected static boolean DEBUG = false;
    private static String CACHE_EXTENSION;
    private static String ROOT_EXTENSIONS;
    private static String ELEMENT_BUNDLE;
    private static String ATTR_BUNDLE_ID;
    private static String ELEMENT_EXTENSION;
    private static String ELEMENT_EXTENSION_POINT;
    private Map fExtensions = new HashMap();

    static {
        DEBUG = PDECore.getDefault().isDebugging() && "true".equals(Platform.getDebugOption((String)"org.eclipse.pde.core/cache"));
        CACHE_EXTENSION = ".extensions";
        ROOT_EXTENSIONS = "extensions";
        ELEMENT_BUNDLE = "bundle";
        ATTR_BUNDLE_ID = "bundleID";
        ELEMENT_EXTENSION = "extension";
        ELEMENT_EXTENSION_POINT = "extension-point";
    }

    protected void saveExtensions(State state, File dir) {
        try {
            File file = new File(dir, CACHE_EXTENSION);
            XMLPrintHandler.writeFile(this.createExtensionDocument(state), file);
        }
        catch (IOException iOException) {}
    }

    public Node[] getExtensions(long bundleID) {
        return this.getChildren(bundleID, ELEMENT_EXTENSION);
    }

    public Node[] getExtensionPoints(long bundleID) {
        return this.getChildren(bundleID, ELEMENT_EXTENSION_POINT);
    }

    private Node[] getChildren(long bundleID, String tagName) {
        ArrayList<Node> list = new ArrayList<Node>();
        Element bundle = (Element)this.fExtensions.get(Long.toString(bundleID));
        if (bundle != null) {
            NodeList children = bundle.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                if (tagName.equals(children.item(i).getNodeName())) {
                    list.add(children.item(i));
                }
                ++i;
            }
        }
        return list.toArray(new Node[list.size()]);
    }

    public Node[] getAllExtensions(long bundleID) {
        ArrayList<Node> list = new ArrayList<Node>();
        Element bundle = (Element)this.fExtensions.get(Long.toString(bundleID));
        if (bundle != null) {
            NodeList children = bundle.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                String name = children.item(i).getNodeName();
                if (ELEMENT_EXTENSION.equals(name) || ELEMENT_EXTENSION_POINT.equals(name)) {
                    list.add(children.item(i));
                }
                ++i;
            }
        }
        return list.toArray(new Node[list.size()]);
    }

    protected Document createExtensionDocument(State state) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            doc = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        Element root = doc.createElement(ROOT_EXTENSIONS);
        BundleDescription[] bundles = state.getBundles();
        int i = 0;
        while (i < bundles.length) {
            BundleDescription desc = bundles[i];
            Element element = doc.createElement(ELEMENT_BUNDLE);
            element.setAttribute(ATTR_BUNDLE_ID, Long.toString(desc.getBundleId()));
            PDEStateHelper.parseExtensions(desc, element);
            if (element.hasChildNodes()) {
                root.appendChild(element);
                this.fExtensions.put(Long.toString(desc.getBundleId()), element);
            }
            ++i;
        }
        doc.appendChild(root);
        return doc;
    }

    protected boolean readExtensionsCache(File dir) {
        long start = System.currentTimeMillis();
        File file = new File(dir, CACHE_EXTENSION);
        if (file.exists() && file.isFile()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                Document doc = factory.newDocumentBuilder().parse(file);
                Element root = doc.getDocumentElement();
                if (root != null) {
                    NodeList bundles = root.getChildNodes();
                    int i = 0;
                    while (i < bundles.getLength()) {
                        if (bundles.item(i).getNodeType() == 1) {
                            Element bundle = (Element)bundles.item(i);
                            String id = bundle.getAttribute(ATTR_BUNDLE_ID);
                            this.fExtensions.put(id, bundle.getChildNodes());
                        }
                        ++i;
                    }
                }
                if (DEBUG) {
                    System.out.println("Time to read extensions: " + (System.currentTimeMillis() - start) + " ms");
                }
                return true;
            }
            catch (SAXException e) {
                PDECore.log(e);
            }
            catch (IOException e) {
                PDECore.log(e);
            }
            catch (ParserConfigurationException e) {
                PDECore.log(e);
            }
        }
        return false;
    }

    public static void writeExtensions(IPluginModelBase[] models, File destination) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement(ROOT_EXTENSIONS);
            doc.appendChild(root);
            int i = 0;
            while (i < models.length) {
                IPluginBase plugin = models[i].getPluginBase();
                IPluginExtension[] extensions = plugin.getExtensions();
                IPluginExtensionPoint[] extPoints = plugin.getExtensionPoints();
                if (extensions.length != 0 || extPoints.length != 0) {
                    Element element = doc.createElement(ELEMENT_BUNDLE);
                    element.setAttribute(ATTR_BUNDLE_ID, Long.toString(models[i].getBundleDescription().getBundleId()));
                    int j = 0;
                    while (j < extensions.length) {
                        element.appendChild(PDEExtensionRegistry.writeExtension(doc, extensions[j]));
                        ++j;
                    }
                    j = 0;
                    while (j < extPoints.length) {
                        element.appendChild(PDEExtensionRegistry.writeExtensionPoint(doc, extPoints[j]));
                        ++j;
                    }
                    root.appendChild(element);
                }
                ++i;
            }
            XMLPrintHandler.writeFile(doc, new File(destination, CACHE_EXTENSION));
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
        }
        catch (IOException iOException) {}
    }

    public static Element writeExtensionPoint(Document doc, IPluginExtensionPoint extPoint) {
        Element child = doc.createElement("extension-point");
        if (extPoint.getId() != null) {
            child.setAttribute("id", CoreUtility.getWritableString(extPoint.getId()));
        }
        if (extPoint.getName() != null) {
            child.setAttribute("name", CoreUtility.getWritableString(extPoint.getName()));
        }
        if (extPoint.getSchema() != null) {
            child.setAttribute("schema", CoreUtility.getWritableString(extPoint.getSchema()));
        }
        if (extPoint instanceof PluginExtensionPoint) {
            child.setAttribute("line", Integer.toString(((PluginExtensionPoint)extPoint).getStartLine()));
        }
        return child;
    }

    public static Element writeExtension(Document doc, IPluginExtension extension) {
        Element child = doc.createElement("extension");
        if (extension.getPoint() != null) {
            child.setAttribute("point", CoreUtility.getWritableString(extension.getPoint()));
        }
        if (extension.getName() != null) {
            child.setAttribute("name", CoreUtility.getWritableString(extension.getName()));
        }
        if (extension.getId() != null) {
            child.setAttribute("id", CoreUtility.getWritableString(extension.getId()));
        }
        if (extension instanceof PluginExtension) {
            child.setAttribute("line", Integer.toString(((PluginExtension)extension).getStartLine()));
        }
        IPluginObject[] children = extension.getChildren();
        int i = 0;
        while (i < children.length) {
            child.appendChild(PDEExtensionRegistry.writeElement(doc, (IPluginElement)children[i]));
            ++i;
        }
        return child;
    }

    public static Element writeElement(Document doc, IPluginElement element) {
        Element child = doc.createElement(element.getName());
        IPluginAttribute[] attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.length) {
            child.setAttribute(attrs[i].getName(), CoreUtility.getWritableString(attrs[i].getValue()));
            ++i;
        }
        IPluginObject[] elements = element.getChildren();
        int i2 = 0;
        while (i2 < elements.length) {
            child.appendChild(PDEExtensionRegistry.writeElement(doc, (IPluginElement)elements[i2]));
            ++i2;
        }
        return child;
    }

    protected void clear() {
        this.fExtensions.clear();
    }
}

