/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.text.source.VerticalRulerEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.texteditor.LinearLayouter;

public class AnnotationExpansionControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2 {
    protected AnnotationHoverInput fInput;
    private Shell fShell;
    protected Composite fComposite;
    private Cursor fHandCursor;
    private Item fSelection;
    private HoverManager fHoverManager;
    private IAnnotationAccessExtension fAnnotationAccessExtension;
    private final MyPaintListener fPaintListener = new MyPaintListener();
    private final MyMouseTrackListener fMouseTrackListener = new MyMouseTrackListener();
    private final MyMouseListener fMouseListener = new MyMouseListener();
    private final MyMenuDetectListener fMenuDetectListener = new MyMenuDetectListener();
    private final DisposeListener fDisposeListener = new MyDisposeListener();
    private final IViewportListener fViewportListener = new IViewportListener(){

        public void viewportChanged(int verticalOffset) {
            AnnotationExpansionControl.this.dispose();
        }
    };
    private LinearLayouter fLayouter = new LinearLayouter();

    public AnnotationExpansionControl(Shell parent, int shellStyle, IAnnotationAccess access) {
        if (access instanceof IAnnotationAccessExtension) {
            this.fAnnotationAccessExtension = (IAnnotationAccessExtension)access;
        }
        this.fShell = new Shell(parent, shellStyle | 0x80000 | 0x4000);
        Display display = this.fShell.getDisplay();
        this.fShell.setBackground(display.getSystemColor(2));
        this.fComposite = new Composite((Composite)this.fShell, 0x180008);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fShell.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.heightHint = this.fLayouter.getAnnotationSize() + 2 * this.fLayouter.getBorderWidth() + 4;
        this.fComposite.setLayoutData((Object)data);
        this.fComposite.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                if (AnnotationExpansionControl.this.fComposite == null) {
                    return;
                }
                Control[] children = AnnotationExpansionControl.this.fComposite.getChildren();
                Rectangle bounds = null;
                int i = 0;
                while (i < children.length) {
                    if (bounds == null) {
                        bounds = children[i].getBounds();
                    } else {
                        bounds.add(children[i].getBounds());
                    }
                    if (bounds.contains(e.x, e.y)) {
                        return;
                    }
                    ++i;
                }
                AnnotationExpansionControl.this.dispose();
            }
        });
        this.fHandCursor = new Cursor((Device)display, 21);
        this.fShell.setCursor(this.fHandCursor);
        this.fComposite.setCursor(this.fHandCursor);
        this.setInfoSystemColor();
    }

    private void setInfoSystemColor() {
        Display display = this.fShell.getDisplay();
        this.setForegroundColor(display.getSystemColor(28));
        this.setBackgroundColor(display.getSystemColor(29));
    }

    public void setInformation(String information) {
        this.setInput(null);
    }

    public void setInput(Object input) {
        if (this.fInput != null && this.fInput.fViewer != null) {
            this.fInput.fViewer.removeViewportListener(this.fViewportListener);
        }
        this.fInput = input instanceof AnnotationHoverInput ? (AnnotationHoverInput)input : null;
        this.inputChanged(this.fInput, null);
    }

    protected void inputChanged(Object newInput, Object newSelection) {
        this.refresh();
    }

    protected void refresh() {
        this.adjustItemNumber();
        if (this.fInput == null) {
            return;
        }
        if (this.fInput.fAnnotations == null) {
            return;
        }
        if (this.fInput.fViewer != null) {
            this.fInput.fViewer.addViewportListener(this.fViewportListener);
        }
        this.fShell.setRegion(this.fLayouter.getShellRegion(this.fInput.fAnnotations.length));
        Layout layout = this.fLayouter.getLayout(this.fInput.fAnnotations.length);
        this.fComposite.setLayout(layout);
        Control[] children = this.fComposite.getChildren();
        int i = 0;
        while (i < this.fInput.fAnnotations.length) {
            Canvas canvas = (Canvas)children[i];
            Item item = new Item();
            item.canvas = canvas;
            item.fAnnotation = this.fInput.fAnnotations[i];
            canvas.setData((Object)item);
            canvas.redraw();
            ++i;
        }
    }

    protected void adjustItemNumber() {
        if (this.fComposite == null) {
            return;
        }
        Control[] children = this.fComposite.getChildren();
        int oldSize = children.length;
        int newSize = this.fInput == null ? 0 : this.fInput.fAnnotations.length;
        Display display = this.fShell.getDisplay();
        int i = oldSize;
        while (i < newSize) {
            Canvas canvas = new Canvas(this.fComposite, 0);
            Object gridData = this.fLayouter.getLayoutData();
            canvas.setLayoutData(gridData);
            canvas.setBackground(display.getSystemColor(29));
            canvas.addPaintListener((PaintListener)this.fPaintListener);
            canvas.addMouseTrackListener((MouseTrackListener)this.fMouseTrackListener);
            canvas.addMouseListener((MouseListener)this.fMouseListener);
            canvas.addListener(35, (Listener)this.fMenuDetectListener);
            canvas.addDisposeListener(this.fDisposeListener);
            ++i;
        }
        i = oldSize;
        while (i > newSize) {
            Item item = (Item)children[i - 1].getData();
            item.deselect();
            children[i - 1].dispose();
            --i;
        }
    }

    public void setVisible(boolean visible) {
        this.fShell.setVisible(visible);
    }

    public void dispose() {
        if (this.fShell != null) {
            if (!this.fShell.isDisposed()) {
                this.fShell.dispose();
            }
            this.fShell = null;
            this.fComposite = null;
            if (this.fHandCursor != null) {
                this.fHandCursor.dispose();
            }
            this.fHandCursor = null;
            if (this.fHoverManager != null) {
                this.fHoverManager.dispose();
            }
            this.fHoverManager = null;
            this.fSelection = null;
        }
    }

    public boolean hasContents() {
        return this.fInput.fAnnotations != null && this.fInput.fAnnotations.length > 0;
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public Point computeSizeHint() {
        return this.fShell.computeSize(-1, -1);
    }

    public void setLocation(Point location) {
        this.fShell.setLocation(location);
    }

    public void setSize(int width, int height) {
        this.fShell.setSize(width, height);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.fShell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.fShell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.fComposite.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.fComposite.setBackground(background);
    }

    public boolean isFocusControl() {
        if (this.fComposite.isFocusControl()) {
            return true;
        }
        Control[] children = this.fComposite.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].isFocusControl()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setFocus() {
        this.fShell.forceFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.fShell.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.fShell.removeFocusListener(listener);
    }

    private StyleRange[] setViewerBackground(Annotation annotation) {
        StyledText text = this.fInput.fViewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return null;
        }
        Display disp = text.getDisplay();
        Position pos = this.fInput.model.getPosition(annotation);
        if (pos == null) {
            return null;
        }
        IRegion region = ((TextViewer)this.fInput.fViewer).modelRange2WidgetRange((IRegion)new org.eclipse.jface.text.Region(pos.offset, pos.length));
        StyleRange[] ranges = text.getStyleRanges(region.getOffset(), region.getLength());
        ArrayList<Object> undoRanges = new ArrayList<Object>(ranges.length);
        int i = 0;
        while (i < ranges.length) {
            undoRanges.add(ranges[i].clone());
            ++i;
        }
        int offset = region.getOffset();
        StyleRange current = undoRanges.size() > 0 ? (StyleRange)undoRanges.get(0) : null;
        int curStart = current != null ? current.start : region.getOffset() + region.getLength();
        int curEnd = current != null ? current.start + current.length : -1;
        int index = 0;
        while (curEnd < region.getOffset() + region.getLength()) {
            if (curStart > offset) {
                StyleRange undoRange = new StyleRange(offset, curStart - offset, null, null);
                undoRanges.add(index, undoRange);
                ++index;
            }
            if (++index < undoRanges.size()) {
                offset = curEnd;
                current = (StyleRange)undoRanges.get(index);
                curStart = current.start;
                curEnd = current.start + current.length;
                continue;
            }
            if (index == undoRanges.size()) {
                offset = curEnd;
                current = null;
                curStart = region.getOffset() + region.getLength();
                curEnd = -1;
                continue;
            }
            curEnd = region.getOffset() + region.getLength();
        }
        ArrayList<StyleRange> shadedRanges = new ArrayList<StyleRange>(undoRanges.size());
        Iterator it = undoRanges.iterator();
        while (it.hasNext()) {
            StyleRange range = (StyleRange)((StyleRange)it.next()).clone();
            shadedRanges.add(range);
            range.background = this.getHighlightColor(disp);
        }
        Iterator iter = shadedRanges.iterator();
        while (iter.hasNext()) {
            text.setStyleRange((StyleRange)iter.next());
        }
        return undoRanges.toArray(undoRanges.toArray(new StyleRange[0]));
    }

    private void resetViewerBackground(StyleRange[] oldRanges) {
        if (oldRanges == null) {
            return;
        }
        if (this.fInput == null) {
            return;
        }
        StyledText text = this.fInput.fViewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        int i = 0;
        while (i < oldRanges.length) {
            text.setStyleRange(oldRanges[i]);
            ++i;
        }
    }

    private Color getHighlightColor(Display disp) {
        return disp.getSystemColor(15);
    }

    private Color getSelectionColor(Display disp) {
        return disp.getSystemColor(15);
    }

    public static interface ICallback {
        public void run(IInformationControlExtension2 var1);
    }

    public static class AnnotationHoverInput {
        public Annotation[] fAnnotations;
        public ISourceViewer fViewer;
        public IVerticalRulerInfo fRulerInfo;
        public IVerticalRulerListener fAnnotationListener;
        public IDoubleClickListener fDoubleClickListener;
        public ICallback redoAction;
        public IAnnotationModel model;
    }

    private final class Item {
        Annotation fAnnotation;
        Canvas canvas;
        StyleRange[] oldStyles;

        private Item() {
        }

        public void selected() {
            Display disp = AnnotationExpansionControl.this.fShell.getDisplay();
            this.canvas.setCursor(AnnotationExpansionControl.this.fHandCursor);
            this.canvas.setBackground(AnnotationExpansionControl.this.getSelectionColor(disp));
            this.oldStyles = AnnotationExpansionControl.this.setViewerBackground(this.fAnnotation);
            AnnotationExpansionControl.this.fSelection = this;
            if (AnnotationExpansionControl.this.fHoverManager != null) {
                AnnotationExpansionControl.this.fHoverManager.showInformation();
            }
            if (AnnotationExpansionControl.this.fInput.fAnnotationListener != null) {
                VerticalRulerEvent event = new VerticalRulerEvent(this.fAnnotation);
                AnnotationExpansionControl.this.fInput.fAnnotationListener.annotationSelected(event);
            }
        }

        public void defaultSelected() {
            if (AnnotationExpansionControl.this.fInput.fAnnotationListener != null) {
                VerticalRulerEvent event = new VerticalRulerEvent(this.fAnnotation);
                AnnotationExpansionControl.this.fInput.fAnnotationListener.annotationDefaultSelected(event);
            }
            AnnotationExpansionControl.this.dispose();
        }

        public void showContextMenu(Menu menu) {
            if (AnnotationExpansionControl.this.fInput.fAnnotationListener != null) {
                VerticalRulerEvent event = new VerticalRulerEvent(this.fAnnotation);
                AnnotationExpansionControl.this.fInput.fAnnotationListener.annotationContextMenuAboutToShow(event, menu);
            }
        }

        public void deselect() {
            AnnotationExpansionControl.this.fSelection = null;
            AnnotationExpansionControl.this.resetViewerBackground(this.oldStyles);
            this.oldStyles = null;
            Display disp = AnnotationExpansionControl.this.fShell.getDisplay();
            this.canvas.setCursor(null);
            this.canvas.setBackground(disp.getSystemColor(29));
        }
    }

    private static final class MyDisposeListener
    implements DisposeListener {
        private MyDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent e) {
            Item item = (Item)((Widget)e.getSource()).getData();
            item.deselect();
            item.canvas = null;
            item.fAnnotation = null;
            item.oldStyles = null;
            ((Widget)e.getSource()).setData(null);
        }
    }

    private final class MyMenuDetectListener
    implements Listener {
        private MyMenuDetectListener() {
        }

        public void handleEvent(Event event) {
            Menu menu;
            Control ruler;
            if (event.type == 35 && AnnotationExpansionControl.this.fInput != null && (ruler = AnnotationExpansionControl.this.fInput.fRulerInfo.getControl()) != null && !ruler.isDisposed() && (menu = ruler.getMenu()) != null && !menu.isDisposed()) {
                menu.setLocation(event.x, event.y);
                menu.addMenuListener(new MenuListener(this){
                    final /* synthetic */ MyMenuDetectListener this$1;
                    {
                        this.this$1 = myMenuDetectListener;
                    }

                    public void menuHidden(MenuEvent e) {
                        MyMenuDetectListener.access$1(this.this$1).dispose();
                    }

                    public void menuShown(MenuEvent e) {
                    }
                });
                menu.setVisible(true);
            }
        }

        static /* synthetic */ AnnotationExpansionControl access$1(MyMenuDetectListener myMenuDetectListener) {
            return myMenuDetectListener.AnnotationExpansionControl.this;
        }
    }

    private final class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            Item item = (Item)((Widget)e.getSource()).getData();
            if (e.button == 1 && item.fAnnotation == AnnotationExpansionControl.this.fInput.fAnnotations[0] && AnnotationExpansionControl.this.fInput.fDoubleClickListener != null) {
                AnnotationExpansionControl.this.fInput.fDoubleClickListener.doubleClick(null);
                if (AnnotationExpansionControl.this.fInput.redoAction != null) {
                    AnnotationExpansionControl.this.fInput.redoAction.run(AnnotationExpansionControl.this);
                }
            }
        }

        public void mouseUp(MouseEvent e) {
            Item item = (Item)((Widget)e.getSource()).getData();
            if (item != null && e.button == 1) {
                item.defaultSelected();
            }
        }

        public void mouseDown(MouseEvent e) {
            super.mouseDown(e);
        }
    }

    private final class MyMouseTrackListener
    implements MouseTrackListener {
        private MyMouseTrackListener() {
        }

        public void mouseEnter(MouseEvent e) {
            Item item = (Item)((Widget)e.getSource()).getData();
            if (item != null) {
                item.selected();
            }
        }

        public void mouseExit(MouseEvent e) {
            Item item = (Item)((Widget)e.getSource()).getData();
            if (item != null) {
                item.deselect();
            }
            Region region = AnnotationExpansionControl.this.fShell.getRegion();
            Canvas can = (Canvas)e.getSource();
            Point p = can.toDisplay(e.x, e.y);
            if (region == null) {
                Rectangle bounds = AnnotationExpansionControl.this.fShell.getBounds();
                if (!bounds.contains(p)) {
                    AnnotationExpansionControl.this.dispose();
                }
            } else {
                p = AnnotationExpansionControl.this.fShell.toControl(p);
                if (!region.contains(p)) {
                    AnnotationExpansionControl.this.dispose();
                }
            }
        }

        public void mouseHover(MouseEvent e) {
            if (AnnotationExpansionControl.this.fHoverManager == null) {
                AnnotationExpansionControl.this.fHoverManager = new HoverManager();
                AnnotationExpansionControl.this.fHoverManager.takesFocusWhenVisible(false);
                AnnotationExpansionControl.this.fHoverManager.install((Control)AnnotationExpansionControl.this.fComposite);
                AnnotationExpansionControl.this.fHoverManager.showInformation();
            }
        }
    }

    private final class MyPaintListener
    implements PaintListener {
        private MyPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            Canvas can = (Canvas)e.getSource();
            Annotation a = ((Item)can.getData()).fAnnotation;
            if (a != null) {
                Rectangle rect = new Rectangle(AnnotationExpansionControl.this.fLayouter.getBorderWidth(), AnnotationExpansionControl.this.fLayouter.getBorderWidth(), AnnotationExpansionControl.this.fLayouter.getAnnotationSize(), AnnotationExpansionControl.this.fLayouter.getAnnotationSize());
                if (AnnotationExpansionControl.this.fAnnotationAccessExtension != null) {
                    AnnotationExpansionControl.this.fAnnotationAccessExtension.paint(a, e.gc, can, rect);
                }
            }
        }
    }

    private final class HoverManager
    extends AbstractInformationControlManager {
        public HoverManager() {
            super(new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent);
                }
            });
            this.setMargins(5, 10);
            this.setAnchor(ANCHOR_BOTTOM);
            this.setFallbackAnchors(new AbstractInformationControlManager.Anchor[]{ANCHOR_BOTTOM, ANCHOR_LEFT, ANCHOR_RIGHT});
        }

        protected void computeInformation() {
            if (AnnotationExpansionControl.this.fSelection != null) {
                Rectangle subjectArea = ((AnnotationExpansionControl)AnnotationExpansionControl.this).fSelection.canvas.getBounds();
                Annotation annotation = ((AnnotationExpansionControl)AnnotationExpansionControl.this).fSelection.fAnnotation;
                String msg = annotation != null ? annotation.getText() : null;
                this.setInformation(msg, subjectArea);
            }
        }
    }
}

