/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.context;

import java.io.ByteArrayInputStream;
import java.text.MessageFormat;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.help.internal.FilterableUAElement;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.context.Context;
import org.eclipse.help.internal.context.Contexts;
import org.eclipse.help.internal.context.ContextsBuilder;
import org.eclipse.help.internal.context.ContextsFile;
import org.eclipse.help.internal.context.ContextsNode;
import org.eclipse.help.internal.context.RelatedTopic;
import org.eclipse.help.internal.util.FastStack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ContextsFileParser
extends DefaultHandler {
    protected FastStack stack = new FastStack();
    StringBuffer buffer = new StringBuffer();
    boolean seenDescription = false;
    ContextsFile contextsFile;
    private ContextsBuilder builder;
    private static final SAXParserFactory factory = SAXParserFactory.newInstance();

    public ContextsFileParser(ContextsBuilder builder) {
        this.builder = builder;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.seenDescription) {
            this.buffer.append(ch, start, length);
        }
        if (HelpPlugin.DEBUG_CONTEXT) {
            System.out.println("ContextsFileParser.characters(): got char from parser= " + new StringBuffer().append(ch, start, length).toString());
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals("description")) {
            this.seenDescription = false;
            ((Context)this.stack.peek()).setStyledText(this.buffer.toString());
            this.buffer.setLength(0);
        } else if (qName.equals("b")) {
            this.stack.pop();
            if (!this.stack.peek().equals("<@#$b>")) {
                this.buffer.append("</@#$b>");
            }
        } else if (!qName.equals("filter")) {
            ContextsNode node = (ContextsNode)this.stack.pop();
            node.build(this.builder);
        }
    }

    public void error(SAXParseException ex) {
        HelpPlugin.logError("Error parsing " + this.getErrorDetails(ex), null);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        HelpPlugin.logError("Failed to parse " + this.getErrorDetails(ex), ex);
    }

    public String getErrorDetails(SAXParseException ex) {
        String param0 = ex.getSystemId();
        Integer param1 = new Integer(ex.getLineNumber());
        Integer param2 = new Integer(ex.getColumnNumber());
        String param3 = ex.getMessage();
        String message = MessageFormat.format("URL: {0} at line: {1,number,integer}, column: {2,number,integer}.\r\n{3}", param0, param1, param2, param3);
        return message;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("description")) {
            this.seenDescription = true;
        } else if (qName.equals("b")) {
            if (!this.stack.peek().equals("<@#$b>")) {
                this.buffer.append("<@#$b>");
            }
            this.stack.push("<@#$b>");
        } else {
            ContextsNode e = null;
            if (qName.equals("contexts")) {
                e = new Contexts(atts);
            } else if (qName.equals("context")) {
                e = new Context(atts);
            } else if (qName.equals("topic")) {
                e = new RelatedTopic(atts);
            } else {
                if (qName.equals("filter")) {
                    Object parent;
                    if (!this.stack.empty() && (parent = this.stack.peek()) instanceof FilterableUAElement && atts != null) {
                        FilterableUAElement filterableNode = (FilterableUAElement)parent;
                        String name = atts.getValue("name");
                        String value = atts.getValue("value");
                        if (name != null && value != null) {
                            filterableNode.addFilter(name, value);
                        }
                    }
                    return;
                }
                return;
            }
            if (!this.stack.empty()) {
                ((ContextsNode)this.stack.peek()).addChild(e);
            }
            this.stack.push(e);
        }
    }

    public void warning(SAXParseException ex) {
        HelpPlugin.logWarning("Warning parsing " + this.getErrorDetails(ex));
    }

    /*
     * Exception decompiling
     */
    public void parse(ContextsFile contextsFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 167->171)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        InputSource source = new InputSource(new ByteArrayInputStream(new byte[0]));
        source.setPublicId(publicId);
        source.setSystemId(systemId);
        return source;
    }
}

