/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;

public abstract class OutputStream {
    static final int BUFFER_SIZE = 1024;
    private final byte[] buffer = new byte[1024];
    private long bufferStart = 0L;
    private int bufferPosition = 0;

    public final void writeByte(byte b) throws IOException {
        if (this.bufferPosition >= 1024) {
            this.flush();
        }
        this.buffer[this.bufferPosition++] = b;
    }

    public final void writeBytes(byte[] b, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            this.writeByte(b[i]);
        }
    }

    public final void writeInt(int i) throws IOException {
        this.writeByte((byte)(i >> 24));
        this.writeByte((byte)(i >> 16));
        this.writeByte((byte)(i >> 8));
        this.writeByte((byte)i);
    }

    public final void writeVInt(int i) throws IOException {
        while ((i & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    public final void writeLong(long i) throws IOException {
        this.writeInt((int)(i >> 32));
        this.writeInt((int)i);
    }

    public final void writeVLong(long i) throws IOException {
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    public final void writeString(String s) throws IOException {
        int length = s.length();
        this.writeVInt(length);
        this.writeChars(s, 0, length);
    }

    public final void writeChars(String s, int start, int length) throws IOException {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char code = s.charAt(i);
            if (code >= '\u0001' && code <= '\u007f') {
                this.writeByte((byte)code);
                continue;
            }
            if (code >= '\u0080' && code <= '\u07ff' || code == '\u0000') {
                this.writeByte((byte)(0xC0 | code >> 6));
                this.writeByte((byte)(0x80 | code & 0x3F));
                continue;
            }
            this.writeByte((byte)(0xE0 | code >>> 12));
            this.writeByte((byte)(0x80 | code >> 6 & 0x3F));
            this.writeByte((byte)(0x80 | code & 0x3F));
        }
    }

    protected final void flush() throws IOException {
        this.flushBuffer(this.buffer, this.bufferPosition);
        this.bufferStart += (long)this.bufferPosition;
        this.bufferPosition = 0;
    }

    protected abstract void flushBuffer(byte[] var1, int var2) throws IOException;

    public void close() throws IOException {
        this.flush();
    }

    public final long getFilePointer() throws IOException {
        return this.bufferStart + (long)this.bufferPosition;
    }

    public void seek(long pos) throws IOException {
        this.flush();
        this.bufferStart = pos;
    }

    public abstract long length() throws IOException;
}

