/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.intro.IntroDescriptor;
import org.eclipse.ui.internal.intro.IntroMessages;

public class IntroAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow workbenchWindow;
    private IPageListener pageListener = new IPageListener(){

        public void pageActivated(IWorkbenchPage page) {
        }

        public void pageClosed(IWorkbenchPage page) {
            IntroAction.this.setEnabled(IntroAction.this.workbenchWindow.getPages().length > 0);
        }

        public void pageOpened(IWorkbenchPage page) {
            IntroAction.this.setEnabled(true);
        }
    };

    public IntroAction(IWorkbenchWindow window) {
        super(IntroMessages.Intro_action_text);
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        this.setActionDefinitionId("org.eclipse.ui.help.quickStartAction");
        window.addPageListener(this.pageListener);
    }

    public void dispose() {
        this.workbenchWindow.removePageListener(this.pageListener);
        this.workbenchWindow = null;
    }

    public void runWithEvent(Event event) {
        IntroDescriptor introDescriptor = ((Workbench)this.workbenchWindow.getWorkbench()).getIntroDescriptor();
        if (introDescriptor == null) {
            MessageDialog.openWarning((Shell)event.display.getActiveShell(), (String)IntroMessages.Intro_missing_product_title, (String)IntroMessages.Intro_missing_product_message);
        } else {
            this.workbenchWindow.getWorkbench().getIntroManager().showIntro(this.workbenchWindow, false);
        }
    }

    public ImageDescriptor getImageDescriptor() {
        IntroDescriptor introDescriptor = ((Workbench)this.workbenchWindow.getWorkbench()).getIntroDescriptor();
        if (introDescriptor == null) {
            return null;
        }
        return introDescriptor.getImageDescriptor();
    }
}

