/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IModelLifecycleListener;
import org.eclipse.ui.ISaveableModel;
import org.eclipse.ui.ISaveableModelManager;
import org.eclipse.ui.ISaveableModelSource;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ModelLifecycleEvent;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.internal.DefaultSaveableModel;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.internal.SaveableHelper;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.EventLoopProgressMonitor;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;

public class SaveableModelManager
implements ISaveableModelManager {
    private ListenerList listeners = new ListenerList();
    private Map modelMap = new HashMap();
    private Map modelRefCounts = new HashMap();

    public ISaveableModel[] getOpenModels() {
        return this.modelRefCounts.keySet().toArray(new ISaveableModel[this.modelRefCounts.size()]);
    }

    private boolean addModel(Object source, ISaveableModel model) {
        boolean result = false;
        HashSet<ISaveableModel> modelsForSource = (HashSet<ISaveableModel>)this.modelMap.get(source);
        if (modelsForSource == null) {
            modelsForSource = new HashSet<ISaveableModel>();
            this.modelMap.put(source, modelsForSource);
        }
        if (modelsForSource.add(model)) {
            result = this.incrementRefCount(this.modelRefCounts, model);
        }
        return result;
    }

    private boolean incrementRefCount(Map referenceMap, Object key) {
        boolean result = false;
        Integer refCount = (Integer)referenceMap.get(key);
        if (refCount == null) {
            result = true;
            refCount = new Integer(0);
        }
        referenceMap.put(key, new Integer(refCount + 1));
        return result;
    }

    private boolean decrementRefCount(Map referenceMap, Object key) {
        boolean result = false;
        Integer refCount = (Integer)referenceMap.get(key);
        Assert.isTrue((refCount != null ? 1 : 0) != 0);
        if (refCount == 1) {
            referenceMap.remove(key);
            result = true;
        } else {
            referenceMap.put(key, new Integer(refCount - 1));
        }
        return result;
    }

    private boolean removeModel(Object source, ISaveableModel model) {
        boolean result = false;
        HashSet modelsForSource = (HashSet)this.modelMap.get(source);
        if (modelsForSource == null) {
            modelsForSource = new HashSet();
            this.modelMap.put(source, modelsForSource);
        }
        if (modelsForSource.remove(model)) {
            result = this.decrementRefCount(this.modelRefCounts, model);
            if (modelsForSource.isEmpty()) {
                this.modelMap.remove(source);
            }
        }
        return result;
    }

    public void handleModelLifecycleEvent(ModelLifecycleEvent event) {
        ISaveableModel[] modelArray = event.getModels();
        switch (event.getEventType()) {
            case 1: {
                this.addModels(event.getSource(), modelArray);
                break;
            }
            case 2: {
                ISaveableModel[] models = event.getModels();
                HashMap modelsDecrementing = new HashMap();
                HashSet modelsClosing = new HashSet();
                int i = 0;
                while (i < models.length) {
                    this.incrementRefCount(modelsDecrementing, models[i]);
                    ++i;
                }
                this.fillModelsClosing(modelsClosing, modelsDecrementing);
                boolean canceled = this.promptForSavingIfNecessary(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), modelsClosing, !event.isForce());
                if (!canceled) break;
                event.setVeto(true);
                break;
            }
            case 3: {
                this.removeModels(event.getSource(), modelArray);
                break;
            }
            case 4: {
                this.fireModelLifecycleEvent(new ModelLifecycleEvent(this, event.getEventType(), event.getModels(), false));
            }
        }
    }

    private void removeModels(Object source, ISaveableModel[] modelArray) {
        ArrayList<ISaveableModel> removed = new ArrayList<ISaveableModel>();
        int i = 0;
        while (i < modelArray.length) {
            ISaveableModel model = modelArray[i];
            if (this.removeModel(source, model)) {
                removed.add(model);
            }
            ++i;
        }
        if (removed.size() > 0) {
            this.fireModelLifecycleEvent(new ModelLifecycleEvent(this, 1, removed.toArray(new ISaveableModel[removed.size()]), false));
        }
    }

    private void addModels(Object source, ISaveableModel[] modelArray) {
        ArrayList<ISaveableModel> added = new ArrayList<ISaveableModel>();
        int i = 0;
        while (i < modelArray.length) {
            ISaveableModel model = modelArray[i];
            if (this.addModel(source, model)) {
                added.add(model);
            }
            ++i;
        }
        if (added.size() > 0) {
            this.fireModelLifecycleEvent(new ModelLifecycleEvent(this, 1, added.toArray(new ISaveableModel[added.size()]), false));
        }
    }

    private void fireModelLifecycleEvent(ModelLifecycleEvent event) {
        Object[] listenerArray = this.listeners.getListeners();
        int i = 0;
        while (i < listenerArray.length) {
            ((IModelLifecycleListener)listenerArray[i]).handleModelLifecycleEvent(event);
            ++i;
        }
    }

    public void addModelLifecycleListener(IModelLifecycleListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeModelLifecycleListener(IModelLifecycleListener listener) {
        this.listeners.remove((Object)listener);
    }

    public Object preCloseParts(List editorsToClose, boolean save, IWorkbenchWindow window) {
        boolean canceled;
        PostCloseInfo postCloseInfo = new PostCloseInfo();
        Iterator it = editorsToClose.iterator();
        while (it.hasNext()) {
            ISaveablePart2 saveablePart2;
            int response;
            IWorkbenchPart part = (IWorkbenchPart)it.next();
            postCloseInfo.partsClosing.add(part);
            if (part instanceof ISaveablePart) {
                ISaveablePart saveablePart = (ISaveablePart)((Object)part);
                if (save && !saveablePart.isSaveOnCloseNeeded()) continue;
            }
            if (save && part instanceof ISaveablePart2 && (response = SaveableHelper.savePart(saveablePart2 = (ISaveablePart2)((Object)part), window, true)) != 3) continue;
            ISaveableModel[] modelsFromSource = this.getSaveableModels(part);
            int i = 0;
            while (i < modelsFromSource.length) {
                this.incrementRefCount(postCloseInfo.modelsDecrementing, modelsFromSource[i]);
                ++i;
            }
        }
        this.fillModelsClosing(postCloseInfo.modelsClosing, postCloseInfo.modelsDecrementing);
        if (save && (canceled = this.promptForSavingIfNecessary(window, postCloseInfo.modelsClosing, true))) {
            return null;
        }
        return postCloseInfo;
    }

    private boolean promptForSavingIfNecessary(IWorkbenchWindow window, Set modelsClosing, boolean canCancel) {
        ArrayList<ISaveableModel> modelsToSave = new ArrayList<ISaveableModel>();
        Iterator it = modelsClosing.iterator();
        while (it.hasNext()) {
            ISaveableModel modelClosing = (ISaveableModel)it.next();
            if (!modelClosing.isDirty()) continue;
            modelsToSave.add(modelClosing);
        }
        return modelsToSave.isEmpty() ? false : this.promptForSaving(modelsToSave, window, canCancel);
    }

    private void fillModelsClosing(Set modelsClosing, Map modelsDecrementing) {
        Iterator it = modelsDecrementing.keySet().iterator();
        while (it.hasNext()) {
            ISaveableModel model = (ISaveableModel)it.next();
            if (!modelsDecrementing.get(model).equals(this.modelRefCounts.get(model))) continue;
            modelsClosing.add(model);
        }
    }

    private boolean promptForSaving(List modelsToSave, IWorkbenchWindow window, boolean canCancel) {
        List<Object> finalModels;
        IRunnableWithProgress progressOp;
        block7: {
            block8: {
                if (modelsToSave.size() <= 0) break block7;
                if (modelsToSave.size() != 1) break block8;
                ISaveableModel model = (ISaveableModel)modelsToSave.get(0);
                String message = NLS.bind((String)WorkbenchMessages.EditorManager_saveChangesQuestion, (Object)model.getName());
                String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                MessageDialog d = new MessageDialog(window.getShell(), WorkbenchMessages.Save_Resource, null, message, 3, buttons, 0);
                int choice = SaveableHelper.testGetAutomatedResponse();
                if (SaveableHelper.testGetAutomatedResponse() == -1) {
                    choice = d.open();
                }
                switch (choice) {
                    case 0: {
                        break block7;
                    }
                    case 1: {
                        modelsToSave.clear();
                        break block7;
                    }
                    default: {
                        return true;
                    }
                }
            }
            MyListSelectionDialog dlg = new MyListSelectionDialog(window.getShell(), modelsToSave, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new WorkbenchPartLabelProvider(), EditorManager.RESOURCES_TO_SAVE_MESSAGE, canCancel);
            dlg.setInitialSelections(modelsToSave.toArray());
            dlg.setTitle(EditorManager.SAVE_RESOURCES_TITLE);
            if (SaveableHelper.testGetAutomatedResponse() == -1) {
                int result = dlg.open();
                if (result == 1) {
                    return true;
                }
                modelsToSave = Arrays.asList(dlg.getResult());
            }
        }
        return !SaveableHelper.runProgressMonitorOperation(WorkbenchMessages.Save_All, progressOp = new IRunnableWithProgress(finalModels = modelsToSave, window){
            private final /* synthetic */ List val$finalModels;
            private final /* synthetic */ IWorkbenchWindow val$window;
            {
                this.val$finalModels = list;
                this.val$window = iWorkbenchWindow;
            }

            public void run(IProgressMonitor monitor) {
                EventLoopProgressMonitor monitorWrap = new EventLoopProgressMonitor(monitor);
                monitorWrap.beginTask("", this.val$finalModels.size());
                Iterator i = this.val$finalModels.iterator();
                while (i.hasNext()) {
                    ISaveableModel model = (ISaveableModel)i.next();
                    if (!model.isDirty()) {
                        monitor.worked(1);
                        continue;
                    }
                    try {
                        model.doSave((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitorWrap, 1));
                    }
                    catch (CoreException e) {
                        ErrorDialog.openError((Shell)this.val$window.getShell(), (String)WorkbenchMessages.Error, (String)e.getMessage(), (IStatus)e.getStatus());
                    }
                    if (monitorWrap.isCanceled()) break;
                }
                monitorWrap.done();
            }
        }, window);
    }

    public void postClose(Object postCloseInfoObject) {
        PostCloseInfo postCloseInfo = (PostCloseInfo)postCloseInfoObject;
        ArrayList<ISaveableModel> removed = new ArrayList<ISaveableModel>();
        Iterator it = postCloseInfo.partsClosing.iterator();
        while (it.hasNext()) {
            IWorkbenchPart part = (IWorkbenchPart)it.next();
            ISaveableModel[] modelArray = this.getSaveableModels(part);
            int i = 0;
            while (i < modelArray.length) {
                ISaveableModel model = modelArray[i];
                if (this.removeModel(part, model)) {
                    removed.add(model);
                }
                ++i;
            }
        }
        if (removed.size() > 0) {
            this.fireModelLifecycleEvent(new ModelLifecycleEvent(this, 3, removed.toArray(new ISaveableModel[removed.size()]), false));
        }
    }

    private ISaveableModel[] getSaveableModels(IWorkbenchPart part) {
        if (part instanceof ISaveableModelSource) {
            ISaveableModelSource source = (ISaveableModelSource)((Object)part);
            return source.getModels();
        }
        if (part instanceof ISaveablePart) {
            return new ISaveableModel[]{new DefaultSaveableModel(part)};
        }
        return new ISaveableModel[0];
    }

    public void postOpen(IWorkbenchPart part) {
        this.addModels(part, this.getSaveableModels(part));
    }

    public void dirtyChanged(IWorkbenchPart part) {
        ISaveableModel[] saveableModels = this.getSaveableModels(part);
        if (saveableModels.length > 0) {
            this.fireModelLifecycleEvent(new ModelLifecycleEvent(this, 4, saveableModels, false));
        }
    }

    public Object[] testGetSourcesForModel(ISaveableModel model) {
        ArrayList result = new ArrayList();
        Iterator it = this.modelMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Set values = (Set)entry.getValue();
            if (!values.contains(model)) continue;
            result.add(entry.getKey());
        }
        return result.toArray();
    }

    private static class PostCloseInfo {
        private List partsClosing = new ArrayList();
        private Map modelsDecrementing = new HashMap();
        private Set modelsClosing = new HashSet();

        private PostCloseInfo() {
        }
    }

    private static final class MyListSelectionDialog
    extends ListSelectionDialog {
        private final boolean canCancel;

        private MyListSelectionDialog(Shell shell, Object input, IStructuredContentProvider contentprovider, ILabelProvider labelProvider, String message, boolean canCancel) {
            super(shell, input, contentprovider, labelProvider, message);
            this.canCancel = canCancel;
            if (!canCancel) {
                int shellStyle = this.getShellStyle();
                this.setShellStyle(shellStyle &= 0xFFFFFFBF);
            }
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            if (this.canCancel) {
                this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            }
        }
    }
}

