/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.text.Collator;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.themes.ITheme;

public class ViewsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button showTextOnPerspectiveBar;
    private Button showTraditionalStyleTabs;
    private Button enableAnimations;
    private Button editorTopButton;
    private Button editorBottomButton;
    private Button viewTopButton;
    private Button viewBottomButton;
    private Button perspLeftButton;
    private Button perspTopLeftButton;
    private Button perspTopRightButton;
    static final String EDITORS_TITLE = WorkbenchMessages.ViewsPreference_editors;
    private static final String EDITORS_TOP_TITLE = WorkbenchMessages.ViewsPreference_editors_top;
    private static final String EDITORS_BOTTOM_TITLE = WorkbenchMessages.ViewsPreference_editors_bottom;
    private static final String VIEWS_TITLE = WorkbenchMessages.ViewsPreference_views;
    private static final String VIEWS_TOP_TITLE = WorkbenchMessages.ViewsPreference_views_top;
    private static final String VIEWS_BOTTOM_TITLE = WorkbenchMessages.ViewsPreference_views_bottom;
    private static final String PERSP_TITLE = WorkbenchMessages.ViewsPreference_perspectiveBar;
    private static final String PERSP_LEFT_TITLE = WorkbenchMessages.ViewsPreference_perspectiveBar_left;
    private static final String PERSP_TOP_LEFT_TITLE = WorkbenchMessages.ViewsPreference_perspectiveBar_topLeft;
    private static final String PERSP_TOP_RIGHT_TITLE = WorkbenchMessages.ViewsPreference_perspectiveBar_topRight;
    private static final String R21PRESENTATION_ID = "org.eclipse.ui.internal.r21presentationFactory";
    private static final String R30PRESENTATION_ID = "org.eclipse.ui.presentations.default";
    private static final String INITIAL_VAL = new String();
    private static final int INITIAL_LOC_INT = -1;
    private String fastViewLoc = INITIAL_VAL;
    private String showTextOnPerspBar = INITIAL_VAL;
    private int editorAlignment;
    private boolean editorAlignmentChanged = false;
    private int viewAlignment;
    private boolean viewAlignmentChanged = false;
    private String perspBarLocation;
    private Combo themeCombo;
    private Combo presentationCombo;
    private IConfigurationElement[] presentationFactories;
    private String currentPresentationFactoryId;
    private Button overridePresButton;
    private IPropertyChangeListener overrideListener;
    private boolean restartPosted = false;

    private Group createButtonGroup(Composite composite, String title) {
        Group buttonComposite = new Group(composite, 0);
        buttonComposite.setText(title);
        buttonComposite.setFont(composite.getFont());
        FormLayout layout = new FormLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        buttonComposite.setLayoutData((Object)data);
        return buttonComposite;
    }

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.views_preference_page_context");
        IPreferenceStore internalStore = PrefUtil.getInternalPreferenceStore();
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.editorAlignment = internalStore.getInt("EDITOR_TAB_POSITION");
        this.viewAlignment = internalStore.getInt("VIEW_TAB_POSITION");
        this.perspBarLocation = apiStore.getString("DOCK_PERSPECTIVE_BAR");
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(font);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.createPresentationCombo(composite);
        this.createPresentationOverride(composite);
        this.createEditorTabButtonGroup(composite);
        this.createViewTabButtonGroup(composite);
        this.createPerspBarTabButtonGroup(composite);
        this.createShowTextOnPerspectiveBarPref(composite);
        this.hookOverrideListener();
        this.updateOverride();
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        Label label = new Label(composite, 0);
        label.setText(WorkbenchMessages.ViewsPreference_currentTheme);
        label.setFont(parent.getFont());
        label.setLayoutData((Object)data);
        data = new GridData(256);
        data.horizontalSpan = 2;
        this.themeCombo = new Combo(composite, 8);
        this.themeCombo.setLayoutData((Object)data);
        this.themeCombo.setFont(parent.getFont());
        this.refreshThemeCombo(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getId());
        this.createShowTraditionalStyleTabsPref(composite);
        this.createEnableAnimationsPref(composite);
        return composite;
    }

    private void createPresentationOverride(Composite parent) {
        String barLocation;
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.overridePresButton = new Button(parent, 32);
        this.overridePresButton.setText(WorkbenchMessages.ViewsPreferencePage_override);
        this.overridePresButton.setFont(parent.getFont());
        this.overridePresButton.setLayoutData((Object)data);
        IPreferenceStore store = this.getPreferenceStore();
        boolean override = store.getBoolean("overridepresentation");
        boolean showText = PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR");
        if ((showText && this.isR21(this.currentPresentationFactoryId) || !showText && this.isR30(this.currentPresentationFactoryId)) && !override) {
            store.setValue("overridepresentation", true);
            override = true;
        }
        if ((!(barLocation = PrefUtil.getAPIPreferenceStore().getString("DOCK_PERSPECTIVE_BAR")).equals("left") && this.isR21(this.currentPresentationFactoryId) || !barLocation.equals("topRight") && this.isR30(this.currentPresentationFactoryId)) && !override) {
            store.setValue("overridepresentation", true);
            override = true;
        }
        this.overridePresButton.setSelection(override);
        this.overridePresButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ViewsPreferencePage.this.updateOverrideState(ViewsPreferencePage.this.overridePresButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ViewsPreferencePage.this.updateOverrideState(ViewsPreferencePage.this.overridePresButton.getSelection());
            }
        });
    }

    private void updateOverrideState(boolean override) {
        IPreferenceStore store = this.getPreferenceStore();
        if (store.getBoolean("overridepresentation") != override) {
            store.setValue("overridepresentation", override);
        }
        this.setPresentationPrefs(this.getSelectedPresentationID());
    }

    private void createPresentationCombo(Composite parent) {
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        Label label = new Label(parent, 0);
        label.setText(WorkbenchMessages.ViewsPreference_currentPresentation);
        label.setFont(parent.getFont());
        label.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.presentationCombo = new Combo(parent, 8);
        this.presentationCombo.setFont(parent.getFont());
        this.presentationCombo.setLayoutData((Object)data);
        this.presentationCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.updateSettings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.updateSettings();
            }

            private void updateSettings() {
                if (!ViewsPreferencePage.this.overridePresButton.getSelection()) {
                    ViewsPreferencePage.this.setPresentationPrefs(ViewsPreferencePage.this.getSelectedPresentationID());
                }
            }
        });
        this.refreshPresentationCombo();
        this.setPresentationSelection();
    }

    private void attachControls(Control leftControl, Control rightControl) {
        FormData leftData = new FormData();
        leftData.left = new FormAttachment(0, 0);
        FormData rightData = new FormData();
        rightData.left = new FormAttachment(leftControl, 5);
        leftControl.setLayoutData((Object)leftData);
        rightControl.setLayoutData((Object)rightData);
    }

    private void createEditorTabButtonGroup(Composite composite) {
        Font font = composite.getFont();
        Group buttonComposite = this.createButtonGroup(composite, EDITORS_TITLE);
        this.editorTopButton = new Button((Composite)buttonComposite, 16);
        this.editorTopButton.setText(EDITORS_TOP_TITLE);
        this.editorTopButton.setSelection(this.editorAlignment == 128);
        this.editorTopButton.setFont(font);
        this.editorTopButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = EDITORS_TITLE;
            }
        });
        this.editorBottomButton = new Button((Composite)buttonComposite, 16);
        this.editorBottomButton.setText(EDITORS_BOTTOM_TITLE);
        this.editorBottomButton.setSelection(this.editorAlignment == 1024);
        this.editorBottomButton.setFont(font);
        SelectionAdapter sel = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget.equals(ViewsPreferencePage.this.editorTopButton)) {
                    if (ViewsPreferencePage.this.editorAlignment != 128) {
                        ViewsPreferencePage.this.editorAlignment = 128;
                        ViewsPreferencePage.this.editorAlignmentChanged = true;
                    }
                } else if (e.widget.equals(ViewsPreferencePage.this.editorBottomButton) && ViewsPreferencePage.this.editorAlignment != 1024) {
                    ViewsPreferencePage.this.editorAlignment = 1024;
                    ViewsPreferencePage.this.editorAlignmentChanged = true;
                }
            }
        };
        this.editorTopButton.addSelectionListener((SelectionListener)sel);
        this.editorBottomButton.addSelectionListener((SelectionListener)sel);
        this.attachControls((Control)this.editorTopButton, (Control)this.editorBottomButton);
    }

    private void createViewTabButtonGroup(Composite composite) {
        Font font = composite.getFont();
        Group buttonComposite = this.createButtonGroup(composite, VIEWS_TITLE);
        buttonComposite.setFont(font);
        this.viewTopButton = new Button((Composite)buttonComposite, 16);
        this.viewTopButton.setText(VIEWS_TOP_TITLE);
        this.viewTopButton.setSelection(this.viewAlignment == 128);
        this.viewTopButton.setFont(font);
        this.viewBottomButton = new Button((Composite)buttonComposite, 16);
        this.viewBottomButton.setText(VIEWS_BOTTOM_TITLE);
        this.viewBottomButton.setSelection(this.viewAlignment == 1024);
        this.viewBottomButton.setFont(font);
        SelectionAdapter sel = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget.equals(ViewsPreferencePage.this.viewTopButton)) {
                    if (ViewsPreferencePage.this.viewAlignment != 128) {
                        ViewsPreferencePage.this.viewAlignment = 128;
                        ViewsPreferencePage.this.viewAlignmentChanged = true;
                    }
                } else if (e.widget.equals(ViewsPreferencePage.this.viewBottomButton) && ViewsPreferencePage.this.viewAlignment != 1024) {
                    ViewsPreferencePage.this.viewAlignment = 1024;
                    ViewsPreferencePage.this.viewAlignmentChanged = true;
                }
            }
        };
        this.viewTopButton.addSelectionListener((SelectionListener)sel);
        this.viewBottomButton.addSelectionListener((SelectionListener)sel);
        this.attachControls((Control)this.viewTopButton, (Control)this.viewBottomButton);
    }

    private void createPerspBarTabButtonGroup(Composite composite) {
        Font font = composite.getFont();
        Group buttonComposite = this.createButtonGroup(composite, PERSP_TITLE);
        buttonComposite.setFont(font);
        this.perspLeftButton = new Button((Composite)buttonComposite, 16);
        this.perspLeftButton.setText(PERSP_LEFT_TITLE);
        this.perspLeftButton.setSelection("left".equals(this.perspBarLocation));
        this.perspLeftButton.setFont(font);
        this.perspLeftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewsPreferencePage.this.perspBarLocation = "left";
            }
        });
        this.perspTopLeftButton = new Button((Composite)buttonComposite, 16);
        this.perspTopLeftButton.setText(PERSP_TOP_LEFT_TITLE);
        this.perspTopLeftButton.setSelection("topLeft".equals(this.perspBarLocation));
        this.perspTopLeftButton.setFont(font);
        this.perspTopLeftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewsPreferencePage.this.perspBarLocation = "topLeft";
            }
        });
        this.perspTopRightButton = new Button((Composite)buttonComposite, 16);
        this.perspTopRightButton.setText(PERSP_TOP_RIGHT_TITLE);
        this.perspTopRightButton.setSelection("topRight".equals(this.perspBarLocation));
        this.perspTopRightButton.setFont(font);
        this.perspTopRightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewsPreferencePage.this.perspBarLocation = "topRight";
            }
        });
        FormData leftData = new FormData();
        leftData.left = new FormAttachment(0, 5);
        FormData topLeftData = new FormData();
        topLeftData.left = new FormAttachment((Control)this.perspLeftButton, 5);
        FormData topRightData = new FormData();
        topRightData.left = new FormAttachment((Control)this.perspTopLeftButton, 0);
        this.perspLeftButton.setLayoutData((Object)leftData);
        this.perspTopLeftButton.setLayoutData((Object)topLeftData);
        this.perspTopRightButton.setLayoutData((Object)topRightData);
    }

    private void hookOverrideListener() {
        if (this.overrideListener != null) {
            return;
        }
        IPreferenceStore store = this.getPreferenceStore();
        this.overrideListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("overridepresentation")) {
                    ViewsPreferencePage.this.updateOverride();
                }
            }
        };
        store.addPropertyChangeListener(this.overrideListener);
    }

    public void dispose() {
        super.dispose();
        if (this.overrideListener != null) {
            this.getPreferenceStore().removePropertyChangeListener(this.overrideListener);
            this.overrideListener = null;
        }
    }

    private void updateOverride() {
        boolean override = this.getPreferenceStore().getBoolean("overridepresentation");
        this.editorTopButton.setEnabled(override);
        this.editorBottomButton.setEnabled(override);
        this.viewTopButton.setEnabled(override);
        this.viewBottomButton.setEnabled(override);
        this.perspTopLeftButton.setEnabled(override);
        this.perspLeftButton.setEnabled(override);
        this.perspTopRightButton.setEnabled(override);
        this.showTextOnPerspectiveBar.setEnabled(override);
    }

    private void refreshPresentationCombo() {
        this.presentationCombo.removeAll();
        this.refreshPresentationFactories();
        int i = 0;
        while (i < this.presentationFactories.length) {
            IConfigurationElement el = this.presentationFactories[i];
            String name = el.getAttribute("name");
            if (!this.currentPresentationFactoryId.equals(el.getAttribute("id"))) {
                this.presentationCombo.add(name);
            } else {
                this.presentationCombo.add(NLS.bind((String)WorkbenchMessages.ViewsPreference_currentPresentationFormat, (Object)name));
            }
            ++i;
        }
    }

    private void setPresentationSelection() {
        int i = 0;
        while (i < this.presentationFactories.length) {
            if (this.currentPresentationFactoryId.equals(this.presentationFactories[i].getAttribute("id"))) {
                this.presentationCombo.select(i);
                break;
            }
            ++i;
        }
    }

    private void refreshPresentationFactories() {
        this.currentPresentationFactoryId = PrefUtil.getAPIPreferenceStore().getString("presentationFactoryId");
        this.presentationFactories = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui", "presentationFactories");
        Arrays.sort(this.presentationFactories, new Comparator(){
            Collator collator = Collator.getInstance(Locale.getDefault());

            public int compare(Object a, Object b) {
                IConfigurationElement el1 = (IConfigurationElement)a;
                IConfigurationElement el2 = (IConfigurationElement)b;
                return this.collator.compare(el1.getAttribute("name"), el2.getAttribute("name"));
            }
        });
    }

    private boolean updatePresentationPreferences() {
        if (this.presentationCombo == null) {
            return false;
        }
        String id = this.getSelectedPresentationID();
        if (id.equals(this.currentPresentationFactoryId)) {
            return false;
        }
        this.currentPresentationFactoryId = id;
        this.setPresentationPrefs(id);
        PrefUtil.getAPIPreferenceStore().putValue("presentationFactoryId", id);
        return true;
    }

    private void setPresentationPrefs(String id) {
        if (this.isR21(id)) {
            this.setR21Preferences();
        } else if (this.isR30(id)) {
            this.setR30Preferences();
        }
    }

    private boolean isR30(String id) {
        return R30PRESENTATION_ID.equals(id);
    }

    private boolean isR21(String id) {
        return R21PRESENTATION_ID.equals(id);
    }

    private String getSelectedPresentationID() {
        int selection = this.presentationCombo.getSelectionIndex();
        IConfigurationElement element = this.presentationFactories[selection];
        String id = element.getAttribute("id");
        return id;
    }

    private void setR30Preferences() {
        IPreferenceStore internalStore = PrefUtil.getInternalPreferenceStore();
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.setEditorAlignDefault(internalStore);
        this.setViewAlignDefault(internalStore);
        this.perspBarLocation = apiStore.getDefaultString("DOCK_PERSPECTIVE_BAR");
        this.perspLeftButton.setSelection(this.perspBarLocation.equals("left"));
        this.perspTopLeftButton.setSelection(this.perspBarLocation.equals("topLeft"));
        this.perspTopRightButton.setSelection(this.perspBarLocation.equals("topRight"));
        this.perspBarLocation = INITIAL_VAL;
        this.showTextOnPerspectiveBar.setSelection(apiStore.getDefaultBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR"));
        this.showTextOnPerspBar = INITIAL_VAL;
        this.fastViewLoc = INITIAL_VAL;
    }

    private void setViewAlignDefault(IPreferenceStore internalStore) {
        int oldVal = this.viewAlignment;
        this.viewAlignment = internalStore.getDefaultInt("VIEW_TAB_POSITION");
        this.viewTopButton.setSelection(this.viewAlignment == 128);
        this.viewBottomButton.setSelection(this.viewAlignment == 1024);
        if (oldVal != this.viewAlignment) {
            this.viewAlignmentChanged = true;
        }
        this.viewAlignment = -1;
    }

    private void setEditorAlignDefault(IPreferenceStore internalStore) {
        int oldVal = this.editorAlignment;
        this.editorAlignment = internalStore.getDefaultInt("EDITOR_TAB_POSITION");
        this.editorTopButton.setSelection(this.editorAlignment == 128);
        this.editorBottomButton.setSelection(this.editorAlignment == 1024);
        if (oldVal != this.editorAlignment) {
            this.editorAlignmentChanged = true;
        }
        this.editorAlignment = -1;
    }

    private void setR21Preferences() {
        int oldVal = this.editorAlignment;
        this.editorAlignment = 128;
        this.editorTopButton.setSelection(this.editorAlignment == 128);
        this.editorBottomButton.setSelection(this.editorAlignment == 1024);
        if (oldVal != this.editorAlignment) {
            this.editorAlignmentChanged = true;
        }
        oldVal = this.viewAlignment;
        this.viewAlignment = 1024;
        this.viewTopButton.setSelection(this.viewAlignment == 128);
        this.viewBottomButton.setSelection(this.viewAlignment == 1024);
        if (oldVal != this.viewAlignment) {
            this.viewAlignmentChanged = true;
        }
        this.perspBarLocation = "left";
        this.perspLeftButton.setSelection(this.perspBarLocation.equals("left"));
        this.perspTopLeftButton.setSelection(this.perspBarLocation.equals("topLeft"));
        this.perspTopRightButton.setSelection(this.perspBarLocation.equals("topRight"));
        this.showTextOnPerspectiveBar.setSelection(false);
        this.showTextOnPerspBar = String.valueOf(false);
        this.fastViewLoc = "left";
    }

    private void refreshThemeCombo(String themeToSelect) {
        this.themeCombo.removeAll();
        ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        IThemeDescriptor[] descs = WorkbenchPlugin.getDefault().getThemeRegistry().getThemes();
        String defaultThemeString = PlatformUI.getWorkbench().getThemeManager().getTheme("org.eclipse.ui.defaultTheme").getLabel();
        if (currentTheme.getId().equals("org.eclipse.ui.defaultTheme")) {
            defaultThemeString = MessageFormat.format(WorkbenchMessages.ViewsPreference_currentThemeFormat, defaultThemeString);
        }
        this.themeCombo.add(defaultThemeString);
        int selection = 0;
        int i = 0;
        while (i < descs.length) {
            String themeString = descs[i].getName();
            if (descs[i].getId().equals(currentTheme.getId())) {
                themeString = MessageFormat.format(WorkbenchMessages.ViewsPreference_currentThemeFormat, themeString);
            }
            if (themeToSelect.equals(descs[i].getId())) {
                selection = i + 1;
            }
            this.themeCombo.add(themeString);
            ++i;
        }
        this.themeCombo.select(selection);
    }

    protected void createShowTextOnPerspectiveBarPref(Composite composite) {
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.showTextOnPerspectiveBar = new Button(composite, 32);
        this.showTextOnPerspectiveBar.setText(WorkbenchMessages.WorkbenchPreference_showTextOnPerspectiveBar);
        this.showTextOnPerspectiveBar.setFont(composite.getFont());
        this.showTextOnPerspectiveBar.setSelection(apiStore.getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR"));
        this.setButtonLayoutData(this.showTextOnPerspectiveBar);
    }

    protected void createShowTraditionalStyleTabsPref(Composite composite) {
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.showTraditionalStyleTabs = new Button(composite, 32);
        this.showTraditionalStyleTabs.setText(WorkbenchMessages.ViewsPreference_traditionalTabs);
        this.showTraditionalStyleTabs.setFont(composite.getFont());
        this.showTraditionalStyleTabs.setSelection(apiStore.getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        this.setButtonLayoutData(this.showTraditionalStyleTabs);
    }

    protected void createEnableAnimationsPref(Composite composite) {
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.enableAnimations = new Button(composite, 32);
        this.enableAnimations.setText(WorkbenchMessages.ViewsPreference_enableAnimations);
        this.enableAnimations.setFont(composite.getFont());
        this.enableAnimations.setSelection(apiStore.getBoolean("ENABLE_ANIMATIONS"));
        this.setButtonLayoutData(this.enableAnimations);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
        this.currentPresentationFactoryId = PrefUtil.getAPIPreferenceStore().getString("presentationFactoryId");
    }

    protected void performDefaults() {
        String presID;
        IPreferenceStore store = this.getPreferenceStore();
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.showTextOnPerspectiveBar.setSelection(apiStore.getDefaultBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR"));
        this.showTraditionalStyleTabs.setSelection(apiStore.getDefaultBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        this.enableAnimations.setSelection(apiStore.getDefaultBoolean("ENABLE_ANIMATIONS"));
        this.currentPresentationFactoryId = presID = apiStore.getDefaultString("presentationFactoryId");
        this.setPresentationSelection();
        boolean overridePrefs = store.getDefaultBoolean("overridepresentation");
        this.overridePresButton.setSelection(overridePrefs);
        this.setEditorAlignDefault(store);
        this.setViewAlignDefault(store);
        this.perspBarLocation = apiStore.getDefaultString("DOCK_PERSPECTIVE_BAR");
        this.perspLeftButton.setSelection("left".equals(this.perspBarLocation));
        this.perspTopLeftButton.setSelection("topLeft".equals(this.perspBarLocation));
        this.perspTopRightButton.setSelection("topRight".equals(this.perspBarLocation));
        this.refreshThemeCombo(PlatformUI.getWorkbench().getThemeManager().getTheme("org.eclipse.ui.defaultTheme").getId());
        WorkbenchPlugin.getDefault().savePluginPreferences();
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        boolean override = store.getBoolean("overridepresentation");
        boolean restart = this.updatePresentationPreferences();
        if (this.showTextOnPerspBar.equals(INITIAL_VAL) && !override) {
            apiStore.setToDefault("SHOW_TEXT_ON_PERSPECTIVE_BAR");
        } else {
            apiStore.setValue("SHOW_TEXT_ON_PERSPECTIVE_BAR", this.showTextOnPerspectiveBar.getSelection());
        }
        if (this.editorAlignmentChanged) {
            if (this.editorAlignment == -1) {
                store.setToDefault("EDITOR_TAB_POSITION");
            } else if (!override) {
                store.setValue("EDITOR_TAB_POSITION", this.editorAlignment);
            } else {
                store.setValue("EDITOR_TAB_POSITION", this.editorAlignment);
            }
            restart = true;
        }
        if (this.viewAlignmentChanged) {
            if (this.viewAlignment == -1) {
                store.setToDefault("VIEW_TAB_POSITION");
            } else if (!override) {
                store.setValue("VIEW_TAB_POSITION", this.viewAlignment);
            } else {
                store.setValue("VIEW_TAB_POSITION", this.viewAlignment);
            }
            restart = true;
        }
        if (this.perspBarLocation.equals(INITIAL_VAL)) {
            apiStore.setToDefault("DOCK_PERSPECTIVE_BAR");
        } else if (!override) {
            apiStore.setValue("DOCK_PERSPECTIVE_BAR", this.perspBarLocation);
        } else {
            apiStore.setValue("DOCK_PERSPECTIVE_BAR", this.perspBarLocation);
        }
        if (this.fastViewLoc.equals(INITIAL_VAL)) {
            apiStore.setToDefault("initialFastViewBarLocation");
        } else {
            apiStore.setValue("initialFastViewBarLocation", this.fastViewLoc);
        }
        int idx = this.themeCombo.getSelectionIndex();
        if (idx == 0) {
            Workbench.getInstance().getThemeManager().setCurrentTheme("org.eclipse.ui.defaultTheme");
            this.refreshThemeCombo("org.eclipse.ui.defaultTheme");
        } else {
            IThemeDescriptor applyTheme = WorkbenchPlugin.getDefault().getThemeRegistry().getThemes()[idx - 1];
            Workbench.getInstance().getThemeManager().setCurrentTheme(applyTheme.getId());
            this.refreshThemeCombo(applyTheme.getId());
        }
        apiStore.setValue("SHOW_TRADITIONAL_STYLE_TABS", this.showTraditionalStyleTabs.getSelection());
        apiStore.setValue("ENABLE_ANIMATIONS", this.enableAnimations.getSelection());
        PrefUtil.savePrefs();
        if (restart && !this.restartPosted && this.getContainer() instanceof IWorkbenchPreferenceContainer) {
            IWorkbenchPreferenceContainer container = (IWorkbenchPreferenceContainer)this.getContainer();
            UIJob job = new UIJob("Restart Request"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    int really = new MessageDialog(null, WorkbenchMessages.ViewsPreference_presentationConfirm_title, null, WorkbenchMessages.ViewsPreference_presentationConfirm_message, 3, new String[]{WorkbenchMessages.ViewsPreference_presentationConfirm_yes, WorkbenchMessages.ViewsPreference_presentationConfirm_no}, 1).open();
                    if (really == 0) {
                        PlatformUI.getWorkbench().restart();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            container.registerUpdateJob(job);
            this.restartPosted = true;
        }
        return true;
    }
}

