/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.internal.progress.AnimationItem;
import org.eclipse.ui.internal.progress.AnimationManager;
import org.eclipse.ui.internal.progress.ProgressAnimationItem;
import org.eclipse.ui.internal.progress.ProgressCanvasViewer;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressViewerContentProvider;
import org.eclipse.ui.internal.progress.ProgressViewerLabelProvider;

public class ProgressRegion
implements IWindowTrim {
    ProgressCanvasViewer viewer;
    AnimationItem item;
    Composite region;
    WorkbenchWindow workbenchWindow;
    private int fWidthHint = -1;
    private int fHeightHint = -1;

    public Control createContents(Composite parent, WorkbenchWindow window) {
        this.workbenchWindow = window;
        this.region = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 3;
        this.region.setLayout((Layout)gl);
        this.viewer = new ProgressCanvasViewer(this.region, 524288, 1, 36);
        this.viewer.setUseHashlookup(true);
        Control viewerControl = this.viewer.getControl();
        GridData gd = new GridData(1808);
        gd.widthHint = this.viewer.getSizeHints().x;
        viewerControl.setLayoutData((Object)gd);
        int widthPreference = AnimationManager.getInstance().getPreferredWidth() + 25;
        this.item = new ProgressAnimationItem(this);
        this.item.createControl(this.region);
        this.item.setAnimationContainer(new AnimationItem.IAnimationContainer(){

            public void animationDone() {
                if (ProgressRegion.this.viewer.getControl().isDisposed()) {
                    return;
                }
                ProgressRegion.this.viewer.refresh();
            }

            public void animationStart() {
            }
        });
        Control itemControl = this.item.getControl();
        gd = new GridData(1040);
        gd.widthHint = widthPreference;
        itemControl.setLayoutData((Object)gd);
        viewerControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ProgressRegion.this.processDoubleClick();
            }
        });
        ProgressViewerContentProvider provider = new ProgressViewerContentProvider(this.viewer, false, false);
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setInput(provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProgressViewerLabelProvider(viewerControl));
        this.viewer.setSorter(ProgressManagerUtil.getProgressViewerSorter());
        return this.region;
    }

    public AnimationItem getAnimationItem() {
        return this.item;
    }

    public Control getControl() {
        return this.region;
    }

    public void processDoubleClick() {
        ProgressManagerUtil.openProgressView(this.workbenchWindow);
    }

    public void dock(int dropSide) {
    }

    public String getId() {
        return "org.eclipse.ui.internal.progress.ProgressRegion";
    }

    public String getDisplayName() {
        return WorkbenchMessages.TrimCommon_Progress_TrimName;
    }

    public int getValidSides() {
        return 1024;
    }

    public boolean isCloseable() {
        return false;
    }

    public void handleClose() {
    }

    public int getWidthHint() {
        return this.fWidthHint;
    }

    public void setWidthHint(int w) {
        this.fWidthHint = w;
    }

    public int getHeightHint() {
        return this.fHeightHint;
    }

    public void setHeightHint(int h) {
        this.fHeightHint = h;
    }

    public boolean isResizeable() {
        return false;
    }
}

