/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.model;

import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.jface.util.Assert;

public class TestCaseElement
extends TestElement {
    private TestElement.Status fStatus;
    private String fTrace;
    private String fExpected;
    private String fActual;

    public TestCaseElement(TestSuiteElement parent, String id, String testName) {
        super(parent, id, testName);
        Assert.isNotNull((Object)parent);
        this.fStatus = TestElement.Status.NOT_RUN;
    }

    public void setStatus(TestElement.Status status) {
        this.fStatus = status;
    }

    public void setStatus(TestElement.Status status, String trace, String expected, String actual) {
        this.fStatus = status;
        this.fTrace = trace;
        this.fExpected = expected;
        this.fActual = actual;
    }

    public TestElement.Status getStatus() {
        return this.fStatus;
    }

    public String getTrace() {
        return this.fTrace;
    }

    public String getExpected() {
        return this.fExpected;
    }

    public String getActual() {
        return this.fActual;
    }

    public boolean isComparisonFailure() {
        return this.fExpected != null && this.fActual != null;
    }

    public String getTestMethodName() {
        int index = this.getTestName().indexOf(40);
        if (index > 0) {
            return this.getTestName().substring(0, index);
        }
        index = this.getTestName().indexOf(64);
        if (index > 0) {
            return this.getTestName().substring(0, index);
        }
        return this.getTestName();
    }
}

