/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CopyFailureListAction
extends Action {
    private final Clipboard fClipboard;
    private final TestRunnerViewPart fRunner;

    public CopyFailureListAction(TestRunnerViewPart runner, Clipboard clipboard) {
        super(JUnitMessages.CopyFailureList_action_label);
        this.fRunner = runner;
        this.fClipboard = clipboard;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.junit.copy_failure_list_action_context");
    }

    public void run() {
        block3: {
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            try {
                this.fClipboard.setContents((Object[])new String[]{this.getAllFailureTraces()}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)JUnitMessages.CopyFailureList_problem, (String)JUnitMessages.CopyFailureList_clipboard_busy)) break block3;
                this.run();
            }
        }
    }

    public String getAllFailureTraces() {
        StringBuffer buf = new StringBuffer();
        TestCaseElement[] failures = this.fRunner.getAllFailures();
        String lineDelim = System.getProperty("line.separator", "\n");
        int i = 0;
        while (i < failures.length) {
            TestCaseElement failure = failures[i];
            buf.append(failure.getTestName()).append(lineDelim);
            String failureTrace = failure.getTrace();
            if (failureTrace != null) {
                int start = 0;
                while (start < failureTrace.length()) {
                    int idx = failureTrace.indexOf(10, start);
                    if (idx != -1) {
                        String line = failureTrace.substring(start, idx - 1);
                        buf.append(line).append(lineDelim);
                        start = idx + 1;
                        continue;
                    }
                    start = Integer.MAX_VALUE;
                }
            }
            ++i;
        }
        return buf.toString();
    }
}

