/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.junit.model.JUnitModel;
import org.eclipse.jdt.junit.ITestRunListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class JUnitPlugin
extends AbstractUIPlugin {
    private static JUnitPlugin fgPlugin = null;
    public static final String PLUGIN_ID = "org.eclipse.jdt.junit";
    public static final String ID_EXTENSION_POINT_TESTRUN_LISTENERS = "org.eclipse.jdt.junit.testRunListeners";
    public static final String ID_EXTENSION_POINT_JUNIT_LAUNCHCONFIGS = "org.eclipse.jdt.junit.junitLaunchConfigs";
    public static final String TEST_SUPERCLASS_NAME = "junit.framework.TestCase";
    public static final String TEST_INTERFACE_NAME = "junit.framework.Test";
    public static final String SIMPLE_TEST_INTERFACE_NAME = "Test";
    public static final String JUNIT_HOME = "JUNIT_HOME";
    public static final String JUNIT_SRC_HOME = "JUNIT_SRC_HOME";
    private static final IPath ICONS_PATH = new Path("$nl$/icons/full");
    private final JUnitModel fJUnitModel = new JUnitModel();
    private List fTestRunListeners;
    private List fJUnitLaunchConfigTypeIDs;
    private static boolean fIsStopped = false;

    public JUnitPlugin() {
        fgPlugin = this;
    }

    public static JUnitPlugin getDefault() {
        return fgPlugin;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow workBenchWindow = JUnitPlugin.getActiveWorkbenchWindow();
        if (workBenchWindow == null) {
            return null;
        }
        return workBenchWindow.getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (fgPlugin == null) {
            return null;
        }
        IWorkbench workBench = fgPlugin.getWorkbench();
        if (workBench == null) {
            return null;
        }
        return workBench.getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = JUnitPlugin.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static void log(Throwable e) {
        JUnitPlugin.log((IStatus)new Status(4, JUnitPlugin.getPluginId(), 4, "Error", e));
    }

    public static void log(IStatus status) {
        JUnitPlugin.getDefault().getLog().log(status);
    }

    public static ImageDescriptor getImageDescriptor(String relativePath) {
        IPath path = ICONS_PATH.append(relativePath);
        return JUnitPlugin.createImageDescriptor(JUnitPlugin.getDefault().getBundle(), path, true);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        JUnitPlugin.setImageDescriptors(action, "lcl16", iconName);
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id = JUnitPlugin.createImageDescriptor("d" + type, relPath, false);
        if (id != null) {
            action.setDisabledImageDescriptor(id);
        }
        ImageDescriptor descriptor = JUnitPlugin.createImageDescriptor("e" + type, relPath, true);
        action.setHoverImageDescriptor(descriptor);
        action.setImageDescriptor(descriptor);
    }

    private static ImageDescriptor createImageDescriptor(String pathPrefix, String imageName, boolean useMissingImageDescriptor) {
        IPath path = ICONS_PATH.append(pathPrefix).append(imageName);
        return JUnitPlugin.createImageDescriptor(JUnitPlugin.getDefault().getBundle(), path, useMissingImageDescriptor);
    }

    private static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fJUnitModel.start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext context) throws Exception {
        fIsStopped = true;
        try {
            this.fJUnitModel.stop();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.stop(context);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        super.stop(context);
    }

    public static JUnitModel getModel() {
        return JUnitPlugin.getDefault().fJUnitModel;
    }

    private void loadTestRunListeners() {
        this.fTestRunListeners = new ArrayList();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ID_EXTENSION_POINT_TESTRUN_LISTENERS);
        if (extensionPoint == null) {
            return;
        }
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        MultiStatus status = new MultiStatus(PLUGIN_ID, 0, "Could not load some testRunner extension points", null);
        int i = 0;
        while (i < configs.length) {
            try {
                ITestRunListener testRunListener = (ITestRunListener)configs[i].createExecutableExtension("class");
                this.fTestRunListeners.add(testRunListener);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
            ++i;
        }
        if (!status.isOK()) {
            JUnitPlugin.log((IStatus)status);
        }
    }

    private void loadLaunchConfigTypeIDs() {
        this.fJUnitLaunchConfigTypeIDs = new ArrayList();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ID_EXTENSION_POINT_JUNIT_LAUNCHCONFIGS);
        if (extensionPoint == null) {
            return;
        }
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configs.length) {
            String configTypeID = configs[i].getAttribute("configTypeID");
            this.fJUnitLaunchConfigTypeIDs.add(configTypeID);
            ++i;
        }
    }

    public ITestRunListener[] getTestRunListeners() {
        if (this.fTestRunListeners == null) {
            this.loadTestRunListeners();
        }
        return this.fTestRunListeners.toArray(new ITestRunListener[this.fTestRunListeners.size()]);
    }

    public List getJUnitLaunchConfigTypeIDs() {
        if (this.fJUnitLaunchConfigTypeIDs == null) {
            this.loadLaunchConfigTypeIDs();
        }
        return this.fJUnitLaunchConfigTypeIDs;
    }

    public void addTestRunListener(ITestRunListener newListener) {
        if (this.fTestRunListeners == null) {
            this.loadTestRunListeners();
        }
        Iterator iter = this.fTestRunListeners.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o != newListener) continue;
            return;
        }
        this.fTestRunListeners.add(newListener);
    }

    public void removeTestRunListener(ITestRunListener newListener) {
        if (this.fTestRunListeners != null) {
            this.fTestRunListeners.remove(newListener);
        }
    }

    public static boolean isStopped() {
        return fIsStopped;
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }
}

