/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestRoot;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.OpenTestAction;
import org.eclipse.jdt.internal.junit.ui.RerunAction;
import org.eclipse.jdt.internal.junit.ui.TestRunnerViewPart;
import org.eclipse.jdt.internal.junit.ui.TestSessionContentProvider;
import org.eclipse.jdt.internal.junit.ui.TestSessionLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class TestViewer {
    private final TestRunnerViewPart fTestRunnerPart;
    private final TreeViewer fTreeViewer;
    private final Image fHierarchyIcon;
    private final TestSessionContentProvider fTestSessionContentProvider;
    private final TestSessionLabelProvider fTestSessionLabelProvider;
    private ViewerFilter fFailuresOnlyFilter;
    private int fLayoutMode;
    private TestRunSession fTestRunSession;
    private boolean fNeedRefresh;
    private HashSet fNeedUpdate;
    private TestCaseElement fAutoScrollTarget;
    private LinkedList fAutoClose;
    private HashSet fAutoExpand;

    public TestViewer(Composite parent, TestRunnerViewPart runner) {
        this.fTestRunnerPart = runner;
        this.fHierarchyIcon = TestRunnerViewPart.createImage("obj16/testhier.gif");
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TestViewer.this.disposeIcons();
            }
        });
        this.fTreeViewer = new TreeViewer(parent, 516);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTestSessionContentProvider = new TestSessionContentProvider();
        this.fTreeViewer.setContentProvider((IContentProvider)this.fTestSessionContentProvider);
        this.fTestSessionLabelProvider = new TestSessionLabelProvider(this.fTestRunnerPart);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fTestSessionLabelProvider);
        this.fLayoutMode = 1;
        this.fFailuresOnlyFilter = null;
        this.fTreeViewer.getTree().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TestViewer.this.handleSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TestViewer.this.handleDefaultSelected(null);
            }
        });
        this.fNeedRefresh = true;
        this.fNeedUpdate = new HashSet();
        this.fAutoClose = new LinkedList();
        this.fAutoExpand = new HashSet();
        this.initMenu();
    }

    private void initMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TestViewer.this.handleMenuAboutToShow(manager);
            }
        });
        this.fTestRunnerPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fTreeViewer);
        Menu menu = menuMgr.createContextMenu((Control)this.fTreeViewer.getTree());
        this.fTreeViewer.getTree().setMenu(menu);
    }

    void handleMenuAboutToShow(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        if (!selection.isEmpty()) {
            TestElement testElement = (TestElement)selection.getFirstElement();
            String testLabel = testElement.getTestName();
            String className = testElement.getClassName();
            if (testElement instanceof TestSuiteElement) {
                manager.add((IAction)new OpenTestAction(this.fTestRunnerPart, testLabel));
                manager.add((IContributionItem)new Separator());
                if (this.testClassExists(className) && !this.fTestRunnerPart.lastLaunchIsKeptAlive()) {
                    manager.add((IAction)new RerunAction(this.fTestRunnerPart, testElement.getId(), className, null, "run"));
                    manager.add((IAction)new RerunAction(this.fTestRunnerPart, testElement.getId(), className, null, "debug"));
                }
            } else {
                TestCaseElement testCaseElement = (TestCaseElement)testElement;
                String testMethodName = testCaseElement.getTestMethodName();
                manager.add((IAction)new OpenTestAction(this.fTestRunnerPart, className, testMethodName));
                manager.add((IContributionItem)new Separator());
                if (this.fTestRunnerPart.lastLaunchIsKeptAlive()) {
                    manager.add((IAction)new RerunAction(this.fTestRunnerPart, testElement.getId(), className, testMethodName, "run"));
                } else {
                    manager.add((IAction)new RerunAction(this.fTestRunnerPart, testElement.getId(), className, testMethodName, "run"));
                    manager.add((IAction)new RerunAction(this.fTestRunnerPart, testElement.getId(), className, testMethodName, "debug"));
                }
            }
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new ExpandAllAction());
        }
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("additions-end"));
    }

    private boolean testClassExists(String className) {
        IJavaProject project = this.fTestRunnerPart.getLaunchedProject();
        try {
            IType type = project.findType(className);
            return type != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    public synchronized void setActiveSession(TestRunSession testRunSession) {
        this.fTestRunSession = testRunSession;
        this.registerAutoScrollTarget(null);
        this.registerViewerRefresh();
    }

    void handleDefaultSelected(MouseEvent e) {
        OpenTestAction action;
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        TestElement testElement = (TestElement)selection.getFirstElement();
        if (testElement instanceof TestSuiteElement) {
            action = new OpenTestAction(this.fTestRunnerPart, testElement.getTestName());
        } else if (testElement instanceof TestCaseElement) {
            TestCaseElement testCase = (TestCaseElement)testElement;
            action = new OpenTestAction(this.fTestRunnerPart, testCase.getClassName(), testCase.getTestMethodName());
        } else {
            throw new IllegalStateException(String.valueOf(testElement));
        }
        if (action.isEnabled()) {
            action.run();
        }
    }

    private void handleSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        TestElement testElement = null;
        if (selection.size() == 1) {
            testElement = (TestElement)selection.getFirstElement();
        }
        this.fTestRunnerPart.handleTestSelected(testElement);
    }

    void disposeIcons() {
        this.fHierarchyIcon.dispose();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setShowFailuresOnly(boolean failuresOnly, int layoutMode) {
        this.fLayoutMode = layoutMode;
        try {
            this.fTreeViewer.getTree().setRedraw(false);
            if (failuresOnly) {
                if (!this.isShowFailuresOnly()) {
                    this.fFailuresOnlyFilter = new FailuresOnlyFilter();
                    this.fTreeViewer.addFilter(this.fFailuresOnlyFilter);
                }
                this.fTestSessionContentProvider.setLayout(layoutMode);
                this.fTestSessionLabelProvider.setLayout(layoutMode);
            } else {
                this.fTestSessionContentProvider.setLayout(layoutMode);
                this.fTestSessionLabelProvider.setLayout(layoutMode);
                if (this.isShowFailuresOnly()) {
                    this.fTreeViewer.removeFilter(this.fFailuresOnlyFilter);
                    this.fFailuresOnlyFilter = null;
                }
            }
            Object var3_5 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fTreeViewer.getTree().setRedraw(true);
            throw throwable;
        }
        this.fTreeViewer.getTree().setRedraw(true);
    }

    private boolean isShowFailuresOnly() {
        return this.fFailuresOnlyFilter != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChangesInUI() {
        TestRoot testRoot;
        if (this.fTestRunSession != null) {
            testRoot = this.fTestRunSession.getTestRoot();
        } else {
            testRoot = null;
            this.fNeedRefresh = true;
        }
        if (this.fNeedRefresh) {
            this.registerViewerRefresh();
            this.fNeedRefresh = false;
            this.fTreeViewer.setInput((Object)testRoot);
        } else {
            Object[] toUpdate;
            TestViewer testViewer = this;
            synchronized (testViewer) {
                toUpdate = this.fNeedUpdate.toArray();
                this.fNeedUpdate.clear();
            }
            if (this.isShowFailuresOnly() && testRoot != null) {
                int i = 0;
                while (i < toUpdate.length) {
                    TestElement testElement = (TestElement)toUpdate[i];
                    if (testElement instanceof TestCaseElement) {
                        if (testElement.getStatus().isFailure()) {
                            if (this.fTreeViewer.testFindItem((Object)testElement) == null) {
                                this.fTreeViewer.add((Object)testRoot, (Object)testElement);
                            } else {
                                this.fTreeViewer.update((Object)testElement, null);
                            }
                        } else {
                            this.fTreeViewer.remove((Object)testElement);
                        }
                    }
                    ++i;
                }
            } else {
                this.fTreeViewer.update(toUpdate, null);
            }
        }
        this.autoScrollInUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoScrollInUI() {
        TestSuiteElement parent;
        if (!this.fTestRunnerPart.isAutoScroll()) {
            this.clearAutoExpand();
            this.fAutoClose.clear();
            return;
        }
        TestViewer testViewer = this;
        synchronized (testViewer) {
            Iterator iter = this.fAutoExpand.iterator();
            while (iter.hasNext()) {
                TestSuiteElement suite = (TestSuiteElement)iter.next();
                this.fTreeViewer.setExpandedState((Object)suite, true);
            }
            this.clearAutoExpand();
        }
        TestCaseElement current = this.fAutoScrollTarget;
        this.fAutoScrollTarget = null;
        TestSuiteElement testSuiteElement = parent = current == null ? null : (TestSuiteElement)this.fTestSessionContentProvider.getParent(current);
        if (this.fAutoClose.isEmpty() || !this.fAutoClose.getLast().equals(parent)) {
            ListIterator iter = this.fAutoClose.listIterator(this.fAutoClose.size());
            while (iter.hasPrevious()) {
                TestSuiteElement previousAutoOpened = (TestSuiteElement)iter.previous();
                if (previousAutoOpened.equals(parent)) break;
                if (previousAutoOpened.getStatus() != TestElement.Status.OK) continue;
                iter.remove();
                this.fTreeViewer.collapseToLevel((Object)previousAutoOpened, -1);
            }
            while (parent != null && !this.fTestRunSession.getTestRoot().equals(parent) && !this.fTreeViewer.getExpandedState((Object)parent)) {
                this.fAutoClose.add(parent);
                parent = (TestSuiteElement)this.fTestSessionContentProvider.getParent(parent);
            }
        }
        if (current != null) {
            this.fTreeViewer.reveal((Object)current);
        }
    }

    public void selectFirstFailure() {
        TestCaseElement firstFailure = this.getNextChildFailure(this.fTestRunSession.getTestRoot(), true);
        if (firstFailure != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)firstFailure), true);
        }
    }

    public void selectFailure(boolean showNext) {
        TestCaseElement next;
        ITreeSelection selection = (ITreeSelection)this.fTreeViewer.getSelection();
        TestElement selected = (TestElement)selection.getFirstElement();
        if (selected == null) {
            next = this.getNextChildFailure(this.fTestRunSession.getTestRoot(), showNext);
        } else if (selected instanceof TestSuiteElement) {
            next = this.getNextChildFailure((TestSuiteElement)selected, showNext);
            if (next == null) {
                next = this.getNextFailureSibling(selected, showNext);
            }
        } else {
            next = this.getNextFailureSibling(selected, showNext);
        }
        if (next != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)next), true);
        }
    }

    private TestCaseElement getNextFailureSibling(TestElement current, boolean showNext) {
        int nextIndex;
        TestSuiteElement parent = current.getParent();
        if (parent == null) {
            return null;
        }
        ReverseList siblings = Arrays.asList(parent.getChildren());
        if (!showNext) {
            siblings = new ReverseList(siblings);
        }
        int i = nextIndex = siblings.indexOf(current) + 1;
        while (i < siblings.size()) {
            TestElement sibling = (TestElement)siblings.get(i);
            if (sibling.getStatus().isFailure()) {
                if (sibling instanceof TestCaseElement) {
                    return (TestCaseElement)sibling;
                }
                return this.getNextChildFailure((TestSuiteElement)sibling, showNext);
            }
            ++i;
        }
        return this.getNextFailureSibling(parent, showNext);
    }

    private TestCaseElement getNextChildFailure(TestSuiteElement root, boolean showNext) {
        ReverseList children = Arrays.asList(root.getChildren());
        if (!showNext) {
            children = new ReverseList(children);
        }
        int i = 0;
        while (i < children.size()) {
            TestElement child = (TestElement)children.get(i);
            if (child.getStatus().isFailure()) {
                if (child instanceof TestCaseElement) {
                    return (TestCaseElement)child;
                }
                return this.getNextChildFailure((TestSuiteElement)child, showNext);
            }
            ++i;
        }
        return null;
    }

    public synchronized void registerViewerRefresh() {
        this.fNeedRefresh = true;
        this.fNeedUpdate.clear();
        this.fAutoClose.clear();
        this.clearAutoExpand();
    }

    public synchronized void registerViewerUpdate(TestElement testElement) {
        TestElement element = testElement;
        do {
            this.fNeedUpdate.add(element);
        } while ((element = element.getParent()) != null);
    }

    public synchronized void clearAutoExpand() {
        this.fAutoExpand.clear();
    }

    public void registerAutoScrollTarget(TestCaseElement testCaseElement) {
        this.fAutoScrollTarget = testCaseElement;
    }

    public synchronized void registerFailedForAutoScroll(TestCaseElement testCaseElement) {
        this.fAutoExpand.add(this.fTestSessionContentProvider.getParent(testCaseElement));
    }

    private final class FailuresOnlyFilter
    extends ViewerFilter {
        private FailuresOnlyFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof TestElement)) {
                return true;
            }
            TestElement testElement = (TestElement)element;
            TestElement.Status status = testElement.getStatus();
            if (status == TestElement.Status.FAILURE || status == TestElement.Status.ERROR) {
                return true;
            }
            if (status == TestElement.Status.RUNNING) {
                return TestViewer.this.fLayoutMode == 1;
            }
            return false;
        }
    }

    private static class ReverseList
    extends AbstractList {
        private final List fList;

        public ReverseList(List list) {
            this.fList = list;
        }

        public Object get(int index) {
            return this.fList.get(this.fList.size() - index - 1);
        }

        public int size() {
            return this.fList.size();
        }
    }

    private class ExpandAllAction
    extends Action {
        public ExpandAllAction() {
            this.setText(JUnitMessages.ExpandAllAction_text);
            this.setToolTipText(JUnitMessages.ExpandAllAction_tooltip);
        }

        public void run() {
            TestViewer.this.fTreeViewer.expandAll();
        }
    }
}

