/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.ui.text;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.ScopePart;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.ui.IWorkingSet;

public final class FileTextSearchScope
extends TextSearchScope {
    private static final boolean IS_CASE_SENSITIVE_FILESYSTEM = !new File("Temp").equals(new File("temp"));
    private final String fDescription;
    private final IResource[] fRootElements;
    private final String[] fFileNamePatterns;
    private Matcher fFileNameMatcher;
    private boolean fVisitDerived;
    private IWorkingSet[] fWorkingSets;
    static /* synthetic */ Class class$0;

    public static FileTextSearchScope newWorkspaceScope(String[] fileNamePatterns, boolean includeDerived) {
        return new FileTextSearchScope(SearchMessages.WorkspaceScope, new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, null, fileNamePatterns, includeDerived);
    }

    public static FileTextSearchScope newSearchScope(IResource[] roots, String[] fileNamePatterns, boolean includeDerived) {
        StringBuffer buf = new StringBuffer();
        int n = roots.length > 3 ? 3 : roots.length;
        int i = 0;
        while (i < n) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append('\'');
            buf.append(roots[i].getName());
            buf.append('\'');
            ++i;
        }
        if (roots.length > n) {
            buf.append("...");
        }
        String description = buf.toString();
        return new FileTextSearchScope(description, FileTextSearchScope.removeRedundantEntries(roots, includeDerived), null, fileNamePatterns, includeDerived);
    }

    public static FileTextSearchScope newSearchScope(IWorkingSet[] workingSets, String[] fileNamePatterns, boolean includeDerived) {
        String description = Messages.format(SearchMessages.WorkingSetScope, ScopePart.toString(workingSets));
        FileTextSearchScope scope = new FileTextSearchScope(description, FileTextSearchScope.convertToResources(workingSets, includeDerived), workingSets, fileNamePatterns, includeDerived);
        return scope;
    }

    private FileTextSearchScope(String description, IResource[] resources, IWorkingSet[] workingSets, String[] fileNamePatterns, boolean visitDerived) {
        this.fDescription = description;
        this.fRootElements = resources;
        this.fFileNamePatterns = fileNamePatterns;
        this.fFileNameMatcher = null;
        this.fVisitDerived = visitDerived;
        this.fWorkingSets = workingSets;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String[] getFileNamePatterns() {
        return this.fFileNamePatterns;
    }

    public IWorkingSet[] getWorkingSets() {
        return this.fWorkingSets;
    }

    public IContentType[] getContentTypes() {
        return null;
    }

    public String getFilterDescription() {
        Object[] ext = this.fFileNamePatterns;
        if (ext == null) {
            return "*";
        }
        Arrays.sort(ext);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < ext.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append((String)ext[i]);
            ++i;
        }
        return buf.toString();
    }

    public boolean includeDerived() {
        return this.fVisitDerived;
    }

    public IResource[] getRoots() {
        return this.fRootElements;
    }

    public boolean contains(IResourceProxy proxy) {
        if (!this.fVisitDerived && proxy.isDerived()) {
            return false;
        }
        if (proxy.getType() == 1) {
            return this.matchesFileName(proxy.getName());
        }
        return true;
    }

    private boolean matchesFileName(String fileName) {
        return this.getFileNameMatcher().reset(fileName).matches();
    }

    private Matcher getFileNameMatcher() {
        if (this.fFileNameMatcher == null) {
            Pattern pattern = this.fFileNamePatterns == null || this.fFileNamePatterns.length == 0 ? Pattern.compile(".*") : PatternConstructor.createPattern(this.fFileNamePatterns, IS_CASE_SENSITIVE_FILESYSTEM);
            this.fFileNameMatcher = pattern.matcher("");
        }
        return this.fFileNameMatcher;
    }

    private static IResource[] removeRedundantEntries(IResource[] elements, boolean includeDerived) {
        ArrayList res = new ArrayList();
        int i = 0;
        while (i < elements.length) {
            IResource curr = elements[i];
            FileTextSearchScope.addToList(res, curr, includeDerived);
            ++i;
        }
        return res.toArray(new IResource[res.size()]);
    }

    private static IResource[] convertToResources(IWorkingSet[] workingSets, boolean includeDerived) {
        ArrayList res = new ArrayList();
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet workingSet = workingSets[i];
            if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty()) {
                return new IResource[]{ResourcesPlugin.getWorkspace().getRoot()};
            }
            IAdaptable[] elements = workingSet.getElements();
            int k = 0;
            while (k < elements.length) {
                IResource curr;
                IAdaptable iAdaptable = elements[k];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((curr = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                    FileTextSearchScope.addToList(res, curr, includeDerived);
                }
                ++k;
            }
            ++i;
        }
        return res.toArray(new IResource[res.size()]);
    }

    private static void addToList(ArrayList res, IResource curr, boolean includeDerived) {
        if (!includeDerived && FileTextSearchScope.isDerived(curr)) {
            return;
        }
        IPath currPath = curr.getFullPath();
        int k = res.size() - 1;
        while (k >= 0) {
            IResource other = (IResource)res.get(k);
            IPath otherPath = other.getFullPath();
            if (otherPath.isPrefixOf(currPath)) {
                return;
            }
            if (currPath.isPrefixOf(otherPath)) {
                res.remove(k);
            }
            --k;
        }
        res.add(curr);
    }

    private static boolean isDerived(IResource curr) {
        do {
            if (!curr.isDerived()) continue;
            return true;
        } while ((curr = curr.getParent()) != null);
        return false;
    }
}

